/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.exportimport.service.impl;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.service.base.ExportImportConfigurationLocalServiceBaseImpl;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.service.TrashEntryLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ExportImportConfigurationLocalServiceImpl
extends ExportImportConfigurationLocalServiceBaseImpl {
    @BeanReference(type=TrashEntryLocalService.class)
    private TrashEntryLocalService _trashEntryLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public ExportImportConfiguration addDraftExportImportConfiguration(long userId, int type, Map<String, Serializable> settingsMap) throws PortalException {
        return this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(userId, GetterUtil.getString((Object)settingsMap.get("portletId")), type, settingsMap);
    }

    public ExportImportConfiguration addDraftExportImportConfiguration(long userId, String name, int type, Map<String, Serializable> settingsMap) throws PortalException {
        long groupId = GetterUtil.getLong((Object)settingsMap.get("sourceGroupId"));
        if (type == 6 || type == 7) {
            groupId = GetterUtil.getLong((Object)settingsMap.get("targetGroupId"));
        }
        return this.exportImportConfigurationLocalService.addExportImportConfiguration(userId, groupId, name, "", type, settingsMap, 2, new ServiceContext());
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration addExportImportConfiguration(long userId, long groupId, String name, String description, int type, Map<String, Serializable> settingsMap, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long exportImportConfigurationId = this.counterLocalService.increment();
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.create(exportImportConfigurationId);
        exportImportConfiguration.setGroupId(groupId);
        exportImportConfiguration.setCompanyId(user.getCompanyId());
        exportImportConfiguration.setUserId(userId);
        exportImportConfiguration.setUserName(user.getFullName());
        exportImportConfiguration.setName(name);
        exportImportConfiguration.setDescription(description);
        exportImportConfiguration.setType(type);
        if (settingsMap != null) {
            exportImportConfiguration.setSettings(JSONFactoryUtil.serialize(settingsMap));
        }
        exportImportConfiguration.setStatus(status);
        exportImportConfiguration.setStatusByUserId(userId);
        exportImportConfiguration.setStatusByUserName(user.getScreenName());
        exportImportConfiguration.setStatusDate(new Date());
        return (ExportImportConfiguration)this.exportImportConfigurationPersistence.update((BaseModel)exportImportConfiguration);
    }

    public ExportImportConfiguration addExportImportConfiguration(long userId, long groupId, String name, String description, int type, Map<String, Serializable> settingsMap, ServiceContext serviceContext) throws PortalException {
        return this.exportImportConfigurationLocalService.addExportImportConfiguration(userId, groupId, name, description, type, settingsMap, 0, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ExportImportConfiguration deleteExportImportConfiguration(ExportImportConfiguration exportImportConfiguration) {
        this.exportImportConfigurationPersistence.remove((BaseModel)exportImportConfiguration);
        return exportImportConfiguration;
    }

    @Override
    public ExportImportConfiguration deleteExportImportConfiguration(long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        return this.exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
    }

    public void deleteExportImportConfigurations(long groupId) {
        List exportImportConfigurations = this.exportImportConfigurationPersistence.findByGroupId(groupId);
        for (ExportImportConfiguration exportImportConfiguration : exportImportConfigurations) {
            this.exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
        }
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<ExportImportConfiguration> exportImportConfigurations = new ArrayList<ExportImportConfiguration>(documents.size());
        for (Document document : documents) {
            long exportImportConfigurationId = GetterUtil.getLong((String)document.get("exportImportConfigurationId"));
            ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
            if (exportImportConfiguration == null) {
                exportImportConfigurations = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(ExportImportConfiguration.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (exportImportConfigurations == null) continue;
            exportImportConfigurations.add(exportImportConfiguration);
        }
        return exportImportConfigurations;
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(long groupId, int type) {
        return this.exportImportConfigurationPersistence.findByG_T_S(groupId, type, 0);
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(long groupId, int type, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationPersistence.findByG_T_S(groupId, type, 0, start, end, orderByComparator);
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(long companyId, long groupId, String keywords, int type, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationFinder.findByKeywords(companyId, groupId, keywords, type, 0, start, end, orderByComparator);
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(long companyId, long groupId, String name, String description, int type, boolean andSearch, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationFinder.findByC_G_N_D_T(companyId, groupId, name, description, type, 0, andSearch, start, end, orderByComparator);
    }

    public int getExportImportConfigurationsCount(long groupId) {
        return this.exportImportConfigurationPersistence.countByG_S(groupId, 0);
    }

    public int getExportImportConfigurationsCount(long groupId, int type) {
        return this.exportImportConfigurationPersistence.countByG_T_S(groupId, type, 0);
    }

    public int getExportImportConfigurationsCount(long companyId, long groupId, String keywords, int type) {
        return this.exportImportConfigurationFinder.countByKeywords(companyId, groupId, keywords, type, 0);
    }

    public int getExportImportConfigurationsCount(long companyId, long groupId, String name, String description, int type, boolean andSearch) {
        return this.exportImportConfigurationFinder.countByC_G_N_D_T(companyId, groupId, name, description, type, 0, andSearch);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration moveExportImportConfigurationToTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        if (exportImportConfiguration.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = exportImportConfiguration.getStatus();
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), 8);
        this._trashEntryLocalService.addTrashEntry(userId, exportImportConfiguration.getGroupId(), ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId(), null, null, oldStatus, null, null);
        return exportImportConfiguration;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration restoreExportImportConfigurationFromTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        if (!exportImportConfiguration.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(ExportImportConfiguration.class.getName(), exportImportConfigurationId);
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), trashEntry.getStatus());
        this._trashEntryLocalService.deleteEntry(ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId());
        return exportImportConfiguration;
    }

    public BaseModelSearchResult<ExportImportConfiguration> searchExportImportConfigurations(long companyId, long groupId, int type, String keywords, int start, int end, Sort sort) throws PortalException {
        String description = null;
        String name = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            description = keywords;
            name = keywords;
        } else {
            andOperator = true;
        }
        return this.searchExportImportConfigurations(companyId, groupId, type, name, description, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<ExportImportConfiguration> searchExportImportConfigurations(long companyId, long groupId, int type, String name, String description, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ExportImportConfiguration.class);
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, type, name, description, andSearch, start, end, sort);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List exportImportConfigurations = this.exportImportConfigurationLocalService.getExportImportConfigurations(hits);
            if (exportImportConfigurations == null) continue;
            return new BaseModelSearchResult(exportImportConfigurations, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration updateExportImportConfiguration(long userId, long exportImportConfigurationId, String name, String description, Map<String, Serializable> settingsMap, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        exportImportConfiguration.setUserId(userId);
        exportImportConfiguration.setUserName(user.getFullName());
        exportImportConfiguration.setName(name);
        exportImportConfiguration.setDescription(description);
        if (settingsMap != null) {
            exportImportConfiguration.setSettings(JSONFactoryUtil.serialize(settingsMap));
        }
        return (ExportImportConfiguration)this.exportImportConfigurationPersistence.update((BaseModel)exportImportConfiguration);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration updateStatus(long userId, long exportImportConfigurationId, int status) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        exportImportConfiguration.setStatus(status);
        exportImportConfiguration.setStatusByUserId(userId);
        exportImportConfiguration.setStatusByUserName(user.getScreenName());
        exportImportConfiguration.setStatusDate(new Date());
        return (ExportImportConfiguration)this.exportImportConfigurationPersistence.update((BaseModel)exportImportConfiguration);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, int type, String name, String description, boolean andSearch, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)0).put((Object)"description", (Object)description).put((Object)"groupId", (Object)groupId).put((Object)"name", (Object)name).put((Object)"type", (Object)type).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }
}

