/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.async.PortletAsyncListenerFactory;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManager;
import com.liferay.portal.kernel.portlet.async.PortletAsyncScopeManagerFactory;
import com.liferay.portlet.AsyncPortletServletRequest;
import com.liferay.portlet.PortletAsyncListenerAdapter;
import com.liferay.portlet.internal.PortletAsyncScopingListener;
import com.liferay.portlet.internal.PortletAsyncScopingRunnable;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletAsyncListener;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public class PortletAsyncContextImpl
implements PortletAsyncContext {
    private static final PortletAsyncListenerFactory _dummyPortletAsyncListenerFactory = new PortletAsyncListenerFactory(){

        public <T extends PortletAsyncListener> T getPortletAsyncListener(Class<T> clazz) throws PortletException {
            try {
                return (T)((PortletAsyncListener)clazz.newInstance());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new PortletException((Throwable)reflectiveOperationException);
            }
        }
    };
    private static final PortletAsyncScopeManager _dummyPortletAsyncScopeManager = new PortletAsyncScopeManager(){

        public void activateScopeContexts() {
        }

        public void activateScopeContexts(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletConfig portletConfig) {
        }

        public void deactivateScopeContexts(boolean close) {
        }
    };
    private static final ServiceTrackerMap<String, PortletAsyncListenerFactory> _portletAsyncListenerFactories = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), PortletAsyncListenerFactory.class, (String)"servlet.context.name");
    private static final ServiceTrackerMap<String, PortletAsyncScopeManagerFactory> _portletAsyncScopeManagerFactories = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), PortletAsyncScopeManagerFactory.class, (String)"servlet.context.name");
    private AsyncContext _asyncContext;
    private AsyncPortletServletRequest _asyncPortletServletRequest;
    private boolean _calledComplete;
    private boolean _calledDispatch;
    private boolean _hasOriginalRequestAndResponse;
    private PortletAsyncListenerAdapter _portletAsyncListenerAdapter;
    private PortletAsyncListenerFactory _portletAsyncListenerFactory;
    private PortletAsyncScopeManager _portletAsyncScopeManager;
    private ResourceRequest _resourceRequest;
    private ResourceResponse _resourceResponse;
    private boolean _returnedToContainer;
    private String _servletContextName;

    public void addListener(PortletAsyncListener portletAsyncListener) throws IllegalStateException {
        this.addListener(portletAsyncListener, null, null);
    }

    public void addListener(PortletAsyncListener portletAsyncListener, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IllegalStateException {
        if (!this._resourceRequest.isAsyncStarted() || this._returnedToContainer) {
            throw new IllegalStateException();
        }
        this._portletAsyncListenerAdapter.addListener(portletAsyncListener, resourceRequest, resourceResponse);
    }

    public void complete() throws IllegalStateException {
        this._asyncContext.complete();
        this._calledComplete = true;
    }

    public <T extends PortletAsyncListener> T createPortletAsyncListener(Class<T> listenerClass) throws PortletException {
        return (T)this._portletAsyncListenerFactory.getPortletAsyncListener(listenerClass);
    }

    public void dispatch() throws IllegalStateException {
        if (!this._resourceRequest.isAsyncStarted() || this._calledComplete || this._calledDispatch) {
            throw new IllegalStateException();
        }
        HttpServletRequest originalHttpServletRequest = (HttpServletRequest)this._getOriginalServletRequest();
        String path = StringBundler.concat((String[])new String[]{originalHttpServletRequest.getRequestURI(), "?p_p_async=1&", originalHttpServletRequest.getQueryString()});
        ServletContext servletContext = originalHttpServletRequest.getServletContext();
        this._asyncPortletServletRequest.update(servletContext.getContextPath(), path);
        this._asyncContext.dispatch(servletContext, path);
        this._calledDispatch = true;
    }

    public void dispatch(String path) throws IllegalStateException {
        if (!this._resourceRequest.isAsyncStarted() || this._calledComplete || this._calledDispatch) {
            throw new IllegalStateException();
        }
        ServletRequest originalServletRequest = this._getOriginalServletRequest();
        ServletContext servletContext = originalServletRequest.getServletContext();
        String contextPath = this._resourceRequest.getContextPath();
        path = contextPath.concat(path);
        this._asyncPortletServletRequest.update(servletContext.getContextPath(), path);
        this._asyncContext.dispatch(servletContext, path);
        this._calledDispatch = true;
    }

    public PortletAsyncScopeManager getPortletAsyncScopeManager() {
        return this._portletAsyncScopeManager;
    }

    public ResourceRequest getResourceRequest() throws IllegalStateException {
        if (this._calledComplete || this._calledDispatch && !this._resourceRequest.isAsyncStarted()) {
            throw new IllegalStateException();
        }
        return this._resourceRequest;
    }

    public ResourceResponse getResourceResponse() throws IllegalStateException {
        if (this._calledComplete || this._calledDispatch && !this._resourceRequest.isAsyncStarted()) {
            throw new IllegalStateException();
        }
        return this._resourceResponse;
    }

    public long getTimeout() {
        return this._asyncContext.getTimeout();
    }

    public boolean hasOriginalRequestAndResponse() {
        return this._hasOriginalRequestAndResponse;
    }

    public boolean isCalledDispatch() {
        return this._calledDispatch;
    }

    public void setReturnedToContainer() {
        this._returnedToContainer = true;
    }

    public void setTimeout(long timeout) {
        this._asyncContext.setTimeout(timeout);
    }

    public void start(Runnable runnable) throws IllegalStateException {
        this._asyncContext.start((Runnable)new PortletAsyncScopingRunnable(runnable, this._portletAsyncListenerAdapter, this._portletAsyncScopeManager));
    }

    protected void initialize(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletConfig portletConfig, AsyncContext asyncContext, boolean hasOriginalRequestAndResponse) {
        this._resourceRequest = resourceRequest;
        this._resourceResponse = resourceResponse;
        this._asyncContext = asyncContext;
        this._hasOriginalRequestAndResponse = hasOriginalRequestAndResponse;
        PortletContext portletContext = portletConfig.getPortletContext();
        this._servletContextName = portletContext.getPortletContextName();
        this._portletAsyncScopeManager = this._getPortletAsyncScopeManager(this._servletContextName);
        this._portletAsyncScopeManager.activateScopeContexts(resourceRequest, resourceResponse, portletConfig);
        this._portletAsyncListenerFactory = this._getPortletAsyncListenerFactory(this._servletContextName);
        this._calledDispatch = false;
        this._calledComplete = false;
        this._returnedToContainer = false;
        if (this._portletAsyncListenerAdapter == null) {
            this._portletAsyncListenerAdapter = new PortletAsyncScopingListener(this, this._portletAsyncScopeManager);
            this._asyncContext.addListener((AsyncListener)this._portletAsyncListenerAdapter);
        }
        if (this._asyncPortletServletRequest == null) {
            this._asyncPortletServletRequest = (AsyncPortletServletRequest)this._asyncContext.getRequest();
        }
    }

    private ServletRequest _getOriginalServletRequest() {
        AsyncPortletServletRequest originalServletRequest = this._asyncPortletServletRequest;
        while (originalServletRequest instanceof ServletRequestWrapper) {
            ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)originalServletRequest;
            originalServletRequest = servletRequestWrapper.getRequest();
        }
        return originalServletRequest;
    }

    private PortletAsyncListenerFactory _getPortletAsyncListenerFactory(String servletContextName) {
        PortletAsyncListenerFactory portletAsyncListenerFactory = (PortletAsyncListenerFactory)_portletAsyncListenerFactories.getService((Object)servletContextName);
        if (portletAsyncListenerFactory == null) {
            portletAsyncListenerFactory = _dummyPortletAsyncListenerFactory;
        }
        return portletAsyncListenerFactory;
    }

    private PortletAsyncScopeManager _getPortletAsyncScopeManager(String servletContextName) {
        PortletAsyncScopeManagerFactory portletAsyncScopeManagerFactory = (PortletAsyncScopeManagerFactory)_portletAsyncScopeManagerFactories.getService((Object)servletContextName);
        if (portletAsyncScopeManagerFactory == null) {
            return _dummyPortletAsyncScopeManager;
        }
        return portletAsyncScopeManagerFactory.getPortletAsyncScopeManager();
    }
}

