/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.portlet.LiferayPortletSession;
import com.liferay.portlet.PortletSessionAttributeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;

public class PortletSessionImpl
implements LiferayPortletSession {
    protected HttpSession httpSession;
    protected final PortletContext portletContext;
    protected final String scopePrefix;
    private boolean _invalidated;

    public PortletSessionImpl(HttpSession httpSession, PortletContext portletContext, String portletName, long plid) {
        this.httpSession = httpSession;
        this.portletContext = portletContext;
        this.scopePrefix = StringBundler.concat((Object[])new Object[]{"javax.portlet.p.", portletName, "_LAYOUT_", plid, "?"});
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._invalidated) {
            throw new IllegalStateException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        return this.httpSession.getAttribute(name);
    }

    public Map<String, Object> getAttributeMap() {
        return this.getAttributeMap(2);
    }

    public Map<String, Object> getAttributeMap(int scope) {
        if (scope == 2) {
            return new PortletSessionAttributeMap(this.httpSession, this.scopePrefix);
        }
        return new PortletSessionAttributeMap(this.httpSession);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (scope != 2) {
            return this.httpSession.getAttributeNames();
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        Enumeration enumeration = this.httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!name.startsWith(this.scopePrefix)) continue;
            name = name.substring(this.scopePrefix.length());
            attributeNames.add(name);
        }
        return Collections.enumeration(attributeNames);
    }

    public long getCreationTime() {
        if (this._invalidated) {
            throw new IllegalStateException();
        }
        return this.httpSession.getCreationTime();
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void invalidate() {
        this._invalidated = true;
        this.httpSession.invalidate();
    }

    public boolean isInvalidated() {
        return this._invalidated;
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        this.httpSession.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (scope == 2) {
            name = this.scopePrefix.concat(name);
        }
        this.httpSession.setAttribute(name, value);
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
    }
}

