/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.social.model.impl.SocialActivityCounterImpl;
import com.liferay.portlet.social.service.persistence.impl.SocialActivityCounterFinderBaseImpl;
import com.liferay.social.kernel.model.SocialActivityCounter;
import com.liferay.social.kernel.service.persistence.SocialActivityCounterFinder;
import com.liferay.social.kernel.util.SocialCounterPeriodUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SocialActivityCounterFinderImpl
extends SocialActivityCounterFinderBaseImpl
implements SocialActivityCounterFinder {
    public static final String COUNT_U_BY_G_C_N_S_E = SocialActivityCounterFinder.class.getName() + ".countU_ByG_C_N_S_E";
    public static final String FIND_AC_BY_G_N_S_E_1 = SocialActivityCounterFinder.class.getName() + ".findAC_ByG_N_S_E_1";
    public static final String FIND_AC_BY_G_N_S_E_2 = SocialActivityCounterFinder.class.getName() + ".findAC_ByG_N_S_E_2";
    public static final String FIND_AC_BY_G_C_C_N_S_E = SocialActivityCounterFinder.class.getName() + ".findAC_By_G_C_C_N_S_E";
    public static final String FIND_U_BY_G_C_N_S_E = SocialActivityCounterFinder.class.getName() + ".findU_ByG_C_N_S_E";
    private static final PortalCache<String, Serializable> _activityCountersPortalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)SocialActivityCounterFinder.class.getName());

    public int countU_ByG_N(long groupId, String[] names) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_U_BY_G_C_N_S_E);
            sql = StringUtil.replace((String)sql, (String)"[$NAME$]", (String)this.getNames(names));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(PortalUtil.getClassNameId((String)User.class.getName()));
            this.setNames(queryPos, names);
            queryPos.add(SocialCounterPeriodUtil.getPeriodLength());
            queryPos.add(SocialCounterPeriodUtil.getActivityDay());
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SocialActivityCounter> findAC_ByG_N_S_E_1(long groupId, String name, int startPeriod, int endPeriod, int periodLength) {
        String key = StringBundler.concat((Object[])new Object[]{groupId, "#", name, "#", startPeriod, "#", endPeriod, "#", periodLength});
        ArrayList<SocialActivityCounter> activityCounters = null;
        if (endPeriod < SocialCounterPeriodUtil.getActivityDay()) {
            activityCounters = (ArrayList<SocialActivityCounter>)_activityCountersPortalCache.get((Serializable)((Object)key));
        }
        if (activityCounters != null) {
            return activityCounters;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_AC_BY_G_N_S_E_1);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(name);
            queryPos.add(startPeriod);
            queryPos.add(endPeriod);
            queryPos.add(periodLength);
            queryPos.add(endPeriod);
            activityCounters = new ArrayList<SocialActivityCounter>();
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                SocialActivityCounterImpl activityCounter = new SocialActivityCounterImpl();
                activityCounter.setName(GetterUtil.getString((Object)array[0]));
                activityCounter.setCurrentValue(GetterUtil.getInteger((Object)array[1]));
                activityCounter.setStartPeriod(GetterUtil.getInteger((Object)array[2]));
                activityCounter.setEndPeriod(GetterUtil.getInteger((Object)array[3]));
                activityCounters.add(activityCounter);
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            if (activityCounters == null) {
                _activityCountersPortalCache.remove((Serializable)((Object)key));
            } else if (endPeriod < SocialCounterPeriodUtil.getActivityDay()) {
                _activityCountersPortalCache.put((Serializable)((Object)key), (Object)activityCounters);
            }
            this.closeSession(session);
        }
        return activityCounters;
    }

    public List<SocialActivityCounter> findAC_ByG_N_S_E_2(long groupId, String counterName, int startPeriod, int endPeriod, int periodLength) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_AC_BY_G_N_S_E_2);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(counterName);
            queryPos.add(startPeriod);
            queryPos.add(endPeriod);
            queryPos.add(periodLength);
            queryPos.add(endPeriod);
            ArrayList<SocialActivityCounter> activityCounters = new ArrayList<SocialActivityCounter>();
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                SocialActivityCounterImpl activityCounter = new SocialActivityCounterImpl();
                activityCounter.setClassNameId(GetterUtil.getLong((Object)array[0]));
                activityCounter.setName(GetterUtil.getString((Object)array[1]));
                activityCounter.setCurrentValue(GetterUtil.getInteger((Object)array[2]));
                activityCounters.add(activityCounter);
            }
            ArrayList<SocialActivityCounter> arrayList = activityCounters;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SocialActivityCounter> findAC_By_G_C_C_N_S_E(long groupId, List<Long> userIds, String[] names, int start, int end) {
        if (names.length == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_AC_BY_G_C_C_N_S_E);
            sql = StringUtil.replace((String)sql, (String[])new String[]{"[$CLASS_PK$]", "[$NAME$]"}, (String[])new String[]{StringUtil.merge(userIds), this.getNames(names)});
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("SocialActivityCounter", SocialActivityCounterImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(PortalUtil.getClassNameId((String)User.class.getName()));
            this.setNames(queryPos, names);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findU_ByG_N(long groupId, String[] names, int start, int end) {
        if (names.length == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_U_BY_G_C_N_S_E);
            sql = StringUtil.replace((String)sql, (String)"[$NAME$]", (String)this.getNames(names));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("classPK", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(PortalUtil.getClassNameId((String)User.class.getName()));
            this.setNames(queryPos, names);
            queryPos.add(SocialCounterPeriodUtil.getStartPeriod());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getNames(String[] names) {
        if (names.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(names.length * 2 - 1);
        for (int i = 0; i < names.length; ++i) {
            sb.append("?");
            if (i + 1 >= names.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected void setNames(QueryPos queryPos, String[] names) {
        if (ArrayUtil.isNotEmpty((Object[])names)) {
            for (String name : names) {
                queryPos.add(name);
            }
        }
    }
}

