/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.DAOParamUtil;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.OrganizationDisplayTerms;
import javax.portlet.PortletRequest;

public class OrganizationSearchTerms
extends OrganizationDisplayTerms {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationSearchTerms.class);

    public OrganizationSearchTerms(PortletRequest portletRequest) {
        super(portletRequest);
        this.city = DAOParamUtil.getString((PortletRequest)portletRequest, (String)"city");
        this.countryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"countryId");
        this.name = DAOParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        this.parentOrganizationId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"parentOrganizationId");
        this.regionId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"regionId");
        this.street = DAOParamUtil.getString((PortletRequest)portletRequest, (String)"street");
        this.type = DAOParamUtil.getString((PortletRequest)portletRequest, (String)"type");
        this.zip = DAOParamUtil.getString((PortletRequest)portletRequest, (String)"zip");
    }

    public Long getCountryIdObj() {
        if (this.countryId == 0L) {
            return null;
        }
        return this.countryId;
    }

    public String getCountryName() throws PortalException {
        String countryName;
        block3: {
            countryName = null;
            if (this.countryId != 0L) {
                try {
                    Country country = CountryServiceUtil.getCountry((long)this.countryId);
                    countryName = StringUtil.toLowerCase((String)country.getName());
                    countryName = StringUtil.quote((String)countryName, (String)"\"");
                }
                catch (NoSuchCountryException noSuchCountryException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchCountryException);
                }
            }
        }
        return countryName;
    }

    public Long getRegionIdObj() {
        if (this.regionId == 0L) {
            return null;
        }
        return this.regionId;
    }

    public String getRegionName() throws PortalException {
        String regionName;
        block3: {
            regionName = null;
            if (this.regionId != 0L) {
                try {
                    Region region = RegionServiceUtil.getRegion((long)this.regionId);
                    regionName = StringUtil.toLowerCase((String)region.getName());
                    regionName = StringUtil.quote((String)regionName, (String)"\"");
                }
                catch (NoSuchRegionException noSuchRegionException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchRegionException);
                }
            }
        }
        return regionName;
    }

    public boolean hasSearchTerms() {
        return this.isAdvancedSearch() ? Validator.isNotNull((String)this.city) || this.countryId > 0L || Validator.isNotNull((String)this.name) || this.regionId > 0L || Validator.isNotNull((String)this.street) || Validator.isNotNull((String)this.type) || Validator.isNotNull((String)this.zip) : Validator.isNotNull((String)this.keywords);
    }
}

