/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.PortletPreferenceValue;
import com.liferay.portal.kernel.model.PortletPreferenceValueModel;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the PortletPreferenceValue service. Represents a row in the &quot;PortletPreferenceValue&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>PortletPreferenceValueModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PortletPreferenceValueImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PortletPreferenceValueImpl
 * @generated
 */
public class PortletPreferenceValueModelImpl
	extends BaseModelImpl<PortletPreferenceValue>
	implements PortletPreferenceValueModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a portlet preference value model instance should use the <code>PortletPreferenceValue</code> interface instead.
	 */
	public static final String TABLE_NAME = "PortletPreferenceValue";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"portletPreferenceValueId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"portletPreferencesId", Types.BIGINT}, {"index_", Types.INTEGER},
		{"largeValue", Types.CLOB}, {"name", Types.VARCHAR},
		{"readOnly", Types.BOOLEAN}, {"smallValue", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("portletPreferenceValueId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("portletPreferencesId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("index_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("largeValue", Types.CLOB);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("readOnly", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("smallValue", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table PortletPreferenceValue (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,portletPreferenceValueId LONG not null,companyId LONG,portletPreferencesId LONG,index_ INTEGER,largeValue TEXT null,name VARCHAR(255) null,readOnly BOOLEAN,smallValue VARCHAR(255) null,primary key (portletPreferenceValueId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table PortletPreferenceValue";

	public static final String ORDER_BY_JPQL =
		" ORDER BY portletPreferenceValue.index ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY PortletPreferenceValue.index_ ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long INDEX_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PORTLETPREFERENCESID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SMALLVALUE_COLUMN_BITMASK = 8L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.PortletPreferenceValue"));

	public PortletPreferenceValueModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _portletPreferenceValueId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setPortletPreferenceValueId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _portletPreferenceValueId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return PortletPreferenceValue.class;
	}

	@Override
	public String getModelClassName() {
		return PortletPreferenceValue.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<PortletPreferenceValue, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<PortletPreferenceValue, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PortletPreferenceValue, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((PortletPreferenceValue)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<PortletPreferenceValue, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<PortletPreferenceValue, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(PortletPreferenceValue)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<PortletPreferenceValue, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<PortletPreferenceValue, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<PortletPreferenceValue, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<PortletPreferenceValue, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<PortletPreferenceValue, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<PortletPreferenceValue, Object>>();
		Map<String, BiConsumer<PortletPreferenceValue, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<PortletPreferenceValue, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", PortletPreferenceValue::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<PortletPreferenceValue, Long>)
				PortletPreferenceValue::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", PortletPreferenceValue::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<PortletPreferenceValue, Long>)
				PortletPreferenceValue::setCtCollectionId);
		attributeGetterFunctions.put(
			"portletPreferenceValueId",
			PortletPreferenceValue::getPortletPreferenceValueId);
		attributeSetterBiConsumers.put(
			"portletPreferenceValueId",
			(BiConsumer<PortletPreferenceValue, Long>)
				PortletPreferenceValue::setPortletPreferenceValueId);
		attributeGetterFunctions.put(
			"companyId", PortletPreferenceValue::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<PortletPreferenceValue, Long>)
				PortletPreferenceValue::setCompanyId);
		attributeGetterFunctions.put(
			"portletPreferencesId",
			PortletPreferenceValue::getPortletPreferencesId);
		attributeSetterBiConsumers.put(
			"portletPreferencesId",
			(BiConsumer<PortletPreferenceValue, Long>)
				PortletPreferenceValue::setPortletPreferencesId);
		attributeGetterFunctions.put("index", PortletPreferenceValue::getIndex);
		attributeSetterBiConsumers.put(
			"index",
			(BiConsumer<PortletPreferenceValue, Integer>)
				PortletPreferenceValue::setIndex);
		attributeGetterFunctions.put(
			"largeValue", PortletPreferenceValue::getLargeValue);
		attributeSetterBiConsumers.put(
			"largeValue",
			(BiConsumer<PortletPreferenceValue, String>)
				PortletPreferenceValue::setLargeValue);
		attributeGetterFunctions.put("name", PortletPreferenceValue::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<PortletPreferenceValue, String>)
				PortletPreferenceValue::setName);
		attributeGetterFunctions.put(
			"readOnly", PortletPreferenceValue::getReadOnly);
		attributeSetterBiConsumers.put(
			"readOnly",
			(BiConsumer<PortletPreferenceValue, Boolean>)
				PortletPreferenceValue::setReadOnly);
		attributeGetterFunctions.put(
			"smallValue", PortletPreferenceValue::getSmallValue);
		attributeSetterBiConsumers.put(
			"smallValue",
			(BiConsumer<PortletPreferenceValue, String>)
				PortletPreferenceValue::setSmallValue);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getPortletPreferenceValueId() {
		return _portletPreferenceValueId;
	}

	@Override
	public void setPortletPreferenceValueId(long portletPreferenceValueId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_portletPreferenceValueId = portletPreferenceValueId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getPortletPreferencesId() {
		return _portletPreferencesId;
	}

	@Override
	public void setPortletPreferencesId(long portletPreferencesId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_portletPreferencesId = portletPreferencesId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPortletPreferencesId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("portletPreferencesId"));
	}

	@Override
	public int getIndex() {
		return _index;
	}

	@Override
	public void setIndex(int index) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_index = index;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalIndex() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("index_"));
	}

	@Override
	public String getLargeValue() {
		if (_largeValue == null) {
			return "";
		}
		else {
			return _largeValue;
		}
	}

	@Override
	public void setLargeValue(String largeValue) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_largeValue = largeValue;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public boolean getReadOnly() {
		return _readOnly;
	}

	@Override
	public boolean isReadOnly() {
		return _readOnly;
	}

	@Override
	public void setReadOnly(boolean readOnly) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_readOnly = readOnly;
	}

	@Override
	public String getSmallValue() {
		if (_smallValue == null) {
			return "";
		}
		else {
			return _smallValue;
		}
	}

	@Override
	public void setSmallValue(String smallValue) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_smallValue = smallValue;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSmallValue() {
		return getColumnOriginalValue("smallValue");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), PortletPreferenceValue.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public PortletPreferenceValue toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, PortletPreferenceValue>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		PortletPreferenceValueImpl portletPreferenceValueImpl =
			new PortletPreferenceValueImpl();

		portletPreferenceValueImpl.setMvccVersion(getMvccVersion());
		portletPreferenceValueImpl.setCtCollectionId(getCtCollectionId());
		portletPreferenceValueImpl.setPortletPreferenceValueId(
			getPortletPreferenceValueId());
		portletPreferenceValueImpl.setCompanyId(getCompanyId());
		portletPreferenceValueImpl.setPortletPreferencesId(
			getPortletPreferencesId());
		portletPreferenceValueImpl.setIndex(getIndex());
		portletPreferenceValueImpl.setLargeValue(getLargeValue());
		portletPreferenceValueImpl.setName(getName());
		portletPreferenceValueImpl.setReadOnly(isReadOnly());
		portletPreferenceValueImpl.setSmallValue(getSmallValue());

		portletPreferenceValueImpl.resetOriginalValues();

		return portletPreferenceValueImpl;
	}

	@Override
	public PortletPreferenceValue cloneWithOriginalValues() {
		PortletPreferenceValueImpl portletPreferenceValueImpl =
			new PortletPreferenceValueImpl();

		portletPreferenceValueImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		portletPreferenceValueImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		portletPreferenceValueImpl.setPortletPreferenceValueId(
			this.<Long>getColumnOriginalValue("portletPreferenceValueId"));
		portletPreferenceValueImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		portletPreferenceValueImpl.setPortletPreferencesId(
			this.<Long>getColumnOriginalValue("portletPreferencesId"));
		portletPreferenceValueImpl.setIndex(
			this.<Integer>getColumnOriginalValue("index_"));
		portletPreferenceValueImpl.setLargeValue(
			this.<String>getColumnOriginalValue("largeValue"));
		portletPreferenceValueImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		portletPreferenceValueImpl.setReadOnly(
			this.<Boolean>getColumnOriginalValue("readOnly"));
		portletPreferenceValueImpl.setSmallValue(
			this.<String>getColumnOriginalValue("smallValue"));

		return portletPreferenceValueImpl;
	}

	@Override
	public int compareTo(PortletPreferenceValue portletPreferenceValue) {
		int value = 0;

		if (getIndex() < portletPreferenceValue.getIndex()) {
			value = -1;
		}
		else if (getIndex() > portletPreferenceValue.getIndex()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof PortletPreferenceValue)) {
			return false;
		}

		PortletPreferenceValue portletPreferenceValue =
			(PortletPreferenceValue)object;

		long primaryKey = portletPreferenceValue.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<PortletPreferenceValue> toCacheModel() {
		PortletPreferenceValueCacheModel portletPreferenceValueCacheModel =
			new PortletPreferenceValueCacheModel();

		portletPreferenceValueCacheModel.mvccVersion = getMvccVersion();

		portletPreferenceValueCacheModel.ctCollectionId = getCtCollectionId();

		portletPreferenceValueCacheModel.portletPreferenceValueId =
			getPortletPreferenceValueId();

		portletPreferenceValueCacheModel.companyId = getCompanyId();

		portletPreferenceValueCacheModel.portletPreferencesId =
			getPortletPreferencesId();

		portletPreferenceValueCacheModel.index = getIndex();

		portletPreferenceValueCacheModel.largeValue = getLargeValue();

		String largeValue = portletPreferenceValueCacheModel.largeValue;

		if ((largeValue != null) && (largeValue.length() == 0)) {
			portletPreferenceValueCacheModel.largeValue = null;
		}

		portletPreferenceValueCacheModel.name = getName();

		String name = portletPreferenceValueCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			portletPreferenceValueCacheModel.name = null;
		}

		portletPreferenceValueCacheModel.readOnly = isReadOnly();

		portletPreferenceValueCacheModel.smallValue = getSmallValue();

		String smallValue = portletPreferenceValueCacheModel.smallValue;

		if ((smallValue != null) && (smallValue.length() == 0)) {
			portletPreferenceValueCacheModel.smallValue = null;
		}

		return portletPreferenceValueCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<PortletPreferenceValue, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<PortletPreferenceValue, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PortletPreferenceValue, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(PortletPreferenceValue)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<PortletPreferenceValue, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<PortletPreferenceValue, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PortletPreferenceValue, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((PortletPreferenceValue)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, PortletPreferenceValue>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					PortletPreferenceValue.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _portletPreferenceValueId;
	private long _companyId;
	private long _portletPreferencesId;
	private int _index;
	private String _largeValue;
	private String _name;
	private boolean _readOnly;
	private String _smallValue;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<PortletPreferenceValue, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((PortletPreferenceValue)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put(
			"portletPreferenceValueId", _portletPreferenceValueId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put(
			"portletPreferencesId", _portletPreferencesId);
		_columnOriginalValues.put("index_", _index);
		_columnOriginalValues.put("largeValue", _largeValue);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("readOnly", _readOnly);
		_columnOriginalValues.put("smallValue", _smallValue);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("index_", "index");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("portletPreferenceValueId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("portletPreferencesId", 16L);

		columnBitmasks.put("index_", 32L);

		columnBitmasks.put("largeValue", 64L);

		columnBitmasks.put("name", 128L);

		columnBitmasks.put("readOnly", 256L);

		columnBitmasks.put("smallValue", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private PortletPreferenceValue _escapedModel;

}