/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.messaging;

import com.liferay.mail.internal.MailEngine;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.util.HookFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public class MailMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MailMessageListener.class);
    private static final Set<String> _mailSendBlacklist = new HashSet<String>(Arrays.asList(PropsValues.MAIL_SEND_BLACKLIST));

    protected void doMailMessage(MailMessage mailMessage) throws Exception {
        InternetAddress from = this.filterInternetAddress(mailMessage.getFrom());
        if (from == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Skipping email because the sender is not specified");
            }
            return;
        }
        mailMessage.setFrom(from);
        Object[] to = this.filterInternetAddresses(mailMessage.getTo());
        mailMessage.setTo((InternetAddress[])to);
        Object[] cc = this.filterInternetAddresses(mailMessage.getCC());
        mailMessage.setCC((InternetAddress[])cc);
        Object[] bcc = this.filterInternetAddresses(mailMessage.getBCC());
        InternetAddress[] auditTrail = InternetAddress.parse((String)PropsValues.MAIL_AUDIT_TRAIL);
        if (auditTrail.length > 0) {
            if (ArrayUtil.isNotEmpty((Object[])bcc)) {
                for (InternetAddress internetAddress : auditTrail) {
                    bcc = (InternetAddress[])ArrayUtil.append((Object[])bcc, (Object)internetAddress);
                }
            } else {
                bcc = auditTrail;
            }
        }
        mailMessage.setBCC((InternetAddress[])bcc);
        Object[] bulkAddresses = this.filterInternetAddresses(mailMessage.getBulkAddresses());
        mailMessage.setBulkAddresses((InternetAddress[])bulkAddresses);
        InternetAddress[] replyTo = this.filterInternetAddresses(mailMessage.getReplyTo());
        mailMessage.setReplyTo(replyTo);
        if (ArrayUtil.isNotEmpty((Object[])to) || ArrayUtil.isNotEmpty((Object[])cc) || ArrayUtil.isNotEmpty((Object[])bcc) || ArrayUtil.isNotEmpty((Object[])bulkAddresses)) {
            MailEngine.send(mailMessage);
        }
    }

    protected void doMethodHandler(MethodHandler methodHandler) throws Exception {
        methodHandler.invoke((Object)HookFactory.getInstance());
    }

    protected void doReceive(Message message) throws Exception {
        Object payload = message.getPayload();
        if (payload instanceof MailMessage) {
            this.doMailMessage((MailMessage)payload);
        } else if (payload instanceof MethodHandler) {
            this.doMethodHandler((MethodHandler)payload);
        }
    }

    protected InternetAddress filterInternetAddress(InternetAddress internetAddress) {
        String emailAddress;
        if (PortalRunMode.isTestMode()) {
            return internetAddress;
        }
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress = internetAddress.getAddress())) {
            return null;
        }
        if (_mailSendBlacklist.contains(emailAddress)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Email ", emailAddress, " will be ignored because it ", "is included in ", "mail.send.blacklist"}));
            }
            return null;
        }
        return internetAddress;
    }

    protected InternetAddress[] filterInternetAddresses(InternetAddress[] internetAddresses) {
        if (internetAddresses == null) {
            return null;
        }
        ArrayList<InternetAddress> filteredInternetAddresses = new ArrayList<InternetAddress>(internetAddresses.length);
        for (InternetAddress internetAddress : internetAddresses) {
            InternetAddress filteredInternetAddress = this.filterInternetAddress(internetAddress);
            if (filteredInternetAddress == null) continue;
            filteredInternetAddresses.add(filteredInternetAddress);
        }
        return filteredInternetAddresses.toArray(new InternetAddress[0]);
    }
}

