/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.service.impl;

import com.liferay.mail.kernel.model.Account;
import com.liferay.mail.kernel.model.Filter;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.util.Hook;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.portlet.PortletPreferences;

public class MailServiceImpl
implements IdentifiableOSGiService,
MailService {
    private static final Log _log = LogFactoryUtil.getLog(MailServiceImpl.class);
    private static final MethodKey _addForwardMethodKey = new MethodKey(Hook.class, "addForward", new Class[]{Long.TYPE, Long.TYPE, List.class, List.class, Boolean.TYPE});
    private static final MethodKey _addUserMethodKey = new MethodKey(Hook.class, "addUser", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class});
    private static final MethodKey _addVacationMessageMethodKey = new MethodKey(Hook.class, "addVacationMessage", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class});
    private static final MethodKey _deleteEmailAddressMethodKey = new MethodKey(Hook.class, "deleteEmailAddress", new Class[]{Long.TYPE, Long.TYPE});
    private static final MethodKey _deleteUserMethodKey = new MethodKey(Hook.class, "deleteUser", new Class[]{Long.TYPE, Long.TYPE});
    private static final MethodKey _updateBlockedMethodKey = new MethodKey(Hook.class, "updateBlocked", new Class[]{Long.TYPE, Long.TYPE, List.class});
    private static final MethodKey _updateEmailAddressMethodKey = new MethodKey(Hook.class, "updateEmailAddress", new Class[]{Long.TYPE, Long.TYPE, String.class});
    private static final MethodKey _updatePasswordMethodKey = new MethodKey(Hook.class, "updatePassword", new Class[]{Long.TYPE, Long.TYPE, String.class});
    private final Map<Long, Session> _sessions = new ConcurrentHashMap<Long, Session>();

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"addForward");
            }
            MethodHandler methodHandler = new MethodHandler(_addForwardMethodKey, new Object[]{companyId, userId, filters, emailAddresses, leaveCopy});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"addUser");
            }
            MethodHandler methodHandler = new MethodHandler(_addUserMethodKey, new Object[]{companyId, userId, password, firstName, middleName, lastName, emailAddress});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"addVacationMessage");
            }
            MethodHandler methodHandler = new MethodHandler(_addVacationMessageMethodKey, new Object[]{companyId, userId, emailAddress, vacationMessage});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    @Clusterable
    public void clearSession() {
        this.clearSession(0L);
    }

    @Clusterable
    public void clearSession(long companyId) {
        if (companyId == 0L) {
            this._sessions.clear();
        }
        this._sessions.remove(companyId);
    }

    public void deleteEmailAddress(long companyId, long userId) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"deleteEmailAddress");
            }
            MethodHandler methodHandler = new MethodHandler(_deleteEmailAddressMethodKey, new Object[]{companyId, userId});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    public void deleteUser(long companyId, long userId) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"deleteUser");
            }
            MethodHandler methodHandler = new MethodHandler(_deleteUserMethodKey, new Object[]{companyId, userId});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    public String getOSGiServiceIdentifier() {
        return MailService.class.getName();
    }

    public Session getSession() {
        boolean smtpAuth;
        Properties properties;
        String smtpUser;
        String smtpPassword;
        Session session;
        long companyId;
        block10: {
            PortletPreferences systemPortletPreferences;
            companyId = CompanyThreadLocal.getCompanyId();
            session = this._sessions.get(companyId);
            if (session != null) {
                return session;
            }
            session = InfrastructureUtil.getMailSession();
            PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(companyId);
            Function<String, String> function = arg_0 -> MailServiceImpl.lambda$getSession$5(companyPortletPreferences, systemPortletPreferences = PrefsPropsUtil.getPreferences(), arg_0);
            if (!GetterUtil.getBoolean((String)function.apply("mail.session.mail"))) {
                this._sessions.put(companyId, session);
                return session;
            }
            String advancedPropertiesString = function.apply("mail.session.mail.advanced.properties");
            String pop3Host = function.apply("mail.session.mail.pop3.host");
            String pop3Password = function.apply("mail.session.mail.pop3.password");
            int pop3Port = GetterUtil.getInteger((String)function.apply("mail.session.mail.pop3.port"));
            String pop3User = function.apply("mail.session.mail.pop3.user");
            String smtpHost = function.apply("mail.session.mail.smtp.host");
            smtpPassword = function.apply("mail.session.mail.smtp.password");
            int smtpPort = GetterUtil.getInteger((String)function.apply("mail.session.mail.smtp.port"));
            boolean smtpStartTLSEnable = GetterUtil.getBoolean((String)function.apply("mail.session.mail.smtp.starttls.enable"));
            smtpUser = function.apply("mail.session.mail.smtp.user");
            String storeProtocol = function.apply("mail.session.mail.store.protocol");
            String transportProtocol = function.apply("mail.session.mail.transport.protocol");
            properties = session.getProperties();
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            properties.setProperty("mail.store.protocol", storeProtocol);
            String storePrefix = "mail." + storeProtocol + ".";
            properties.setProperty(storePrefix + "host", pop3Host);
            properties.setProperty(storePrefix + "password", pop3Password);
            properties.setProperty(storePrefix + "port", String.valueOf(pop3Port));
            properties.setProperty(storePrefix + "user", pop3User);
            if (!transportProtocol.equals("smtps")) {
                transportProtocol = "smtp";
            }
            properties.setProperty("mail.transport.protocol", transportProtocol);
            String transportPrefix = "mail." + transportProtocol + ".";
            smtpAuth = false;
            if (Validator.isNotNull((String)smtpPassword) || Validator.isNotNull((String)smtpUser)) {
                smtpAuth = true;
            }
            properties.setProperty(transportPrefix + "auth", String.valueOf(smtpAuth));
            properties.setProperty(transportPrefix + "host", smtpHost);
            properties.setProperty(transportPrefix + "password", smtpPassword);
            properties.setProperty(transportPrefix + "port", String.valueOf(smtpPort));
            properties.setProperty(transportPrefix + "starttls.enable", String.valueOf(smtpStartTLSEnable));
            properties.setProperty(transportPrefix + "user", smtpUser);
            try {
                if (Validator.isNotNull((String)advancedPropertiesString)) {
                    Properties advancedProperties = PropertiesUtil.load((String)advancedPropertiesString);
                    for (Map.Entry<Object, Object> entry : advancedProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        properties.setProperty(key, value);
                    }
                }
            }
            catch (IOException ioException) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Throwable)ioException);
            }
        }
        session = smtpAuth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpUser, smtpPassword);
            }
        }) : Session.getInstance((Properties)properties);
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            properties.list(System.out);
        }
        this._sessions.put(companyId, session);
        return session;
    }

    public Session getSession(Account account) {
        Session session = Session.getInstance((Properties)this._getProperties(account));
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            Properties sessionProperties = session.getProperties();
            sessionProperties.list(System.out);
        }
        return session;
    }

    public void sendEmail(MailMessage mailMessage) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"sendEmail");
            }
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)mailMessage);
            return null;
        });
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"updateBlocked");
            }
            MethodHandler methodHandler = new MethodHandler(_updateBlockedMethodKey, new Object[]{companyId, userId, blocked});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"updateEmailAddress");
            }
            MethodHandler methodHandler = new MethodHandler(_updateEmailAddressMethodKey, new Object[]{companyId, userId, emailAddress});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    public void updatePassword(long companyId, long userId, String password) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"updatePassword");
            }
            MethodHandler methodHandler = new MethodHandler(_updatePasswordMethodKey, new Object[]{companyId, userId, password});
            MessageBusUtil.sendMessage((String)"liferay/mail", (Object)methodHandler);
            return null;
        });
    }

    private Properties _getProperties(Account account) {
        Properties properties = new Properties();
        String protocol = account.getProtocol();
        properties.setProperty("mail.transport.protocol", protocol);
        properties.setProperty("mail." + protocol + ".host", account.getHost());
        properties.setProperty("mail." + protocol + ".port", String.valueOf(account.getPort()));
        if (account.isRequiresAuthentication()) {
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".user", account.getUser());
            properties.setProperty("mail." + protocol + ".password", account.getPassword());
        }
        if (account.isSecure()) {
            properties.setProperty("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail." + protocol + ".socketFactory.fallback", "false");
            properties.setProperty("mail." + protocol + ".socketFactory.port", String.valueOf(account.getPort()));
        }
        return properties;
    }

    private static /* synthetic */ String lambda$getSession$5(PortletPreferences companyPortletPreferences, PortletPreferences systemPortletPreferences, String key) {
        return companyPortletPreferences.getValue(key, systemPortletPreferences.getValue(key, PropsUtil.get((String)key)));
    }
}

