/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;

public class AntiTimeDriftDataSourceWrapper
extends DataSourceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(AntiTimeDriftDataSourceWrapper.class);
    private static long _previousTime = System.currentTimeMillis();

    public AntiTimeDriftDataSourceWrapper(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return (Connection)ProxyUtil.newProxyInstance((ClassLoader)AntiTimeDriftDataSourceWrapper.class.getClassLoader(), (Class[])new Class[]{Connection.class}, (InvocationHandler)new AntiTimeDriftInvocationHandler(super.getConnection()));
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        return (Connection)ProxyUtil.newProxyInstance((ClassLoader)AntiTimeDriftDataSourceWrapper.class.getClassLoader(), (Class[])new Class[]{Connection.class}, (InvocationHandler)new AntiTimeDriftInvocationHandler(super.getConnection(userName, password)));
    }

    private static synchronized boolean _checkTimeDrift() {
        long currentTime;
        long delta;
        boolean drifted = false;
        while ((delta = _previousTime - (currentTime = System.currentTimeMillis())) > 0L) {
            drifted = true;
            delta += 1000L;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Detected time drifting, delay execution for " + delta + "ms"));
            }
            try {
                Thread.sleep(delta);
            }
            catch (InterruptedException interruptedException) {}
        }
        _previousTime = currentTime;
        return drifted;
    }

    private static Object _wrapStatement(Object target) {
        if (target instanceof Statement) {
            Class<?> targetClass = target.getClass();
            target = ProxyUtil.newProxyInstance((ClassLoader)targetClass.getClassLoader(), (Class[])targetClass.getInterfaces(), (InvocationHandler)new AntiTimeDriftInvocationHandler(target));
        }
        return target;
    }

    private static class AntiTimeDriftInvocationHandler
    implements InvocationHandler {
        private final Object _target;

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            AntiTimeDriftDataSourceWrapper._checkTimeDrift();
            try {
                return AntiTimeDriftDataSourceWrapper._wrapStatement(method.invoke(this._target, args));
            }
            catch (InvocationTargetException invocationTargetException1) {
                SQLException sqlException;
                Throwable throwable1 = invocationTargetException1.getCause();
                if (throwable1 instanceof SQLException && (sqlException = (SQLException)throwable1).getErrorCode() == -204 && Objects.equals("42704", sqlException.getSQLState()) && AntiTimeDriftDataSourceWrapper._checkTimeDrift()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Caught a \"SQLCODE=-204, SQLSTATE=42704\" and time drift, retry on the method call", throwable1);
                    }
                    try {
                        return AntiTimeDriftDataSourceWrapper._wrapStatement(method.invoke(this._target, args));
                    }
                    catch (InvocationTargetException invocationTargetException2) {
                        Throwable throwable2 = invocationTargetException2.getCause();
                        throwable2.addSuppressed(throwable1);
                        throw throwable2;
                    }
                }
                throw throwable1;
            }
        }

        private AntiTimeDriftInvocationHandler(Object target) {
            this._target = target;
        }
    }
}

