/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;

public class HSQLDialect
extends org.hibernate.dialect.HSQLDialect {
    private final HSQLLimitHandler _hsqlLimitHandler = new HSQLLimitHandler();

    public String getForUpdateString() {
        return " for update";
    }

    public LimitHandler getLimitHandler() {
        return this._hsqlLimitHandler;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        if (hasOffset) {
            return sql.concat(" limit ?, ?");
        }
        return sql.concat(" limit ?");
    }

    private final class HSQLLimitHandler
    extends AbstractLimitHandler {
        private HSQLLimitHandler() {
        }

        public boolean bindLimitParametersFirst() {
            return false;
        }

        public String processSql(String sql, RowSelection selection) {
            return HSQLDialect.this.getLimitString(sql, LimitHelper.hasFirstRow((RowSelection)selection));
        }

        public boolean supportsLimit() {
            return true;
        }
    }
}

