/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.image.BaseHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemHook
extends BaseHook {
    private final File _rootDir = new File(PropsValues.IMAGE_HOOK_FILE_SYSTEM_ROOT_DIR);

    public FileSystemHook() throws IOException {
        FileUtil.mkdirs((File)this._rootDir);
    }

    public void deleteImage(Image image) {
        FileUtil.delete((File)this.getFile(image.getImageId(), image.getType()));
    }

    public byte[] getImageAsBytes(Image image) throws PortalException {
        try {
            File file = this.getFile(image.getImageId(), image.getType());
            if (!file.exists()) {
                throw new NoSuchFileException(file.getPath());
            }
            return FileUtil.getBytes((File)file);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public InputStream getImageAsStream(Image image) throws PortalException {
        try {
            File file = this.getFile(image.getImageId(), image.getType());
            if (!file.exists()) {
                throw new NoSuchFileException(file.getPath());
            }
            return new FileInputStream(file);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void updateImage(Image image, String type, byte[] bytes) {
        try {
            FileUtil.write((File)this.getFile(image.getImageId(), type), (byte[])bytes);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    protected String buildPath(String fileNameFragment) {
        int fileNameFragmentLength = fileNameFragment.length();
        if (fileNameFragmentLength <= 2) {
            return "";
        }
        StringBundler sb = new StringBundler(fileNameFragmentLength / 2 + fileNameFragmentLength);
        for (int i = 0; i < fileNameFragmentLength; i += 2) {
            if (i + 2 >= fileNameFragmentLength) continue;
            sb.append("/");
            sb.append(fileNameFragment.substring(i, i + 2));
        }
        return sb.toString();
    }

    protected File getFile(long imageId, String type) {
        String path = this.buildPath(String.valueOf(imageId));
        return new File(StringBundler.concat((Object[])new Object[]{this._rootDir, "/", path, "/", imageId, ".", type}));
    }
}

