/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.upgrade.BaseUpgradeCallable;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.log.Log4jLogContextLogWrapper;
import com.liferay.portal.log.Log4jLogContextUpgradeLogWrapper;
import com.liferay.portal.log.Log4jLogImpl;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProperties;
import org.apache.logging.log4j.LogManager;

public class Log4jLogFactoryImpl
implements LogFactory {
    private static final Class<?>[] _CLASSES_BASE_UPGRADE = new Class[]{BaseDB.class, BaseDBProcess.class, BaseUpgradeCallable.class, LoggingTimer.class};
    private static final Class<?>[] _CLASSES_STATIC_UPGRADE = new Class[]{DBUpgrader.class, VerifyProperties.class};
    private static volatile boolean _upgradeLogContextEnabled = PropsValues.UPGRADE_LOG_CONTEXT_ENABLED;

    public Log getLog(Class<?> c) {
        return this.getLog(c.getName());
    }

    public Log getLog(String name) {
        LogWrapper log = new Log4jLogContextLogWrapper(new Log4jLogImpl(LogManager.getLogger((String)name)));
        if (_upgradeLogContextEnabled && this._isUpgradeClass(name)) {
            log = new Log4jLogContextUpgradeLogWrapper((Log)log);
        }
        return log;
    }

    private boolean _isUpgradeClass(String name) {
        try {
            Thread thread = Thread.currentThread();
            Class<?> clazz = Class.forName(name, true, thread.getContextClassLoader());
            for (Class<?> baseClazz : _CLASSES_BASE_UPGRADE) {
                if (!baseClazz.isAssignableFrom(clazz)) continue;
                return true;
            }
            for (Class<?> staticClazz : _CLASSES_STATIC_UPGRADE) {
                if (!name.equals(staticClazz)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

