/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.minifier;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.io.unsync.UnsyncStringReader;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.internal.minifier.MinifierThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.minifier.CSSCompressor;
import com.liferay.portal.minifier.JavaScriptMinifier;
import com.liferay.portal.util.PropsValues;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Deprecated
public class MinifierUtil {
    private static final Log _log = LogFactoryUtil.getLog(MinifierUtil.class);
    private static volatile JavaScriptMinifier _javaScriptMinifier = (JavaScriptMinifier)ServiceProxyFactory.newServiceTrackedInstance(JavaScriptMinifier.class, MinifierUtil.class, (String)"_javaScriptMinifier", (boolean)false, (boolean)true);
    private static final ServiceTrackerMap<String, ServletContext> _liferayServletContextsMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), ServletContext.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, ServletContext>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<ServletContext> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Bundle bundle = serviceReference.getBundle();
            String symbolicName = bundle.getSymbolicName();
            if (!symbolicName.startsWith("com.liferay.")) {
                return;
            }
            BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            ServletContext servletContext = (ServletContext)bundleContext.getService(serviceReference);
            try {
                emitter.emit((Object)servletContext.getContextPath());
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
    });

    public static String minifyCss(String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyCss(content);
        }
        return content;
    }

    public static String minifyJavaScript(String resourceName, String content) {
        if (PropsValues.MINIFIER_ENABLED && MinifierThreadLocal.isEnabled()) {
            return MinifierUtil._minifyJavaScript(resourceName, content);
        }
        return content;
    }

    private static String _getServletContextPath(String resourceName) {
        String pathModule = "/o";
        int i = resourceName.indexOf("/", pathModule.length() + 1);
        if (i == -1) {
            return "";
        }
        return resourceName.substring(0, i);
    }

    private static boolean _isLiferayResource(String resourceName) {
        return resourceName.startsWith("/o/admin-theme/") || resourceName.startsWith("/o/classic-theme/") || resourceName.startsWith("/o/js/resolved-module/") || _liferayServletContextsMap.containsKey((Object)MinifierUtil._getServletContextPath(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _minifyCss(String content) {
        String string;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            CSSCompressor cssCompressor = new CSSCompressor((Reader)new UnsyncStringReader(content));
            cssCompressor.compress((Writer)unsyncStringWriter, PropsValues.YUI_COMPRESSOR_CSS_LINE_BREAK);
            string = unsyncStringWriter.toString();
        }
        catch (Exception exception) {
            String string2;
            try {
                _log.error((Object)("Unable to minify CSS:\n" + content), (Throwable)exception);
                unsyncStringWriter.append((CharSequence)content);
                string2 = unsyncStringWriter.toString();
            }
            catch (Throwable throwable) {
                if (_log.isDebugEnabled()) {
                    int length = 0;
                    if (content != null) {
                        byte[] bytes = content.getBytes();
                        length = bytes.length;
                    }
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isDebugEnabled()) {
                int length = 0;
                if (content != null) {
                    byte[] bytes = content.getBytes();
                    length = bytes.length;
                }
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"}));
            }
            return string2;
        }
        if (_log.isDebugEnabled()) {
            int length = 0;
            if (content != null) {
                byte[] bytes = content.getBytes();
                length = bytes.length;
            }
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of CSS took ", stopWatch.getTime(), " ms"}));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _minifyJavaScript(String resourceName, String content) {
        String string;
        JavaScriptMinifier javaScriptMinifier = _javaScriptMinifier;
        if (javaScriptMinifier == null || MinifierUtil._isLiferayResource(resourceName)) {
            return content;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            string = javaScriptMinifier.compress(resourceName, content);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                int length = 0;
                if (content != null) {
                    byte[] bytes = content.getBytes();
                    length = bytes.length;
                }
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of JavaScript in resource ", resourceName, " took ", stopWatch.getTime(), " ms"}));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            int length = 0;
            if (content != null) {
                byte[] bytes = content.getBytes();
                length = bytes.length;
            }
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Minification for ", length, " bytes of JavaScript in resource ", resourceName, " took ", stopWatch.getTime(), " ms"}));
        }
        return string;
    }

    private MinifierUtil() {
    }
}

