/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.CapabilityProvider;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.repository.capabilities.BaseCapabilityRepository;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class CapabilityRepository
extends BaseCapabilityRepository<Repository>
implements Repository {
    private final RepositoryEventTrigger _repositoryEventTrigger;

    public CapabilityRepository(Repository repository, CapabilityProvider capabilityProvider, RepositoryEventTrigger repositoryEventTrigger) {
        super(repository, capabilityProvider);
        this._repositoryEventTrigger = repositoryEventTrigger;
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, expirationDate, reviewDate, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, expirationDate, reviewDate, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileShortcut fileShortcut = repository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileShortcut.class, (Object)fileShortcut);
        return fileShortcut;
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.addFolder(userId, parentFolderId, name, description, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, Folder.class, (Object)folder);
        return folder;
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileVersion fileVersion = repository.cancelCheckOut(fileEntryId);
        if (fileVersion != null) {
            this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileVersion.getFileEntry());
        }
        return fileVersion;
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        repository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)repository.getFileEntry(fileEntryId));
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        repository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)repository.getFileEntry(fileEntryId));
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public void deleteAll() throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Repository.class, (Object)repository);
        repository.deleteAll();
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)repository.getFileEntry(fileEntryId));
        repository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntry(long folderId, String title) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)repository.getFileEntry(folderId, title));
        repository.deleteFileEntry(folderId, title);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileShortcut.class, (Object)repository.getFileShortcut(fileShortcutId));
        repository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.getFileEntry(toFileEntryId);
        List fileShortcuts = fileEntry.getFileShortcuts();
        for (FileShortcut fileShortcut : fileShortcuts) {
            this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileShortcut.class, (Object)fileShortcut);
        }
        repository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileVersion.class, (Object)repository.getFileVersion(fileVersionId));
        repository.deleteFileVersion(fileVersionId);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileVersion.class, (Object)fileEntry.getFileVersion(version));
        repository.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)repository.getFolder(folderId));
        repository.deleteFolder(folderId);
    }

    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)repository.getFolder(parentFolderId, name));
        repository.deleteFolder(parentFolderId, name);
    }

    public FileEntry fetchFileEntry(long folderId, String title) throws PortalException {
        return ((Repository)this.getRepository()).fetchFileEntry(folderId, title);
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, status, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, fileEntryTypeId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, mimeTypes, status, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, mimeTypes, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId, status);
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId, mimeTypes);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes, int status) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId, mimeTypes, status);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByExternalReferenceCode(String externalReferenceCode) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntryByExternalReferenceCode(externalReferenceCode);
    }

    public FileEntry getFileEntryByFileName(long folderId, String fileName) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntryByFileName(folderId, fileName);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntryByUuid(uuid);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return ((Repository)this.getRepository()).getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return ((Repository)this.getRepository()).getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return ((Repository)this.getRepository()).getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return ((Repository)this.getRepository()).getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFolders(parentFolderId, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFolders(parentFolderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, includeOwner, start, end, orderByComparator);
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, start, end, orderByComparator);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders, includeOwner);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersCount(parentFolderId, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersFileEntriesCount(folderIds, status);
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getMountFolders(parentFolderId, start, end, orderByComparator);
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return ((Repository)this.getRepository()).getMountFoldersCount(parentFolderId);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntries(userId, rootFolderId, start, end, orderByComparator);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, orderByComparator);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    @Override
    public long getRepositoryId() {
        return ((Repository)this.getRepository()).getRepositoryId();
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        ((Repository)this.getRepository()).getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        return ((Repository)this.getRepository()).getSubfolderIds(folderId, recurse);
    }

    public Lock lockFolder(long folderId) throws PortalException {
        return ((Repository)this.getRepository()).lockFolder(folderId);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Move.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.moveFolder(userId, folderId, parentFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Move.class, Folder.class, (Object)folder);
        return folder;
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        repository.revertFileEntry(userId, fileEntryId, version, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)this.getFileEntry(fileEntryId));
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        return ((Repository)this.getRepository()).search(creatorUserId, status, start, end);
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return ((Repository)this.getRepository()).search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        return ((Repository)this.getRepository()).search(searchContext);
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return ((Repository)this.getRepository()).search(searchContext, query);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        ((Repository)this.getRepository()).unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        ((Repository)this.getRepository()).unlockFolder(parentFolderId, name, lockUuid);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, expirationDate, reviewDate, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, expirationDate, reviewDate, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileShortcut fileShortcut = repository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileShortcut.class, (Object)fileShortcut);
        return fileShortcut;
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry oldToFileEntry = repository.getFileEntry(oldToFileEntryId);
        List fileShortcuts = oldToFileEntry.getFileShortcuts();
        for (FileShortcut fileShortcut : fileShortcuts) {
            this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileShortcut.class, (Object)fileShortcut);
        }
        repository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, Folder.class, (Object)folder);
        return folder;
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.updateFolder(folderId, name, description, serviceContext);
        if (folderId != 0L) {
            this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, Folder.class, (Object)folder);
        }
        return folder;
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return ((Repository)this.getRepository()).verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        return ((Repository)this.getRepository()).verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return ((Repository)this.getRepository()).verifyInheritableLock(folderId, lockUuid);
    }
}

