/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class StrutsPortletAuthTokenWhitelist
extends BaseAuthTokenWhitelist {
    private static final Log _log = LogFactoryUtil.getLog(StrutsPortletAuthTokenWhitelist.class);
    private volatile Set<String> _portletCSRFWhitelist;
    private volatile Set<String> _portletInvocationWhitelist;

    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        String portletId = portlet.getPortletId();
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        String strutsAction = httpServletRequest.getParameter(namespace.concat("struts_action"));
        if (Validator.isNull((String)strutsAction)) {
            return false;
        }
        Set<String> portletCSRFWhitelist = this._getPortletCSRFWhitelist();
        return portletCSRFWhitelist.contains(strutsAction) && this.isValidStrutsAction(portlet.getCompanyId(), PortletIdCodec.decodePortletName((String)portletId), strutsAction);
    }

    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        String portletId = portlet.getPortletId();
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        String strutsAction = httpServletRequest.getParameter(namespace.concat("struts_action"));
        if (Validator.isNull((String)strutsAction)) {
            strutsAction = httpServletRequest.getParameter("struts_action");
        }
        if (Validator.isNull((String)strutsAction)) {
            return false;
        }
        Set<String> portletInvocationWhitelist = this._getPortletInvocationWhitelist();
        return portletInvocationWhitelist.contains(strutsAction) && this.isValidStrutsAction(portlet.getCompanyId(), portletId, strutsAction);
    }

    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String strutsAction = liferayPortletURL.getParameter("struts_action");
        if (Validator.isBlank((String)strutsAction)) {
            return false;
        }
        Set<String> portletCSRFWhitelist = this._getPortletCSRFWhitelist();
        if (portletCSRFWhitelist.contains(strutsAction)) {
            long plid = liferayPortletURL.getPlid();
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
            if (layout == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to load layout " + plid));
                }
                return false;
            }
            String rootPortletId = PortletIdCodec.decodePortletName((String)liferayPortletURL.getPortletId());
            if (this.isValidStrutsAction(0L, rootPortletId, strutsAction)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        String strutsAction = liferayPortletURL.getParameter("struts_action");
        if (Validator.isBlank((String)strutsAction)) {
            return false;
        }
        Set<String> portletInvocationWhitelist = this._getPortletInvocationWhitelist();
        if (portletInvocationWhitelist.contains(strutsAction)) {
            long plid = liferayPortletURL.getPlid();
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
            if (layout == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to load layout " + plid));
                }
                return false;
            }
            if (this.isValidStrutsAction(0L, liferayPortletURL.getPortletId(), strutsAction)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidStrutsAction(long companyId, String portletId, String strutsAction) {
        block4: {
            try {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                if (portlet == null) {
                    return false;
                }
                String strutsPath = strutsAction.substring(1, strutsAction.lastIndexOf(47));
                if (strutsPath.equals(portlet.getStrutsPath()) || strutsPath.equals(portlet.getParentStrutsPath())) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getPortletCSRFWhitelist() {
        Set<String> portletCSRFWhitelist = this._portletCSRFWhitelist;
        if (portletCSRFWhitelist != null) {
            return portletCSRFWhitelist;
        }
        StrutsPortletAuthTokenWhitelist strutsPortletAuthTokenWhitelist = this;
        synchronized (strutsPortletAuthTokenWhitelist) {
            if (this._portletCSRFWhitelist == null) {
                portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
                this.registerPortalProperty("auth.token.ignore.actions");
                this.trackWhitelistServices("auth.token.ignore.actions", portletCSRFWhitelist);
                this._portletCSRFWhitelist = portletCSRFWhitelist;
            } else {
                portletCSRFWhitelist = this._portletCSRFWhitelist;
            }
        }
        return portletCSRFWhitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getPortletInvocationWhitelist() {
        Set<String> portletInvocationWhitelist = this._portletInvocationWhitelist;
        if (portletInvocationWhitelist != null) {
            return portletInvocationWhitelist;
        }
        StrutsPortletAuthTokenWhitelist strutsPortletAuthTokenWhitelist = this;
        synchronized (strutsPortletAuthTokenWhitelist) {
            if (this._portletInvocationWhitelist == null) {
                portletInvocationWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
                this.registerPortalProperty("portlet.add.default.resource.check.whitelist.actions");
                this.trackWhitelistServices("portlet.add.default.resource.check.whitelist.actions", portletInvocationWhitelist);
                this._portletInvocationWhitelist = portletInvocationWhitelist;
            } else {
                portletInvocationWhitelist = this._portletInvocationWhitelist;
            }
        }
        return portletInvocationWhitelist;
    }
}

