/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.ResourceActionsException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.DocumentType;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;

public class ResourceActionsImpl
implements ResourceActions {
    @BeanReference(type=PortletLocalService.class)
    protected PortletLocalService portletLocalService;
    @BeanReference(type=ResourceActionLocalService.class)
    protected ResourceActionLocalService resourceActionLocalService;
    @BeanReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    private static final String _ACTION_NAME_PREFIX = "action.";
    private static final String _COMPOSITE_MODEL_NAME_SEPARATOR = "-";
    private static final String _MODEL_RESOURCE_NAME_PREFIX = "model.resource.";
    private static final Log _log = LogFactoryUtil.getLog(ResourceActionsImpl.class);
    private final Map<String, Double> _modelResourceWeights = new HashMap<String, Double>();
    private final Set<String> _organizationModelResources = new HashSet<String>();
    private final Set<String> _portalModelResources = new HashSet<String>();
    private final Map<String, String> _portletRootModelResources = new HashMap<String, String>();
    private final Map<String, ResourceActionsBag> _resourceActionsBags = new HashMap<String, ResourceActionsBag>();
    private final Map<String, Set<String>> _resourceReferences = new HashMap<String, Set<String>>();

    public void check(String portletName) {
        this._check(portletName, this.getPortletResourceActions(portletName));
    }

    public String getAction(HttpServletRequest httpServletRequest, String action) {
        String key = _ACTION_NAME_PREFIX + action;
        String value = LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this._getResourceBundlesString(httpServletRequest, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getAction(Locale locale, String action) {
        String key = _ACTION_NAME_PREFIX + action;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this._getResourceBundlesString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getCompositeModelName(String ... classNames) {
        if (ArrayUtil.isEmpty((Object[])classNames)) {
            return "";
        }
        Arrays.sort(classNames);
        StringBundler sb = new StringBundler(classNames.length * 2);
        for (String className : classNames) {
            sb.append(className);
            sb.append(this.getCompositeModelNameSeparator());
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public String getCompositeModelNameSeparator() {
        return _COMPOSITE_MODEL_NAME_SEPARATOR;
    }

    public List<String> getModelNames() {
        ArrayList<String> modelNames = new ArrayList<String>();
        for (String name : this._resourceActionsBags.keySet()) {
            if (name.indexOf(46) == -1) continue;
            modelNames.add(name);
        }
        return modelNames;
    }

    public List<String> getModelPortletResources(String name) {
        Set<String> resources = this._resourceReferences.get(name);
        if (resources == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(resources);
    }

    public String getModelResource(HttpServletRequest httpServletRequest, String name) {
        String key = this.getModelResourceNamePrefix() + name;
        String value = LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this._getResourceBundlesString(httpServletRequest, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getModelResource(Locale locale, String name) {
        String key = this.getModelResourceNamePrefix() + name;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null) {
            value = this._getResourceBundlesString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public List<String> getModelResourceActions(String name) {
        ResourceActionsBag modelResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getSupportsActions());
    }

    public List<String> getModelResourceGroupDefaultActions(String name) {
        ResourceActionsBag modelResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getGroupDefaultActions());
    }

    public List<String> getModelResourceGuestDefaultActions(String name) {
        ResourceActionsBag modelResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getGuestDefaultActions());
    }

    public List<String> getModelResourceGuestUnsupportedActions(String name) {
        ResourceActionsBag modelResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getGuestUnsupportedActions());
    }

    public String getModelResourceNamePrefix() {
        return _MODEL_RESOURCE_NAME_PREFIX;
    }

    public List<String> getModelResourceOwnerDefaultActions(String name) {
        ResourceActionsBag modelResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getOwnerDefaultActions());
    }

    public Double getModelResourceWeight(String name) {
        return this._modelResourceWeights.get(name);
    }

    public List<String> getPortletModelResources(String portletName) {
        Set<String> resources = this._resourceReferences.get(portletName = PortletIdCodec.decodePortletName((String)portletName));
        if (resources == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(resources);
    }

    public List<String> getPortletNames() {
        ArrayList<String> portletNames = new ArrayList<String>();
        for (String name : this._resourceActionsBags.keySet()) {
            if (name.indexOf(46) != -1) continue;
            portletNames.add(name);
        }
        return portletNames;
    }

    public List<String> getPortletResourceActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        Portlet portlet = this.portletLocalService.getPortletById(name);
        return this._getPortletResourceActions(name, portlet);
    }

    public List<String> getPortletResourceGroupDefaultActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        ResourceActionsBag portletResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getGroupDefaultActions());
    }

    public List<String> getPortletResourceGuestDefaultActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        ResourceActionsBag portletResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getGuestDefaultActions());
    }

    public List<String> getPortletResourceGuestUnsupportedActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        ResourceActionsBag portletResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getGuestUnsupportedActions());
    }

    public List<String> getPortletResourceLayoutManagerActions(String name) {
        name = PortletIdCodec.decodePortletName((String)name);
        ResourceActionsBag portletResourceActionsBag = this._getResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getLayoutManagerActions());
    }

    public String getPortletRootModelResource(String portletName) {
        return this._portletRootModelResources.get(PortletIdCodec.decodePortletName((String)portletName));
    }

    public List<String> getResourceActions(String name) {
        if (name.indexOf(46) != -1) {
            return this.getModelResourceActions(name);
        }
        return this.getPortletResourceActions(name);
    }

    public List<String> getResourceActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? this.getPortletResourceActions(portletResource) : this.getModelResourceActions(modelResource);
        return actions;
    }

    public List<String> getResourceGuestUnsupportedActions(String portletResource, String modelResource) {
        if (Validator.isNull((String)modelResource)) {
            return this.getPortletResourceGuestUnsupportedActions(portletResource);
        }
        if (Validator.isNull((String)portletResource)) {
            return this.getModelResourceGuestUnsupportedActions(modelResource);
        }
        if (this._resourceActionsBags.containsKey(modelResource)) {
            return this.getModelResourceGuestUnsupportedActions(modelResource);
        }
        if (this._resourceActionsBags.containsKey(portletResource)) {
            return this.getPortletResourceGuestUnsupportedActions(portletResource);
        }
        return Collections.emptyList();
    }

    public List<Role> getRoles(long companyId, Group group, String modelResource, int[] roleTypes) {
        if (roleTypes == null) {
            roleTypes = this._getRoleTypes(group, modelResource);
        }
        return this.roleLocalService.getRoles(companyId, roleTypes);
    }

    public boolean isPortalModelResource(String modelResource) {
        return this._portalModelResources.contains(modelResource);
    }

    public boolean isRootModelResource(String modelResource) {
        Collection<String> rootModelResources = this._portletRootModelResources.values();
        return rootModelResources.contains(modelResource);
    }

    public void populateModelResources(ClassLoader classLoader, String ... sources) throws ResourceActionsException {
        if (ArrayUtil.isEmpty((Object[])sources)) {
            return;
        }
        HashSet modelResourceNames = new HashSet();
        for (String source : sources) {
            this._read(classLoader, source, (UnsafeConsumer<Element, ResourceActionsException>)((UnsafeConsumer)rootElement -> this._readModelResources((Element)rootElement, modelResourceNames)));
        }
        for (String modelResourceName : modelResourceNames) {
            this.resourceActionLocalService.checkResourceActions(modelResourceName, this.getModelResourceActions(modelResourceName));
        }
    }

    public void populateModelResources(Document document) throws ResourceActionsException {
        DocumentType documentType = document.getDocumentType();
        String publicId = GetterUtil.getString((String)documentType.getPublicId());
        if (publicId.equals("-//Liferay//DTD Resource Action Mapping 6.0.0//EN") && _log.isWarnEnabled()) {
            _log.warn((Object)"Please update document to use the 6.1.0 format");
        }
        HashSet<String> modelResourceNames = new HashSet<String>();
        this._readModelResources(document.getRootElement(), modelResourceNames);
        for (String modelResourceName : modelResourceNames) {
            this.resourceActionLocalService.checkResourceActions(modelResourceName, this.getModelResourceActions(modelResourceName));
        }
    }

    public void populatePortletResource(Portlet portlet, ClassLoader classLoader, String ... sources) throws ResourceActionsException {
        if (portlet == null) {
            throw new IllegalArgumentException("Portlet must not be null");
        }
        if (ArrayUtil.isNotEmpty((Object[])sources) && PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            for (String source : sources) {
                this._read(classLoader, source, (UnsafeConsumer<Element, ResourceActionsException>)((UnsafeConsumer)rootElement -> this._readPortletResource((Element)rootElement, portlet)));
            }
        }
        String portletResourceName = PortletIdCodec.decodePortletName((String)portlet.getPortletId());
        this.resourceActionLocalService.checkResourceActions(portletResourceName, this._getPortletResourceActions(portletResourceName, portlet));
    }

    public void populatePortletResources(ClassLoader classLoader, String ... sources) throws ResourceActionsException {
        if (ArrayUtil.isEmpty((Object[])sources) || !PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            return;
        }
        HashSet portletResourceNames = new HashSet();
        for (String source : sources) {
            this._read(classLoader, source, (UnsafeConsumer<Element, ResourceActionsException>)((UnsafeConsumer)rootElement -> this._readPortletResources((Element)rootElement, portletResourceNames)));
        }
        for (String portletResourceName : portletResourceNames) {
            this.resourceActionLocalService.checkResourceActions(portletResourceName, this.getPortletResourceActions(portletResourceName));
        }
    }

    public void readModelResources(ClassLoader classLoader, String source) throws ResourceActionsException {
        this._read(classLoader, source, (UnsafeConsumer<Element, ResourceActionsException>)((UnsafeConsumer)rootElement -> this._readModelResources((Element)rootElement, null)));
    }

    private void _check(String portletName, List<String> portletResourceActions) {
        ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, portletResourceActions);
        for (String modelName : this.getPortletModelResources(portletName)) {
            ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, this.getModelResourceActions(modelName));
        }
    }

    private void _checkGuestUnsupportedActions(Set<String> guestUnsupportedActions, Set<String> guestDefaultActions) {
        Iterator<String> iterator = guestDefaultActions.iterator();
        while (iterator.hasNext()) {
            String actionId = iterator.next();
            if (!guestUnsupportedActions.contains(actionId)) continue;
            iterator.remove();
        }
    }

    private void _checkPortletGuestUnsupportedActions(Set<String> actions) {
        actions.add("CONFIGURATION");
        actions.add("PERMISSIONS");
    }

    private void _checkPortletLayoutManagerActions(Set<String> actions) {
        if (!actions.contains("ACCESS_IN_CONTROL_PANEL")) {
            actions.add("ADD_TO_PAGE");
        }
        actions.add("CONFIGURATION");
        actions.add("PERMISSIONS");
        actions.add("PREFERENCES");
        actions.add("VIEW");
    }

    private String _getCompositeModelName(Element compositeModelNameElement) {
        StringBundler sb = new StringBundler();
        ArrayList elements = new ArrayList(compositeModelNameElement.elements("model-name"));
        Collections.sort(elements, new Comparator<Element>(){

            @Override
            public int compare(Element element1, Element element2) {
                String textTrim1 = GetterUtil.getString((String)element1.getTextTrim());
                String textTrim2 = GetterUtil.getString((String)element2.getTextTrim());
                return textTrim1.compareTo(textTrim2);
            }
        });
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element modelNameElement = (Element)iterator.next();
            sb.append(modelNameElement.getTextTrim());
            if (!iterator.hasNext()) continue;
            sb.append(_COMPOSITE_MODEL_NAME_SEPARATOR);
        }
        return sb.toString();
    }

    private Element _getPermissionsChildElement(Element parentElement, String childElementName) {
        Element permissionsElement = parentElement.element("permissions");
        if (permissionsElement != null) {
            return permissionsElement.element(childElementName);
        }
        return parentElement.element(childElementName);
    }

    private Set<String> _getPortletMimeTypeActions(String name, Portlet portlet) {
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        if (portlet != null) {
            Map portletModes = portlet.getPortletModes();
            Set mimeTypePortletModes = (Set)portletModes.get("text/html");
            if (mimeTypePortletModes != null) {
                for (String actionId : mimeTypePortletModes) {
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit")) {
                        actions.add("PREFERENCES");
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit_guest")) {
                        actions.add("GUEST_PREFERENCES");
                        continue;
                    }
                    actions.add(StringUtil.toUpperCase((String)actionId));
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to obtain resource actions for unknown portlet " + name));
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _getPortletResourceActions(String name, Portlet portlet) {
        ResourceActionsBag portletResourceActionsBag = this._getResourceActionsBag(name);
        Set<String> portletActions = portletResourceActionsBag.getSupportsActions();
        if (!portletActions.isEmpty()) {
            return new ArrayList<String>(portletActions);
        }
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            portletActions = this._getPortletMimeTypeActions(name, portlet);
            if (!name.equals("90")) {
                this._checkPortletLayoutManagerActions(portletActions);
                portletActions.add("ACCESS_IN_CONTROL_PANEL");
            }
            Set<String> groupDefaultActions = portletResourceActionsBag.getGroupDefaultActions();
            groupDefaultActions.add("VIEW");
            Set<String> guestDefaultActions = portletResourceActionsBag.getGuestDefaultActions();
            guestDefaultActions.add("VIEW");
            this._checkPortletGuestUnsupportedActions(portletResourceActionsBag.getGuestUnsupportedActions());
            this._checkPortletLayoutManagerActions(portletResourceActionsBag.getLayoutManagerActions());
        }
        return new ArrayList<String>(portletActions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceActionsBag _getResourceActionsBag(String name) {
        ResourceActionsBag resourceActionsBag = this._resourceActionsBags.get(name);
        if (resourceActionsBag != null) {
            return resourceActionsBag;
        }
        Map<String, ResourceActionsBag> map = this._resourceActionsBags;
        synchronized (map) {
            resourceActionsBag = this._resourceActionsBags.get(name);
            if (resourceActionsBag != null) {
                return resourceActionsBag;
            }
            resourceActionsBag = new ResourceActionsBag();
            this._resourceActionsBags.put(name, resourceActionsBag);
        }
        return resourceActionsBag;
    }

    private String _getResourceBundlesString(HttpServletRequest httpServletRequest, String key) {
        Locale locale = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            locale = (Locale)httpSession.getAttribute("LOCALE");
        }
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        return this._getResourceBundlesString(locale, key);
    }

    private String _getResourceBundlesString(Locale locale, String key) {
        if (locale == null || key == null) {
            return null;
        }
        for (ResourceBundleLoader resourceBundleLoader : ResourceBundleLoaderListHolder._resourceBundleLoaders) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
            if (resourceBundle == null || !resourceBundle.containsKey(key)) continue;
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        }
        return null;
    }

    private int[] _getRoleTypes(Group group, String modelResource) {
        int[] types = RoleConstants.TYPES_REGULAR_AND_SITE;
        if (this.isPortalModelResource(modelResource)) {
            types = modelResource.equals(Organization.class.getName()) || modelResource.equals(User.class.getName()) ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR : RoleConstants.TYPES_REGULAR;
        } else if (group != null) {
            block9: {
                if (group.isLayout()) {
                    try {
                        group = GroupServiceUtil.getGroup((long)group.getParentGroupId());
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block9;
                        _log.debug((Throwable)exception);
                    }
                }
            }
            if (group.isOrganization()) {
                types = RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE;
            } else if (group.isCompany() || group.isUser() || group.isUserGroup()) {
                types = RoleConstants.TYPES_REGULAR;
            }
        }
        return types;
    }

    private void _read(ClassLoader classLoader, String source, UnsafeConsumer<Element, ResourceActionsException> readResourceConsumer) throws ResourceActionsException {
        InputStream inputStream = classLoader.getResourceAsStream(source);
        if (inputStream == null) {
            if (_log.isInfoEnabled() && !source.endsWith("-ext.xml") && !source.startsWith("META-INF/")) {
                _log.info((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        try {
            Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true);
            DocumentType documentType = document.getDocumentType();
            String publicId = GetterUtil.getString((String)documentType.getPublicId());
            if (publicId.equals("-//Liferay//DTD Resource Action Mapping 6.0.0//EN") && _log.isWarnEnabled()) {
                _log.warn((Object)("Please update " + source + " to use the 6.1.0 format"));
            }
            Element rootElement = document.getRootElement();
            for (Element resourceElement : rootElement.elements("resource")) {
                String file = StringUtil.trim((String)resourceElement.attributeValue("file"));
                this._read(classLoader, file, readResourceConsumer);
                String extFileName = StringUtil.replace((String)file, (String)".xml", (String)"-ext.xml");
                this._read(classLoader, extFileName, readResourceConsumer);
            }
            readResourceConsumer.accept((Object)rootElement);
            if (source.endsWith(".xml") && !source.endsWith("-ext.xml")) {
                String extFileName = StringUtil.replace((String)source, (String)".xml", (String)"-ext.xml");
                this._read(classLoader, extFileName, readResourceConsumer);
            }
        }
        catch (DocumentException documentException) {
            throw new ResourceActionsException((Throwable)documentException);
        }
    }

    private void _readActionKeys(Collection<String> actions, Element parentElement) {
        for (Element actionKeyElement : parentElement.elements("action-key")) {
            String actionKey = actionKeyElement.getTextTrim();
            if (Validator.isNull((String)actionKey)) continue;
            actions.add(actionKey);
        }
    }

    private void _readModelResources(Element rootElement, Set<String> resourceNames) throws ResourceActionsException {
        for (Element modelResourceElement : rootElement.elements("model-resource")) {
            String modelName = modelResourceElement.elementTextTrim("model-name");
            if (Validator.isNull((String)modelName)) {
                modelName = this._getCompositeModelName(modelResourceElement.element("composite-model-name"));
            }
            if (GetterUtil.getBoolean((String)modelResourceElement.attributeValue("organization"))) {
                this._organizationModelResources.add(modelName);
            }
            if (GetterUtil.getBoolean((String)modelResourceElement.attributeValue("portal"))) {
                this._portalModelResources.add(modelName);
            }
            Element portletRefElement = modelResourceElement.element("portlet-ref");
            for (Element portletNameElement : portletRefElement.elements("portlet-name")) {
                String existingModelName;
                String portletName = portletNameElement.getTextTrim();
                Set modelResources = this._resourceReferences.computeIfAbsent(portletName, key -> new HashSet());
                modelResources.add(modelName);
                Set portletResources = this._resourceReferences.computeIfAbsent(modelName, key -> new HashSet());
                portletResources.add(portletName);
                boolean root = GetterUtil.getBoolean((String)modelResourceElement.elementText("root"));
                if (!root || !Validator.isNotNull((String)(existingModelName = this._portletRootModelResources.putIfAbsent(portletName, modelName))) || Objects.equals(existingModelName, modelName)) continue;
                throw new ResourceActionsException(StringBundler.concat((String[])new String[]{"Portlet ", portletName, " cannot be assigned to both ", existingModelName, " and ", modelName, " as root model resources. See LPS-135983."}));
            }
            double weight = GetterUtil.getDouble((String)modelResourceElement.elementTextTrim("weight"), (double)100.0);
            this._modelResourceWeights.put(modelName, weight);
            this._readResource(modelResourceElement, modelName, Collections.singleton("PERMISSIONS"));
            if (resourceNames == null) continue;
            resourceNames.add(modelName);
        }
    }

    private void _readPortletResource(Element rootElement, Portlet portlet) throws ResourceActionsException {
        String deployPortletName = PortletIdCodec.decodePortletName((String)portlet.getPortletId());
        for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
            String portletName = portletResourceElement.elementTextTrim("portlet-name");
            if (!portletName.equals(deployPortletName)) continue;
            Set<String> portletActions = this._getPortletMimeTypeActions(portletName, portlet);
            if (!portletName.equals("90")) {
                this._checkPortletLayoutManagerActions(portletActions);
            }
            this._readResource(portletResourceElement, portletName, portletActions);
        }
    }

    private void _readPortletResources(Element rootElement, Set<String> resourceNames) throws ResourceActionsException {
        if (PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
                String portletName = portletResourceElement.elementTextTrim("portlet-name");
                Portlet portlet = this.portletLocalService.getPortletById(portletName);
                Set<String> portletActions = this._getPortletMimeTypeActions(portletName, portlet);
                if (!portletName.equals("90")) {
                    this._checkPortletLayoutManagerActions(portletActions);
                }
                this._readResource(portletResourceElement, portletName, portletActions);
                if (resourceNames == null) continue;
                resourceNames.add(portletName);
            }
        }
    }

    private void _readResource(Element resourceElement, String name, Set<String> defaultResourceActions) throws ResourceActionsException {
        Element ownerDefaultsElement;
        Element guestUnsupportedElement;
        ResourceActionsBag resourceActionsBag = this._getResourceActionsBag(name);
        Set<String> resourceActions = resourceActionsBag.getSupportsActions();
        Element supportsElement = this._getPermissionsChildElement(resourceElement, "supports");
        this._readActionKeys(resourceActions, supportsElement);
        resourceActions.addAll(defaultResourceActions);
        if (resourceActions.size() > 64) {
            throw new ResourceActionsException("There are more than 64 actions for resource " + name);
        }
        Element groupDefaultsElement = this._getPermissionsChildElement(resourceElement, "site-member-defaults");
        if (groupDefaultsElement == null) {
            groupDefaultsElement = this._getPermissionsChildElement(resourceElement, "community-defaults");
            if (_log.isWarnEnabled() && groupDefaultsElement != null) {
                _log.warn((Object)"The community-defaults element is deprecated. Use the site-member-defaults element instead.");
            }
        }
        if (groupDefaultsElement != null) {
            Set<String> groupDefaultActions = resourceActionsBag.getGroupDefaultActions();
            groupDefaultActions.clear();
            this._readActionKeys(groupDefaultActions, groupDefaultsElement);
        }
        Set<String> guestDefaultActions = resourceActionsBag.getGuestDefaultActions();
        Element guestDefaultsElement = this._getPermissionsChildElement(resourceElement, "guest-defaults");
        if (guestDefaultsElement != null) {
            guestDefaultActions.clear();
            this._readActionKeys(guestDefaultActions, guestDefaultsElement);
        }
        if ((guestUnsupportedElement = this._getPermissionsChildElement(resourceElement, "guest-unsupported")) != null) {
            Set<String> guestUnsupportedActions = resourceActionsBag.getGuestUnsupportedActions();
            guestUnsupportedActions.clear();
            this._readActionKeys(guestUnsupportedActions, guestUnsupportedElement);
            String resourceElementName = resourceElement.getName();
            if (Objects.equals(resourceElementName, "portlet-resource")) {
                this._checkPortletGuestUnsupportedActions(guestUnsupportedActions);
            }
            this._checkGuestUnsupportedActions(guestUnsupportedActions, guestDefaultActions);
        }
        if ((ownerDefaultsElement = this._getPermissionsChildElement(resourceElement, "owner-defaults")) != null) {
            this._readActionKeys(resourceActionsBag.getOwnerDefaultActions(), ownerDefaultsElement);
        }
        Set<String> layoutManagerActions = resourceActionsBag.getLayoutManagerActions();
        Element layoutManagerElement = this._getPermissionsChildElement(resourceElement, "layout-manager");
        if (layoutManagerElement == null) {
            layoutManagerActions.addAll(resourceActions);
            return;
        }
        layoutManagerActions.clear();
        this._readActionKeys(layoutManagerActions, layoutManagerElement);
    }

    private static class ResourceBundleLoaderListHolder {
        private static final ServiceTrackerList<ResourceBundleLoader> _resourceBundleLoaders = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), ResourceBundleLoader.class);

        private ResourceBundleLoaderListHolder() {
        }
    }

    private static class ResourceActionsBag {
        private final Set<String> _groupDefaultActions = new HashSet<String>();
        private final Set<String> _guestDefaultActions = new HashSet<String>();
        private final Set<String> _guestUnsupportedActions = new HashSet<String>();
        private final Set<String> _layoutManagerActions = new HashSet<String>();
        private final Set<String> _ownerDefaultActions = new HashSet<String>();
        private final Set<String> _supportsActions = new HashSet<String>();

        private ResourceActionsBag() {
        }

        public Set<String> getGroupDefaultActions() {
            return this._groupDefaultActions;
        }

        public Set<String> getGuestDefaultActions() {
            return this._guestDefaultActions;
        }

        public Set<String> getGuestUnsupportedActions() {
            return this._guestUnsupportedActions;
        }

        public Set<String> getLayoutManagerActions() {
            return this._layoutManagerActions;
        }

        public Set<String> getOwnerDefaultActions() {
            return this._ownerDefaultActions;
        }

        public Set<String> getSupportsActions() {
            return this._supportsActions;
        }
    }
}

