/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.change.tracking.CTTransactionException;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.MasterLayoutException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.exception.SitemapChangeFrequencyException;
import com.liferay.portal.kernel.exception.SitemapIncludeException;
import com.liferay.portal.kernel.exception.SitemapPagePriorityException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutTable;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.PortalPreferenceValueTable;
import com.liferay.portal.kernel.model.PortalPreferencesTable;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.PortalPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutFriendlyURLPersistence;
import com.liferay.portal.kernel.service.persistence.LayoutPrototypePersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPersistence;
import com.liferay.portal.kernel.service.persistence.PortalPreferencesPersistence;
import com.liferay.portal.kernel.service.persistence.ResourcePermissionPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.LayoutComparator;
import com.liferay.portal.kernel.util.comparator.LayoutPriorityComparator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.base.LayoutLocalServiceBaseImpl;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.util.PropsValues;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class LayoutLocalServiceImpl
extends LayoutLocalServiceBaseImpl {
    @BeanReference(type=LayoutLocalServiceHelper.class)
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceImpl.class);
    private static final ThreadLocal<Long> _virtualLayoutTargetGroupId = new CentralizedThreadLocal(LayoutLocalServiceImpl.class + "._virtualLayoutTargetGroupId", () -> 0L);
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=ImageLocalService.class)
    private ImageLocalService _imageLocalService;
    @BeanReference(type=LayoutFriendlyURLLocalService.class)
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    @BeanReference(type=LayoutFriendlyURLPersistence.class)
    private LayoutFriendlyURLPersistence _layoutFriendlyURLPersistence;
    @BeanReference(type=LayoutPrototypeLocalService.class)
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @BeanReference(type=LayoutPrototypePersistence.class)
    private LayoutPrototypePersistence _layoutPrototypePersistence;
    @BeanReference(type=LayoutSetLocalService.class)
    private LayoutSetLocalService _layoutSetLocalService;
    @BeanReference(type=LayoutSetPersistence.class)
    private LayoutSetPersistence _layoutSetPersistence;
    @BeanReference(type=LayoutSetPrototypeLocalService.class)
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @BeanReference(type=PortalPreferencesPersistence.class)
    private PortalPreferencesPersistence _portalPreferencesPersistence;
    @BeanReference(type=PortalPreferenceValueLocalService.class)
    private PortalPreferenceValueLocalService _portalPreferenceValueLocalService;
    @BeanReference(type=PortletPreferencesLocalService.class)
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @BeanReference(type=RatingsStatsLocalService.class)
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=ResourcePermissionLocalService.class)
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @BeanReference(type=ResourcePermissionPersistence.class)
    private ResourcePermissionPersistence _resourcePermissionPersistence;
    @BeanReference(type=UserGroupLocalService.class)
    private UserGroupLocalService _userGroupLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;
    @BeanReference(type=WorkflowDefinitionLinkLocalService.class)
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public static String getCounterName(long groupId, boolean privateLayout) {
        return StringBundler.concat((Object[])new Object[]{Layout.class.getName(), "#", groupId, "#", privateLayout});
    }

    @Indexable(type=IndexableType.REINDEX)
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        LayoutTypePortlet layoutTypePortlet;
        User user = this._userPersistence.findByPrimaryKey(userId);
        long layoutId = this.getNextLayoutId(groupId, privateLayout);
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = system && (Objects.equals(type, "asset_display") || Objects.equals(type, "collection") || Objects.equals(type, "content")) ? this._getDraftFriendlyURLMap(groupId, friendlyURLMap) : this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)typeSettings).build();
        int priority = Integer.MAX_VALUE;
        if (!system) {
            priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, null, -1);
        }
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        Date date = new Date();
        Layout layout = this.layoutPersistence.create(this.layoutLocalServiceHelper.getUniquePlid());
        String uuid = serviceContext.getUuid();
        if (Validator.isNotNull((String)uuid)) {
            layout.setUuid(uuid);
        }
        layout.setGroupId(groupId);
        layout.setCompanyId(user.getCompanyId());
        layout.setUserId(user.getUserId());
        layout.setUserName(user.getFullName());
        layout.setCreateDate(serviceContext.getCreateDate(date));
        layout.setModifiedDate(serviceContext.getModifiedDate(date));
        layout.setParentPlid(this._getParentPlid(groupId, privateLayout, parentLayoutId));
        layout.setPrivateLayout(privateLayout);
        layout.setLayoutId(layoutId);
        layout.setParentLayoutId(parentLayoutId);
        layout.setClassNameId(classNameId);
        layout.setClassPK(classPK);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        if (!layoutUpdateable) {
            typeSettingsUnicodeProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        }
        if (privateLayout) {
            typeSettingsUnicodeProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        this.validateTypeSettingsProperties(layout, typeSettingsUnicodeProperties);
        layout.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        if (type.equals("portlet") && Validator.isNull((String)(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).getLayoutTemplateId())) {
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.LAYOUT_DEFAULT_TEMPLATE_ID, false);
        }
        layout.setHidden(hidden);
        layout.setSystem(system);
        layout.setFriendlyURL(friendlyURL);
        layout.setPriority(priority);
        layout.setMasterLayoutPlid(masterLayoutPlid);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled", (boolean)PropsValues.LAYOUT_PROTOTYPE_LINK_ENABLED_DEFAULT);
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        layout.setPublishDate(serviceContext.getModifiedDate(date));
        if (this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(layout.getCompanyId(), layout.getGroupId(), Layout.class.getName()) && (Objects.equals(type, "collection") || Objects.equals(type, "content")) && !system) {
            layout.setStatus(2);
        } else {
            layout.setStatus(0);
        }
        layout.setStatusByUserId(userId);
        layout.setStatusByUserName(user.getFullName());
        layout.setStatusDate(serviceContext.getCreateDate(date));
        layout.setExpandoBridgeAttributes(serviceContext);
        layout = this.layoutLocalService.updateLayout(layout);
        this._layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(user.getUserId(), user.getCompanyId(), groupId, layout.getPlid(), privateLayout, friendlyURLMap, serviceContext);
        if (Validator.isNotNull((String)layoutPrototypeUuid) && !layoutPrototypeLinkEnabled) {
            this._applyLayoutPrototype(layoutPrototypeUuid, layout, layoutPrototypeLinkEnabled);
        }
        boolean addGroupPermissions = true;
        Group group = this._groupLocalService.getGroup(groupId);
        if (privateLayout && (group.isUser() || group.isUserGroup())) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || type.equals("control_panel") || group.isLayoutSetPrototype()) {
            addGuestPermissions = true;
        }
        this._resourceLocalService.addResources(user.getCompanyId(), groupId, user.getUserId(), Layout.class.getName(), layout.getPlid(), false, addGroupPermissions, addGuestPermissions);
        this._groupLocalService.updateSite(groupId, true);
        layout.setLayoutSet(null);
        this.updateAsset(userId, layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (!layout.isDraftLayout() && (layout.isTypeAssetDisplay() || layout.isTypeContent())) {
            serviceContext.setModifiedDate(date);
            this.addLayout(userId, groupId, privateLayout, parentLayoutId, this._classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, true, true, Collections.emptyMap(), layout.getMasterLayoutPlid(), serviceContext);
        }
        return this.layoutLocalService.getLayout(layout.getPlid());
    }

    @Indexable(type=IndexableType.REINDEX)
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, 0L, 0L, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, 0L, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, false, friendlyURLMap, serviceContext);
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, boolean system, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap nameMap = HashMapBuilder.put((Object)locale, (Object)name).build();
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, description);
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, new HashMap<Locale, String>(), new HashMap<Locale, String>(), type, "", hidden, system, friendlyURLMap, serviceContext);
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, false, friendlyURL, serviceContext);
    }

    @Override
    public Layout deleteLayout(Layout layout) throws PortalException {
        this.layoutLocalService.deleteLayout(layout, new ServiceContext());
        return layout;
    }

    @SystemEvent(action=1, type=1)
    public void deleteLayout(Layout layout, ServiceContext serviceContext) throws PortalException {
        Indexer indexer;
        Layout firstLayout;
        List rootLayouts;
        if (layout.getParentLayoutId() == 0L && (rootLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), 0L, 0, 2)).size() > 1 && (firstLayout = (Layout)rootLayouts.get(0)).getLayoutId() == layout.getLayoutId()) {
            Layout secondLayout = (Layout)rootLayouts.get(1);
            this.layoutLocalServiceHelper.validateFirstLayout(secondLayout);
        }
        List childLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        for (Layout childLayout : childLayouts) {
            this.layoutLocalService.deleteLayout(childLayout, serviceContext);
        }
        this._layoutFriendlyURLLocalService.deleteLayoutFriendlyURLs(layout.getPlid());
        this._portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        this._assetEntryLocalService.deleteEntry(Layout.class.getName(), layout.getPlid());
        this._ratingsStatsLocalService.deleteStats(Layout.class.getName(), layout.getPlid());
        this._expandoRowLocalService.deleteRows(layout.getCompanyId(), this._classNameLocalService.getClassNameId(Layout.class.getName()), layout.getPlid());
        this._imageLocalService.deleteImage(layout.getIconImageId());
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            this._groupLocalService.deleteGroup(scopeGroup.getGroupId());
        }
        String primKey = layout.getPlid() + "_LAYOUT_" + "%";
        List resourcePermissions = this._resourcePermissionPersistence.findByC_LikeP(layout.getCompanyId(), primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this._resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        this._resourceLocalService.deleteResource(layout.getCompanyId(), Layout.class.getName(), 4, layout.getPlid());
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout != null) {
            this.layoutLocalService.deleteLayout(draftLayout);
        }
        if ((layout = (Layout)this.layoutPersistence.remove((BaseModel)layout)) == null) {
            return;
        }
        this._resetPortalPreferences(layout);
        SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
        if (systemEventHierarchyEntry != null && systemEventHierarchyEntry.hasTypedModel(Layout.class.getName(), layout.getPlid())) {
            systemEventHierarchyEntry.setExtraDataValue("privateLayout", String.valueOf(layout.isPrivateLayout()));
        }
        if ((indexer = IndexerRegistryUtil.getIndexer(Layout.class)) != null) {
            indexer.delete((Object)layout);
        }
    }

    @Override
    public Layout deleteLayout(long plid) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.layoutLocalService.deleteLayout(layout, new ServiceContext());
        return layout;
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.layoutLocalService.deleteLayout(layout, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.layoutLocalService.deleteLayout(layout, serviceContext);
    }

    public void deleteLayouts(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        this._deleteLayouts(groupId, privateLayout, false, serviceContext);
        this._deleteLayouts(groupId, privateLayout, true, serviceContext);
        this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
    }

    public Layout fetchDefaultLayout(long groupId, boolean privateLayout) {
        List layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1)).isEmpty()) {
            return (Layout)layouts.get(0);
        }
        return null;
    }

    public Layout fetchDraftLayout(long plid) {
        return this.fetchLayout(this._classNameLocalService.getClassNameId(Layout.class), plid);
    }

    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.fetchByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator());
    }

    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId, boolean hidden) {
        return this.layoutPersistence.fetchByG_P_P_H_First(groupId, privateLayout, parentLayoutId, hidden, (OrderByComparator)new LayoutPriorityComparator());
    }

    public Layout fetchLayout(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
    }

    public Layout fetchLayout(long classNameId, long classPK) {
        return this.layoutPersistence.fetchByC_C(classNameId, classPK);
    }

    public Layout fetchLayout(String uuid, long groupId, boolean privateLayout) {
        return this.layoutPersistence.fetchByUUID_G_P(uuid, groupId, privateLayout);
    }

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(friendlyURL);
        return this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL);
    }

    public Layout fetchLayoutByIconImageId(boolean privateLayout, long iconImageId) throws PortalException {
        return this.layoutPersistence.fetchByP_I(privateLayout, iconImageId);
    }

    @Override
    public Layout fetchLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) {
        return this.layoutPersistence.fetchByUUID_G_P(uuid, groupId, privateLayout);
    }

    public List<Layout> getAllLayouts(long groupId, boolean privateLayout, String type) throws PortalException {
        DynamicQuery dynamicQuery = this.layoutLocalService.dynamicQuery();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.ne((Object)this._classNameLocalService.getClassNameId(Layout.class.getName())));
        Property typeProperty = PropertyFactoryUtil.forName((String)"type");
        dynamicQuery.add(typeProperty.eq((Object)type));
        List layouts = this.layoutLocalService.dynamicQuery(dynamicQuery);
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        if (!group.isUser()) {
            return layouts;
        }
        HashSet<Long> checkedPlids = new HashSet<Long>();
        ArrayDeque<Long> checkParentLayoutIds = new ArrayDeque<Long>();
        checkParentLayoutIds.add(0L);
        LayoutSet layoutSet = this._layoutSetPersistence.findByG_P(groupId, privateLayout);
        while (!checkParentLayoutIds.isEmpty()) {
            long parentLayoutId = (Long)checkParentLayoutIds.poll();
            List<Layout> userGroupLayouts = this._addUserGroupLayouts(group, layoutSet, Collections.emptyList(), parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                long userGroupPlid = userGroupLayout.getPlid();
                if (!checkedPlids.add(userGroupPlid)) continue;
                layouts.add(userGroupLayout);
                checkParentLayoutIds.add(userGroupLayout.getLayoutId());
            }
        }
        return layouts;
    }

    public long getDefaultPlid(long groupId) {
        List layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByGroupId(groupId, 0, 1)).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) {
        Layout layout = this.fetchDefaultLayout(groupId, privateLayout);
        if (layout != null) {
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId > 0L) {
            List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                return layout.getPlid();
            }
        }
        return 0L;
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        if (Validator.isNull((String)friendlyURL)) {
            throw new NoSuchLayoutException(StringBundler.concat((Object[])new Object[]{"{groupId=", groupId, ", privateLayout=", privateLayout, "}"}));
        }
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(friendlyURL);
        Layout layout = null;
        List layoutFriendlyURLs = this._layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL, 0, 1);
        if (!layoutFriendlyURLs.isEmpty()) {
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
            layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
        }
        if (layout == null && friendlyURL.startsWith("/") && Validator.isNumber((String)friendlyURL.substring(1))) {
            long layoutId = GetterUtil.getLong((String)friendlyURL.substring(1));
            layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        }
        if (layout == null) {
            throw new NoSuchLayoutException(StringBundler.concat((Object[])new Object[]{"{groupId=", groupId, ", privateLayout=", privateLayout, ", friendlyURL=", friendlyURL, "}"}));
        }
        return layout;
    }

    @Override
    public Layout getLayout(long plid) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        if (this._mergeLayout(layout, plid)) {
            return this.layoutPersistence.findByPrimaryKey(plid);
        }
        return layout;
    }

    public Layout getLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (this._mergeLayout(layout, groupId, privateLayout, layoutId)) {
            return this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        }
        return layout;
    }

    public Layout getLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(friendlyURL);
        return this.layoutPersistence.findByG_P_F(groupId, privateLayout, friendlyURL);
    }

    public Layout getLayoutByIconImageId(long iconImageId) throws PortalException {
        return this.layoutPersistence.findByIconImageId(iconImageId);
    }

    @Override
    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException {
        return this.layoutPersistence.findByUUID_G_P(uuid, groupId, privateLayout);
    }

    public Map<Long, List<Layout>> getLayoutChildLayouts(List<Layout> parentLayouts) {
        HashMap<LayoutSet, List> layoutsMap = new HashMap<LayoutSet, List>();
        for (Layout layout : parentLayouts) {
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                Layout sourceLayout = virtualLayout.getSourceLayout();
                LayoutSet sourceLayoutSet = sourceLayout.getLayoutSet();
                List layouts = layoutsMap.computeIfAbsent(sourceLayoutSet, key -> new ArrayList());
                layouts.add(sourceLayout);
                continue;
            }
            List list = layoutsMap.computeIfAbsent(layout.getLayoutSet(), key -> new ArrayList());
            list.add(layout);
        }
        ArrayList<Layout> childLayouts = new ArrayList<Layout>();
        for (Map.Entry entry : layoutsMap.entrySet()) {
            List<Layout> newChildLayouts = this._getChildLayouts((LayoutSet)entry.getKey(), ListUtil.toLongArray((List)((List)entry.getValue()), LayoutModel::getLayoutId));
            childLayouts.addAll(newChildLayouts);
        }
        HashMap<Long, List<Layout>> hashMap = new HashMap<Long, List<Layout>>();
        for (Layout childLayout : childLayouts) {
            List layoutChildLayouts = hashMap.computeIfAbsent(childLayout.getParentPlid(), parentPlid -> new ArrayList());
            layoutChildLayouts.add(childLayout);
        }
        for (List layoutChildLayouts : hashMap.values()) {
            layoutChildLayouts.sort(Comparator.comparing(LayoutModel::getPriority));
        }
        return hashMap;
    }

    public List<Layout> getLayouts(long companyId) {
        return this.layoutPersistence.findByCompanyId(companyId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.findByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, int start, int end, OrderByComparator<Layout> orderByComparator) {
        return this.layoutPersistence.findByG_P(groupId, privateLayout, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) {
        return this.layoutPersistence.findByG_P_ST(groupId, privateLayout, statuses, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.getLayouts(groupId, privateLayout, parentLayoutId, false, -1, -1, null);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) {
        return this.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end, null);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end, OrderByComparator<Layout> orderByComparator) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end, orderByComparator);
        }
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            if (layoutSet.isLayoutSetPrototypeLinkActive() && !this._mergeLayouts(group, layoutSet, groupId, privateLayout, parentLayoutId, start, end, orderByComparator)) {
                return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end, orderByComparator);
            }
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end, orderByComparator);
            return this._injectVirtualLayouts(group, layoutSet, (List<Layout>)layouts, parentLayoutId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long[] layoutIds) throws PortalException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (long layoutId : layoutIds) {
            layouts.add(this.getLayout(groupId, privateLayout, layoutId));
        }
        return layouts;
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) throws PortalException {
        return this.getLayouts(groupId, privateLayout, new String[]{type});
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String keywords, String[] types, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        return this.getLayouts(groupId, 0L, privateLayout, keywords, types, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String[] types) throws PortalException {
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        ArrayList<Layout> layouts = this.layoutPersistence.findByG_P_T(groupId, privateLayout, types);
        if (!group.isUser()) {
            return layouts;
        }
        layouts = new ArrayList<Layout>(layouts);
        HashSet<Long> checkedPlids = new HashSet<Long>();
        ArrayDeque<Long> checkParentLayoutIds = new ArrayDeque<Long>();
        checkParentLayoutIds.add(0L);
        LayoutSet layoutSet = this._layoutSetPersistence.findByG_P(groupId, privateLayout);
        while (!checkParentLayoutIds.isEmpty()) {
            long parentLayoutId = (Long)checkParentLayoutIds.poll();
            List<Layout> userGroupLayouts = this._addUserGroupLayouts(group, layoutSet, Collections.emptyList(), parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                long userGroupPlid = userGroupLayout.getPlid();
                if (!checkedPlids.add(userGroupPlid)) continue;
                layouts.add(userGroupLayout);
                checkParentLayoutIds.add(userGroupLayout.getLayoutId());
            }
        }
        return layouts;
    }

    public List<Layout> getLayouts(long groupId, int start, int end, OrderByComparator<Layout> orderByComparator) {
        return this.layoutPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, long userId, boolean privateLayout, String keywords, String[] types, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        return this.getLayouts(groupId, userId, privateLayout, keywords, types, new int[0], start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, long userId, boolean privateLayout, String keywords, String[] types, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.getLayouts(groupId, privateLayout, statuses, start, end, orderByComparator);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, userId, privateLayout, keywords, types, statuses, start, end, orderByComparator));
        List documents = hits.toList();
        ArrayList<Layout> layouts = new ArrayList<Layout>(documents.size());
        for (Document document : documents) {
            Layout layout = this.fetchLayout(GetterUtil.getLong((String)document.get("entryClassPK")));
            if (layout == null) {
                indexer.delete((Object)layout);
                continue;
            }
            layouts.add(layout);
        }
        return layouts;
    }

    public LayoutReference[] getLayouts(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        List layoutReferences = this.layoutFinder.findByC_P_P(companyId, portletId, preferencesKey, preferencesValue);
        return layoutReferences.toArray(new LayoutReference[0]);
    }

    public List<Layout> getLayouts(long groupId, String keywords, String[] types, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        return this.getLayouts(groupId, keywords, types, new int[0], start, end, orderByComparator);
    }

    public List<Layout> getLayouts(long groupId, String keywords, String[] types, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.getLayouts(groupId, start, end, orderByComparator);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, null, keywords, types, statuses, start, end, orderByComparator));
        List documents = hits.toList();
        ArrayList<Layout> layouts = new ArrayList<Layout>(documents.size());
        for (Document document : documents) {
            Layout layout = this.fetchLayout(GetterUtil.getLong((String)document.get("entryClassPK")));
            if (layout == null) {
                indexer.delete((Object)layout);
                continue;
            }
            layouts.add(layout);
        }
        return layouts;
    }

    public List<Layout> getLayoutsByLayoutPrototypeUuid(String layoutPrototypeUuid) {
        return this.layoutPersistence.findByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsByLayoutPrototypeUuidCount(String layoutPrototypeUuid) {
        return this.layoutPersistence.countByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsCount(Group group, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(group, privateLayout, true);
    }

    public int getLayoutsCount(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        int count = this.layoutPersistence.countByG_P(group.getGroupId(), privateLayout);
        if (!group.isUser() || !includeUserGroups) {
            return count;
        }
        long[] userGroupIds = this._userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this._classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this._groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                count += this.layoutPersistence.countByG_P(userGroupGroup.getGroupId(), privateLayout);
            }
        }
        return count;
    }

    public int getLayoutsCount(Group group, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P(group.getGroupId(), privateLayout, parentLayoutId);
    }

    public int getLayoutsCount(Group group, boolean privateLayout, long[] layoutIds) {
        if (ArrayUtil.isEmpty((long[])layoutIds)) {
            return 0;
        }
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)group.getGroupId()));
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        Property layoutIdProperty = PropertyFactoryUtil.forName((String)"layoutId");
        dynamicQuery.add(layoutIdProperty.in(layoutIds));
        return GetterUtil.getInteger((Object)this.dynamicQueryCount(dynamicQuery));
    }

    public int getLayoutsCount(Group group, boolean privateLayout, String keywords, String[] types) throws PortalException {
        return this.getLayoutsCount(group.getGroupId(), 0L, privateLayout, keywords, types);
    }

    public int getLayoutsCount(long groupId) {
        return this.layoutPersistence.countByGroupId(groupId);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout) {
        return this.layoutPersistence.countByG_P(groupId, privateLayout);
    }

    public int getLayoutsCount(long groupId, long userId, boolean privateLayout, String keywords, String[] types) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.getLayoutsCount(groupId, privateLayout);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, userId, privateLayout, keywords, types, new int[0], -1, -1, null));
        return hits.getLength();
    }

    public int getLayoutsCount(long groupId, long userId, boolean privateLayout, String keywords, String[] types, int[] statuses) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.getLayoutsCount(groupId, privateLayout);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, userId, privateLayout, keywords, types, statuses, -1, -1, null));
        return hits.getLength();
    }

    public int getLayoutsCount(long groupId, String keywords, String[] types) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.getLayoutsCount(groupId);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, null, keywords, types, new int[0], -1, -1, null));
        return hits.getLength();
    }

    public int getLayoutsCount(long groupId, String keywords, String[] types, int[] statuses) throws PortalException {
        if (Validator.isNull((String)keywords)) {
            return this.getLayoutsCount(groupId);
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)Layout.class.getName());
        Hits hits = indexer.search(this._buildSearchContext(groupId, null, keywords, types, statuses, -1, -1, null));
        return hits.getLength();
    }

    public int getLayoutsCount(User user, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(user, privateLayout, true);
    }

    public int getLayoutsCount(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        Group group = this._groupPersistence.findByC_C_C(user.getCompanyId(), this._classNameLocalService.getClassNameId(User.class), user.getUserId());
        return this.getLayoutsCount(group, privateLayout, includeUserGroups);
    }

    public List<Layout> getMasterLayouts(long groupId, long masterLayoutPlid) {
        return this.layoutPersistence.findByG_MLP(groupId, masterLayoutPlid);
    }

    public int getMasterLayoutsCount(long groupId, long masterLayoutPlid) {
        return this.layoutPersistence.countByG_MLP(groupId, masterLayoutPlid);
    }

    public long getNextLayoutId(long groupId, boolean privateLayout) {
        List layouts;
        long nextLayoutId = this.counterLocalService.increment(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
        if (nextLayoutId == 1L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1, (OrderByComparator)new LayoutComparator())).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            nextLayoutId = layout.getLayoutId() + 1L;
            this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout), nextLayoutId);
        }
        return nextLayoutId;
    }

    public Layout getParentLayout(Layout layout) throws PortalException {
        Layout parentLayout = null;
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            Layout sourceLayout = virtualLayout.getSourceLayout();
            parentLayout = this.getLayout(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getParentLayoutId());
            parentLayout = new VirtualLayout(parentLayout, layout.getGroup());
        } else {
            parentLayout = this.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        }
        return parentLayout;
    }

    public List<Layout> getPublishedLayouts(long groupId, int start, int end, OrderByComparator<Layout> orderByComparator) {
        GroupByStep groupByStep = this._getPublishedLayoutsGroupByStep(groupId, DSLQueryFactoryUtil.select((Table)LayoutTable.INSTANCE));
        return (List)this.dslQuery(groupByStep.orderBy(orderByStep -> {
            if (orderByComparator == null) {
                return orderByStep.orderBy(new OrderByExpression[]{LayoutTable.INSTANCE.priority.ascending()});
            }
            return orderByStep.orderBy((Table)LayoutTable.INSTANCE, (OrderByInfo)orderByComparator);
        }).limit(start, end));
    }

    public int getPublishedLayoutsCount(long groupId) {
        return this.dslQueryCount((DSLQuery)this._getPublishedLayoutsGroupByStep(groupId, DSLQueryFactoryUtil.count()));
    }

    public List<Layout> getScopeGroupLayouts(long parentGroupId) throws PortalException {
        int count;
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_ENABLED) {
            return this.layoutFinder.findByScopeGroup(parentGroupId);
        }
        Group parentGroup = this._groupPersistence.findByPrimaryKey(parentGroupId);
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD >= 0 && (count = this._groupLocalService.getGroupsCount(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId)) >= PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD) {
            return this.layoutFinder.findByScopeGroup(parentGroupId);
        }
        List groups = this._groupLocalService.getGroups(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId);
        ArrayList<Layout> layouts = new ArrayList<Layout>(groups.size());
        for (Group group : groups) {
            layouts.add(this.layoutPersistence.findByPrimaryKey(group.getClassPK()));
        }
        return layouts;
    }

    public List<Layout> getScopeGroupLayouts(long parentGroupId, boolean privateLayout) throws PortalException {
        int count;
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_ENABLED) {
            return this.layoutFinder.findByScopeGroup(parentGroupId, privateLayout);
        }
        Group parentGroup = this._groupPersistence.findByPrimaryKey(parentGroupId);
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD >= 0 && (count = this._groupLocalService.getGroupsCount(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId)) >= PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD) {
            return this.layoutFinder.findByScopeGroup(parentGroupId, privateLayout);
        }
        List groups = this._groupLocalService.getGroups(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId);
        ArrayList<Layout> layouts = new ArrayList<Layout>(groups.size());
        for (Group group : groups) {
            Layout layout = this.layoutPersistence.findByPrimaryKey(group.getClassPK());
            if (layout.isPrivateLayout() != privateLayout) continue;
            layouts.add(layout);
        }
        return layouts;
    }

    public boolean hasLayout(String uuid, long groupId, boolean privateLayout) throws PortalException {
        try {
            this.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
            return true;
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchLayoutException);
            }
            return false;
        }
    }

    public boolean hasLayouts(Group group) throws PortalException {
        List groupLayoutSets = this._layoutSetPersistence.findByGroupId(group.getGroupId());
        for (LayoutSet layoutSet : groupLayoutSets) {
            if (layoutSet.getPageCount() <= 0) continue;
            return true;
        }
        if (!group.isUser()) {
            return false;
        }
        long[] userGroupIds = this._userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this._classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this._groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                List userGroupGroupLayoutSets = this._layoutSetPersistence.findByGroupId(userGroupGroup.getGroupId());
                for (LayoutSet layoutSet : userGroupGroupLayoutSets) {
                    if (layoutSet.getPageCount() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasLayouts(Group group, boolean privateLayout) throws PortalException {
        return this.hasLayouts(group, privateLayout, true);
    }

    public boolean hasLayouts(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        LayoutSet layoutSet = this._layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        if (layoutSet.getPageCount() > 0) {
            return true;
        }
        if (!group.isUser() || !includeUserGroups) {
            return false;
        }
        long[] userGroupIds = this._userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this._classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this._groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                layoutSet = this._layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                if (layoutSet.getPageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        int count = this.layoutPersistence.countByG_P_P(groupId, privateLayout, parentLayoutId);
        return count > 0;
    }

    public boolean hasLayouts(User user, boolean privateLayout) throws PortalException {
        return this.hasLayouts(user, privateLayout, true);
    }

    public boolean hasLayouts(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        Group group = this._groupPersistence.findByC_C_C(user.getCompanyId(), this._classNameLocalService.getClassNameId(User.class), user.getUserId());
        return this.hasLayouts(group, privateLayout, includeUserGroups);
    }

    public boolean hasLayoutSetPrototypeLayout(long layoutSetPrototypeId, String layoutUuid) throws PortalException {
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(this._layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId), layoutUuid);
    }

    public boolean hasLayoutSetPrototypeLayout(String layoutSetPrototypeUuid, long companyId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        if (layoutIds == null) {
            return;
        }
        if (parentLayoutId == 0L) {
            if (layoutIds.length < 1) {
                throw new RequiredLayoutException(1);
            }
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutIds[0]);
            LayoutType layoutType = layout.getLayoutType();
            if (!layoutType.isFirstPageable()) {
                throw new RequiredLayoutException(3);
            }
        }
        LinkedHashSet<Long> layoutIdsSet = new LinkedHashSet<Long>();
        for (long layoutId : layoutIds) {
            layoutIdsSet.add(layoutId);
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            if (!layoutIdsSet.contains(layout.getLayoutId())) {
                this.deleteLayout(layout, serviceContext);
                continue;
            }
            hashSet.add(layout.getLayoutId());
        }
        int priority = 0;
        Iterator iterator = layoutIdsSet.iterator();
        while (iterator.hasNext()) {
            long layoutId = (Long)iterator.next();
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
            layout.setPriority(priority++);
            this.layoutLocalService.updateLayout(layout);
        }
    }

    public void updateAsset(long userId, Layout layout, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        this._assetEntryLocalService.updateEntry(userId, layout.getGroupId(), layout.getCreateDate(), layout.getModifiedDate(), Layout.class.getName(), layout.getPlid(), layout.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, "text/html", layout.getName(LocaleUtil.getDefault()), null, null, null, null, 0, 0, null);
    }

    public Layout updateFriendlyURL(long userId, long plid, String friendlyURL, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), "", friendlyURL, languageId);
        this.layoutLocalServiceHelper.validateFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), friendlyURL, languageId);
        this._layoutFriendlyURLLocalService.updateLayoutFriendlyURL(userId, layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURL, languageId, new ServiceContext());
        layout.setModifiedDate(new Date());
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        if (languageId.equals(defaultLanguageId)) {
            layout.setFriendlyURL(friendlyURL);
        }
        return this.layoutLocalService.updateLayout(layout);
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return null;
        }
        PortalUtil.updateImageId((BaseModel)layout, (bytes != null ? 1 : 0) != 0, (byte[])bytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        return this.layoutLocalService.updateLayout(layout);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, Date publishDate) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setPublishDate(publishDate);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long classNameId, long classPK) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setClassNameId(classNameId);
        layout.setClassPK(classPK);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean hasIconImage, byte[] iconBytes, long styleBookEntryId, long faviconFileEntryId, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this._validateMasterLayout(masterLayoutPlid, layout.getPlid());
        if (parentLayoutId != layout.getParentLayoutId()) {
            layout.setParentPlid(this._getParentPlid(groupId, privateLayout, parentLayoutId));
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        PortalUtil.updateImageId((BaseModel)layout, (boolean)hasIconImage, (byte[])iconBytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        layout.setStyleBookEntryId(styleBookEntryId);
        layout.setFaviconFileEntryId(faviconFileEntryId);
        layout.setMasterLayoutPlid(masterLayoutPlid);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        Group group = layout.getGroup();
        if (!group.isLayoutPrototype()) {
            typeSettingsUnicodeProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        }
        if (privateLayout) {
            typeSettingsUnicodeProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        layout.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            boolean applyLayoutPrototype = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"applyLayoutPrototype");
            boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled");
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
            if (applyLayoutPrototype) {
                serviceContext.setAttribute("applyLayoutPrototype", (Serializable)Boolean.FALSE);
                this._applyLayoutPrototype(layoutPrototypeUuid, layout, layoutPrototypeLinkEnabled);
                layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
            }
        }
        layout.setExpandoBridgeAttributes(serviceContext);
        layout = this.layoutLocalService.updateLayout(layout);
        this._layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(serviceContext.getUserId(), layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURLMap, serviceContext);
        this.updateAsset(serviceContext.getUserId(), layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Date date = new Date();
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)typeSettings).build();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.validateTypeSettingsProperties(layout, typeSettingsUnicodeProperties);
        layout.setModifiedDate(date);
        layout.setTypeSettings(typeSettingsUnicodeProperties.toString());
        if (layout.isSystem() && layout.getClassPK() > 0L) {
            layout.setPublishDate(date);
        }
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings, byte[] iconBytes, String themeId, String colorSchemeId, long styleBookEntryId, String css, long faviconFileEntryId, long masterLayoutPlid) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)typeSettings).build();
        this.validateTypeSettingsProperties(layout, typeSettingsUnicodeProperties);
        this._validateMasterLayout(masterLayoutPlid, layout.getPlid());
        layout.setModifiedDate(new Date());
        layout.setTypeSettings(typeSettingsUnicodeProperties.toString());
        layout.setThemeId(themeId);
        layout.setColorSchemeId(colorSchemeId);
        layout.setStyleBookEntryId(styleBookEntryId);
        layout.setCss(css);
        layout.setFaviconFileEntryId(faviconFileEntryId);
        layout.setMasterLayoutPlid(masterLayoutPlid);
        PortalUtil.updateImageId((BaseModel)layout, (iconBytes != null ? 1 : 0) != 0, (byte[])iconBytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setModifiedDate(new Date());
        layout.setThemeId(themeId);
        layout.setColorSchemeId(colorSchemeId);
        layout.setCss(css);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateMasterLayoutPlid(long groupId, boolean privateLayout, long layoutId, long masterLayoutPlid) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this._validateMasterLayout(masterLayoutPlid, layout.getPlid());
        layout.setMasterLayoutPlid(masterLayoutPlid);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateName(Layout layout, String name, String languageId) throws PortalException {
        Date date = new Date();
        this.layoutLocalServiceHelper.validateName(name, languageId);
        layout.setModifiedDate(date);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        layout = (Layout)this.layoutPersistence.update((BaseModel)layout);
        Group group = layout.getGroup();
        if (group.isLayoutPrototype()) {
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            layoutPrototype.setModifiedDate(date);
            layoutPrototype.setName(name, LocaleUtil.fromLanguageId((String)languageId));
            this._layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        }
        return layout;
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            layout.setParentPlid(this._getParentPlid(groupId, privateLayout, parentLayoutId));
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(new Date());
        layout.setParentLayoutId(parentLayoutId);
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout != null) {
            this.updateParentLayoutId(groupId, privateLayout, draftLayout.getLayoutId(), parentLayoutId);
        }
        return this.layoutLocalService.updateLayout(layout);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        Layout parentLayout;
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        if (layout.getParentPlid() == parentPlid) {
            return layout;
        }
        long parentLayoutId = 0L;
        if (parentPlid > 0L && (parentLayout = this.layoutPersistence.fetchByPrimaryKey(parentPlid)) != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), parentLayoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(new Date());
        layout.setParentPlid(parentPlid);
        layout.setParentLayoutId(parentLayoutId);
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout != null) {
            this.updateParentLayoutId(draftLayout.getPlid(), parentPlid);
        }
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        Layout layout = this.updateParentLayoutId(plid, parentPlid);
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout != null) {
            this.layoutLocalService.updatePriority(draftLayout.getPlid(), priority);
        }
        return this.layoutLocalService.updatePriority(layout, priority);
    }

    public void updatePriorities(long groupId, boolean privateLayout) throws PortalException {
        List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
        for (Layout layout : layouts) {
            int nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layout.getPriority());
            layout.setPriority(nextPriority);
            Layout draftLayout = (layout = (Layout)this.layoutPersistence.update((BaseModel)layout)).fetchDraftLayout();
            if (draftLayout == null) continue;
            draftLayout.setPriority(nextPriority);
            this.layoutPersistence.update((BaseModel)draftLayout);
        }
    }

    public Layout updatePriority(Layout layout, int priority) throws PortalException {
        int nextPriority;
        if (layout.getPriority() == priority) {
            return layout;
        }
        int oldPriority = layout.getPriority();
        if (oldPriority == (nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), priority))) {
            return layout;
        }
        layout.setModifiedDate(new Date());
        layout.setPriority(nextPriority);
        layout = (Layout)this.layoutPersistence.update((BaseModel)layout);
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout != null) {
            draftLayout.setPriority(nextPriority);
            draftLayout = (Layout)this.layoutPersistence.update((BaseModel)draftLayout);
        }
        List layouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        boolean lessThan = false;
        if (oldPriority < nextPriority) {
            lessThan = true;
        }
        layouts = ListUtil.sort((List)layouts, (Comparator)new LayoutPriorityComparator(layout, lessThan));
        if (layout.getParentLayoutId() == 0L) {
            Layout firstLayout = (Layout)layouts.get(0);
            this.layoutLocalServiceHelper.validateFirstLayout(firstLayout);
        }
        int newPriority = 0;
        for (Layout curLayout : layouts) {
            int curNextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), curLayout.getSourcePrototypeLayoutUuid(), newPriority++);
            if (curLayout.getPriority() == curNextPriority) continue;
            curLayout.setModifiedDate(layout.getModifiedDate());
            curLayout.setPriority(curNextPriority);
            curLayout = (Layout)this.layoutPersistence.update((BaseModel)curLayout);
            draftLayout = curLayout.fetchDraftLayout();
            if (draftLayout != null) {
                draftLayout.setPriority(nextPriority);
                this.layoutPersistence.update((BaseModel)draftLayout);
            }
            if (!curLayout.equals(layout)) continue;
            layout = curLayout;
        }
        return layout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        Layout layout = this.getLayout(groupId, privateLayout, layoutId);
        int priority = layout.getPriority();
        Layout nextLayout = null;
        if (nextLayoutId > 0L) {
            nextLayout = this.getLayout(groupId, privateLayout, nextLayoutId);
        }
        Layout previousLayout = null;
        if (previousLayoutId > 0L) {
            previousLayout = this.getLayout(groupId, privateLayout, previousLayoutId);
        }
        if (nextLayout != null && priority > nextLayout.getPriority()) {
            priority = nextLayout.getPriority();
        } else if (previousLayout != null && priority < previousLayout.getPriority()) {
            priority = previousLayout.getPriority();
        }
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updatePriority(layout, priority);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Layout updateStatus(long userId, long plid, int status, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        layout.setModifiedDate(new Date());
        layout.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        layout.setStatusByUserId(user.getUserId());
        layout.setStatusByUserName(user.getFullName());
        Date statusDate = new Date();
        if (serviceContext != null) {
            statusDate = serviceContext.getModifiedDate(statusDate);
        }
        layout.setStatusDate(statusDate);
        if (layout.isDraftLayout() && status == 0 && GetterUtil.getBoolean((Object)serviceContext.getAttribute("published"), (boolean)true)) {
            UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
            typeSettingsUnicodeProperties.put("published", Boolean.TRUE.toString());
        }
        layout = (Layout)this.layoutPersistence.update((BaseModel)layout);
        if (status == 0) {
            this._assetEntryLocalService.updateEntry(Layout.class.getName(), layout.getPlid(), layout.getStatusDate(), null, true, false);
        }
        return layout;
    }

    public Layout updateStyleBookEntryId(long groupId, boolean privateLayout, long layoutId, long styleBookEntryId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setStyleBookEntryId(styleBookEntryId);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateType(long plid, String type) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        layout.setType(type);
        if (Objects.equals(type, "collection") || Objects.equals(type, "content")) {
            layout.setLayoutPrototypeUuid("");
            layout.setLayoutPrototypeLinkEnabled(false);
        }
        return this.layoutLocalService.updateLayout(layout);
    }

    protected void validateTypeSettingsProperties(Layout layout, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        boolean enableJavaScript;
        String sitemapChangeFrequency = typeSettingsUnicodeProperties.getProperty("sitemap-changefreq");
        if (!(!Validator.isNotNull((String)sitemapChangeFrequency) || sitemapChangeFrequency.equals("always") || sitemapChangeFrequency.equals("hourly") || sitemapChangeFrequency.equals("daily") || sitemapChangeFrequency.equals("weekly") || sitemapChangeFrequency.equals("monthly") || sitemapChangeFrequency.equals("yearly") || sitemapChangeFrequency.equals("never"))) {
            throw new SitemapChangeFrequencyException();
        }
        String sitemapInclude = typeSettingsUnicodeProperties.getProperty("sitemap-include");
        if (Validator.isNotNull((String)sitemapInclude) && !sitemapInclude.equals("0") && !sitemapInclude.equals("1")) {
            throw new SitemapIncludeException();
        }
        String sitemapPriority = typeSettingsUnicodeProperties.getProperty("sitemap-priority");
        if (Validator.isNotNull((String)sitemapPriority)) {
            try {
                double priority = Double.parseDouble(sitemapPriority);
                if (priority < 0.0 || priority > 1.0) {
                    throw new SitemapPagePriorityException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SitemapPagePriorityException((Throwable)numberFormatException);
            }
        }
        if (!(enableJavaScript = PropsValues.FIELD_ENABLE_COM_LIFERAY_PORTAL_KERNEL_MODEL_LAYOUT_JAVASCRIPT)) {
            UnicodeProperties layoutTypeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
            String javaScript = layoutTypeSettingsUnicodeProperties.getProperty("javascript");
            typeSettingsUnicodeProperties.setProperty("javascript", javaScript);
        }
    }

    private List<Layout> _addChildUserGroupLayouts(Group group, List<Layout> layouts) throws PortalException {
        ArrayList<Layout> childLayouts = new ArrayList<Layout>(layouts.size());
        for (Layout layout : layouts) {
            Group layoutGroup = layout.getGroup();
            if (layoutGroup.isUserGroup()) {
                childLayouts.add((Layout)new VirtualLayout(layout, group));
                continue;
            }
            childLayouts.add(layout);
        }
        return childLayouts;
    }

    private List<Layout> _addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws PortalException {
        layouts = new ArrayList<Layout>(layouts);
        List userUserGroups = this._userGroupLocalService.getUserUserGroups(group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List<Layout> userGroupLayouts = this.getLayouts(userGroupGroup.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                layouts.add((Layout)new VirtualLayout(userGroupLayout, group));
            }
        }
        return layouts;
    }

    private List<Layout> _addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long[] parentLayoutIds) throws PortalException {
        boolean copied = false;
        List userUserGroups = this._userGroupLocalService.getUserUserGroups(group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List<Layout> userGroupLayouts = this.getLayouts(userGroupGroup.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            for (Layout userGroupLayout : userGroupLayouts) {
                if (!copied) {
                    layouts = new ArrayList<Layout>(layouts);
                    copied = true;
                }
                layouts.add((Layout)new VirtualLayout(userGroupLayout, group));
            }
        }
        return layouts;
    }

    private void _applyLayoutPrototype(String layoutPrototypeUuid, Layout layout, boolean layoutPrototypeLinkEnabled) throws PortalException {
        LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, layout.getCompanyId());
        try {
            SitesUtil.applyLayoutPrototype((LayoutPrototype)layoutPrototype, (Layout)layout, (boolean)layoutPrototypeLinkEnabled);
        }
        catch (PortalException portalException) {
            throw portalException;
        }
        catch (SystemException systemException) {
            throw systemException;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private SearchContext _buildSearchContext(long groupId, Boolean privateLayout, String keywords, String[] types, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        return this._buildSearchContext(groupId, 0L, privateLayout, keywords, types, statuses, start, end, orderByComparator);
    }

    private SearchContext _buildSearchContext(long groupId, long userId, Boolean privateLayout, String keywords, String[] types, int[] statuses, int start, int end, OrderByComparator<Layout> orderByComparator) throws PortalException {
        SearchContext searchContext = new SearchContext();
        if (ArrayUtil.isNotEmpty((int[])statuses)) {
            searchContext.setAttribute("status", (Serializable)statuses);
        }
        searchContext.setAttribute("title", (Serializable)((Object)keywords));
        searchContext.setAttribute("type", (Serializable)types);
        searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
        if (privateLayout != null) {
            searchContext.setAttribute("privateLayout", (Serializable)((Object)String.valueOf(privateLayout)));
        }
        Group group = this._groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setIncludeInternalAssetCategories(true);
        searchContext.setKeywords(keywords);
        searchContext.setStart(start);
        if (orderByComparator != null) {
            searchContext.setSorts(new Sort[]{this._getSortFromComparator(orderByComparator)});
        }
        if (userId > 0L) {
            searchContext.setUserId(userId);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private void _deleteLayouts(long groupId, boolean privateLayout, boolean system, ServiceContext serviceContext) throws PortalException {
        List layouts = this.layoutPersistence.findByG_P_P_S(groupId, privateLayout, 0L, system, -1, -1, (OrderByComparator)new LayoutPriorityComparator(false));
        for (Layout layout : layouts) {
            try {
                this.layoutLocalService.deleteLayout(layout, serviceContext);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)noSuchLayoutException);
            }
        }
    }

    private String _generateFriendlyURLUUID() {
        UUID uuid = new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong());
        return "/" + uuid.toString();
    }

    private List<Layout> _getChildLayouts(LayoutSet layoutSet, long[] parentLayoutIds) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
        }
        try {
            Group group = this._groupPersistence.findByPrimaryKey(layoutSet.getGroupId());
            if (layoutSet.isLayoutSetPrototypeLinkActive() && !this._mergeLayouts(group, layoutSet, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds)) {
                return this.layoutPersistence.findByG_P_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            }
            List layouts = this.layoutPersistence.findByG_P_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            return this._injectVirtualLayouts(group, layoutSet, (List<Layout>)layouts, parentLayoutIds);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    private Map<Locale, String> _getDraftFriendlyURLMap(long groupId, Map<Locale, String> friendlyURLMap) {
        HashMap<Locale, String> newFriendlyURLMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            if (!Validator.isNotNull((String)friendlyURL)) continue;
            newFriendlyURLMap.put(locale, this._generateFriendlyURLUUID());
        }
        Locale siteDefaultLocale = LocaleUtil.getSiteDefault();
        if (newFriendlyURLMap.isEmpty() || Validator.isNull((String)((String)newFriendlyURLMap.get(siteDefaultLocale)))) {
            newFriendlyURLMap.put(siteDefaultLocale, this._generateFriendlyURLUUID());
        }
        return newFriendlyURLMap;
    }

    private DSLQuery _getDraftLayoutsClassPKsDSLQuery(long groupId) {
        return DSLQueryFactoryUtil.select((Expression[])new Expression[]{LayoutTable.INSTANCE.classPK}).from((Table)LayoutTable.INSTANCE).where(LayoutTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)LayoutTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(Layout.class))));
    }

    private long _getParentPlid(long groupId, boolean privateLayout, long parentLayoutId) {
        if (parentLayoutId == 0L) {
            return 0L;
        }
        Layout parentLayout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, parentLayoutId);
        if (parentLayout == null) {
            return 0L;
        }
        return parentLayout.getPlid();
    }

    private GroupByStep _getPublishedLayoutsGroupByStep(long groupId, FromStep fromStep) {
        return fromStep.from((Table)LayoutTable.INSTANCE).where(LayoutTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)LayoutTable.INSTANCE.system.eq((Object)false)).and((Expression)LayoutTable.INSTANCE.type.notIn((Object[])new String[]{"collection", "content"}).or((Expression)LayoutTable.INSTANCE.plid.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{LayoutTable.INSTANCE.classPK}).from((Table)LayoutTable.INSTANCE).where(LayoutTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)LayoutTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(Layout.class)).and((Expression)LayoutTable.INSTANCE.typeSettings.like("%published=true%")))))).or((Expression)LayoutTable.INSTANCE.status.eq((Object)0).and((Expression)LayoutTable.INSTANCE.hidden.eq((Object)false)).and((Expression)LayoutTable.INSTANCE.plid.notIn(this._getDraftLayoutsClassPKsDSLQuery(groupId)))).withParentheses()));
    }

    private Sort _getSortFromComparator(OrderByComparator<Layout> orderByComparator) {
        Object[] fields = orderByComparator.getOrderByFields();
        if (ArrayUtil.contains((Object[])fields, (Object)"score")) {
            return new Sort(null, 0, false);
        }
        boolean reverse = !orderByComparator.isAscending();
        Object field = fields[0];
        return new Sort((String)field, 6, reverse);
    }

    private List<Layout> _injectVirtualLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws PortalException {
        long targetGroupId;
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return layouts;
        }
        if (group.isUser()) {
            _virtualLayoutTargetGroupId.set(group.getGroupId());
            if (parentLayoutId == 0L) {
                return this._addUserGroupLayouts(group, layoutSet, layouts, parentLayoutId);
            }
            return this._addChildUserGroupLayouts(group, layouts);
        }
        if (group.isUserGroup() && parentLayoutId != 0L && (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) != 0L) {
            Group targetGroup = this._groupLocalService.getGroup(targetGroupId);
            return this._addChildUserGroupLayouts(targetGroup, layouts);
        }
        return layouts;
    }

    private List<Layout> _injectVirtualLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long[] parentLayoutIds) throws PortalException {
        long targetGroupId;
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return layouts;
        }
        if (group.isUser()) {
            _virtualLayoutTargetGroupId.set(group.getGroupId());
            if (ArrayUtil.contains((long[])parentLayoutIds, (long)0L)) {
                this._addUserGroupLayouts(group, layoutSet, layouts, parentLayoutIds);
                if (parentLayoutIds.length == 1) {
                    return layouts;
                }
            }
            return this._addChildUserGroupLayouts(group, layouts);
        }
        if (group.isUserGroup() && (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) != 0L) {
            Group targetGroup = this._groupLocalService.getGroup(targetGroupId);
            return this._addChildUserGroupLayouts(targetGroup, layouts);
        }
        return layouts;
    }

    private boolean _mergeLayout(Layout layout, Object ... arguments) throws PortalException {
        if (MergeLayoutPrototypesThreadLocal.isInProgress() || StartupHelperUtil.isUpgrading()) {
            return false;
        }
        Group group = layout.getGroup();
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete((String)"getLayout", (Object[])arguments) && !group.isUser()) {
            return false;
        }
        if (Validator.isNull((String)layout.getLayoutPrototypeUuid()) && Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
            return false;
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        LayoutSet layoutSet = layout.getLayoutSet();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            SitesUtil.mergeLayoutPrototypeLayout((Group)group, (Layout)layout);
            if (Validator.isNotNull((String)layout.getSourcePrototypeLayoutUuid())) {
                SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
            }
        }
        catch (CTTransactionException | PortalException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete((String)"getLayout", (Object[])arguments);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _mergeLayouts(Group group, LayoutSet layoutSet, Object ... arguments) {
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete((String)"getLayouts", (Object[])arguments) && !group.isUser() || StartupHelperUtil.isUpgrading()) {
            return false;
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            if (SitesUtil.isLayoutSetMergeable((Group)group, (LayoutSet)layoutSet)) {
                WorkflowThreadLocal.setEnabled((boolean)false);
                SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to merge layouts for site template", (Throwable)exception);
            }
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete((String)"getLayouts", (Object[])arguments);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
        return true;
    }

    private void _resetPortalPreferences(Layout layout) {
        String namespace = CustomizedPages.namespacePlid((long)layout.getPlid());
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Table)PortalPreferencesTable.INSTANCE).from((Table)PortalPreferencesTable.INSTANCE).innerJoinON((Table)PortalPreferenceValueTable.INSTANCE, PortalPreferenceValueTable.INSTANCE.portalPreferencesId.eq((Expression)PortalPreferencesTable.INSTANCE.portalPreferencesId)).where(PortalPreferencesTable.INSTANCE.ownerType.eq((Object)4).and((Expression)PortalPreferenceValueTable.INSTANCE.namespace.eq((Object)namespace)));
        for (com.liferay.portal.kernel.model.PortalPreferences portalPreferencesModel : (List)this._portalPreferencesPersistence.dslQuery((DSLQuery)dslQuery)) {
            PortalPreferences portalPreferences = this._portalPreferenceValueLocalService.getPortalPreferences(portalPreferencesModel, false);
            portalPreferences.resetValues(namespace);
        }
    }

    private void _validateMasterLayout(long masterLayoutPlid, long plid) throws PortalException {
        if (masterLayoutPlid == plid) {
            throw new MasterLayoutException("Master page cannot point to itself");
        }
    }
}

