/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.RolePermissions;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.service.persistence.impl.GroupFinderBaseImpl;
import com.liferay.portal.service.persistence.impl.GroupPersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GroupFinderImpl
extends GroupFinderBaseImpl
implements GroupFinder {
    public static final String COUNT_BY_LAYOUTS = GroupFinder.class.getName() + ".countByLayouts";
    public static final String COUNT_BY_GROUP_ID = GroupFinder.class.getName() + ".countByGroupId";
    public static final String COUNT_BY_C_PG_N_D = GroupFinder.class.getName() + ".countByC_PG_N_D";
    public static final String FIND_BY_ACTIVE_GROUPS = GroupFinder.class.getName() + ".findByActiveGroups";
    public static final String FIND_BY_COMPANY_ID = GroupFinder.class.getName() + ".findByCompanyId";
    public static final String FIND_BY_LAYOUTS = GroupFinder.class.getName() + ".findByLayouts";
    public static final String FIND_BY_LIVE_GROUPS = GroupFinder.class.getName() + ".findByLiveGroups";
    public static final String FIND_BY_C_P = GroupFinder.class.getName() + ".findByC_P";
    public static final String FIND_BY_C_GK = GroupFinder.class.getName() + ".findByC_GK";
    public static final String FIND_BY_C_A = GroupFinder.class.getName() + ".findByC_A";
    public static final String FIND_BY_L_TS_S_RSGC = GroupFinder.class.getName() + ".findByL_TS_S_RSGC";
    public static final String FIND_BY_C_PG_N_D = GroupFinder.class.getName() + ".findByC_PG_N_D";
    public static final FinderPath FINDER_PATH_FIND_BY_C_A = new FinderPath(GroupPersistenceImpl.FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "GroupFinderImpl_findByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "active_"}, false);
    public static final String JOIN_BY_ACTION_ID = GroupFinder.class.getName() + ".joinByActionId";
    public static final String JOIN_BY_ACTIVE = GroupFinder.class.getName() + ".joinByActive";
    public static final String JOIN_BY_CREATOR_USER_ID = GroupFinder.class.getName() + ".joinByCreatorUserId";
    public static final String JOIN_BY_GROUP_ORG = GroupFinder.class.getName() + ".joinByGroupOrg";
    public static final String JOIN_BY_GROUPS_ORGS = GroupFinder.class.getName() + ".joinByGroupsOrgs";
    public static final String JOIN_BY_GROUPS_ROLES = GroupFinder.class.getName() + ".joinByGroupsRoles";
    public static final String JOIN_BY_GROUPS_USER_GROUPS = GroupFinder.class.getName() + ".joinByGroupsUserGroups";
    public static final String JOIN_BY_LAYOUT = GroupFinder.class.getName() + ".joinByLayout";
    public static final String JOIN_BY_MANUAL_MEMBERSHIP = GroupFinder.class.getName() + ".joinByManualMembership";
    public static final String JOIN_BY_MEMBERSHIP_RESTRICTION = GroupFinder.class.getName() + ".joinByMembershipRestriction";
    public static final String JOIN_BY_PAGE_COUNT = GroupFinder.class.getName() + ".joinByPageCount";
    public static final String JOIN_BY_ROLE_RESOURCE_PERMISSIONS = GroupFinder.class.getName() + ".joinByRoleResourcePermissions";
    public static final String JOIN_BY_SITE = GroupFinder.class.getName() + ".joinBySite";
    public static final String JOIN_BY_TYPE = GroupFinder.class.getName() + ".joinByType";
    public static final String JOIN_BY_USER_GROUP_ROLE = GroupFinder.class.getName() + ".joinByUserGroupRole";
    public static final String JOIN_BY_USERS_GROUPS = GroupFinder.class.getName() + ".joinByUsersGroups";
    private final LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap();
    private final Map<String, String> _findByCompanyIdSQLCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> _findByC_C_PG_N_DSQLCache = new ConcurrentHashMap<String, String>();
    private volatile long[] _groupOrganizationClassNameIds;
    private volatile Map<String, String> _joinMap;
    private final Map<String, String> _replaceJoinAndWhereSQLCache = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> _whereMap;

    public int countByLayouts(long companyId, long parentGroupId, boolean site) {
        return this.countByLayouts(companyId, parentGroupId, site, null);
    }

    public int countByLayouts(long companyId, long parentGroupId, boolean site, Boolean active) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_LAYOUTS);
            sql = active != null ? StringUtil.replace((String)sql, (String)"[$ACTIVE$]", (String)"AND (Group_.active_ = ?)") : StringUtil.removeSubstring((String)sql, (String)"[$ACTIVE$]");
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(parentGroupId);
            queryPos.add(site);
            if (active != null) {
                queryPos.add(active);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U(long groupId, long userId, boolean inherit) {
        LinkedHashMap params1 = LinkedHashMapBuilder.put((Object)"usersGroups", (Object)userId).build();
        LinkedHashMap params2 = LinkedHashMapBuilder.put((Object)"groupOrg", (Object)userId).build();
        LinkedHashMap params3 = LinkedHashMapBuilder.put((Object)"groupsOrgs", (Object)userId).build();
        LinkedHashMap params4 = LinkedHashMapBuilder.put((Object)"groupsUserGroups", (Object)userId).build();
        Session session = null;
        try {
            session = this.openSession();
            int count = this.countByGroupId(session, groupId, params1);
            if (inherit) {
                count += this.countByGroupId(session, groupId, params2);
                count += this.countByGroupId(session, groupId, params3);
                count += this.countByGroupId(session, groupId, params4);
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_C_PG_N_D(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) {
        String parentGroupIdComparator = "=";
        if (parentGroupId == -1L) {
            parentGroupIdComparator = "!=";
        }
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean doUnion = Validator.isNotNull((Long)userId);
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params3 = new LinkedHashMap<String, Object>(params1);
            params4 = new LinkedHashMap<String, Object>(params1);
            this._populateUnionParams(userId, classNameIds, params1, params2, params3, params4);
        } else if (classNameIds != null) {
            params1.put("classNameIds", classNameIds);
        }
        Session session = null;
        try {
            session = this.openSession();
            HashSet<Long> groupIds = new HashSet<Long>();
            groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params1, andOperator));
            if (doUnion) {
                if (params2.containsKey("classNameIds")) {
                    groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params2, andOperator));
                }
                if (params3.containsKey("classNameIds")) {
                    groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params3, andOperator));
                }
                if (params4.containsKey("classNameIds")) {
                    groupIds.addAll(this.countByC_PG_N_D(session, companyId, parentGroupId, parentGroupIdComparator, names, descriptions, params4, andOperator));
                }
            }
            int n = groupIds.size();
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Group fetchByC_GK(long companyId, String groupKey) throws NoSuchGroupException {
        groupKey = StringUtil.lowerCase((String)groupKey);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_GK);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Group_", GroupImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(groupKey);
            List groups = sqlQuery.list();
            if (groups.isEmpty()) {
                Group group = null;
                return group;
            }
            Group group = (Group)groups.get(0);
            return group;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByActiveGroupIds(long userId) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ACTIVE_GROUPS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("groupId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByCompanyId(long companyId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Group> orderByComparator) {
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean doUnion = false;
        if (Validator.isNotNull((Long)userId) && inherit) {
            doUnion = true;
        }
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params3 = new LinkedHashMap<String, Object>(params1);
            params4 = new LinkedHashMap<String, Object>(params1);
            this._populateUnionParams(userId, null, params1, params2, params3, params4);
        } else {
            params1.put("classNameIds", this._getGroupOrganizationClassNameIds());
        }
        String sqlKey = this._buildSQLCacheKey(orderByComparator, params1, params2, params3, params4);
        String sql = this._findByCompanyIdSQLCache.get(sqlKey);
        if (sql == null) {
            String findByCompanyIdSQL = CustomSQLUtil.get((String)FIND_BY_COMPANY_ID);
            if (params.get("active") == Boolean.TRUE) {
                findByCompanyIdSQL = StringUtil.removeSubstring((String)findByCompanyIdSQL, (String)"(Group_.liveGroupId = 0) AND");
            }
            findByCompanyIdSQL = this.replaceOrderBy(findByCompanyIdSQL, orderByComparator);
            StringBundler sb = new StringBundler(11);
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params1));
            if (doUnion) {
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params2));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params3));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByCompanyIdSQL, params4));
            }
            sb.append(")");
            if (orderByComparator != null) {
                sb.append(" ORDER BY ");
                sb.append(orderByComparator.toString());
            }
            sql = sb.toString();
            this._findByCompanyIdSQLCache.put(sqlKey, sql);
        }
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("groupId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            this.setJoin(queryPos, params1);
            queryPos.add(companyId);
            if (doUnion) {
                this.setJoin(queryPos, params2);
                queryPos.add(companyId);
                this.setJoin(queryPos, params3);
                queryPos.add(companyId);
                this.setJoin(queryPos, params4);
                queryPos.add(companyId);
            }
            List groupIds = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, Boolean active, int start, int end, OrderByComparator<Group> orderByComparator) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LAYOUTS);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, orderByComparator);
            sql = active != null ? StringUtil.replace((String)sql, (String)"[$ACTIVE$]", (String)"AND (Group_.active_ = ?)") : StringUtil.removeSubstring((String)sql, (String)"[$ACTIVE$]");
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Group_", GroupImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(parentGroupId);
            queryPos.add(site);
            if (active != null) {
                queryPos.add(active);
            }
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByLayouts(long companyId, long parentGroupId, boolean site, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.findByLayouts(companyId, parentGroupId, site, null, start, end, orderByComparator);
    }

    public List<Group> findByLiveGroups() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LIVE_GROUPS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Group_", GroupImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByC_P(long companyId, long parentGroupId, long previousGroupId, int size) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_P);
            if (previousGroupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(groupId > ?) AND");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("groupId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (previousGroupId > 0L) {
                queryPos.add(previousGroupId);
            }
            queryPos.add(companyId);
            queryPos.add(parentGroupId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)0, (int)size);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Group findByC_GK(long companyId, String groupKey) throws NoSuchGroupException {
        Group group = this.fetchByC_GK(companyId, groupKey);
        if (group == null) {
            throw new NoSuchGroupException(StringBundler.concat((Object[])new Object[]{"No Group exists with the key {companyId=", companyId, ", groupKey=", groupKey, "}"}));
        }
        return group;
    }

    public List<Long> findByC_A(long companyId, boolean active) {
        Object[] finderArgs = new Object[]{companyId, active};
        List list = (List)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_C_A, (Object[])finderArgs, null);
        if (list != null) {
            return list;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_A);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("groupId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(active);
            list = sqlQuery.list(true);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_C_A, (Object[])finderArgs, (Object)list);
            List list2 = list;
            return list2;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByL_TS_S_RSGC(long liveGroupId, String typeSettings, boolean site, int remoteStagingGroupCount) {
        String sql = CustomSQLUtil.get((String)FIND_BY_L_TS_S_RSGC);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Group_", GroupImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(liveGroupId);
            queryPos.add(StringUtil.quote((String)typeSettings, (String)"%"));
            queryPos.add(site);
            queryPos.add(remoteStagingGroupCount);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByC_C_PG_N_D(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<Group> orderByComparator) {
        String parentGroupIdComparator = "=";
        if (parentGroupId == -1L) {
            parentGroupIdComparator = "!=";
        }
        names = CustomSQLUtil.keywords((String[])names);
        descriptions = CustomSQLUtil.keywords((String[])descriptions);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean doUnion = false;
        if (Validator.isNotNull((Long)userId) && inherit) {
            doUnion = true;
        }
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params3 = new LinkedHashMap<String, Object>(params1);
            params4 = new LinkedHashMap<String, Object>(params1);
            this._populateUnionParams(userId, classNameIds, params1, params2, params3, params4);
        } else if (classNameIds != null) {
            params1.put("classNameIds", classNameIds);
        }
        if (orderByComparator == null) {
            orderByComparator = new GroupNameComparator(true);
        }
        String sql = null;
        String sqlKey = null;
        if (this._isCacheableSQL(classNameIds)) {
            sqlKey = this._buildSQLCacheKey((OrderByComparator<Group>)orderByComparator, params1, params2, params3, params4);
            sql = this._findByC_C_PG_N_DSQLCache.get(sqlKey);
        }
        if (sql == null) {
            String findByC_PG_N_D_SQL = CustomSQLUtil.get((String)FIND_BY_C_PG_N_D);
            findByC_PG_N_D_SQL = this.replaceOrderBy(findByC_PG_N_D_SQL, (OrderByComparator<Group>)orderByComparator);
            StringBundler sb = new StringBundler(10);
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params1));
            if (doUnion) {
                if (params2.containsKey("classNameIds")) {
                    sb.append(") UNION (");
                    sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params2));
                }
                if (params3.containsKey("classNameIds")) {
                    sb.append(") UNION (");
                    sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params3));
                }
                if (params4.containsKey("classNameIds")) {
                    sb.append(") UNION (");
                    sb.append(this.replaceJoinAndWhere(findByC_PG_N_D_SQL, params4));
                }
            }
            sb.append(") ORDER BY ");
            sb.append(orderByComparator.toString());
            sql = sb.toString();
            if (sqlKey != null) {
                this._findByC_C_PG_N_DSQLCache.put(sqlKey, sql);
            }
        }
        sql = parentGroupIdComparator.equals("=") ? StringUtil.replace(sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"=") : StringUtil.replace(sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"!=");
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Group_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Group_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("groupId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            this.setJoin(queryPos, params1);
            queryPos.add(companyId);
            queryPos.add(parentGroupId);
            queryPos.add(names, 2);
            queryPos.add(descriptions, 2);
            if (doUnion) {
                this.setJoin(queryPos, params2);
                queryPos.add(companyId);
                queryPos.add(parentGroupId);
                queryPos.add(names, 2);
                queryPos.add(descriptions, 2);
                this.setJoin(queryPos, params3);
                queryPos.add(companyId);
                queryPos.add(parentGroupId);
                queryPos.add(names, 2);
                queryPos.add(descriptions, 2);
                this.setJoin(queryPos, params4);
                queryPos.add(companyId);
                queryPos.add(parentGroupId);
                queryPos.add(names, 2);
                queryPos.add(descriptions, 2);
            }
            List groupIds = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByGroupId(Session session, long groupId, Map<String, Object> params) throws Exception {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_GROUP_ID);
        sql = this.replaceJoinAndWhere(sql, params);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        this.setJoin(queryPos, params);
        queryPos.add(groupId);
        Iterator iterator = sqlQuery.iterate();
        if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected List<Long> countByC_PG_N_D(Session session, long companyId, long parentGroupId, String parentGroupIdComparator, String[] names, String[] descriptions, Map<String, Object> params, boolean andOperator) throws Exception {
        String sql = CustomSQLUtil.get((String)COUNT_BY_C_PG_N_D);
        sql = parentGroupIdComparator.equals("=") ? StringUtil.replace((String)sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"=") : StringUtil.replace((String)sql, (String)"[$PARENT_GROUP_ID_COMPARATOR$]", (String)"!=");
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Group_.name)", (String)"LIKE", (boolean)false, (String[])names);
        sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"LOWER(Group_.description)", (String)"LIKE", (boolean)true, (String[])descriptions);
        sql = this.replaceJoinAndWhere(sql, params);
        sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.addScalar("groupId", Type.LONG);
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        this.setJoin(queryPos, params);
        queryPos.add(companyId);
        queryPos.add(parentGroupId);
        queryPos.add(names, 2);
        queryPos.add(descriptions, 2);
        return sqlQuery.list(true);
    }

    protected String getJoin(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> joinMap;
            String joinValue;
            if (Validator.isNull((Object)entry.getValue())) continue;
            String key = entry.getKey();
            if (key.equals("rolePermissions")) {
                key = "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(joinValue = (joinMap = this._getJoinMap()).get(key)))) continue;
            sb.append(joinValue);
        }
        return sb.toString();
    }

    protected String getWhere(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> whereMap;
            String whereValue;
            String key = entry.getKey();
            if (key.equals("classNameIds")) {
                if (entry.getValue() instanceof Long) {
                    sb.append("(Group_.classNameId = ?) AND ");
                    continue;
                }
                sb.append("(");
                long[] classNameIds = (long[])entry.getValue();
                for (int i = 0; i < classNameIds.length; ++i) {
                    sb.append("(Group_.classNameId = ?) OR ");
                }
                sb.setStringAt("(Group_.classNameId = ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("excludedGroupIds")) {
                List excludedGroupIds = (List)entry.getValue();
                if (excludedGroupIds.isEmpty()) continue;
                sb.append("(");
                for (int i = 0; i < excludedGroupIds.size(); ++i) {
                    sb.append("(Group_.groupId != ?) AND ");
                }
                sb.setStringAt("(Group_.groupId != ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("groupsTree")) {
                List groupsTree = (List)entry.getValue();
                if (groupsTree.isEmpty()) continue;
                sb.append("(");
                for (int i = 0; i < groupsTree.size(); ++i) {
                    sb.append("(Group_.treePath LIKE ?) OR ");
                }
                sb.setStringAt("(Group_.treePath LIKE ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("types")) {
                List types = (List)entry.getValue();
                if (types.isEmpty()) continue;
                sb.append("(");
                for (int i = 0; i < types.size(); ++i) {
                    sb.append("(Group_.type_ = ?) OR ");
                }
                sb.setStringAt("(Group_.type_ = ?)) AND ", sb.index() - 1);
                continue;
            }
            if (key.equals("rolePermissions")) {
                key = "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(whereValue = (whereMap = this._getWhereMap()).get(key)))) continue;
            sb.append(whereValue);
        }
        return sb.toString();
    }

    protected String replaceJoinAndWhere(String sql, Map<String, Object> params) {
        if (params.isEmpty()) {
            return StringUtil.removeSubstrings((String)sql, (String[])new String[]{"[$JOIN$]", "[$WHERE$]"});
        }
        String cacheKey = this._buildSQLCacheKey(sql, params);
        String resultSQL = this._replaceJoinAndWhereSQLCache.get(cacheKey);
        if (resultSQL == null) {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            resultSQL = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            this._replaceJoinAndWhereSQLCache.put(cacheKey, resultSQL);
        }
        return resultSQL;
    }

    protected String replaceOrderBy(String sql, OrderByComparator<Group> orderByComparator) {
        if (orderByComparator instanceof GroupNameComparator) {
            sql = StringUtil.replace((String)sql, (String)"Group_.name AS groupName", (String)"REPLACE(Group_.name, ' LFR_ORGANIZATION', '') AS groupName");
        }
        return sql;
    }

    protected void setJoin(QueryPos queryPos, Map<String, Object> params) throws Exception {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            List values;
            Object value;
            Object adminRole;
            String key = entry.getKey();
            if (key.equals("actionId")) {
                Long companyId = CompanyThreadLocal.getCompanyId();
                adminRole = RoleLocalServiceUtil.fetchRole((long)companyId, (String)"Administrator");
                Role siteAdminRole = RoleLocalServiceUtil.fetchRole((long)companyId, (String)"Site Administrator");
                Role siteOwnerRole = RoleLocalServiceUtil.fetchRole((long)companyId, (String)"Site Owner");
                Long userId = (Long)params.get("userId");
                if (Validator.isNull((Long)userId)) {
                    PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                    userId = permissionChecker.getUserId();
                }
                ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)Group.class.getName(), (String)((String)entry.getValue()));
                queryPos.add(RoleLocalServiceUtil.hasUserRole((long)userId, (long)adminRole.getRoleId()));
                queryPos.add(userId);
                queryPos.add(siteAdminRole.getRoleId());
                queryPos.add(siteOwnerRole.getRoleId());
                queryPos.add(resourceAction.getBitwiseValue());
                continue;
            }
            if (key.equals("active") || key.equals("layout") || key.equals("manualMembership") || key.equals("site")) {
                value = (Boolean)entry.getValue();
                queryPos.add((Boolean)value);
                continue;
            }
            if (key.equals("classNameIds")) {
                if (entry.getValue() instanceof Long) {
                    queryPos.add(((Long)entry.getValue()).longValue());
                    continue;
                }
                for (Object classNameId : (Object)((long[])entry.getValue())) {
                    queryPos.add((long)classNameId);
                }
                continue;
            }
            if (key.equals("excludedGroupIds")) {
                List excludedGroupIds = (List)entry.getValue();
                if (excludedGroupIds.isEmpty()) continue;
                adminRole = excludedGroupIds.iterator();
                while (adminRole.hasNext()) {
                    long excludedGroupId = (Long)adminRole.next();
                    queryPos.add(excludedGroupId);
                }
                continue;
            }
            if (key.equals("groupsTree")) {
                List groupsTree = (List)entry.getValue();
                if (groupsTree.isEmpty()) continue;
                for (Group group : groupsTree) {
                    queryPos.add(StringBundler.concat((Object[])new Object[]{"%", "/", group.getGroupId(), "/", "%"}));
                }
                continue;
            }
            if (key.equals("pageCount")) continue;
            if (key.equals("rolePermissions")) {
                RolePermissions rolePermissions = (RolePermissions)entry.getValue();
                ResourceAction resourceAction = ResourceActionLocalServiceUtil.getResourceAction((String)rolePermissions.getName(), (String)rolePermissions.getActionId());
                queryPos.add(rolePermissions.getName());
                queryPos.add(rolePermissions.getScope());
                queryPos.add(rolePermissions.getRoleId());
                queryPos.add(resourceAction.getBitwiseValue());
                continue;
            }
            if (key.equals("types")) {
                values = (List)entry.getValue();
                for (Integer value2 : values) {
                    queryPos.add(value2);
                }
                continue;
            }
            if (key.equals("userGroupRole")) {
                values = (List)entry.getValue();
                Long userId = (Long)values.get(0);
                Long roleId = (Long)values.get(1);
                queryPos.add(userId);
                queryPos.add(roleId);
                continue;
            }
            if (key.equals("userId")) continue;
            value = entry.getValue();
            if (value instanceof Integer) {
                Integer valueInteger = (Integer)value;
                if (valueInteger == null) continue;
                queryPos.add(valueInteger);
                continue;
            }
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                queryPos.add(valueLong);
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            queryPos.add(valueString);
        }
    }

    @SafeVarargs
    private final String _buildSQLCacheKey(OrderByComparator<Group> orderByComparator, Map<String, Object> ... params) {
        if (orderByComparator == null) {
            return this._buildSQLCacheKey("", params);
        }
        return this._buildSQLCacheKey(orderByComparator.getOrderBy(), params);
    }

    @SafeVarargs
    private final String _buildSQLCacheKey(String sql, Map<String, Object> ... params) {
        int size = 1;
        for (Map<String, Object> param : params) {
            if (param == null) continue;
            size += param.size() * 5;
        }
        StringBundler sb = new StringBundler(size);
        sb.append(sql);
        for (Map<String, Object> param : params) {
            if (param == null) continue;
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                Object values;
                sb.append(",");
                String key = entry.getKey();
                if (key.equals("rolePermissions")) {
                    key = "rolePermissions_6";
                }
                sb.append(key);
                sb.append("-");
                Object value = entry.getValue();
                if (value instanceof long[]) {
                    values = (long[])value;
                    sb.append(((long[])values).length);
                } else if (value instanceof Collection) {
                    values = (Collection)value;
                    sb.append(values.size());
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    private String _getCondition(String join) {
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            if (pos != -1) {
                join = "(" + join.substring(pos + 5);
                join = join.concat(") AND ");
            } else {
                join = "";
            }
        }
        return join;
    }

    private long[] _getGroupOrganizationClassNameIds() {
        if (this._groupOrganizationClassNameIds == null) {
            this._groupOrganizationClassNameIds = new long[]{ClassNameLocalServiceUtil.getClassNameId(Group.class), ClassNameLocalServiceUtil.getClassNameId(Organization.class)};
        }
        return this._groupOrganizationClassNameIds;
    }

    private Map<String, String> _getJoinMap() {
        HashMap joinMap;
        if (this._joinMap != null) {
            return this._joinMap;
        }
        this._joinMap = joinMap = HashMapBuilder.put((Object)"actionId", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ACTION_ID))).put((Object)"active", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ACTIVE))).put((Object)"groupOrg", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG))).put((Object)"groupsOrgs", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS))).put((Object)"groupsRoles", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES))).put((Object)"groupsUserGroups", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS))).put((Object)"layout", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_LAYOUT))).put((Object)"membershipRestriction", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_MEMBERSHIP_RESTRICTION))).put((Object)"pageCount", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT))).put((Object)"rolePermissions_6", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS))).put((Object)"site", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_SITE))).put((Object)"type", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_TYPE))).put((Object)"userGroupRole", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE))).put((Object)"usersGroups", (Object)this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS))).build();
        return this._joinMap;
    }

    private Map<String, String> _getWhereMap() {
        HashMap whereMap;
        if (this._whereMap != null) {
            return this._whereMap;
        }
        this._whereMap = whereMap = HashMapBuilder.put((Object)"actionId", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ACTION_ID))).put((Object)"active", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ACTIVE))).put((Object)"creatorUserId", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_CREATOR_USER_ID))).put((Object)"groupOrg", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG))).put((Object)"groupsOrgs", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS))).put((Object)"groupsRoles", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES))).put((Object)"groupsUserGroups", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS))).put((Object)"layout", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_LAYOUT))).put((Object)"manualMembership", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_MANUAL_MEMBERSHIP))).put((Object)"membershipRestriction", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_MEMBERSHIP_RESTRICTION))).put((Object)"pageCount", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT))).put((Object)"rolePermissions_6", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS))).put((Object)"site", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_SITE))).put((Object)"type", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_TYPE))).put((Object)"userGroupRole", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE))).put((Object)"usersGroups", (Object)this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS))).build();
        return this._whereMap;
    }

    private boolean _isCacheableSQL(long[] classNameIds) {
        if (classNameIds == null) {
            return true;
        }
        if (classNameIds.length > 2) {
            return false;
        }
        long[] groupOrganizationClassNameIds = this._getGroupOrganizationClassNameIds();
        long groupClassNameId = groupOrganizationClassNameIds[0];
        long organizationClassNameId = groupOrganizationClassNameIds[1];
        for (long classNameId : classNameIds) {
            if (classNameId == groupClassNameId || classNameId == organizationClassNameId) continue;
            return false;
        }
        return true;
    }

    private void _populateUnionParams(long userId, long[] classNameIds, Map<String, Object> params1, Map<String, Object> params2, Map<String, Object> params3, Map<String, Object> params4) {
        params2.remove("usersGroups");
        params2.put("groupOrg", userId);
        params3.remove("usersGroups");
        params3.put("groupsOrgs", userId);
        params4.remove("usersGroups");
        params4.put("groupsUserGroups", userId);
        long[] groupOrganizationClassNameIds = this._getGroupOrganizationClassNameIds();
        long groupClassNameId = groupOrganizationClassNameIds[0];
        long organizationClassNameId = groupOrganizationClassNameIds[1];
        if (classNameIds == null) {
            params1.put("classNameIds", groupOrganizationClassNameIds);
            params2.put("classNameIds", organizationClassNameId);
            params3.put("classNameIds", groupOrganizationClassNameIds);
            params4.put("classNameIds", groupOrganizationClassNameIds);
        } else {
            params1.put("classNameIds", classNameIds);
            if (ArrayUtil.contains((long[])classNameIds, (long)organizationClassNameId)) {
                params2.put("classNameIds", organizationClassNameId);
                if (ArrayUtil.contains((long[])classNameIds, (long)groupClassNameId)) {
                    params3.put("classNameIds", groupClassNameId);
                    params4.put("classNameIds", groupOrganizationClassNameIds);
                } else {
                    params4.put("classNameIds", organizationClassNameId);
                }
            } else if (ArrayUtil.contains((long[])classNameIds, (long)groupClassNameId)) {
                params3.put("classNameIds", groupClassNameId);
                params4.put("classNameIds", groupClassNameId);
            }
        }
    }

    private String _removeWhere(String join) {
        int pos;
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }
}

