/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.persistence.ResourcePermissionFinder;
import com.liferay.portal.kernel.service.persistence.ResourcePermissionUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.ResourcePermissionImpl;
import com.liferay.portal.service.persistence.impl.ResourcePermissionFinderBaseImpl;
import com.liferay.portal.service.persistence.impl.ResourcePermissionPersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourcePermissionFinderImpl
extends ResourcePermissionFinderBaseImpl
implements ResourcePermissionFinder {
    public static final String COUNT_BY_R_S = ResourcePermissionFinder.class.getName() + ".countByR_S";
    public static final String COUNT_BY_C_N_S_P_R_A = ResourcePermissionFinder.class.getName() + ".countByC_N_S_P_R_A";
    public static final String FIND_BY_RESOURCE = ResourcePermissionFinder.class.getName() + ".findByResource";
    public static final String FIND_BY_R_S = ResourcePermissionFinder.class.getName() + ".findByR_S";
    public static final FinderPath FINDER_PATH_COUNT_BY_C_N_S_P_R_A = new FinderPath(ResourcePermissionPersistenceImpl.FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_N_S_P_R_A", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), String.class.getName(), Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "name", "scope", "primKey", "roleId", "actionIds"}, false);

    public int countByR_S(long roleId, int[] scopes) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_R_S);
            sql = StringUtil.replace((String)sql, (String)"[$SCOPE$]", (String)this.getScopes(scopes));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(roleId);
            queryPos.add(scopes);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_N_S_P_R_A(long companyId, String name, int scope, String primKey, long[] roleIds, long actionId) {
        Object[] finderArgs = new Object[]{companyId, name, scope, primKey, StringUtil.merge((long[])roleIds), actionId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_C_N_S_P_R_A, (Object[])finderArgs);
        if (count != null) {
            return count.intValue();
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_N_S_P_R_A);
            if (roleIds.length > 1) {
                StringBundler sb = new StringBundler(roleIds.length * 2 - 1);
                for (int i = 0; i < roleIds.length; ++i) {
                    if (i > 0) {
                        sb.append(" OR ");
                    }
                    sb.append("ResourcePermission.roleId = ?");
                }
                sql = StringUtil.replace((String)sql, (String)"ResourcePermission.roleId = ?", (String)sb.toString());
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(name);
            queryPos.add(scope);
            queryPos.add(primKey);
            queryPos.add(roleIds);
            queryPos.add(actionId);
            queryPos.add(actionId);
            count = (Long)sqlQuery.uniqueResult();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            if (count == null) {
                count = 0L;
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_C_N_S_P_R_A, (Object[])finderArgs, (Object)count);
            this.closeSession(session);
        }
        return count.intValue();
    }

    @Deprecated
    public Map<Serializable, ResourcePermission> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        return ResourcePermissionUtil.fetchByPrimaryKeys(primaryKeys);
    }

    public List<ResourcePermission> findByResource(long companyId, long groupId, String name, String primKey) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_RESOURCE);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("ResourcePermission", ResourcePermissionImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(name);
            queryPos.add(primKey);
            queryPos.add(String.valueOf(groupId));
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ResourcePermission> findByR_S(long roleId, int[] scopes, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_R_S);
            sql = StringUtil.replace((String)sql, (String)"[$SCOPE$]", (String)this.getScopes(scopes));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("ResourcePermission", ResourcePermissionImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(roleId);
            queryPos.add(scopes);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getScopes(int[] scopes) {
        if (scopes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(scopes.length * 2 + 1);
        sb.append("(");
        for (int i = 0; i < scopes.length; ++i) {
            sb.append("ResourcePermission.scope = ? ");
            if (i + 1 == scopes.length) continue;
            sb.append("OR ");
        }
        sb.append(")");
        return sb.toString();
    }
}

