/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseUpgradeResourceBlock
extends UpgradeProcess {
    private static final String _INSERT_SQL = StringBundler.concat((String[])new String[]{"insert into ResourcePermission(mvccVersion, ", "resourcePermissionId, companyId, name, scope, primKey, ", "primKeyId, roleId, ownerId, actionIds, viewActionId) values(?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"});

    protected void doUpgrade() throws Exception {
        String className = this.getClassName();
        this._upgradeCompanyScopePermissions(className);
        this._upgradeGroupScopePermissions(className);
        this._upgradeGroupTemplateScopePermissions(className);
        this._upgradeIndividualScopePermissions(className);
        this._removeResourceBlocks(className);
        this.alterTableDropColumn(this.getTableName(), "resourceBlockId");
    }

    protected abstract String getClassName();

    protected abstract String getPrimaryKeyName();

    @Deprecated
    protected Class<?> getTableClass() {
        return null;
    }

    protected abstract String getTableName();

    protected abstract boolean hasUserId();

    private void _addResourcePermissionBatch(PreparedStatement preparedStatement, long companyId, String name, int scope, long primKeyId, long roleId, long ownerId, long actionIds) throws SQLException {
        preparedStatement.setLong(1, 0L);
        preparedStatement.setLong(2, this.increment(ResourcePermission.class.getName()));
        preparedStatement.setLong(3, companyId);
        preparedStatement.setString(4, name);
        preparedStatement.setInt(5, scope);
        preparedStatement.setString(6, String.valueOf(primKeyId));
        preparedStatement.setLong(7, primKeyId);
        preparedStatement.setLong(8, roleId);
        preparedStatement.setLong(9, ownerId);
        preparedStatement.setLong(10, actionIds);
        preparedStatement.setBoolean(11, actionIds % 2L == 1L);
        preparedStatement.addBatch();
    }

    private void _removeResourceBlocks(String className) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from ResourceTypePermission where name = ?");){
            preparedStatement.setString(1, className);
            preparedStatement.executeUpdate();
        }
        var3_3 = null;
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select resourceBlockId from ResourceBlock where name = ?");){
            selectPreparedStatement.setString(1, className);
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();
                 PreparedStatement deletePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from ResourceBlockPermission where resourceBlockId = ?");){
                while (resultSet.next()) {
                    long resourceBlockId = resultSet.getLong(1);
                    deletePreparedStatement.setLong(1, resourceBlockId);
                    deletePreparedStatement.addBatch();
                }
                deletePreparedStatement.executeBatch();
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        preparedStatement = this.connection.prepareStatement("delete from ResourceBlock where name = ?");
        var3_3 = null;
        try {
            preparedStatement.setString(1, className);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (preparedStatement != null) {
                if (var3_3 != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    preparedStatement.close();
                }
            }
        }
    }

    private void _upgradeCompanyScopePermissions(String className) throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform(StringBundler.concat((Object[])new Object[]{"select ResourceTypePermission.companyId, ", "ResourceTypePermission.roleId, ", "ResourceTypePermission.actionIds from ", "ResourceTypePermission inner join Role_ on ", "Role_.roleId = ResourceTypePermission.roleId ", "where ResourceTypePermission.groupId = 0 and ", "Role_.type_ = ", 1, " and ResourceTypePermission.name = ?"})));){
            selectPreparedStatement.setString(1, className);
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();
                 PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    long roleId = resultSet.getLong("roleId");
                    long actionIds = resultSet.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPreparedStatement, companyId, className, 1, companyId, roleId, 0L, actionIds);
                }
                insertPreparedStatement.executeBatch();
            }
        }
    }

    private void _upgradeGroupScopePermissions(String className) throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform("select companyId, groupId, roleId, actionIds from ResourceTypePermission where groupId != 0 and name = ?"));){
            selectPreparedStatement.setString(1, className);
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();
                 PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    long groupId = resultSet.getLong("groupId");
                    long roleId = resultSet.getLong("roleId");
                    long actionIds = resultSet.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPreparedStatement, companyId, className, 2, groupId, roleId, 0L, actionIds);
                }
                insertPreparedStatement.executeBatch();
            }
        }
    }

    private void _upgradeGroupTemplateScopePermissions(String className) throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform(StringBundler.concat((Object[])new Object[]{"select ResourceTypePermission.companyId, ", "ResourceTypePermission.roleId, ", "ResourceTypePermission.actionIds from ", "ResourceTypePermission inner join Role_ on ", "Role_.roleId = ResourceTypePermission.roleId ", "where ResourceTypePermission.groupId = 0 and ", "Role_.type_ != ", 1, " and ResourceTypePermission.name = ?"})));){
            selectPreparedStatement.setString(1, className);
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();
                 PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    long roleId = resultSet.getLong("roleId");
                    long actionIds = resultSet.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPreparedStatement, companyId, className, 3, 0L, roleId, 0L, actionIds);
                }
                insertPreparedStatement.executeBatch();
            }
        }
    }

    private void _upgradeIndividualScopePermissions(String className) throws Exception {
        StringBundler sb = new StringBundler(16);
        sb.append("select ResourceBlock.companyId, ");
        String tableName = this.getTableName();
        sb.append(tableName);
        sb.append(".");
        String primaryKeyName = this.getPrimaryKeyName();
        sb.append(primaryKeyName);
        sb.append(", ResourceBlockPermission.roleId, ");
        if (this.hasUserId()) {
            sb.append(tableName);
            sb.append(".userId, ");
        }
        sb.append("ResourceBlockPermission.resourceBlockPermissionId, ");
        sb.append("ResourceBlockPermission.actionIds from ");
        sb.append(tableName);
        sb.append(" inner join ResourceBlock on ");
        sb.append("(ResourceBlock.resourceBlockId = ");
        sb.append(tableName);
        sb.append(".resourceBlockId) inner join ResourceBlockPermission on ");
        sb.append("(ResourceBlockPermission.resourceBlockId = ResourceBlock.");
        sb.append("resourceBlockId) where ResourceBlock.name = ?");
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement(SQLTransformer.transform(sb.toString()));){
            selectPreparedStatement.setString(1, className);
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();
                 PreparedStatement insertPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)_INSERT_SQL);){
                while (resultSet.next()) {
                    long companyId = resultSet.getLong("companyId");
                    long primKeyId = resultSet.getLong(primaryKeyName);
                    long roleId = resultSet.getLong("roleId");
                    long userId = 0L;
                    if (this.hasUserId()) {
                        userId = resultSet.getLong("userId");
                    }
                    long actionIds = resultSet.getLong("actionIds");
                    this._addResourcePermissionBatch(insertPreparedStatement, companyId, className, 4, primKeyId, roleId, userId, actionIds);
                }
                insertPreparedStatement.executeBatch();
            }
        }
    }
}

