/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_1;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateSourcePrototypeLayoutUuid();
    }

    protected long getLayoutPrototypeGroupId(String layoutPrototypeUuid) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId from Group_ where classPK = (select layoutPrototypeId from LayoutPrototype where uuid_ = ?)");){
            preparedStatement.setString(1, layoutPrototypeUuid);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong("groupId");
                    return l;
                }
            }
        }
        return 0L;
    }

    protected boolean isGroupPrivateLayout(long groupId, String sourcePrototypeLayoutUuid) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select count(*) from Layout where uuid_ = ? and groupId = ? and privateLayout = ?");){
            preparedStatement.setString(1, sourcePrototypeLayoutUuid);
            preparedStatement.setLong(2, groupId);
            preparedStatement.setBoolean(3, true);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int count = resultSet.getInt(1);
                    if (count > 0) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void updateSourcePrototypeLayoutUuid() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("select plid, layoutPrototypeUuid, ");
            sb.append("sourcePrototypeLayoutUuid from Layout where ");
            sb.append("layoutPrototypeUuid != '' and ");
            sb.append("sourcePrototypeLayoutUuid != ''");
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String sourcePrototypeLayoutUuid;
                    String layoutPrototypeUuid = resultSet.getString("layoutPrototypeUuid");
                    long groupId = this.getLayoutPrototypeGroupId(layoutPrototypeUuid);
                    if (groupId == 0L || !this.isGroupPrivateLayout(groupId, sourcePrototypeLayoutUuid = resultSet.getString("sourcePrototypeLayoutUuid"))) continue;
                    long plid = resultSet.getLong("plid");
                    this.runSQL("update Layout set sourcePrototypeLayoutUuid = null where plid = " + plid);
                }
            }
        }
    }
}

