/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;

public class UpgradeCountry
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        Throwable throwable;
        this.runSQLTemplate("update-7.3.0-7.4.0-country.sql", false);
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select countryId from Country where uuid_ is null");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update Country set uuid_ = ? where countryId = ?");){
            throwable = null;
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    preparedStatement2.setString(1, PortalUUIDUtil.generate());
                    preparedStatement2.setLong(2, resultSet.getLong(1));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        long companyId = 0L;
        long userId = 0L;
        String languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.US);
        String sql = StringBundler.concat((String[])new String[]{"select User_.companyId, User_.userId, User_.languageId from ", "User_ join Company on User_.companyId = Company.companyId where ", "User_.defaultUser = [$TRUE$] and Company.webId = ", StringUtil.quote((String)PropsValues.COMPANY_DEFAULT_WEB_ID)});
        throwable = null;
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform(sql));
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                companyId = resultSet.getLong(1);
                userId = resultSet.getLong(2);
                languageId = resultSet.getString(3);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        this.runSQL("update Country set defaultLanguageId = " + StringUtil.quote((String)languageId) + " where defaultLanguageId is null");
        if (companyId > 0L) {
            this.runSQL("update Country set companyId = " + companyId + " where (companyId is null or companyId = 0)");
        }
        if (userId > 0L) {
            this.runSQL("update Country set userId = " + userId + " where (userId is null or userId = 0)");
        }
    }
}

