/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_4_x;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeExternalReferenceCode
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeExternalReferenceCode.class);

    protected void doUpgrade() throws Exception {
        this.upgradeExternalReference("Address", "addressId");
        this.upgradeExternalReference("AssetCategory", "categoryId");
        this.upgradeExternalReference("AssetVocabulary", "vocabularyId");
        this.upgradeExternalReference("BlogsEntry", "entryId");
        this.upgradeExternalReference("DLFileEntry", "fileEntryId");
        this.upgradeExternalReference("Organization_", "organizationId");
        this.upgradeExternalReference("User_", "userId");
        this.upgradeExternalReference("UserGroup", "userGroupId");
    }

    protected void upgradeExternalReference(String tableName, String primKeyColumnName) throws Exception {
        if (!this.hasTable(tableName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skip nonexistent table " + tableName));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgrade table " + tableName));
        }
        if (!this.hasColumn(tableName, "externalReferenceCode")) {
            this.alterTableAddColumn(tableName, "externalReferenceCode", "VARCHAR(75)");
        }
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler selectSB = new StringBundler(7);
            selectSB.append("select ");
            selectSB.append(primKeyColumnName);
            boolean hasUuid = this.hasColumn(tableName, "uuid_");
            if (hasUuid) {
                selectSB.append(", uuid_");
            }
            selectSB.append(" from ");
            selectSB.append(tableName);
            selectSB.append(" where externalReferenceCode is null or ");
            selectSB.append("externalReferenceCode = ''");
            StringBundler updateSB = new StringBundler(5);
            updateSB.append("update ");
            updateSB.append(tableName);
            updateSB.append(" set externalReferenceCode = ? where ");
            updateSB.append(primKeyColumnName);
            updateSB.append(" = ?");
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(selectSB.toString());
                 ResultSet resultSet = preparedStatement1.executeQuery();
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)updateSB.toString());){
                while (resultSet.next()) {
                    long primKey = resultSet.getLong(1);
                    if (hasUuid) {
                        String uuid = resultSet.getString(2);
                        preparedStatement2.setString(1, uuid);
                    } else {
                        preparedStatement2.setString(1, String.valueOf(primKey));
                    }
                    preparedStatement2.setLong(2, primKey);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

