/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;

public class LicenseUtil {
    public static final String LICENSE_REPOSITORY_DIR = PropsValues.LIFERAY_HOME.concat("/data/license");
    public static final String LICENSE_SERVER_URL = GetterUtil.get((String)PropsUtil.get((String)"license.server.url"), (String)"https://www.liferay.com");
    private static final Log _log = LogFactoryUtil.getLog(LicenseUtil.class);
    private static final MethodHandler _getServerInfoMethodHandler = new MethodHandler(new MethodKey(LicenseUtil.class, "getServerInfo", new Class[0]), new Object[0]);
    private static final Set<String> _ipAddresses;
    private static final Set<String> _macAddresses;
    private static final MethodKey _registerOrderMethodKey;
    private static byte[] _serverIdBytes;

    public static Map<String, String> getClusterServerInfo(String clusterNodeId) throws Exception {
        ClusterNode localClusterNode = ClusterExecutorUtil.getLocalClusterNode();
        String localClusterNodeId = localClusterNode.getClusterNodeId();
        if (clusterNodeId.equals(localClusterNodeId)) {
            return LicenseUtil.getServerInfo();
        }
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        ClusterNode clusterNode = null;
        for (ClusterNode curClusterNode : clusterNodes) {
            String curClusterNodeId = curClusterNode.getClusterNodeId();
            if (!curClusterNodeId.equals(clusterNodeId)) continue;
            clusterNode = curClusterNode;
            break;
        }
        if (clusterNode == null) {
            return null;
        }
        try {
            ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)_getServerInfoMethodHandler, (String[])new String[]{clusterNodeId});
            FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
            return (Map)((Object)clusterNodeResponse.getResult());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw exception;
        }
    }

    public static Set<String> getIpAddresses() {
        return _ipAddresses;
    }

    public static Set<String> getMacAddresses() {
        return _macAddresses;
    }

    public static int getProcessorCores() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.availableProcessors();
    }

    public static byte[] getServerIdBytes() throws Exception {
        if (_serverIdBytes != null) {
            return _serverIdBytes;
        }
        File serverIdFile = new File(LICENSE_REPOSITORY_DIR + "/server/serverId");
        if (!serverIdFile.exists()) {
            return new byte[0];
        }
        _serverIdBytes = FileUtil.getBytes((File)serverIdFile);
        return _serverIdBytes;
    }

    public static Map<String, String> getServerInfo() {
        return HashMapBuilder.put((Object)"hostName", (Object)PortalUtil.getComputerName()).put((Object)"ipAddresses", (Object)StringUtil.merge(_ipAddresses)).put((Object)"macAddresses", (Object)StringUtil.merge(_macAddresses)).put((Object)"processorCores", (Object)String.valueOf(LicenseUtil.getProcessorCores())).build();
    }

    public static void registerOrder(HttpServletRequest httpServletRequest) {
        String orderUuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"orderUuid");
        String productEntryName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"productEntryName");
        int maxServers = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"maxServers");
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        if (clusterNodes == null || clusterNodes.size() <= 1 || Validator.isNull((String)productEntryName) || Validator.isNull((String)orderUuid)) {
            Map<String, Object> attributes = LicenseUtil.registerOrder(orderUuid, productEntryName, maxServers);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                httpServletRequest.setAttribute(entry.getKey(), entry.getValue());
            }
        } else {
            for (ClusterNode clusterNode : clusterNodes) {
                boolean register = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)(clusterNode.getClusterNodeId() + "_register"));
                if (!register) continue;
                try {
                    LicenseUtil._registerClusterOrder(httpServletRequest, clusterNode, orderUuid, productEntryName, maxServers);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                    InetAddress inetAddress = clusterNode.getBindInetAddress();
                    String message = "Error contacting " + inetAddress.getHostName();
                    if (clusterNode.getPortalPort() != -1) {
                        message = message + ":" + clusterNode.getPortalPort();
                    }
                    httpServletRequest.setAttribute(clusterNode.getClusterNodeId() + "_ERROR_MESSAGE", (Object)message);
                }
            }
        }
    }

    public static Map<String, Object> registerOrder(String orderUuid, String productEntryName, int maxServers) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (Validator.isNull((String)orderUuid)) {
            return attributes;
        }
        try {
            JSONObject jsonObject = LicenseUtil._createRequest(orderUuid, productEntryName, maxServers);
            String response = LicenseUtil.sendRequest(jsonObject.toString());
            JSONObjectImpl responseJSONObject = new JSONObjectImpl(response);
            attributes.put("ORDER_PRODUCT_ID", responseJSONObject.getString("productId"));
            attributes.put("ORDER_PRODUCTS", LicenseUtil._getOrderProducts(responseJSONObject));
            String errorMessage = responseJSONObject.getString("errorMessage");
            if (Validator.isNotNull((String)errorMessage)) {
                attributes.put("ERROR_MESSAGE", errorMessage);
                return attributes;
            }
            String licenseXML = responseJSONObject.getString("licenseXML");
            if (Validator.isNotNull((String)licenseXML)) {
                LicenseManagerUtil.registerLicense((JSONObject)responseJSONObject);
                attributes.clear();
                attributes.put("SUCCESS_MESSAGE", "Your license has been successfully registered.");
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            attributes.put("ERROR_MESSAGE", "There was an error contacting " + LICENSE_SERVER_URL);
        }
        return attributes;
    }

    public static String sendRequest(String request) throws Exception {
        Http.Options options = new Http.Options();
        String serverURL = LICENSE_SERVER_URL;
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL + "/";
        }
        serverURL = serverURL + "osb-portlet/license";
        options.setLocation(serverURL);
        options.setPost(true);
        options.setBody(request, "application/json", "UTF-8");
        return HttpUtil.URLtoString((Http.Options)options);
    }

    public static void writeServerProperties(byte[] serverIdBytes) throws Exception {
        File serverIdFile = new File(LICENSE_REPOSITORY_DIR + "/server/serverId");
        FileUtil.write((File)serverIdFile, (byte[])serverIdBytes);
    }

    private static JSONObject _createRequest(String orderUuid, String productEntryName, int maxServers) throws Exception {
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        jsonObject.put("liferayVersion", ReleaseInfo.getBuildNumber()).put("orderUuid", orderUuid).put("version", 2);
        if (Validator.isNull((String)productEntryName)) {
            jsonObject.put("cmd", "QUERY");
        } else {
            jsonObject.put("cmd", "REGISTER");
            if (productEntryName.startsWith("basic")) {
                String[] productNameArray;
                jsonObject.put("productEntryName", "basic");
                if (productEntryName.equals("basic-cluster")) {
                    jsonObject.put("cluster", true).put("maxServers", maxServers);
                } else if (productEntryName.startsWith("basic-") && (productNameArray = StringUtil.split((String)productEntryName, (String)"-")).length >= 3) {
                    jsonObject.put("clusterId", productNameArray[2]).put("offeringEntryId", productNameArray[1]);
                }
            } else {
                jsonObject.put("productEntryName", productEntryName);
            }
            jsonObject.put("hostName", PortalUtil.getComputerName()).put("ipAddresses", StringUtil.merge(_ipAddresses)).put("macAddresses", StringUtil.merge(_macAddresses)).put("processorCores", LicenseUtil.getProcessorCores()).put("serverId", Arrays.toString(LicenseUtil.getServerIdBytes()));
        }
        return jsonObject;
    }

    private static Map<String, String> _getOrderProducts(JSONObject jsonObject) {
        JSONObject productsJSONObject = jsonObject.getJSONObject("productsJSONObject");
        if (productsJSONObject == null) {
            return null;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator iterator = productsJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            sortedMap.put(key, productsJSONObject.getString(key));
        }
        return sortedMap;
    }

    private static void _registerClusterOrder(HttpServletRequest httpServletRequest, ClusterNode clusterNode, String orderUuid, String productEntryName, int maxServers) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_registerOrderMethodKey, new Object[]{orderUuid, productEntryName, maxServers});
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)methodHandler, (String[])new String[]{clusterNode.getClusterNodeId()});
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
        ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
        Map attributes = (Map)((Object)clusterNodeResponse.getResult());
        for (Map.Entry entry : attributes.entrySet()) {
            httpServletRequest.setAttribute(clusterNode.getClusterNodeId() + "_" + (String)entry.getKey(), entry.getValue());
        }
    }

    static {
        _registerOrderMethodKey = new MethodKey(LicenseUtil.class, "registerOrder", new Class[]{String.class, String.class, Integer.TYPE});
        HashSet<String> ipAddresses = new HashSet<String>();
        HashSet<String> macAddresses = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumeration.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumeration.nextElement();
                Enumeration<InetAddress> inetAddressEnumeration = networkInterface.getInetAddresses();
                while (inetAddressEnumeration.hasMoreElements()) {
                    InetAddress inetAddress = inetAddressEnumeration.nextElement();
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    ipAddresses.add(inetAddress.getHostAddress());
                }
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (ArrayUtil.isEmpty((byte[])hardwareAddress)) continue;
                StringBundler sb = new StringBundler(hardwareAddress.length * 3 - 1);
                String hexString = StringUtil.bytesToHexString((byte[])hardwareAddress);
                for (int i = 0; i < hexString.length(); i += 2) {
                    if (i != 0) {
                        sb.append(':');
                    }
                    sb.append(Character.toLowerCase(hexString.charAt(i)));
                    sb.append(Character.toLowerCase(hexString.charAt(i + 1)));
                }
                macAddresses.add(sb.toString());
            }
        }
        catch (SocketException socketException) {
            _log.error((Object)"Unable to read local server network interfaces", (Throwable)socketException);
        }
        _ipAddresses = Collections.unmodifiableSet(ipAddresses);
        _macAddresses = Collections.unmodifiableSet(macAddresses);
    }
}

