/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.document.library.kernel.exception.ImageSizeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.encryptor.EncryptorUtil;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RSSFeedException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.LayoutQueryStringComposite;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.LiferayRenderResponse;
import com.liferay.portal.kernel.portlet.LiferayStateAwareResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.redirect.RedirectURLSettingsUtil;
import com.liferay.portal.kernel.security.auth.AlwaysAllowDoAsUser;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.servlet.NonSerializableObjectRequestWrapper;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.DeterminateKeyGenerator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.InheritableMap;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalInetSocketAddressEventListener;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.RemotePreference;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TreeMapBuilder;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.impl.CookieRemotePreference;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.security.jaas.JAASHelper;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.upload.UploadPortletRequestImpl;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.admin.util.OmniadminUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.util.JS;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PortalImpl
implements Portal {
    private static final String _J_SECURITY_CHECK = "j_security_check";
    private static final String _LOCALHOST = "localhost";
    private static final Locale _NULL_LOCALE;
    private static final int _PORTLET_RESOURCE_ID_URL_DECODE_COUNT;
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING;
    private static final String _UNICODE_REPLACEMENT_CHARACTER = "\ufffd";
    private static final Log _log;
    private static final Pattern _bannedResourceIdPattern;
    private static final Map<Long, String> _cdnHostHttpMap;
    private static final Map<Long, String> _cdnHostHttpsMap;
    private static final MethodHandler _resetCDNHostsMethodHandler;
    private static final Date _upTime;
    private static final Log _webServerServletLog;
    private final String[] _allSystemGroups;
    private final String[] _allSystemOrganizationRoles;
    private final String[] _allSystemRoles;
    private final String[] _allSystemSiteRoles;
    private final List<AlwaysAllowDoAsUser> _alwaysAllowDoAsUsers;
    private final BundleContext _bundleContext;
    private final Set<String> _computerAddresses;
    private final String _computerName;
    private String[] _customSqlKeys;
    private String[] _customSqlValues;
    private volatile StrutsAction _editDiscussionStrutsAction;
    private volatile StrutsAction _getCommentsStrutsAction;
    private final String _pathContext;
    private final String _pathFriendlyURLPrivateGroup;
    private final String _pathFriendlyURLPrivateUser;
    private final String _pathFriendlyURLPublic;
    private final String _pathImage;
    private final String _pathMain;
    private final String _pathModule;
    private final String _pathProxy;
    private final Map<String, Long> _plidToPortletIdMap;
    private final Set<PortalInetSocketAddressEventListener> _portalInetSocketAddressEventListeners;
    private final AtomicReference<InetSocketAddress> _portalLocalInetSocketAddress;
    private final AtomicReference<InetSocketAddress> _portalServerInetSocketAddress;
    private final Set<String> _reservedParams;
    private final AtomicReference<InetSocketAddress> _securePortalLocalInetSocketAddress;
    private final AtomicReference<InetSocketAddress> _securePortalServerInetSocketAddress;
    private final String _servletContextName;
    private final String[] _sortedSystemGroups;
    private final String[] _sortedSystemOrganizationRoles;
    private final String[] _sortedSystemRoles;
    private final String[] _sortedSystemSiteRoles;
    private final boolean _validPortalDomainCheckDisabled;

    public PortalImpl() {
        block12: {
            String computerName;
            block11: {
                this._alwaysAllowDoAsUsers = new ArrayList<AlwaysAllowDoAsUser>();
                this._bundleContext = SystemBundleUtil.getBundleContext();
                this._computerAddresses = new HashSet<String>();
                this._plidToPortletIdMap = new ConcurrentHashMap<String, Long>();
                this._portalInetSocketAddressEventListeners = new CopyOnWriteArraySet<PortalInetSocketAddressEventListener>();
                this._portalLocalInetSocketAddress = new AtomicReference();
                this._portalServerInetSocketAddress = new AtomicReference();
                this._reservedParams = new HashSet<String>();
                this._securePortalLocalInetSocketAddress = new AtomicReference();
                this._securePortalServerInetSocketAddress = new AtomicReference();
                computerName = SystemProperties.get((String)"env.COMPUTERNAME");
                if (Validator.isNull((String)computerName)) {
                    computerName = SystemProperties.get((String)"env.HOST");
                }
                if (Validator.isNull((String)computerName)) {
                    computerName = SystemProperties.get((String)"env.HOSTNAME");
                }
                if (Validator.isNull((String)computerName)) {
                    try {
                        InetAddress inetAddress = InetAddress.getLocalHost();
                        computerName = inetAddress.getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!_log.isDebugEnabled()) break block11;
                        _log.debug((Throwable)unknownHostException);
                    }
                }
            }
            this._computerName = computerName;
            try {
                ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface networkInterface : networkInterfaces) {
                    ArrayList<InetAddress> inetAddresses = Collections.list(networkInterface.getInetAddresses());
                    for (InetAddress inetAddress : inetAddresses) {
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        this._computerAddresses.add(inetAddress.getHostAddress());
                    }
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to determine server's IP addresses");
                _log.error((Throwable)exception);
            }
            this._pathProxy = PropsValues.PORTAL_PROXY_PATH;
            this._pathContext = this._pathProxy.concat(this.getContextPath(PortalContextLoaderListener.getPortalServletContextPath()));
            this._pathFriendlyURLPrivateGroup = this._pathContext + _PRIVATE_GROUP_SERVLET_MAPPING;
            this._pathFriendlyURLPrivateUser = this._pathContext + _PRIVATE_USER_SERVLET_MAPPING;
            this._pathFriendlyURLPublic = this._pathContext + _PUBLIC_GROUP_SERVLET_MAPPING;
            this._pathImage = this._pathContext + "/image";
            this._pathMain = this._pathContext + "/c";
            this._pathModule = this._pathContext + "/o";
            Object[] customSystemGroups = PropsUtil.getArray("system.groups");
            this._allSystemGroups = ArrayUtil.isEmpty((Object[])customSystemGroups) ? GroupConstants.SYSTEM_GROUPS : (String[])ArrayUtil.append((Object[])GroupConstants.SYSTEM_GROUPS, (Object[])customSystemGroups);
            this._sortedSystemGroups = new String[this._allSystemGroups.length];
            System.arraycopy(this._allSystemGroups, 0, this._sortedSystemGroups, 0, this._allSystemGroups.length);
            Arrays.sort(this._sortedSystemGroups, new StringComparator());
            Object[] customSystemRoles = PropsUtil.getArray("system.roles");
            this._allSystemRoles = ArrayUtil.isEmpty((Object[])customSystemRoles) ? RoleConstants.SYSTEM_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_ROLES, (Object[])customSystemRoles);
            this._sortedSystemRoles = new String[this._allSystemRoles.length];
            System.arraycopy(this._allSystemRoles, 0, this._sortedSystemRoles, 0, this._allSystemRoles.length);
            Arrays.sort(this._sortedSystemRoles, new StringComparator());
            Object[] customSystemOrganizationRoles = PropsUtil.getArray("system.organization.roles");
            this._allSystemOrganizationRoles = ArrayUtil.isEmpty((Object[])customSystemOrganizationRoles) ? RoleConstants.SYSTEM_ORGANIZATION_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_ORGANIZATION_ROLES, (Object[])customSystemOrganizationRoles);
            this._sortedSystemOrganizationRoles = new String[this._allSystemOrganizationRoles.length];
            System.arraycopy(this._allSystemOrganizationRoles, 0, this._sortedSystemOrganizationRoles, 0, this._allSystemOrganizationRoles.length);
            Arrays.sort(this._sortedSystemOrganizationRoles, new StringComparator());
            Object[] customSystemSiteRoles = PropsUtil.getArray("system.site.roles");
            this._allSystemSiteRoles = ArrayUtil.isEmpty((Object[])customSystemSiteRoles) ? RoleConstants.SYSTEM_SITE_ROLES : (String[])ArrayUtil.append((Object[])RoleConstants.SYSTEM_SITE_ROLES, (Object[])customSystemSiteRoles);
            this._sortedSystemSiteRoles = new String[this._allSystemSiteRoles.length];
            System.arraycopy(this._allSystemSiteRoles, 0, this._sortedSystemSiteRoles, 0, this._allSystemSiteRoles.length);
            Arrays.sort(this._sortedSystemSiteRoles, new StringComparator());
            this._reservedParams.add("p_auth");
            this._reservedParams.add("p_auth_secret");
            this._reservedParams.add("p_l_back_url");
            this._reservedParams.add("p_l_id");
            this._reservedParams.add("p_l_mode");
            this._reservedParams.add("p_l_reset");
            this._reservedParams.add("p_p_auth");
            this._reservedParams.add("p_p_id");
            this._reservedParams.add("p_p_i_id");
            this._reservedParams.add("p_p_lifecycle");
            this._reservedParams.add("p_p_url_type");
            this._reservedParams.add("p_p_state");
            this._reservedParams.add("p_p_state_rcv");
            this._reservedParams.add("p_p_mode");
            this._reservedParams.add("p_p_resource_id");
            this._reservedParams.add("p_p_cacheability");
            this._reservedParams.add("p_p_async");
            this._reservedParams.add("p_p_hub");
            this._reservedParams.add("p_p_width");
            this._reservedParams.add("p_p_col_id");
            this._reservedParams.add("p_p_col_pos");
            this._reservedParams.add("p_p_col_count");
            this._reservedParams.add("p_p_boundary");
            this._reservedParams.add("p_p_decorate");
            this._reservedParams.add("p_p_static");
            this._reservedParams.add("p_p_isolated");
            this._reservedParams.add("p_t_lifecycle");
            this._reservedParams.add("p_v_l_s_g_id");
            this._reservedParams.add("p_f_id");
            this._reservedParams.add("p_j_a_id");
            this._reservedParams.add("saveLastPath");
            this._reservedParams.add("scroll");
            this._reservedParams.add("switchGroup");
            this._servletContextName = PortalContextLoaderListener.getPortalServletContextName();
            this._validPortalDomainCheckDisabled = ArrayUtil.isEmpty((Object[])PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) || ArrayUtil.contains((Object[])PropsValues.VIRTUAL_HOSTS_VALID_HOSTS, (Object)"*");
            try {
                ServiceTracker alwaysAllowDoAsUserServiceTracker = new ServiceTracker(this._bundleContext, AlwaysAllowDoAsUser.class, (ServiceTrackerCustomizer)new AlwaysAllowDoAsUserServiceTrackerCustomizer());
                alwaysAllowDoAsUserServiceTracker.open();
                ServiceTracker portalInetSocketAddressEventListenerServiceTracker = new ServiceTracker(this._bundleContext, PortalInetSocketAddressEventListener.class, (ServiceTrackerCustomizer)new PortalInetSocketAddressEventListenerServiceTrackerCustomizer());
                portalInetSocketAddressEventListenerServiceTracker.open();
                ServiceTracker commentsStrutsActionServiceTracker = new ServiceTracker(this._bundleContext, StrutsAction.class, (ServiceTrackerCustomizer)new CommentsStrutsActionServiceTrackerCustomizer());
                commentsStrutsActionServiceTracker.open();
            }
            catch (NullPointerException nullPointerException) {
                if (!_log.isDebugEnabled()) break block12;
                _log.debug((Throwable)nullPointerException);
            }
        }
    }

    public void addPageDescription(String description, HttpServletRequest httpServletRequest) {
        ListMergeable descriptionListMergeable = (ListMergeable)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION");
        if (descriptionListMergeable == null) {
            descriptionListMergeable = new ListMergeable();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)descriptionListMergeable);
        }
        descriptionListMergeable.add((Object)description);
    }

    public void addPageKeywords(String keywords, HttpServletRequest httpServletRequest) {
        String[] keywordsArray;
        ListMergeable keywordsListMergeable = (ListMergeable)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        if (keywordsListMergeable == null) {
            keywordsListMergeable = new ListMergeable();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_KEYWORDS", (Object)keywordsListMergeable);
        }
        for (String keyword : keywordsArray = StringUtil.split((String)keywords)) {
            if (keywordsListMergeable.contains((Object)StringUtil.toLowerCase((String)keyword))) continue;
            keywordsListMergeable.add((Object)StringUtil.toLowerCase((String)keyword));
        }
    }

    public void addPageSubtitle(String subtitle, HttpServletRequest httpServletRequest) {
        ListMergeable subtitleListMergeable = (ListMergeable)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_SUBTITLE");
        if (subtitleListMergeable == null) {
            subtitleListMergeable = new ListMergeable();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitleListMergeable);
        }
        subtitleListMergeable.add((Object)subtitle);
    }

    public void addPageTitle(String title, HttpServletRequest httpServletRequest) {
        ListMergeable titleListMergeable = (ListMergeable)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_TITLE");
        if (titleListMergeable == null) {
            titleListMergeable = new ListMergeable();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)titleListMergeable);
        }
        titleListMergeable.add((Object)title);
    }

    public boolean addPortalInetSocketAddressEventListener(PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        return this._portalInetSocketAddressEventListeners.add(portalInetSocketAddressEventListener);
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest httpServletRequest, String title, String url) {
        this.addPortletBreadcrumbEntry(httpServletRequest, title, url, null);
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest httpServletRequest, String title, String url, Map<String, Object> data) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        boolean portletBreadcrumbEntry = false;
        if (Validator.isNotNull((String)portletDisplay.getId()) && !portletDisplay.isFocused()) {
            portletBreadcrumbEntry = true;
        }
        this.addPortletBreadcrumbEntry(httpServletRequest, title, url, null, portletBreadcrumbEntry);
    }

    public void addPortletBreadcrumbEntry(HttpServletRequest httpServletRequest, String title, String url, Map<String, Object> data, boolean portletBreadcrumbEntry) {
        ArrayList<BreadcrumbEntry> breadcrumbEntries;
        String name = "LIFERAY_SHARED_PORTLET_BREADCRUMBS";
        if (portletBreadcrumbEntry) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            name = name + "_" + portletDisplay.getId();
        }
        if ((breadcrumbEntries = (ArrayList<BreadcrumbEntry>)httpServletRequest.getAttribute(name)) == null) {
            breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
            httpServletRequest.setAttribute(name, breadcrumbEntries);
        }
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setData(data);
        breadcrumbEntry.setTitle(title);
        breadcrumbEntry.setURL(url);
        breadcrumbEntries.add(breadcrumbEntry);
    }

    public void addPortletDefaultResource(HttpServletRequest httpServletRequest, Portlet portlet) throws PortalException {
        String name = this._getPortletBaseResource(portlet);
        if (Validator.isNull((String)name)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long groupId = 0L;
        groupId = layout.isTypeControlPanel() ? themeDisplay.getScopeGroupId() : this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(themeDisplay.getCompanyId(), groupId, name);
    }

    public void addPortletDefaultResource(long companyId, Layout layout, Portlet portlet) throws PortalException {
        String name = this._getPortletBaseResource(portlet);
        if (Validator.isNull((String)name)) {
            return;
        }
        long groupId = this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(companyId, groupId, name);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, Layout layout, String url, boolean doAsUser) {
        return this.addPreservedParameters(themeDisplay, url, layout.isTypeControlPanel(), doAsUser);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, String url) {
        return this.addPreservedParameters(themeDisplay, themeDisplay.getLayout(), url, true);
    }

    public String addPreservedParameters(ThemeDisplay themeDisplay, String url, boolean typeControlPanel, boolean doAsUser) {
        if (doAsUser) {
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
                url = HttpComponentsUtil.setParameter((String)url, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
            }
            if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
                url = HttpComponentsUtil.setParameter((String)url, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
            }
        }
        if (typeControlPanel) {
            if (Validator.isNotNull((String)themeDisplay.getPpid())) {
                url = HttpComponentsUtil.setParameter((String)url, (String)"p_p_id", (String)themeDisplay.getPpid());
            }
            if (themeDisplay.getDoAsGroupId() > 0L) {
                url = HttpComponentsUtil.setParameter((String)url, (String)"doAsGroupId", (long)themeDisplay.getDoAsGroupId());
            }
            if (themeDisplay.getRefererGroupId() != 0L) {
                url = HttpComponentsUtil.setParameter((String)url, (String)"refererGroupId", (long)themeDisplay.getRefererGroupId());
            }
            if (themeDisplay.getRefererPlid() != 0L) {
                url = HttpComponentsUtil.setParameter((String)url, (String)"refererPlid", (long)themeDisplay.getRefererPlid());
            }
        }
        return url;
    }

    public void clearRequestParameters(RenderRequest renderRequest) {
        LiferayRenderRequest liferayRenderRequest = (LiferayRenderRequest)renderRequest;
        if (liferayRenderRequest.isTriggeredByActionURL()) {
            liferayRenderRequest.clearRenderParameters();
        }
    }

    public void copyRequestParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        LiferayStateAwareResponse liferayStateAwareResponse;
        if (actionResponse instanceof LiferayStateAwareResponse && (liferayStateAwareResponse = (LiferayStateAwareResponse)actionResponse).getRedirectLocation() != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Cannot copy parameters on a redirected LiferayStateAwareResponse");
            }
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this.getLiferayPortletResponse((PortletResponse)actionResponse);
        StateAwareResponse stateAwareResponse = (StateAwareResponse)liferayPortletResponse;
        Map renderParameters = stateAwareResponse.getRenderParameterMap();
        actionResponse.setRenderParameter("p_p_lifecycle", "1");
        Enumeration enumeration = actionRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            if (renderParameters.get(actionResponse.getNamespace() + param) != null) continue;
            Object[] values = actionRequest.getParameterValues(param);
            values = values == null ? new String[]{} : (String[])ArrayUtil.filter((Object[])values, s -> s != null);
            actionResponse.setRenderParameter(param, (String[])values);
        }
    }

    public String escapeRedirect(String url) {
        URI uri;
        block20: {
            if (Validator.isNull((String)url)) {
                return url;
            }
            if (url.contains(_UNICODE_REPLACEMENT_CHARACTER)) {
                return null;
            }
            uri = null;
            try {
                uri = HttpComponentsUtil.getURI((String)url);
            }
            catch (URISyntaxException uriSyntaxException) {
                if (!_log.isDebugEnabled()) break block20;
                _log.debug((Throwable)uriSyntaxException);
            }
        }
        if (uri == null) {
            return null;
        }
        if (!uri.isAbsolute()) {
            if ((url = url.trim()).startsWith("//")) {
                return null;
            }
            return url;
        }
        String domain = uri.getHost();
        if (Validator.isNull((String)domain)) {
            return null;
        }
        if (!this._validPortalDomainCheckDisabled && this.isValidPortalDomain(domain)) {
            return url;
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        String securityMode = RedirectURLSettingsUtil.getSecurityMode((long)companyId);
        if (securityMode.equals("domain")) {
            String[] allowedDomains = RedirectURLSettingsUtil.getAllowedDomains((long)companyId);
            if (allowedDomains.length == 0) {
                return url;
            }
            for (String allowedDomain : allowedDomains) {
                if (allowedDomain.startsWith("*.") && (allowedDomain.regionMatches(1, domain, domain.length() - (allowedDomain.length() - 1), allowedDomain.length() - 1) || allowedDomain.regionMatches(2, domain, 0, domain.length()))) {
                    return url;
                }
                if (!allowedDomain.equals(domain)) continue;
                return url;
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Redirect URL " + url + " is not allowed"));
            }
            url = null;
        } else {
            block21: {
                String[] allowedIPs = RedirectURLSettingsUtil.getAllowedIPs((long)companyId);
                if (allowedIPs.length == 0) {
                    return url;
                }
                try {
                    InetAddress inetAddress = InetAddressUtil.getInetAddressByName((String)domain);
                    String hostAddress = inetAddress.getHostAddress();
                    boolean serverIpIsHostAddress = this._computerAddresses.contains(hostAddress);
                    for (String ip : allowedIPs) {
                        if ((!serverIpIsHostAddress || !ip.equals("SERVER_IP")) && !ip.equals(hostAddress)) continue;
                        return url;
                    }
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Redirect URL " + url + " is not allowed"));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (!_log.isDebugEnabled()) break block21;
                    _log.debug((Object)("Unable to determine IP for redirect URL " + url), (Throwable)unknownHostException);
                }
            }
            url = null;
        }
        return url;
    }

    public String generateRandomKey(HttpServletRequest httpServletRequest, String input) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isAjax() || themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive()) {
            return StringUtil.randomId();
        }
        StringBundler sb = new StringBundler(5);
        sb.append(DeterminateKeyGenerator.generate((String)input));
        sb.append("_");
        Object columnId = httpServletRequest.getAttribute("RENDER_PORTLET_COLUMN_ID");
        if (columnId != null) {
            sb.append(HtmlUtil.getAUICompatibleId((String)columnId.toString()));
        }
        sb.append("_");
        Object columnPos = httpServletRequest.getAttribute("RENDER_PORTLET_COLUMN_POS");
        if (columnPos != null) {
            sb.append(HtmlUtil.getAUICompatibleId((String)columnPos.toString()));
        }
        return sb.toString();
    }

    public String getAbsoluteURL(HttpServletRequest httpServletRequest, String url) {
        String portalURL = this.getPortalURL(httpServletRequest);
        if (url.charAt(0) == '/' && Validator.isNotNull((String)portalURL)) {
            url = portalURL.concat(url);
        }
        if (!CookieKeys.hasSessionId((HttpServletRequest)httpServletRequest) && url.startsWith(portalURL)) {
            HttpSession httpSession = httpServletRequest.getSession();
            url = this.getURLWithSessionId(url, httpSession.getId());
        }
        return url;
    }

    public LayoutQueryStringComposite getActualLayoutQueryStringComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        List layouts;
        Layout layout = null;
        if (Validator.isNull((String)friendlyURL)) {
            layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L, (boolean)true, (int)0, (int)1);
            if (layouts.isEmpty()) {
                throw new NoSuchLayoutException(StringBundler.concat((Object[])new Object[]{"{groupId=", groupId, ", privateLayout=", privateLayout, "}"}));
            }
        } else {
            return this.getPortletFriendlyURLMapperLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        }
        layout = (Layout)layouts.get(0);
        return new LayoutQueryStringComposite(layout, friendlyURL, "");
    }

    public String getActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String actualURL = null;
        if (friendlyURL != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
            long companyId = PortalInstances.getCompanyId(httpServletRequest);
            for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
                if (!friendlyURL.startsWith(urlSeparator)) continue;
                try {
                    FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)urlSeparator);
                    actualURL = friendlyURLResolver.getActualURL(companyId, groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
                    break;
                }
                catch (Exception exception) {
                    throw new NoSuchLayoutException((Throwable)exception);
                }
            }
        }
        if (actualURL == null) {
            actualURL = this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
        }
        return actualURL;
    }

    public String getAlternateURL(String canonicalURL, ThemeDisplay themeDisplay, Locale locale, Layout layout) throws PortalException {
        Map<Locale, String> alternateURLs = this._getAlternateURLs(canonicalURL, themeDisplay, layout, Collections.singleton(locale));
        return alternateURLs.get(locale);
    }

    public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        Set availableLocales = LanguageUtil.getAvailableLocales((long)layout.getGroupId());
        return this._getAlternateURLs(canonicalURL, themeDisplay, layout, availableLocales);
    }

    public long[] getAncestorSiteGroupIds(long groupId) {
        int i = 0;
        Set<Group> groups = this.getAncestorSiteGroups(groupId, false);
        long[] groupIds = new long[groups.size()];
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    public BaseModel<?> getBaseModel(ResourcePermission resourcePermission) throws PortalException {
        String modelName = resourcePermission.getName();
        return this.getBaseModel(modelName, resourcePermission.getPrimKey());
    }

    public BaseModel<?> getBaseModel(String modelName, String primKey) throws PortalException {
        if (!modelName.contains(".model.")) {
            return null;
        }
        Object[] parts = StringUtil.split((String)modelName, (char)'.');
        if (parts.length <= 2 || !parts[parts.length - 2].equals("model")) {
            return null;
        }
        parts[parts.length - 2] = "service";
        String serviceName = StringUtil.merge((Object[])parts, (String)".") + "LocalServiceUtil";
        String methodName = "get" + (String)parts[parts.length - 1];
        Method method = null;
        try {
            Class<?> serviceUtil = Class.forName(serviceName);
            if (Validator.isNumber((String)primKey)) {
                method = serviceUtil.getMethod(methodName, Long.TYPE);
                return (BaseModel)method.invoke(null, Long.valueOf(primKey));
            }
            method = serviceUtil.getMethod(methodName, String.class);
            return (BaseModel)method.invoke(null, primKey);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof PortalException) {
                throw (PortalException)throwable;
            }
            if (throwable instanceof SystemException) {
                throw (SystemException)throwable;
            }
            throw new SystemException(throwable);
        }
    }

    public List<Group> getBrowsableScopeGroups(long userId, long companyId, long groupId, String portletId) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        groups.addAll(0, GroupLocalServiceUtil.search((long)companyId, null, null, (LinkedHashMap)LinkedHashMapBuilder.put((Object)"usersGroups", (Object)userId).build(), (int)-1, (int)-1));
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
        for (Organization organization : organizations) {
            groups.add(0, organization.getGroup());
        }
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            groups.add(0, GroupLocalServiceUtil.getUserGroup((long)companyId, (long)userId));
        }
        groups.addAll(0, this.getCurrentAndAncestorSiteGroups(groupId));
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : ListUtil.unique(groups)) {
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                if (stagingGroup.getGroupId() != groupId || !group.isStagedPortlet(portletId) || group.isStagedRemotely() || !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet")) continue;
                filteredGroups.add(stagingGroup);
                continue;
            }
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        return this.getCanonicalURL(completeURL, themeDisplay, layout, false, true);
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout, boolean forceLayoutFriendlyURL) throws PortalException {
        return this.getCanonicalURL(completeURL, themeDisplay, layout, forceLayoutFriendlyURL, true);
    }

    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout, boolean forceLayoutFriendlyURL, boolean includeQueryString) throws PortalException {
        String groupFriendlyURL = "";
        boolean includeParametersURL = false;
        String parametersURL = "";
        if (Validator.isNotNull((String)completeURL)) {
            completeURL = this.removeRedirectParameter(completeURL);
            int pos = -1;
            for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
                pos = completeURL.indexOf(urlSeparator);
                if (pos == -1) continue;
                String friendlyURL = layout.getFriendlyURL();
                if (friendlyURL.contains(urlSeparator)) {
                    pos = -1;
                    continue;
                }
                includeParametersURL = true;
                break;
            }
            if (pos == -1) {
                pos = completeURL.indexOf(63);
            }
            groupFriendlyURL = completeURL;
            if (pos != -1) {
                groupFriendlyURL = completeURL.substring(0, pos);
                parametersURL = completeURL.substring(pos);
            }
        }
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        String canonicalLayoutFriendlyURL = "";
        String defaultLayoutFriendlyURL = null;
        Locale siteDefaultLocale = this.getSiteDefaultLocale(layout.getGroupId());
        defaultLayoutFriendlyURL = siteDefaultLocale.equals(themeDisplay.getLocale()) ? themeDisplay.getLayoutFriendlyURL(layout) : layout.getFriendlyURL(this.getSiteDefaultLocale(layout.getGroupId()));
        Group layoutGroup = layout.getGroup();
        if (forceLayoutFriendlyURL || (!layout.isFirstParent() || Validator.isNotNull((String)parametersURL)) && this._requiresLayoutFriendlyURL(layoutGroup.getFriendlyURL(), themeDisplay.getLayoutFriendlyURL(layout), StringUtil.toLowerCase((String)groupFriendlyURL)) || groupFriendlyURL.endsWith("/" + layout.getLayoutId())) {
            canonicalLayoutFriendlyURL = defaultLayoutFriendlyURL;
        }
        groupFriendlyURL = this.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay, true, layout.isTypeControlPanel());
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            String groupFriendlyURLDomain = HttpComponentsUtil.getDomain((String)groupFriendlyURL);
            int pos = groupFriendlyURL.indexOf(groupFriendlyURLDomain);
            if (pos > 0) {
                pos = groupFriendlyURL.indexOf(47, pos + groupFriendlyURLDomain.length());
                if (Validator.isNotNull((String)this._pathContext)) {
                    pos = groupFriendlyURL.indexOf(47, pos + this._pathContext.length());
                }
            }
            StringBundler sb = new StringBundler(3);
            if (pos <= 0 || pos >= groupFriendlyURL.length()) {
                sb.append(groupFriendlyURL);
                sb.append(this._buildI18NPath(siteDefaultLocale, layout.getGroup()));
                if (!canonicalLayoutFriendlyURL.startsWith("/")) {
                    sb.append("/");
                }
            } else {
                String groupFriendlyURLPrefix = groupFriendlyURL.substring(0, pos);
                String groupFriendlyURLSuffix = groupFriendlyURL.substring(pos);
                sb.append(groupFriendlyURLPrefix);
                sb.append(this._buildI18NPath(siteDefaultLocale, layout.getGroup()));
                sb.append(groupFriendlyURLSuffix);
            }
            groupFriendlyURL = sb.toString();
        }
        groupFriendlyURL = groupFriendlyURL.concat(canonicalLayoutFriendlyURL);
        if (includeQueryString) {
            if (groupFriendlyURL.endsWith("/") && parametersURL.startsWith("/")) {
                parametersURL = parametersURL.substring(1);
            }
            groupFriendlyURL = groupFriendlyURL.concat(parametersURL);
        } else if (includeParametersURL) {
            int y;
            int x = 0;
            if (groupFriendlyURL.endsWith("/") && parametersURL.startsWith("/")) {
                x = 1;
            }
            if ((y = parametersURL.indexOf(63)) == -1) {
                y = parametersURL.length();
            }
            groupFriendlyURL = groupFriendlyURL.concat(parametersURL.substring(x, y));
        }
        return groupFriendlyURL;
    }

    public String getCDNHost(boolean secure) {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (secure) {
            return this.getCDNHostHttps(companyId);
        }
        return this.getCDNHostHttp(companyId);
    }

    public String getCDNHost(HttpServletRequest httpServletRequest) throws PortalException {
        boolean cdnEnabled = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"cdn_enabled", (boolean)true);
        String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
        if (!cdnEnabled || portletId.equals("com_liferay_portal_settings_web_portlet_PortalSettingsPortlet")) {
            return "";
        }
        String cdnHost = null;
        Company company = this.getCompany(httpServletRequest);
        cdnHost = this.isSecure(httpServletRequest) ? this.getCDNHostHttps(company.getCompanyId()) : this.getCDNHostHttp(company.getCompanyId());
        if (Validator.isUrl((String)cdnHost)) {
            return cdnHost;
        }
        return "";
    }

    public String getCDNHostHttp(long companyId) {
        String cdnHostHttp;
        block4: {
            cdnHostHttp = _cdnHostHttpMap.get(companyId);
            if (cdnHostHttp != null) {
                return cdnHostHttp;
            }
            try {
                cdnHostHttp = PrefsPropsUtil.getString(companyId, "cdn.host.http", PropsValues.CDN_HOST_HTTP);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        if (cdnHostHttp == null || cdnHostHttp.startsWith("${") || !Validator.isUrl((String)cdnHostHttp)) {
            cdnHostHttp = "";
        }
        _cdnHostHttpMap.put(companyId, cdnHostHttp);
        return cdnHostHttp;
    }

    public String getCDNHostHttps(long companyId) {
        String cdnHostHttps;
        block4: {
            cdnHostHttps = _cdnHostHttpsMap.get(companyId);
            if (cdnHostHttps != null) {
                return cdnHostHttps;
            }
            try {
                cdnHostHttps = PrefsPropsUtil.getString(companyId, "cdn.host.https", PropsValues.CDN_HOST_HTTPS);
            }
            catch (SystemException systemException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)systemException);
            }
        }
        if (cdnHostHttps == null || cdnHostHttps.startsWith("${") || !Validator.isUrl((String)cdnHostHttps)) {
            cdnHostHttps = "";
        }
        _cdnHostHttpsMap.put(companyId, cdnHostHttps);
        return cdnHostHttps;
    }

    public String getClassName(long classNameId) {
        try {
            ClassName className = ClassNameLocalServiceUtil.getClassName((long)classNameId);
            return className.getValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get class name from id " + classNameId, exception);
        }
    }

    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getClassNameId(String value) {
        if (!StartupHelperUtil.isUpgrading()) {
            return ClassNameLocalServiceUtil.getClassNameId((String)value);
        }
        try (Connection connection = DataAccess.getConnection();){
            if (PortalUpgradeProcess.isInLatestSchemaVersion(connection)) {
                long l = ClassNameLocalServiceUtil.getClassNameId((String)value);
                return l;
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement("select classNameId from ClassName_ where value = ?");){
                preparedStatement.setString(1, value);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (!resultSet.next()) return 0L;
                    long l = resultSet.getLong("classNameId");
                    return l;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get class name ID from value " + value, exception);
        }
    }

    public Company getCompany(HttpServletRequest httpServletRequest) throws PortalException {
        long companyId = this.getCompanyId(httpServletRequest);
        if (companyId <= 0L) {
            return null;
        }
        Company company = (Company)httpServletRequest.getAttribute("COMPANY");
        if (company == null) {
            company = CompanyLocalServiceUtil.fetchCompanyById((long)companyId);
            if (company == null) {
                company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstances.getDefaultCompanyId());
            }
            httpServletRequest.setAttribute("COMPANY", (Object)company);
        }
        return company;
    }

    public Company getCompany(PortletRequest portletRequest) throws PortalException {
        return this.getCompany(this.getHttpServletRequest(portletRequest));
    }

    public long getCompanyId(HttpServletRequest httpServletRequest) {
        return PortalInstances.getCompanyId(httpServletRequest);
    }

    public long getCompanyId(PortletRequest portletRequest) {
        return this.getCompanyId(this.getHttpServletRequest(portletRequest));
    }

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public Set<String> getComputerAddresses() {
        return this._computerAddresses;
    }

    public String getComputerName() {
        return this._computerName;
    }

    public String getControlPanelFullURL(long scopeGroupId, String ppid, Map<String, String[]> params) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
        Group controlPanelDisplayGroup = this.getControlPanelDisplayGroup(group.getCompanyId(), scopeGroupId, 0L, ppid);
        Company company = CompanyLocalServiceUtil.getCompany((long)controlPanelDisplayGroup.getCompanyId());
        return this.getSiteAdminURL(this.getPortalURL(company.getVirtualHostname(), this.getPortalServerPort(false), false), controlPanelDisplayGroup, ppid, params);
    }

    public long getControlPanelPlid(long companyId) throws PortalException {
        Group controlPanelGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Control Panel");
        return LayoutLocalServiceUtil.getDefaultPlid((long)controlPanelGroup.getGroupId(), (boolean)true);
    }

    public long getControlPanelPlid(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    public PortletURL getControlPanelPortletURL(HttpServletRequest httpServletRequest, Group group, String portletId, long refererGroupId, long refererPlid, String lifecycle) {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest);
        if (group == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = this.getControlPanelDisplayGroup(themeDisplay.getControlPanelGroup(), themeDisplay.getScopeGroup(), themeDisplay.getDoAsGroupId(), portletId);
        }
        return requestBackedPortletURLFactory.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, lifecycle);
    }

    public PortletURL getControlPanelPortletURL(HttpServletRequest httpServletRequest, String portletId, String lifecycle) {
        return this.getControlPanelPortletURL(httpServletRequest, null, portletId, 0L, 0L, lifecycle);
    }

    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, Group group, String portletId, long refererGroupId, long refererPlid, String lifecycle) {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create((PortletRequest)portletRequest);
        if (group == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = this.getControlPanelDisplayGroup(themeDisplay.getControlPanelGroup(), themeDisplay.getScopeGroup(), themeDisplay.getDoAsGroupId(), portletId);
        }
        return requestBackedPortletURLFactory.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, lifecycle);
    }

    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, String portletId, String lifecycle) {
        return this.getControlPanelPortletURL(portletRequest, null, portletId, 0L, 0L, lifecycle);
    }

    public String getCreateAccountURL(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay) throws Exception {
        if (Validator.isNull((String)PropsValues.COMPANY_SECURITY_STRANGERS_URL)) {
            long plid = themeDisplay.getPlid();
            Layout layout = themeDisplay.getLayout();
            if (layout.isPrivateLayout()) {
                plid = LayoutLocalServiceUtil.getDefaultPlid((long)layout.getGroupId(), (boolean)false);
            }
            PortletURL createAccountURL = PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_login_web_portlet_LoginPortlet", (long)plid, (String)"RENDER_PHASE")).setMVCRenderCommandName("/login/create_account").setParameter("saveLastPath", (Object)false).setPortletMode(PortletMode.VIEW).setWindowState(WindowState.MAXIMIZED).buildPortletURL();
            if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS) {
                return createAccountURL.toString();
            }
            return StringUtil.replaceFirst((String)createAccountURL.toString(), (String)this.getPortalURL(httpServletRequest), (String)this.getPortalURL(httpServletRequest, true));
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (String)PropsValues.COMPANY_SECURITY_STRANGERS_URL);
            return this.getLayoutURL(layout, themeDisplay);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchLayoutException);
            }
            return "";
        }
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long groupId) throws PortalException {
        return this.getCurrentAndAncestorSiteGroupIds(groupId, false);
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long groupId, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        List<Group> groups = this.getCurrentAndAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled);
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return groupIds;
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long[] groupIds) throws PortalException {
        return this.getCurrentAndAncestorSiteGroupIds(groupIds, false);
    }

    public long[] getCurrentAndAncestorSiteGroupIds(long[] groupIds, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        List<Group> groups = this.getCurrentAndAncestorSiteGroups(groupIds, checkContentSharingWithChildrenEnabled);
        long[] currentAndAncestorSiteGroupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            currentAndAncestorSiteGroupIds[i] = group.getGroupId();
        }
        return currentAndAncestorSiteGroupIds;
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long groupId) throws PortalException {
        return this.getCurrentAndAncestorSiteGroups(groupId, false);
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long groupId, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Group siteGroup = this.getCurrentSiteGroup(groupId);
        if (siteGroup != null) {
            groups.add(siteGroup);
        }
        groups.addAll(this.getAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled));
        return new ArrayList<Group>(groups);
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long[] groupIds) throws PortalException {
        return this.getCurrentAndAncestorSiteGroups(groupIds, false);
    }

    public List<Group> getCurrentAndAncestorSiteGroups(long[] groupIds, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (long groupId : groupIds) {
            groups.addAll(this.getCurrentAndAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled));
        }
        return new ArrayList<Group>(groups);
    }

    public String getCurrentCompleteURL(HttpServletRequest httpServletRequest) {
        String currentCompleteURL = (String)httpServletRequest.getAttribute("CURRENT_COMPLETE_URL");
        if (currentCompleteURL == null) {
            currentCompleteURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest);
            httpServletRequest.setAttribute("CURRENT_COMPLETE_URL", (Object)currentCompleteURL);
        }
        return currentCompleteURL;
    }

    public String getCurrentURL(HttpServletRequest httpServletRequest) {
        String currentURL = (String)httpServletRequest.getAttribute("CURRENT_URL");
        if (currentURL != null) {
            return currentURL;
        }
        currentURL = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"currentURL");
        if (Validator.isNull((String)currentURL) && Validator.isNotNull((String)(currentURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest))) && !currentURL.contains(_J_SECURITY_CHECK)) {
            currentURL = currentURL.substring(currentURL.indexOf("://") + "://".length());
            currentURL = currentURL.substring(currentURL.indexOf(47));
        }
        if (Validator.isNull((String)currentURL)) {
            currentURL = this.getPathMain();
        }
        httpServletRequest.setAttribute("CURRENT_URL", (Object)currentURL);
        return currentURL;
    }

    public String getCurrentURL(PortletRequest portletRequest) {
        return (String)portletRequest.getAttribute("CURRENT_URL");
    }

    public String getCustomSQLFunctionIsNotNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNOTNULL;
    }

    public String getCustomSQLFunctionIsNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNULL;
    }

    public Date getDate(int month, int day, int year) {
        try {
            return this.getDate(month, day, year, null);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    public Date getDate(int month, int day, int year, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, null, clazz);
    }

    public Date getDate(int month, int day, int year, int hour, int min, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, hour, min, null, clazz);
    }

    public Date getDate(int month, int day, int year, int hour, int min, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        if (!Validator.isGregorianDate((int)month, (int)day, (int)year)) {
            if (clazz != null) {
                try {
                    throw clazz.newInstance();
                }
                catch (PortalException portalException) {
                    throw portalException;
                }
                catch (Exception exception) {
                    throw new PortalException((Throwable)exception);
                }
            }
            return null;
        }
        Calendar cal = null;
        cal = timeZone == null ? CalendarFactoryUtil.getCalendar() : CalendarFactoryUtil.getCalendar((TimeZone)timeZone);
        if (hour == -1 || min == -1) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, hour, min, 0);
        }
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public Date getDate(int month, int day, int year, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, -1, -1, timeZone, clazz);
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    public String getEmailFromAddress(javax.portlet.PortletPreferences preferences, long companyId, String defaultValue) {
        if (Validator.isNull((String)defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        return preferences.getValue("emailFromAddress", defaultValue);
    }

    public String getEmailFromName(javax.portlet.PortletPreferences preferences, long companyId, String defaultValue) {
        if (Validator.isNull((String)defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        return preferences.getValue("emailFromName", defaultValue);
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, HttpServletRequest httpServletRequest) throws PortalException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            if (!param.contains("ExpandoAttributeName--")) continue;
            String name = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            UnicodeProperties unicodeProperties = expandoBridge.getAttributeProperties(name);
            String displayType = GetterUtil.getString((String)unicodeProperties.getProperty("display-type"), (String)"text-box");
            Serializable value = this.getExpandoValue(httpServletRequest, "ExpandoAttribute--" + name + "--", type, displayType);
            attributes.put(name, value);
        }
        return attributes;
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, PortletRequest portletRequest) throws PortalException {
        return this.getExpandoBridgeAttributes(expandoBridge, this.getHttpServletRequest(portletRequest));
    }

    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, UploadPortletRequest uploadPortletRequest) throws PortalException {
        return this.getExpandoBridgeAttributes(expandoBridge, (HttpServletRequest)uploadPortletRequest);
    }

    public Serializable getExpandoValue(HttpServletRequest httpServletRequest, String name, int type, String displayType) throws PortalException {
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)name);
        } else if (type != 2) {
            if (type == 3) {
                int valueDateMonth = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)(name + "Month"));
                int valueDateDay = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)(name + "Day"));
                int valueDateYear = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)(name + "Year"));
                int valueDateHour = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)(name + "Hour"));
                int valueDateMinute = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)(name + "Minute"));
                int valueDateAmPm = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)(name + "AmPm"));
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                TimeZone timeZone = null;
                User user = this.getUser(httpServletRequest);
                if (user != null) {
                    timeZone = user.getTimeZone();
                }
                value = this.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, timeZone, ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble((HttpServletRequest)httpServletRequest, (String)name);
                } else if (type == 6) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat((HttpServletRequest)httpServletRequest, (String)name));
                } else if (type == 8) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)name);
                } else if (type == 10) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)name);
                } else if (type == 12) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber((HttpServletRequest)httpServletRequest, (String)name);
                } else if (type == 18) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort((HttpServletRequest)httpServletRequest, (String)name);
                } else if (type == 14) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getShortValues((String[])values);
                } else if (type == 16) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty((Object[])values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = values;
                } else {
                    value = type == 20 ? (Serializable)((Object)LocalizationUtil.getLocalizationMap((HttpServletRequest)httpServletRequest, (String)name)) : ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)name);
                }
            }
        }
        return value;
    }

    public Serializable getExpandoValue(PortletRequest portletRequest, String name, int type, String displayType) throws PortalException {
        return this.getExpandoValue(this.getHttpServletRequest(portletRequest), name, type, displayType);
    }

    public Serializable getExpandoValue(UploadPortletRequest uploadPortletRequest, String name, int type, String displayType) throws PortalException {
        return this.getExpandoValue((HttpServletRequest)uploadPortletRequest, name, type, displayType);
    }

    public String getFirstPageLayoutTypes(HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler();
        for (String type : LayoutTypeControllerTracker.getTypes()) {
            LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type);
            if (!layoutTypeController.isFirstPageable()) continue;
            sb.append(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)("layout.types." + type)));
            sb.append(",");
            sb.append(" ");
        }
        if (sb.index() >= 2) {
            sb.setIndex(sb.index() - 2);
        }
        return sb.toString();
    }

    public String getForwardedHost(HttpServletRequest httpServletRequest) {
        String serverName = httpServletRequest.getServerName();
        if (!PropsValues.WEB_SERVER_FORWARDED_HOST_ENABLED) {
            return serverName;
        }
        String forwardedHost = httpServletRequest.getHeader(PropsValues.WEB_SERVER_FORWARDED_HOST_HEADER);
        if (Validator.isBlank((String)forwardedHost) || forwardedHost.equals(serverName)) {
            return serverName;
        }
        if (this._validPortalDomainCheckDisabled) {
            if (!Validator.isHostName((String)forwardedHost)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid forwarded host: " + forwardedHost));
                }
                return serverName;
            }
        } else if (!this.isValidPortalDomain(forwardedHost)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid forwarded host: " + forwardedHost));
            }
            return serverName;
        }
        return forwardedHost;
    }

    public int getForwardedPort(HttpServletRequest httpServletRequest) {
        if (!PropsValues.WEB_SERVER_FORWARDED_PORT_ENABLED) {
            return httpServletRequest.getServerPort();
        }
        return GetterUtil.getInteger((String)httpServletRequest.getHeader(PropsValues.WEB_SERVER_FORWARDED_PORT_HEADER), (int)httpServletRequest.getServerPort());
    }

    public String getFullName(String firstName, String middleName, String lastName) {
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        return fullNameGenerator.getFullName(firstName, middleName, lastName);
    }

    public String getGoogleGadgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.GOOGLE_GADGET_SERVLET_MAPPING, themeDisplay);
    }

    public String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL, boolean controlPanel) throws PortalException {
        Group group = themeDisplay.getSiteGroup();
        if (group.getGroupId() != layoutSet.getGroupId()) {
            group = layoutSet.getGroup();
        }
        return this._getGroupFriendlyURL(group, layoutSet, themeDisplay, canonicalURL, controlPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getGroupFriendlyURL(layoutSet, themeDisplay, false, false);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    public int[] getGroupFriendlyURLIndex(String requestURI) {
        if (requestURI.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING + "/") || requestURI.startsWith(_PRIVATE_USER_SERVLET_MAPPING + "/") || requestURI.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING + "/")) {
            int x = requestURI.indexOf("/", 1);
            int y = requestURI.indexOf(47, x + 1);
            if (y == -1) {
                requestURI = requestURI + "/";
                y = requestURI.indexOf(47, x + 1);
            }
            return new int[]{x, y};
        }
        return null;
    }

    public String getHomeURL(HttpServletRequest httpServletRequest) throws PortalException {
        String portalURL = this.getPortalURL(httpServletRequest);
        return portalURL + this._pathContext + this.getRelativeHomeURL(httpServletRequest);
    }

    public String getHost(HttpServletRequest httpServletRequest) {
        String host = (httpServletRequest = this.getOriginalServletRequest(httpServletRequest)).getHeader("Host");
        if (host != null) {
            int pos = (host = StringUtil.toLowerCase((String)host.trim())).indexOf(93);
            if (pos > 0 && host.startsWith("[")) {
                return host.substring(1, pos);
            }
            pos = host.indexOf(58);
            if (pos >= 0) {
                host = host.substring(0, pos);
            }
        }
        return host;
    }

    public String getHost(PortletRequest portletRequest) {
        return this.getHost(this.getHttpServletRequest(portletRequest));
    }

    public HttpServletRequest getHttpServletRequest(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)portletRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest");
        if (httpServletRequest != null) {
            return httpServletRequest;
        }
        if (portletRequest instanceof LiferayPortletRequest) {
            LiferayPortletRequest liferayPortletRequest = (LiferayPortletRequest)portletRequest;
            return liferayPortletRequest.getHttpServletRequest();
        }
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        return liferayPortletRequest.getHttpServletRequest();
    }

    public HttpServletResponse getHttpServletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof LiferayPortletResponse) {
            LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)portletResponse;
            return liferayPortletResponse.getHttpServletResponse();
        }
        LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
        return liferayPortletResponse.getHttpServletResponse();
    }

    public String getI18nPathLanguageId(Locale locale, String defaultI18nPathLanguageId) {
        String i18nPathLanguageId = StringUtil.replace((String)defaultI18nPathLanguageId, (char)'_', (char)'-');
        if (!LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            i18nPathLanguageId = locale.getLanguage();
        } else {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                i18nPathLanguageId = locale.getLanguage();
            }
        }
        return i18nPathLanguageId;
    }

    public String getJsSafePortletId(String portletId) {
        return JS.getSafeName((String)portletId);
    }

    public String getLayoutActualURL(Layout layout) {
        return this.getLayoutActualURL(layout, this.getPathMain());
    }

    public String getLayoutActualURL(Layout layout, String mainPath) {
        Layout browsableLayout = this.getBrowsableLayout(layout);
        String groupIdString = String.valueOf(browsableLayout.getGroupId());
        HashMap variables = HashMapBuilder.put((Object)"liferay:groupId", (Object)groupIdString).put((Object)"liferay:layoutId", (Object)String.valueOf(browsableLayout.getLayoutId())).put((Object)"liferay:mainPath", (Object)mainPath).put((Object)"liferay:plid", (Object)String.valueOf(browsableLayout.getPlid())).put((Object)"liferay:privateLayout", (Object)String.valueOf(browsableLayout.isPrivateLayout())).build();
        String pvlsgid = "0";
        if (browsableLayout instanceof VirtualLayout) {
            pvlsgid = groupIdString;
        }
        variables.put("liferay:pvlsgid", pvlsgid);
        variables.putAll(layout.getTypeSettingsProperties());
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        return LayoutTypeImpl.getURL(layoutTypeController.getURL(), variables);
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL) throws PortalException {
        return this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, null, null);
    }

    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        UnicodeProperties typeSettingsUnicodeProperties;
        LayoutQueryStringComposite actualLayoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        Layout layout = actualLayoutQueryStringComposite.getLayout();
        String queryString = actualLayoutQueryStringComposite.getQueryString();
        String layoutActualURL = this.getLayoutActualURL(layout, mainPath);
        if (Validator.isNotNull((String)queryString)) {
            layoutActualURL = layoutActualURL.concat(queryString);
        } else if (MapUtil.isEmpty(params) && Validator.isNotNull((String)(queryString = (typeSettingsUnicodeProperties = layout.getTypeSettingsProperties()).getProperty("query-string"))) && layoutActualURL.contains("?")) {
            layoutActualURL = StringBundler.concat((String[])new String[]{layoutActualURL, "&", queryString});
        }
        return layoutActualURL;
    }

    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        if (themeDisplay.getLayout() == layout) {
            return this.getLayoutFriendlyURL(themeDisplay);
        }
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (!layoutTypeController.isURLFriendliable()) {
            return null;
        }
        String friendlyURL = layoutTypeController.getFriendlyURL(themeDisplay.getRequest(), layout);
        if (friendlyURL != null) {
            return friendlyURL;
        }
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        if (layoutSet == null || layoutSet.getGroupId() != layout.getGroupId() || layoutSet.isPrivateLayout() != layout.isPrivateLayout()) {
            layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet((long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
        }
        if (layoutSet == null) {
            return null;
        }
        String groupFriendlyURL = this.getGroupFriendlyURL(layoutSet, themeDisplay, false, layout.isTypeControlPanel());
        return groupFriendlyURL.concat(themeDisplay.getLayoutFriendlyURL(layout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutFriendlyURL(layout, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    public String getLayoutFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (!layoutTypeController.isURLFriendliable()) {
            return null;
        }
        String friendlyURL = layoutTypeController.getFriendlyURL(themeDisplay.getRequest(), layout);
        if (friendlyURL != null) {
            return friendlyURL;
        }
        Group group = themeDisplay.getSiteGroup();
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        if (group.getGroupId() != layoutSet.getGroupId()) {
            group = layoutSet.getGroup();
        }
        String groupFriendlyURL = this._getGroupFriendlyURL(group, themeDisplay.getLayoutSet(), themeDisplay, false, layout.isTypeControlPanel());
        return groupFriendlyURL.concat(themeDisplay.getLayoutFriendlyURL(layout));
    }

    public LayoutFriendlyURLSeparatorComposite getLayoutFriendlyURLSeparatorComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = null;
        if (friendlyURL != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
            long companyId = PortalInstances.getCompanyId(httpServletRequest);
            for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
                if (!friendlyURL.startsWith(urlSeparator)) continue;
                try {
                    FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)urlSeparator);
                    layoutFriendlyURLSeparatorComposite = friendlyURLResolver.getLayoutFriendlyURLSeparatorComposite(companyId, groupId, privateLayout, friendlyURL, params, requestContext);
                    break;
                }
                catch (Exception exception) {
                    throw new NoSuchLayoutException((Throwable)exception);
                }
            }
        }
        if (layoutFriendlyURLSeparatorComposite != null) {
            return layoutFriendlyURLSeparatorComposite;
        }
        LayoutQueryStringComposite layoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        return new LayoutFriendlyURLSeparatorComposite(layoutQueryStringComposite.getLayout(), layoutQueryStringComposite.getFriendlyURL(), "/-/", false);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutFullURL(layout, themeDisplay, true);
    }

    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        String layoutURL = this.getLayoutURL(layout, themeDisplay, doAsUser);
        if (!HttpComponentsUtil.hasProtocol((String)layoutURL)) {
            layoutURL = this.getPortalURL(layout, themeDisplay) + layoutURL;
        }
        return layoutURL;
    }

    public String getLayoutFullURL(long groupId, String portletId) throws PortalException {
        return this.getLayoutFullURL(groupId, portletId, false);
    }

    public String getLayoutFullURL(long groupId, String portletId, boolean secure) throws PortalException {
        long parentGroupId;
        long plid = this.getPlidFromPortletId(groupId, portletId);
        if (plid == 0L) {
            return null;
        }
        StringBundler sb = new StringBundler(4);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
            group = GroupLocalServiceUtil.getGroup((long)parentGroupId);
        }
        String virtualHostname = null;
        LayoutSet layoutSet = layout.getLayoutSet();
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (!virtualHostnames.isEmpty()) {
            virtualHostname = (String)virtualHostnames.firstKey();
        } else {
            Company company = CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId());
            virtualHostname = company.getVirtualHostname();
        }
        sb.append(this.getPortalURL(virtualHostname, this.getPortalServerPort(secure), secure));
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(this.getPathFriendlyURLPrivateUser());
            } else {
                sb.append(this.getPathFriendlyURLPrivateGroup());
            }
        } else {
            sb.append(this.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL());
        return sb.toString();
    }

    public String getLayoutFullURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutFullURL(themeDisplay.getLayout(), themeDisplay);
    }

    public String getLayoutRelativeURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutRelativeURL(layout, themeDisplay, true);
    }

    public String getLayoutRelativeURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        if (layout.isTypeURL()) {
            return this.getLayoutURL(layout, themeDisplay, doAsUser);
        }
        return HttpComponentsUtil.removeDomain((String)this.getLayoutFullURL(layout, themeDisplay, doAsUser));
    }

    public String getLayoutSetDisplayURL(LayoutSet layoutSet, boolean secureConnection) throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompany((long)layoutSet.getCompanyId());
        String defaultVirtualHostname = this._getDefaultVirtualHostname(company);
        int portalPort = this.getPortalServerPort(secureConnection);
        String portalURL = this.getPortalURL(company.getVirtualHostname(), portalPort, secureConnection);
        TreeMap<String, String> virtualHostnames = this.getVirtualHostnames(layoutSet);
        if (!virtualHostnames.isEmpty() && !virtualHostnames.containsKey(defaultVirtualHostname)) {
            int index = portalURL.indexOf("://");
            String portalDomain = portalURL.substring(index + 3);
            String virtualHostname = this.getCanonicalDomain(virtualHostnames, portalDomain, defaultVirtualHostname);
            if ((virtualHostname = this.getPortalURL(virtualHostname, portalPort, secureConnection)).contains(portalDomain)) {
                return virtualHostname.concat(this.getPathContext());
            }
        }
        StringBundler sb = new StringBundler(4);
        sb.append(portalURL);
        sb.append(this.getPathContext());
        Group group = layoutSet.getGroup();
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        sb.append(friendlyURL);
        sb.append(group.getFriendlyURL());
        return sb.toString();
    }

    public String getLayoutSetFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        String defaultVirtualHostname = this._getDefaultVirtualHostname(themeDisplay.getCompany());
        String virtualHostname = null;
        TreeMap<String, String> virtualHostnames = this.getVirtualHostnames(layoutSet);
        if (!virtualHostnames.isEmpty()) {
            virtualHostname = virtualHostnames.firstKey();
        }
        if (Validator.isNotNull(virtualHostname) && !StringUtil.equalsIgnoreCase((String)virtualHostname, (String)defaultVirtualHostname)) {
            String portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
            Layout curLayout = themeDisplay.getLayout();
            LayoutSet curLayoutSet = curLayout.getLayoutSet();
            long curLayoutSetId = curLayoutSet.getLayoutSetId();
            if (layoutSet.getLayoutSetId() != curLayoutSetId || portalURL.startsWith(themeDisplay.getURLPortal())) {
                String layoutSetFriendlyURL = portalURL + this._pathContext;
                if (themeDisplay.isI18n()) {
                    layoutSetFriendlyURL = layoutSetFriendlyURL + themeDisplay.getI18nPath();
                }
                return this.addPreservedParameters(themeDisplay, layoutSetFriendlyURL);
            }
        }
        Group group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        if (themeDisplay.isI18n()) {
            friendlyURL = themeDisplay.getI18nPath() + friendlyURL;
        }
        String layoutSetFriendlyURL = this._pathContext + friendlyURL + group.getFriendlyURL();
        return this.addPreservedParameters(themeDisplay, layoutSetFriendlyURL);
    }

    public String getLayoutTarget(Layout layout) {
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        String target = typeSettingsUnicodeProperties.getProperty("target");
        target = Validator.isNull((String)target) ? "" : "target=\"" + HtmlUtil.escapeAttribute((String)target) + "\"";
        return target;
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutURL(layout, themeDisplay, true);
    }

    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        if (layout == null) {
            return themeDisplay.getPathMain() + "/portal/layout";
        }
        if (layout.isTypeURL()) {
            String url = layout.getTypeSettingsProperty("url");
            if (Validator.isNotNull((String)url) && !url.startsWith("/") && !url.startsWith(this.getPortalURL(layout, themeDisplay))) {
                return url;
            }
            return this.addPreservedParameters(themeDisplay, layout, this.getLayoutActualURL(layout), doAsUser);
        }
        String layoutFriendlyURL = this.getLayoutFriendlyURL(layout, themeDisplay);
        if (Validator.isNotNull((String)layoutFriendlyURL)) {
            return this.addPreservedParameters(themeDisplay, layout, layoutFriendlyURL, doAsUser);
        }
        String layoutURL = this.getLayoutActualURL(layout);
        return this.addPreservedParameters(themeDisplay, layout, layoutURL, doAsUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutURL(layout, themeDisplay, true);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    public String getLayoutURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutURL(themeDisplay.getLayout(), themeDisplay);
    }

    public LiferayPortletRequest getLiferayPortletRequest(PortletRequest portletRequest) {
        if (portletRequest instanceof LiferayPortletRequest) {
            return (LiferayPortletRequest)portletRequest;
        }
        return LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
    }

    public LiferayPortletResponse getLiferayPortletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof LiferayPortletResponse) {
            return (LiferayPortletResponse)portletResponse;
        }
        return LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
    }

    public Locale getLocale(HttpServletRequest httpServletRequest) {
        Locale locale = (Locale)httpServletRequest.getAttribute("LOCALE");
        if (locale == _NULL_LOCALE) {
            return null;
        }
        if (locale == null) {
            locale = this.getLocale(httpServletRequest, null, false);
            if (locale == null) {
                httpServletRequest.setAttribute("LOCALE", (Object)_NULL_LOCALE);
            } else {
                httpServletRequest.setAttribute("LOCALE", (Object)locale);
            }
        }
        return locale;
    }

    public Locale getLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean initialize) {
        long groupId;
        block53: {
            User defaultUser;
            ThemeDisplay themeDisplay;
            block52: {
                Company company;
                block51: {
                    block50: {
                        Locale cookieLocale;
                        Locale userLocale;
                        Locale locale;
                        User user;
                        block49: {
                            String doAsUserLanguageId;
                            String i18nLanguageId;
                            block48: {
                                block47: {
                                    user = null;
                                    if (initialize) {
                                        try {
                                            user = this.initUser(httpServletRequest);
                                        }
                                        catch (NoSuchUserException noSuchUserException) {
                                            if (_log.isDebugEnabled()) {
                                                _log.debug((Throwable)noSuchUserException);
                                            }
                                            return null;
                                        }
                                        catch (Exception exception) {
                                            if (!_log.isDebugEnabled()) break block47;
                                            _log.debug((Throwable)exception);
                                        }
                                    }
                                }
                                locale = null;
                                themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                                if (themeDisplay != null) {
                                    locale = themeDisplay.getLocale();
                                    if (LanguageUtil.isAvailableLocale((long)themeDisplay.getSiteGroupId(), (Locale)locale)) {
                                        return locale;
                                    }
                                }
                                groupId = 0L;
                                Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
                                if (layout != null && !layout.isTypeControlPanel()) {
                                    try {
                                        groupId = this.getSiteGroupId(this.getScopeGroupId(httpServletRequest));
                                    }
                                    catch (Exception exception) {
                                        if (!_log.isDebugEnabled()) break block48;
                                        _log.debug((Throwable)exception);
                                    }
                                }
                            }
                            if (Validator.isNotNull((String)(i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID")))) {
                                locale = LocaleUtil.fromLanguageId((String)i18nLanguageId, (boolean)true, (boolean)false);
                                if (LanguageUtil.isAvailableLocale((long)groupId, (Locale)locale)) {
                                    return locale;
                                }
                                if (groupId > 0L) {
                                    String i18nLanguageCode;
                                    boolean inheritLocales = true;
                                    try {
                                        inheritLocales = LanguageUtil.isInheritLocales((long)groupId);
                                    }
                                    catch (PortalException portalException) {
                                        _log.error((Object)("Unable to check if group " + groupId + " inherits locales"), (Throwable)portalException);
                                    }
                                    if (!inheritLocales && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = LanguageUtil.getLocale((long)groupId, (String)(i18nLanguageCode = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_CODE")))))) {
                                        return locale;
                                    }
                                }
                            }
                            if (Validator.isNotNull((String)(doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserLanguageId"))) && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = LocaleUtil.fromLanguageId((String)doAsUserLanguageId)))) {
                                return locale;
                            }
                            HttpSession httpSession = httpServletRequest.getSession(false);
                            if (httpSession != null && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = (Locale)httpSession.getAttribute("LOCALE")))) {
                                return locale;
                            }
                            if (user == null) {
                                try {
                                    user = this.getUser(httpServletRequest);
                                }
                                catch (Exception exception) {
                                    if (!_log.isDebugEnabled()) break block49;
                                    _log.debug((Throwable)exception);
                                }
                            }
                        }
                        if (user != null && !user.isDefaultUser() && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(userLocale = this.getAvailableLocale(groupId, user.getLocale())))) {
                            if (initialize) {
                                this.setLocale(httpServletRequest, httpServletResponse, userLocale);
                            }
                            return userLocale;
                        }
                        String languageId = CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)"GUEST_LANGUAGE_ID", (boolean)false);
                        if (Validator.isNotNull((String)languageId) && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(cookieLocale = this.getAvailableLocale(groupId, LocaleUtil.fromLanguageId((String)languageId))))) {
                            if (initialize) {
                                this.setLocale(httpServletRequest, httpServletResponse, cookieLocale);
                            }
                            return cookieLocale;
                        }
                        if (PropsValues.LOCALE_DEFAULT_REQUEST) {
                            Enumeration enumeration = httpServletRequest.getLocales();
                            while (enumeration.hasMoreElements()) {
                                Locale requestLocale = this.getAvailableLocale(groupId, (Locale)enumeration.nextElement());
                                if (!LanguageUtil.isAvailableLocale((long)groupId, (Locale)requestLocale)) continue;
                                if (initialize) {
                                    this.setLocale(httpServletRequest, httpServletResponse, requestLocale);
                                }
                                return requestLocale;
                            }
                        }
                        if (groupId > 0L) {
                            try {
                                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                                UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
                                String defaultLanguageId = typeSettingsUnicodeProperties.getProperty("languageId");
                                if (Validator.isNotNull((String)defaultLanguageId) && LanguageUtil.isAvailableLocale((long)groupId, (Locale)(locale = LocaleUtil.fromLanguageId((String)defaultLanguageId)))) {
                                    if (initialize) {
                                        this.setLocale(httpServletRequest, httpServletResponse, locale);
                                    }
                                    return locale;
                                }
                            }
                            catch (Exception exception) {
                                if (!_log.isDebugEnabled()) break block50;
                                _log.debug((Throwable)exception);
                            }
                        }
                    }
                    company = null;
                    try {
                        company = this.getCompany(httpServletRequest);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block51;
                        _log.debug((Throwable)exception);
                    }
                }
                if (company == null) {
                    return null;
                }
                defaultUser = null;
                try {
                    defaultUser = company.getDefaultUser();
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block52;
                    _log.debug((Throwable)exception);
                }
            }
            if (defaultUser == null) {
                return null;
            }
            Locale defaultUserLocale = this.getAvailableLocale(groupId, defaultUser.getLocale());
            if (LanguageUtil.isAvailableLocale((long)groupId, (Locale)defaultUserLocale)) {
                if (initialize) {
                    this.setLocale(httpServletRequest, httpServletResponse, defaultUserLocale);
                }
                return defaultUserLocale;
            }
            try {
                if (themeDisplay != null) {
                    return themeDisplay.getSiteDefaultLocale();
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block53;
                _log.debug((Throwable)exception);
            }
        }
        try {
            return this.getSiteDefaultLocale(groupId);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return LocaleUtil.getDefault();
        }
    }

    public Locale getLocale(PortletRequest portletRequest) {
        return this.getLocale(this.getHttpServletRequest(portletRequest));
    }

    public String getLocalizedFriendlyURL(HttpServletRequest httpServletRequest, Layout layout, Locale locale, Locale originalLocale) {
        String contextPath;
        String requestURI = httpServletRequest.getRequestURI();
        HttpServletRequest originalHttpServletRequest = this.getOriginalServletRequest(httpServletRequest);
        StringBuffer originRequestURL = originalHttpServletRequest.getRequestURL();
        if (originRequestURL.indexOf(_PUBLIC_GROUP_SERVLET_MAPPING) < 0) {
            requestURI = originalHttpServletRequest.getRequestURI();
        }
        if (Validator.isNotNull((String)(contextPath = this.getPathContext())) && requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace((String)requestURI, (String)"//", (String)"/");
        String layoutFriendlyURL = null;
        if (originalLocale == null) {
            int y;
            String path = httpServletRequest.getPathInfo();
            int x = path.indexOf(47, 1);
            if (x != -1 && x + 1 != path.length()) {
                layoutFriendlyURL = path.substring(x);
            }
            if ((y = layoutFriendlyURL.indexOf("/~")) != -1 && (y = layoutFriendlyURL.indexOf(47, 3)) != -1 && y + 1 != layoutFriendlyURL.length()) {
                layoutFriendlyURL = layoutFriendlyURL.substring(y);
            }
            if ((y = layoutFriendlyURL.indexOf("/-/")) != -1) {
                layoutFriendlyURL = layoutFriendlyURL.substring(0, y);
            }
        } else {
            layoutFriendlyURL = layout.getFriendlyURL(originalLocale);
        }
        if (requestURI.contains(layoutFriendlyURL)) {
            requestURI = StringUtil.replaceFirst((String)requestURI, (String)layoutFriendlyURL, (String)layout.getFriendlyURL(locale));
        }
        boolean appendI18nPath = true;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && locale.equals(LocaleUtil.getDefault())) {
            appendI18nPath = false;
        }
        String localizedFriendlyURL = contextPath;
        if (appendI18nPath) {
            String i18nPathLanguageId = this.getI18nPathLanguageId(locale, LocaleUtil.toLanguageId((Locale)locale));
            String i18nPath = "/" + i18nPathLanguageId;
            if (!requestURI.contains(i18nPath)) {
                localizedFriendlyURL = localizedFriendlyURL + i18nPath;
            }
        }
        localizedFriendlyURL = localizedFriendlyURL + requestURI;
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNull((String)queryString)) {
            queryString = (String)httpServletRequest.getAttribute("javax.servlet.forward.query_string");
        }
        if (Validator.isNotNull((String)queryString)) {
            localizedFriendlyURL = localizedFriendlyURL + "?" + queryString;
        }
        return localizedFriendlyURL;
    }

    public String getMailId(String mx, String popPortletPrefix, Object ... ids) {
        StringBundler sb = new StringBundler(ids.length * 2 + 7);
        sb.append("<");
        sb.append(popPortletPrefix);
        if (!popPortletPrefix.endsWith(".")) {
            sb.append(".");
        }
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            if (i != 0) {
                sb.append(".");
            }
            sb.append(id);
        }
        sb.append("@");
        if (Validator.isNotNull((String)PropsValues.POP_SERVER_SUBDOMAIN)) {
            sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
            sb.append(".");
        }
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    public String getNetvibesURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.NETVIBES_SERVLET_MAPPING, themeDisplay);
    }

    public String getNewPortletTitle(String portletTitle, String oldScopeName, String newScopeName) {
        if (portletTitle.endsWith(" (" + oldScopeName + ")")) {
            int pos = portletTitle.lastIndexOf(" (" + oldScopeName + ")");
            portletTitle = portletTitle.substring(0, pos);
        }
        if (Validator.isNull((String)newScopeName)) {
            return portletTitle;
        }
        return StringUtil.appendParentheticalSuffix((String)portletTitle, (String)newScopeName);
    }

    public HttpServletRequest getOriginalServletRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest currentHttpServletRequest = httpServletRequest;
        PersistentHttpServletRequestWrapper currentRequestWrapper = null;
        PersistentHttpServletRequestWrapper originalHttpServletRequest = null;
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper) {
            if (currentHttpServletRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentHttpServletRequest;
                persistentHttpServletRequestWrapper = persistentHttpServletRequestWrapper.clone();
                if (originalHttpServletRequest == null) {
                    originalHttpServletRequest = persistentHttpServletRequestWrapper;
                }
                if (currentRequestWrapper != null) {
                    currentRequestWrapper.setRequest((ServletRequest)persistentHttpServletRequestWrapper);
                }
                currentRequestWrapper = persistentHttpServletRequestWrapper;
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (currentRequestWrapper != null) {
            currentRequestWrapper.setRequest((ServletRequest)currentHttpServletRequest);
        }
        if (originalHttpServletRequest != null) {
            return originalHttpServletRequest;
        }
        return currentHttpServletRequest;
    }

    public String getPathContext() {
        return this._pathContext;
    }

    public String getPathContext(HttpServletRequest httpServletRequest) {
        return this.getPathContext(httpServletRequest.getContextPath());
    }

    public String getPathContext(PortletRequest portletRequest) {
        return this.getPathContext(portletRequest.getContextPath());
    }

    public String getPathContext(String contextPath) {
        return this._pathProxy.concat(this.getContextPath(contextPath));
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathImage() {
        return this._pathImage;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public String getPathModule() {
        return this._pathModule;
    }

    public String getPathProxy() {
        return this._pathProxy;
    }

    public long getPlidFromFriendlyURL(long companyId, String friendlyURL) {
        Group group;
        boolean privateLayout;
        String[] urlParts;
        block16: {
            if (Validator.isNull((String)friendlyURL) || friendlyURL.equals("/")) {
                return 0L;
            }
            urlParts = friendlyURL.split("\\/", 4);
            if (friendlyURL.charAt(0) != '/' && urlParts.length != 4) {
                return 0L;
            }
            privateLayout = true;
            String urlPrefix = "/" + urlParts[1];
            if (_PUBLIC_GROUP_SERVLET_MAPPING.equals(urlPrefix)) {
                privateLayout = false;
            } else if (_PRIVATE_GROUP_SERVLET_MAPPING.equals(urlPrefix) || _PRIVATE_USER_SERVLET_MAPPING.equals(urlPrefix)) {
                privateLayout = true;
            } else {
                return 0L;
            }
            group = null;
            try {
                group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)("/" + urlParts[2]));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block16;
                _log.debug((Throwable)exception);
            }
        }
        if (group == null) {
            return 0L;
        }
        Layout layout = null;
        try {
            if (urlParts.length == 4) {
                String layoutFriendlyURL = "/" + urlParts[3];
                layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)group.getGroupId(), (boolean)privateLayout, (String)layoutFriendlyURL);
            } else {
                List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)privateLayout, (long)0L, (boolean)true, (int)0, (int)1);
                if (!layouts.isEmpty()) {
                    layout = (Layout)layouts.get(0);
                } else {
                    return 0L;
                }
            }
            return layout.getPlid();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return 0L;
        }
    }

    public long getPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        String key = StringBundler.concat((Object[])new Object[]{groupId, " ", privateLayout, " ", portletId});
        Long plidObj = this._plidToPortletIdMap.get(key);
        if (plidObj == null) {
            long plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
            if (plid != 0L) {
                this._plidToPortletIdMap.put(key, plid);
            }
            return plid;
        }
        long plid = plidObj;
        boolean validPlid = false;
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        if (layout != null && this._layoutContainsPortletId(layout, portletId)) {
            validPlid = true;
        }
        if (!validPlid) {
            this._plidToPortletIdMap.remove(key);
            plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
            if (plid != 0L) {
                this._plidToPortletIdMap.put(key, plid);
            }
        }
        return plid;
    }

    public long getPlidFromPortletId(long groupId, String portletId) {
        long plid = this.getPlidFromPortletId(groupId, false, portletId);
        if (plid == 0L) {
            plid = this.getPlidFromPortletId(groupId, true, portletId);
        }
        if (plid == 0L && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Portlet ", portletId, " does not exist on a page in group ", groupId}));
        }
        return plid;
    }

    public PortalInetSocketAddressEventListener[] getPortalInetSocketAddressEventListeners() {
        return this._portalInetSocketAddressEventListeners.toArray(new PortalInetSocketAddressEventListener[0]);
    }

    public InetAddress getPortalLocalInetAddress(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalLocalInetSocketAddress.get() : this._portalLocalInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    public int getPortalLocalPort(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalLocalInetSocketAddress.get() : this._portalLocalInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    public Properties getPortalProperties() {
        return PropsUtil.getProperties();
    }

    public InetAddress getPortalServerInetAddress(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalServerInetSocketAddress.get() : this._portalServerInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    public int getPortalServerPort(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalServerInetSocketAddress.get() : this._portalServerInetSocketAddress.get();
        if (inetSocketAddress == null) {
            if (secure) {
                return PropsValues.WEB_SERVER_HTTPS_PORT;
            }
            return PropsValues.WEB_SERVER_HTTP_PORT;
        }
        return inetSocketAddress.getPort();
    }

    public String getPortalURL(HttpServletRequest httpServletRequest) {
        return this.getPortalURL(httpServletRequest, this.isSecure(httpServletRequest));
    }

    public String getPortalURL(HttpServletRequest httpServletRequest, boolean secure) {
        int serverPort = this.getForwardedPort(httpServletRequest);
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(this.getForwardedHost(httpServletRequest), serverPort, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, serverPort, secure);
    }

    public String getPortalURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        if (layout != null) {
            Layout virtualHostLayout = layout;
            long refererPlid = themeDisplay.getRefererPlid();
            if (refererPlid > 0L) {
                virtualHostLayout = LayoutLocalServiceUtil.getLayout((long)refererPlid);
            }
            return this.getPortalURL(virtualHostLayout.getLayoutSet(), themeDisplay);
        }
        return this.getPortalURL(themeDisplay.getServerName(), themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    public String getPortalURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) {
        String domain;
        String serverName = themeDisplay.getServerName();
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (!virtualHostnames.isEmpty() && this._containsHostname(virtualHostnames, domain = themeDisplay.getPortalDomain())) {
            serverName = domain;
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    public String getPortalURL(PortletRequest portletRequest) {
        return this.getPortalURL(this.getHttpServletRequest(portletRequest));
    }

    public String getPortalURL(PortletRequest portletRequest, boolean secure) {
        return this.getPortalURL(this.getHttpServletRequest(portletRequest), secure);
    }

    public String getPortalURL(String serverName, int serverPort, boolean secure) {
        if (Validator.isNull((String)PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(serverName, serverPort, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, serverPort, secure);
    }

    public String getPortalURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getPortalURL((Layout)null, themeDisplay);
    }

    public PortletConfig getPortletConfig(long companyId, String portletId, ServletContext servletContext) throws PortletException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        return invokerPortlet.getPortletConfig();
    }

    public String getPortletDescription(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletDescription = LanguageUtil.get((ResourceBundle)resourceBundle, (String)StringBundler.concat((String[])new String[]{"javax.portlet.description", ".", portlet.getRootPortletId()}), null);
        if (Validator.isNull((String)portletDescription)) {
            portletDescription = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.description");
        }
        return portletDescription;
    }

    public String getPortletDescription(Portlet portlet, User user) {
        return this.getPortletDescription(portlet.getPortletId(), user);
    }

    public String getPortletDescription(String portletId, Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)StringBundler.concat((String[])new String[]{"javax.portlet.description", ".", portletId}));
    }

    public String getPortletDescription(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletDescription(portletId, locale);
    }

    public String getPortletDescription(String portletId, User user) {
        return LanguageUtil.get((Locale)user.getLocale(), (String)StringBundler.concat((String[])new String[]{"javax.portlet.description", ".", portletId}));
    }

    public LayoutQueryStringComposite getPortletFriendlyURLMapperLayoutQueryStringComposite(long groupId, boolean privateLayout, String url, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutQueryStringComposite layoutQueryStringComposite = this._getPortletFriendlyURLMapperLayoutQueryStringComposite(url, params, requestContext);
        Layout layout = null;
        if (Validator.isNotNull((String)layoutQueryStringComposite.getFriendlyURL())) {
            layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)privateLayout, (String)layoutQueryStringComposite.getFriendlyURL());
            if (Validator.isNotNull((String)layout.getSourcePrototypeLayoutUuid())) {
                layout = LayoutLocalServiceUtil.getLayout((long)layout.getPlid());
            }
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)LayoutLocalServiceUtil.getDefaultPlid((long)groupId, (boolean)privateLayout));
        }
        layoutQueryStringComposite.setLayout(layout);
        return layoutQueryStringComposite;
    }

    public LayoutQueryStringComposite getPortletFriendlyURLMapperLayoutQueryStringComposite(String url, Map<String, String[]> params, Map<String, Object> requestContext) {
        return this._getPortletFriendlyURLMapperLayoutQueryStringComposite(url, params, requestContext);
    }

    public String getPortletId(HttpServletRequest httpServletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    public String getPortletId(PortletRequest portletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletRequest.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    public String getPortletLongTitle(Portlet portlet, Locale locale) {
        return this.getPortletLongTitle(portlet.getPortletId(), locale);
    }

    public String getPortletLongTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        try {
            String portletLongTitle = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.long-title");
            if (portletLongTitle.startsWith("javax.portlet.long-title")) {
                portletLongTitle = this.getPortletTitle(portlet, servletContext, locale);
            }
            return portletLongTitle;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return this.getPortletTitle(portlet, servletContext, locale);
        }
    }

    public String getPortletLongTitle(Portlet portlet, String languageId) {
        return this.getPortletLongTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletLongTitle(Portlet portlet, User user) {
        return this.getPortletLongTitle(portlet.getPortletId(), user);
    }

    public String getPortletLongTitle(String portletId, Locale locale) {
        String portletLongTitle = LanguageUtil.get((Locale)locale, (String)StringBundler.concat((String[])new String[]{"javax.portlet.long-title", ".", portletId}), (String)"");
        if (Validator.isNull((String)portletLongTitle)) {
            portletLongTitle = this.getPortletTitle(portletId, locale);
        }
        return portletLongTitle;
    }

    public String getPortletLongTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletLongTitle(portletId, locale);
    }

    public String getPortletLongTitle(String portletId, User user) {
        return this.getPortletLongTitle(portletId, user.getLocale());
    }

    public String getPortletNamespace(String portletId) {
        return StringBundler.concat((String[])new String[]{"_", portletId, "_"});
    }

    public String getPortletTitle(Portlet portlet, Locale locale) {
        return this.getPortletTitle(portlet.getPortletId(), locale);
    }

    public String getPortletTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        return this._getPortletTitle(portlet.getRootPortletId(), portletConfig, locale);
    }

    public String getPortletTitle(Portlet portlet, String languageId) {
        return this.getPortletTitle(portlet.getPortletId(), languageId);
    }

    public String getPortletTitle(Portlet portlet, User user) {
        return this.getPortletTitle(portlet.getPortletId(), user);
    }

    public String getPortletTitle(PortletRequest portletRequest) {
        String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
        PortletConfig portletConfig = PortletConfigFactoryUtil.get((String)portletId);
        Locale locale = portletRequest.getLocale();
        String portletTitle = null;
        if (portletConfig == null) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(portletRequest), (String)portletId);
            HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
            ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
            portletTitle = this.getPortletTitle(portlet, servletContext, locale);
        } else {
            portletTitle = this._getPortletTitle(PortletIdCodec.decodePortletName((String)portletId), portletConfig, locale);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long portletScopeGroupId = this._getScopeGroupId(themeDisplay, layout, portletId);
        if (portletScopeGroupId != layout.getGroupId()) {
            Group portletScopeGroup = GroupLocalServiceUtil.fetchGroup((long)portletScopeGroupId);
            String portletScopeName = portletScopeGroup.getName(locale);
            try {
                portletScopeName = portletScopeGroup.getDescriptiveName(locale);
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable to get descriptive name", (Throwable)portalException);
            }
            return this.getNewPortletTitle(portletTitle, "", portletScopeName);
        }
        return portletTitle;
    }

    public String getPortletTitle(PortletResponse portletResponse) {
        LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
        if (liferayPortletResponse instanceof LiferayRenderResponse) {
            LiferayRenderResponse liferayRenderResponse = (LiferayRenderResponse)liferayPortletResponse;
            return liferayRenderResponse.getTitle();
        }
        return null;
    }

    public String getPortletTitle(String portletId, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.get((String)portletId);
        if (portletConfig == null) {
            return PortletIdCodec.decodePortletName((String)portletId);
        }
        return this.getPortletTitle(portletId, portletConfig.getResourceBundle(locale));
    }

    public String getPortletTitle(String portletId, ResourceBundle resourceBundle) {
        portletId = PortletIdCodec.decodePortletName((String)portletId);
        String portletTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)StringBundler.concat((String[])new String[]{"javax.portlet.title", ".", portletId}), null);
        if (Validator.isNull((String)portletTitle)) {
            portletTitle = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"javax.portlet.title");
        }
        return portletTitle;
    }

    public String getPortletTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        return this.getPortletTitle(portletId, locale);
    }

    public String getPortletTitle(String portletId, User user) {
        return LanguageUtil.get((Locale)user.getLocale(), (String)StringBundler.concat((String[])new String[]{"javax.portlet.title", ".", portletId}));
    }

    public String getPortletXmlFileName() {
        if (PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML) {
            return "portlet-custom.xml";
        }
        return "portlet.xml";
    }

    public javax.portlet.PortletPreferences getPreferences(HttpServletRequest httpServletRequest) {
        RenderRequest renderRequest = (RenderRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (renderRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)renderRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        PortletBag portletBag = PortletBagPool.get((String)portlet.getRootPortletId());
        if (portletBag == null) {
            return null;
        }
        List preferencesValidatorInstances = portletBag.getPreferencesValidatorInstances();
        if (preferencesValidatorInstances.isEmpty()) {
            return null;
        }
        return (PreferencesValidator)preferencesValidatorInstances.get(0);
    }

    public String getRelativeHomeURL(HttpServletRequest httpServletRequest) throws PortalException {
        Company company = this.getCompany(httpServletRequest);
        String homeURL = company.getHomeURL();
        if (Validator.isNull((String)homeURL)) {
            homeURL = PropsValues.COMPANY_DEFAULT_HOME_URL;
        }
        return homeURL;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle(locale);
    }

    public long getScopeGroupId(HttpServletRequest httpServletRequest) throws PortalException {
        return this.getScopeGroupId(httpServletRequest, this.getPortletId(httpServletRequest));
    }

    public long getScopeGroupId(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        return this.getScopeGroupId(httpServletRequest, portletId, false);
    }

    public long getScopeGroupId(HttpServletRequest httpServletRequest, String portletId, boolean checkStagingGroup) throws PortalException {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = 0L;
        if (layout != null) {
            Group layoutGroup;
            Group group = layout.getGroup();
            long doAsGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"doAsGroupId");
            if (doAsGroupId <= 0L) {
                HttpServletRequest originalHttpServletRequest = this.getOriginalServletRequest(httpServletRequest);
                doAsGroupId = ParamUtil.getLong((HttpServletRequest)originalHttpServletRequest, (String)"doAsGroupId");
            }
            Group doAsGroup = null;
            if (doAsGroupId > 0L) {
                doAsGroup = GroupLocalServiceUtil.fetchGroup((long)doAsGroupId);
            }
            if (group.isControlPanel()) {
                if (doAsGroupId > 0L) {
                    scopeGroupId = doAsGroupId;
                }
                if ((group = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId)) != null && group.hasStagingGroup()) {
                    try {
                        Group stagingGroup = StagingUtil.getPermissionStagingGroup((Group)group);
                        scopeGroupId = stagingGroup.getGroupId();
                    }
                    catch (Exception exception) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)exception);
                        }
                    }
                }
            } else if (doAsGroup != null) {
                scopeGroupId = doAsGroupId;
            }
            if (group != null && group.isInheritContent() && !(layoutGroup = layout.getGroup()).isControlPanel()) {
                scopeGroupId = group.getParentGroupId();
            }
            if (portletId != null && group != null && (group.isStaged() || group.isStagingGroup())) {
                Group liveGroup = group;
                if (group.isStagingGroup()) {
                    liveGroup = group.getLiveGroup();
                }
                if (liveGroup.isStaged() && !liveGroup.isStagedPortlet(portletId)) {
                    Layout liveGroupLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layout.getUuid(), (long)liveGroup.getGroupId(), (boolean)layout.isPrivateLayout());
                    if (liveGroupLayout != null && liveGroupLayout.hasScopeGroup()) {
                        scopeGroupId = this._getScopeGroupId(themeDisplay, liveGroupLayout, portletId);
                    } else if (checkStagingGroup && !liveGroup.isStagedRemotely()) {
                        Group stagingGroup = liveGroup.getStagingGroup();
                        scopeGroupId = stagingGroup.getGroupId();
                    } else {
                        scopeGroupId = liveGroup.getGroupId();
                    }
                }
            }
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = this._getScopeGroupId(themeDisplay, layout, portletId);
        }
        return scopeGroupId;
    }

    public long getScopeGroupId(Layout layout) {
        if (layout == null) {
            return 0L;
        }
        return layout.getGroupId();
    }

    public long getScopeGroupId(Layout layout, String portletId) {
        return this._getScopeGroupId(null, layout, portletId);
    }

    public long getScopeGroupId(long plid) {
        Layout layout;
        block2: {
            layout = null;
            try {
                layout = LayoutLocalServiceUtil.getLayout((long)plid);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        return this.getScopeGroupId(layout);
    }

    public long getScopeGroupId(PortletRequest portletRequest) throws PortalException {
        return this.getScopeGroupId(this.getHttpServletRequest(portletRequest));
    }

    public User getSelectedUser(HttpServletRequest httpServletRequest) throws PortalException {
        return this.getSelectedUser(httpServletRequest, true);
    }

    public User getSelectedUser(HttpServletRequest httpServletRequest, boolean checkPermission) throws PortalException {
        User user;
        block2: {
            long userId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_u_i_d");
            user = null;
            try {
                user = checkPermission ? UserServiceUtil.getUserById((long)userId) : UserLocalServiceUtil.getUserById((long)userId);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)noSuchUserException);
            }
        }
        return user;
    }

    public User getSelectedUser(PortletRequest portletRequest) throws PortalException {
        return this.getSelectedUser(portletRequest, true);
    }

    public User getSelectedUser(PortletRequest portletRequest, boolean checkPermission) throws PortalException {
        return this.getSelectedUser(this.getHttpServletRequest(portletRequest), checkPermission);
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public long[] getSharedContentSiteGroupIds(long companyId, long groupId, long userId) throws PortalException {
        int sitesContentSharingWithChildrenEnabled;
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Group siteGroup = this.getCurrentSiteGroup(groupId);
        if (siteGroup != null) {
            groups.add(siteGroup);
            groups.addAll(siteGroup.getDescendants(true));
            groups.addAll(GroupLocalServiceUtil.getGroups((long)siteGroup.getCompanyId(), (String)Layout.class.getName(), (long)siteGroup.getGroupId()));
        }
        if (PrefsPropsUtil.getBoolean(companyId, "sites.content.sharing.through.administrators.enabled")) {
            groups.addAll(GroupLocalServiceUtil.getUserSitesGroups((long)userId));
        }
        if ((sitesContentSharingWithChildrenEnabled = PrefsPropsUtil.getInteger(companyId, "sites.content.sharing.with.children.enabled")) != 0) {
            groups.addAll(this.getAncestorSiteGroups(groupId, true));
        }
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (StagingUtil.isGroupAccessible((Group)group, (Group)siteGroup)) continue;
            iterator.remove();
        }
        long[] groupIds = new long[groups.size()];
        int i = 0;
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    public String getSiteAdminURL(String portalURL, Group group, String ppid, Map<String, String[]> params) throws PortalException {
        StringBundler sb = new StringBundler(7);
        sb.append(portalURL);
        sb.append(this.getPathFriendlyURLPrivateGroup());
        if (group != null && !group.isControlPanel()) {
            sb.append(group.getFriendlyURL());
            sb.append("/~");
        }
        sb.append("/control_panel");
        sb.append(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        params = params != null ? new LinkedHashMap<String, String[]>(params) : new LinkedHashMap<String, String[]>();
        if (Validator.isNotNull((String)ppid)) {
            params.put("p_p_id", new String[]{ppid});
        }
        params.put("p_p_lifecycle", new String[]{"0"});
        params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        sb.append(HttpComponentsUtil.parameterMapToString(params, (boolean)true));
        return sb.toString();
    }

    public String getSiteAdminURL(ThemeDisplay themeDisplay, String ppid, Map<String, String[]> params) throws PortalException {
        return this.getSiteAdminURL(themeDisplay.getPortalURL(), themeDisplay.getScopeGroup(), ppid, params);
    }

    public Locale getSiteDefaultLocale(Group group) throws PortalException {
        if (group == null) {
            return LocaleUtil.getDefault();
        }
        Group liveGroup = group;
        if (group.isStagingGroup()) {
            liveGroup = group.getLiveGroup();
        }
        if (LanguageUtil.isInheritLocales((long)liveGroup.getGroupId())) {
            Company company = CompanyLocalServiceUtil.getCompany((long)liveGroup.getCompanyId());
            return company.getLocale();
        }
        UnicodeProperties typeSettingsUnicodeProperties = liveGroup.getTypeSettingsProperties();
        User defaultUser = UserLocalServiceUtil.getDefaultUser((long)group.getCompanyId());
        String languageId = GetterUtil.getString((String)typeSettingsUnicodeProperties.getProperty("languageId"), (String)defaultUser.getLanguageId());
        return LocaleUtil.fromLanguageId((String)languageId);
    }

    public Locale getSiteDefaultLocale(long groupId) throws PortalException {
        if (groupId <= 0L) {
            return LocaleUtil.getDefault();
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        return this.getSiteDefaultLocale(group);
    }

    public long getSiteGroupId(long groupId) {
        Group group = this._getSiteGroup(groupId);
        if (group == null) {
            return 0L;
        }
        return group.getGroupId();
    }

    public String getSiteLoginURL(ThemeDisplay themeDisplay) throws PortalException {
        if (Validator.isNull((String)PropsValues.AUTH_LOGIN_SITE_URL)) {
            return null;
        }
        List layouts = themeDisplay.getUnfilteredLayouts();
        if (layouts == null) {
            return null;
        }
        for (Layout layout : layouts) {
            String friendlyURL = themeDisplay.getLayoutFriendlyURL(layout);
            if (!friendlyURL.equals(PropsValues.AUTH_LOGIN_SITE_URL)) continue;
            if (themeDisplay.getLayout() == null) break;
            String layoutSetFriendlyURL = this.getLayoutSetFriendlyURL(layout.getLayoutSet(), themeDisplay);
            return layoutSetFriendlyURL + PropsValues.AUTH_LOGIN_SITE_URL;
        }
        return null;
    }

    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri) {
        return this.getStaticResourceURL(httpServletRequest, uri, null, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri, long timestamp) {
        return this.getStaticResourceURL(httpServletRequest, uri, null, timestamp);
    }

    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri, String queryString) {
        return this.getStaticResourceURL(httpServletRequest, uri, queryString, 0L);
    }

    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri, String queryString, long timestamp) {
        if (uri.indexOf(63) != -1) {
            return uri;
        }
        if (uri.startsWith("//")) {
            uri = uri.substring(1);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        Map parameterMap = null;
        if (Validator.isNotNull((String)queryString)) {
            parameterMap = HttpComponentsUtil.getParameterMap((String)queryString);
        }
        StringBundler sb = new StringBundler(15);
        sb.append(uri);
        boolean firstParam = true;
        if (parameterMap == null || !parameterMap.containsKey("browserId")) {
            sb.append("?browserId=");
            sb.append(BrowserSnifferUtil.getBrowserId((HttpServletRequest)httpServletRequest));
            firstParam = false;
        }
        if (!(!uri.endsWith(".css") && !uri.endsWith(".jsp") || parameterMap != null && parameterMap.containsKey("themeId"))) {
            if (firstParam) {
                sb.append("?themeId=");
                firstParam = false;
            } else {
                sb.append("&themeId=");
            }
            sb.append(URLCodec.encodeURL((String)theme.getThemeId()));
        }
        if (uri.endsWith(".jsp") && (parameterMap == null || !parameterMap.containsKey("colorSchemeId"))) {
            if (firstParam) {
                sb.append("?colorSchemeId=");
                firstParam = false;
            } else {
                sb.append("&colorSchemeId=");
            }
            ColorScheme colorScheme = themeDisplay.getColorScheme();
            sb.append(URLCodec.encodeURL((String)colorScheme.getColorSchemeId()));
        }
        if (parameterMap == null || !parameterMap.containsKey("minifierType")) {
            String minifierType = "";
            if (uri.endsWith(".css") || uri.endsWith("css.jsp") || uri.endsWith(".jsp") && uri.contains("/css/")) {
                if (themeDisplay.isThemeCssFastLoad()) {
                    minifierType = "css";
                }
            } else if (themeDisplay.isThemeJsFastLoad()) {
                minifierType = "js";
            }
            if (Validator.isNotNull((String)minifierType)) {
                if (firstParam) {
                    sb.append("?minifierType=");
                    firstParam = false;
                } else {
                    sb.append("&minifierType=");
                }
                sb.append(minifierType);
            }
        }
        if (Validator.isNotNull((String)queryString)) {
            if (queryString.charAt(0) == '&') {
                if (firstParam) {
                    sb.append("?");
                    sb.append(queryString.substring(1));
                } else {
                    sb.append(queryString);
                }
            } else if (firstParam) {
                sb.append("?");
                sb.append(queryString);
            } else {
                sb.append("&");
                sb.append(queryString);
            }
            firstParam = false;
        }
        if (firstParam) {
            sb.append("?languageId=");
        } else {
            sb.append("&languageId=");
        }
        sb.append(themeDisplay.getLanguageId());
        if (!(parameterMap != null && parameterMap.containsKey("t") || timestamp < 0L)) {
            if (timestamp == 0L) {
                String portalURL = this.getPortalURL(httpServletRequest);
                String path = uri;
                if (uri.startsWith(portalURL)) {
                    path = uri.substring(portalURL.length());
                }
                if (path.startsWith("/html")) {
                    ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
                    timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext, (String)path, (boolean)true);
                } else {
                    timestamp = PortalWebResourcesUtil.getPathLastModified((String)path, (long)theme.getTimestamp());
                }
            }
            sb.append("&t=");
            sb.append(timestamp);
        }
        return sb.toString();
    }

    public String getStrutsAction(HttpServletRequest httpServletRequest) {
        String strutsAction = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"struts_action");
        if (Validator.isNotNull((String)strutsAction)) {
            return "";
        }
        return this.getPortletParam(httpServletRequest, "struts_action");
    }

    public String[] getSystemGroups() {
        return this._allSystemGroups;
    }

    public String[] getSystemOrganizationRoles() {
        return this._allSystemOrganizationRoles;
    }

    public String[] getSystemRoles() {
        return this._allSystemRoles;
    }

    public String[] getSystemSiteRoles() {
        return this._allSystemSiteRoles;
    }

    public String getUniqueElementId(HttpServletRequest httpServletRequest, String namespace, String elementId) {
        String uniqueElementId = elementId;
        Set uniqueElementIds = (Set)httpServletRequest.getAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS");
        if (uniqueElementIds == null) {
            uniqueElementIds = Collections.newSetFromMap(new ConcurrentHashMap());
            httpServletRequest.setAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS", uniqueElementIds);
        } else {
            int i = 1;
            while (uniqueElementIds.contains(namespace.concat(uniqueElementId))) {
                uniqueElementId = Validator.isNull((String)elementId) || elementId.endsWith("_") ? elementId.concat(String.valueOf(i)) : StringBundler.concat((Object[])new Object[]{elementId, "_", i});
                ++i;
            }
        }
        uniqueElementIds.add(namespace.concat(uniqueElementId));
        return uniqueElementId;
    }

    public String getUniqueElementId(PortletRequest request, String namespace, String elementId) {
        return this.getUniqueElementId(this.getHttpServletRequest(request), namespace, elementId);
    }

    public UploadPortletRequest getUploadPortletRequest(PortletRequest portletRequest) {
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        DynamicServletRequest dynamicRequest = (DynamicServletRequest)liferayPortletRequest.getHttpServletRequest();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)dynamicRequest.getRequest();
        return new UploadPortletRequestImpl(this.getUploadServletRequest((HttpServletRequest)requestWrapper), (PortletRequest)liferayPortletRequest, this.getPortletNamespace(liferayPortletRequest.getPortletName()));
    }

    public UploadServletRequest getUploadServletRequest(HttpServletRequest httpServletRequest) {
        return this.getUploadServletRequest(httpServletRequest, 0, null, 0L, 0L);
    }

    public UploadServletRequest getUploadServletRequest(HttpServletRequest httpServletRequest, int fileSizeThreshold, String location, long maxRequestSize, long maxFileSize) {
        ArrayList<PersistentHttpServletRequestWrapper> persistentHttpServletRequestWrappers = new ArrayList<PersistentHttpServletRequestWrapper>();
        HttpServletRequest currentHttpServletRequest = httpServletRequest;
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper) {
            if (currentHttpServletRequest instanceof UploadServletRequest) {
                return (UploadServletRequest)currentHttpServletRequest;
            }
            Class<?> currentRequestClass = currentHttpServletRequest.getClass();
            String currentRequestClassName = currentRequestClass.getName();
            if (!this.isUnwrapRequest(currentRequestClassName)) break;
            if (currentHttpServletRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentHttpServletRequest;
                persistentHttpServletRequestWrappers.add(persistentHttpServletRequestWrapper.clone());
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (ServerDetector.isWebLogic()) {
            currentHttpServletRequest = new NonSerializableObjectRequestWrapper(currentHttpServletRequest);
        }
        for (int i = persistentHttpServletRequestWrappers.size() - 1; i >= 0; --i) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)persistentHttpServletRequestWrappers.get(i);
            httpServletRequestWrapper.setRequest((ServletRequest)currentHttpServletRequest);
            currentHttpServletRequest = httpServletRequestWrapper;
        }
        return new UploadServletRequestImpl(currentHttpServletRequest, fileSizeThreshold, location, maxRequestSize, maxFileSize);
    }

    public Date getUptime() {
        return _upTime;
    }

    public String getURLWithSessionId(String url, String sessionId) {
        int y;
        HttpSession httpSession;
        if (!PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID) {
            return url;
        }
        if (Validator.isNull((String)url)) {
            return url;
        }
        int x = url.indexOf(59);
        if (x != -1) {
            return url;
        }
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter() && (httpSession = PortalSessionContext.get((String)sessionId)) != null) {
            while (httpSession instanceof HttpSessionWrapper) {
                HttpSessionWrapper httpSessionWrapper = (HttpSessionWrapper)httpSession;
                httpSession = httpSessionWrapper.getWrappedSession();
            }
            sessionId = httpSession.getId();
        }
        if ((x = url.indexOf(63)) != -1) {
            return StringBundler.concat((String[])new String[]{url.substring(0, x), ";jsessionid=", sessionId, url.substring(x)});
        }
        x = url.indexOf("//");
        StringBundler sb = new StringBundler(4);
        sb.append(url);
        if (x != -1 && x + 1 == (y = url.lastIndexOf(47))) {
            sb.append("/");
        }
        sb.append(";jsessionid=");
        sb.append(sessionId);
        return sb.toString();
    }

    public User getUser(HttpServletRequest httpServletRequest) throws PortalException {
        Cookie[] cookies;
        User user = (User)httpServletRequest.getAttribute("USER");
        if (user != null) {
            return user;
        }
        long userId = this.getUserId(httpServletRequest);
        if (userId <= 0L) {
            String remoteUser = httpServletRequest.getRemoteUser();
            if (remoteUser == null && !PropsValues.PORTAL_JAAS_ENABLE) {
                HttpSession httpSession = httpServletRequest.getSession();
                remoteUser = (String)httpSession.getAttribute("j_remoteuser");
            }
            if (remoteUser == null) {
                return null;
            }
            if (PropsValues.PORTAL_JAAS_ENABLE) {
                long companyId = this.getCompanyId(httpServletRequest);
                try {
                    userId = JAASHelper.getJaasUserId(companyId, remoteUser);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)exception);
                    }
                }
            } else {
                userId = GetterUtil.getLong((String)remoteUser);
            }
        }
        if (userId > 0L) {
            user = UserLocalServiceUtil.getUserById((long)userId);
            httpServletRequest.setAttribute("USER", (Object)user);
        }
        if ((cookies = httpServletRequest.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!cookieName.startsWith("REMOTE_PREFERENCE_")) continue;
                user.addRemotePreference((RemotePreference)new CookieRemotePreference(cookie));
            }
        }
        return user;
    }

    public User getUser(PortletRequest portletRequest) throws PortalException {
        return this.getUser(this.getHttpServletRequest(portletRequest));
    }

    public String getUserEmailAddress(long userId) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            return user.getEmailAddress();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return "";
        }
    }

    public long getUserId(HttpServletRequest httpServletRequest) {
        HttpSession httpSession;
        Long userIdObj = (Long)httpServletRequest.getAttribute("USER_ID");
        if (userIdObj != null) {
            return userIdObj;
        }
        String doAsUserIdString = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserId", null);
        if (doAsUserIdString != null) {
            String actionName = this.getPortletParam(httpServletRequest, "actionName");
            String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"mvcRenderCommandName");
            String path = GetterUtil.getString((String)httpServletRequest.getPathInfo());
            boolean alwaysAllowDoAsUser = false;
            if (actionName.equals("addFile") || mvcRenderCommandName.equals("/document_library/edit_file_entry") || path.equals("/portal/session_click") || this.isAlwaysAllowDoAsUser(actionName, mvcRenderCommandName, path, this.getStrutsAction(httpServletRequest))) {
                try {
                    alwaysAllowDoAsUser = this.isAlwaysAllowDoAsUser(httpServletRequest);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
            if (!PropsValues.PORTAL_JAAS_ENABLE && PropsValues.PORTAL_IMPERSONATION_ENABLE || alwaysAllowDoAsUser) {
                try {
                    long doAsUserId = this.getDoAsUserId(httpServletRequest, doAsUserIdString, alwaysAllowDoAsUser);
                    if (doAsUserId > 0L) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Impersonating user " + doAsUserId));
                        }
                        return doAsUserId;
                    }
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to impersonate user " + doAsUserIdString), (Throwable)exception);
                }
            }
        }
        if ((userIdObj = (Long)(httpSession = httpServletRequest.getSession()).getAttribute("USER_ID")) != null) {
            httpServletRequest.setAttribute("USER_ID", (Object)userIdObj);
            return userIdObj;
        }
        return 0L;
    }

    public long getUserId(PortletRequest portletRequest) {
        return this.getUserId(this.getHttpServletRequest(portletRequest));
    }

    public String getUserName(BaseModel<?> baseModel) {
        long userId = 0L;
        String userName = "";
        if (baseModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)baseModel;
            userId = auditedModel.getUserId();
            userName = auditedModel.getUserName();
        } else {
            userId = BeanPropertiesUtil.getLongSilent(baseModel, (String)"userId");
            userName = BeanPropertiesUtil.getStringSilent(baseModel, (String)"userName");
        }
        if (userId == 0L) {
            return "";
        }
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.unescape((String)userName);
        }
        userName = this.getUserName(userId, userName);
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.escape((String)userName);
        }
        return userName;
    }

    public String getUserName(long userId, String defaultUserName) {
        return this.getUserName(userId, defaultUserName, "user.name.full");
    }

    public String getUserName(long userId, String defaultUserName, HttpServletRequest httpServletRequest) {
        return this.getUserName(userId, defaultUserName, "user.name.full", httpServletRequest);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute) {
        return this.getUserName(userId, defaultUserName, userAttribute, null);
    }

    public String getUserName(long userId, String defaultUserName, String userAttribute, HttpServletRequest httpServletRequest) {
        String userName = defaultUserName;
        User user = UserLocalServiceUtil.fetchUserById((long)userId);
        if (user != null) {
            userName = userAttribute.equals("user.name.full") ? user.getFullName() : user.getScreenName();
            if (httpServletRequest != null) {
                Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
                userName = StringBundler.concat((String[])new String[]{"<a href=\"", PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_directory_web_portlet_DirectoryPortlet", (Layout)layout, (String)"RENDER_PHASE")).setParameter("struts_action", "/directory/view_user").setParameter("p_u_i_d", (Object)user.getUserId()).setPortletMode(PortletMode.VIEW).setWindowState(WindowState.MAXIMIZED).buildString(), "\">", HtmlUtil.escape((String)userName), "</a>"});
            }
        }
        return userName;
    }

    public String getUserPassword(HttpServletRequest httpServletRequest) {
        httpServletRequest = this.getOriginalServletRequest(httpServletRequest);
        return this.getUserPassword(httpServletRequest.getSession());
    }

    public String getUserPassword(HttpSession httpSession) {
        return (String)httpSession.getAttribute("USER_PASSWORD");
    }

    public String getUserPassword(PortletRequest portletRequest) {
        return this.getUserPassword(this.getHttpServletRequest(portletRequest));
    }

    public String getValidPortalDomain(long companyId, String domain) {
        if (this._validPortalDomainCheckDisabled) {
            return domain;
        }
        for (String virtualHost : PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) {
            if (!StringUtil.equalsIgnoreCase((String)domain, (String)virtualHost) && !StringUtil.wildcardMatches((String)domain, (String)virtualHost, (char)'?', (char)'*', (char)'%', (boolean)false)) continue;
            return domain;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Set the property \"", "virtual.hosts.valid.hosts", "\" in portal.properties to allow \"", domain, "\" as a domain"}));
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getDefaultCompanyId());
            return company.getVirtualHostname();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to load default portal instance", (Throwable)exception);
            return _LOCALHOST;
        }
    }

    public long getValidUserId(long companyId, long userId) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)userId);
        if (user == null) {
            return UserLocalServiceUtil.getDefaultUserId((long)companyId);
        }
        if (user.getCompanyId() == companyId) {
            return user.getUserId();
        }
        return userId;
    }

    public TreeMap<String, String> getVirtualHostnames(LayoutSet layoutSet) {
        TreeMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (!virtualHostnames.isEmpty()) {
            return virtualHostnames;
        }
        String companyFallbackVirtualHostname = layoutSet.getCompanyFallbackVirtualHostname();
        if (Validator.isNull((String)companyFallbackVirtualHostname)) {
            return virtualHostnames;
        }
        return TreeMapBuilder.put((Object)companyFallbackVirtualHostname, (Object)"").build();
    }

    public String getWidgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.WIDGET_SERVLET_MAPPING, themeDisplay);
    }

    public void initCustomSQL() {
        this._customSqlKeys = new String[]{"[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.GROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.LAYOUT$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ORGANIZATION$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ROLE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.TEAM$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USERGROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFILEENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFOLDER$]", "[$RESOURCE_SCOPE_COMPANY$]", "[$RESOURCE_SCOPE_GROUP$]", "[$RESOURCE_SCOPE_GROUP_TEMPLATE$]", "[$RESOURCE_SCOPE_INDIVIDUAL$]", "[$SOCIAL_RELATION_TYPE_BI_COWORKER$]", "[$SOCIAL_RELATION_TYPE_BI_FRIEND$]", "[$SOCIAL_RELATION_TYPE_BI_ROMANTIC_PARTNER$]", "[$SOCIAL_RELATION_TYPE_BI_SIBLING$]", "[$SOCIAL_RELATION_TYPE_BI_SPOUSE$]", "[$SOCIAL_RELATION_TYPE_UNI_CHILD$]", "[$SOCIAL_RELATION_TYPE_UNI_ENEMY$]", "[$SOCIAL_RELATION_TYPE_UNI_FOLLOWER$]", "[$SOCIAL_RELATION_TYPE_UNI_PARENT$]", "[$SOCIAL_RELATION_TYPE_UNI_SUBORDINATE$]", "[$SOCIAL_RELATION_TYPE_UNI_SUPERVISOR$]", "[$FALSE$]", "[$TRUE$]"};
        DB db = DBManagerUtil.getDB();
        this._customSqlValues = ArrayUtil.toStringArray((Object[])new Object[]{this.getClassNameId(Group.class), this.getClassNameId(Layout.class), this.getClassNameId(Organization.class), this.getClassNameId(Role.class), this.getClassNameId(Team.class), this.getClassNameId(User.class), this.getClassNameId(UserGroup.class), this.getClassNameId(DLFileEntry.class), this.getClassNameId(DLFolder.class), 1, 2, 3, 4, 1, 2, 3, 4, 5, 6, 9, 8, 7, 10, 11, db.getTemplateFalse(), db.getTemplateTrue()});
    }

    public User initUser(HttpServletRequest httpServletRequest) throws Exception {
        User user = null;
        try {
            user = this.getUser(httpServletRequest);
        }
        catch (NoSuchUserException noSuchUserException) {
            long userId;
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)noSuchUserException);
            }
            if ((userId = this.getUserId(httpServletRequest)) > 0L) {
                HttpSession httpSession = httpServletRequest.getSession();
                httpSession.invalidate();
            }
            throw noSuchUserException;
        }
        if (user != null) {
            return user;
        }
        Company company = this.getCompany(httpServletRequest);
        return company.getDefaultUser();
    }

    public boolean isCDNDynamicResourcesEnabled(HttpServletRequest httpServletRequest) throws PortalException {
        Company company = this.getCompany(httpServletRequest);
        return this.isCDNDynamicResourcesEnabled(company.getCompanyId());
    }

    public boolean isCDNDynamicResourcesEnabled(long companyId) {
        try {
            return PrefsPropsUtil.getBoolean(companyId, "cdn.dynamic.resources.enabled", PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED);
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)systemException);
            }
            return PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED;
        }
    }

    public boolean isCompanyAdmin(User user) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isCompanyAdmin();
    }

    public boolean isCompanyControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) throws PortalException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, category, themeDisplay);
    }

    public boolean isCompanyControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) throws PortalException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, themeDisplay);
    }

    public boolean isControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
        String controlPanelEntryCategory = portlet.getControlPanelEntryCategory();
        if (controlPanelEntryCategory.equals(category) || category.endsWith(".") && StringUtil.startsWith((String)controlPanelEntryCategory, (String)category)) {
            return this.isControlPanelPortlet(portletId, themeDisplay);
        }
        return false;
    }

    public boolean isControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) {
        try {
            return PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (String)portletId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to check control panel access permission", (Throwable)portalException);
            }
            return false;
        }
    }

    public boolean isCustomPortletMode(PortletMode portletMode) {
        return !LiferayPortletMode.ABOUT.equals((Object)portletMode) && !LiferayPortletMode.CONFIG.equals((Object)portletMode) && !LiferayPortletMode.EDIT.equals((Object)portletMode) && !LiferayPortletMode.EDIT_DEFAULTS.equals((Object)portletMode) && !LiferayPortletMode.EDIT_GUEST.equals((Object)portletMode) && !LiferayPortletMode.HELP.equals((Object)portletMode) && !LiferayPortletMode.PREVIEW.equals((Object)portletMode) && !LiferayPortletMode.PRINT.equals((Object)portletMode) && !LiferayPortletMode.VIEW.equals((Object)portletMode);
    }

    public boolean isForwardedSecure(HttpServletRequest httpServletRequest) {
        String forwardedProtocol;
        if (PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_ENABLED && Validator.isNotNull((String)(forwardedProtocol = httpServletRequest.getHeader(PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_HEADER))) && Objects.equals("https", forwardedProtocol)) {
            return true;
        }
        return httpServletRequest.isSecure();
    }

    public boolean isGroupAdmin(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isGroupAdmin(groupId);
    }

    public boolean isGroupControlPanelPath(String path) {
        if (Validator.isNull((String)path)) {
            return false;
        }
        return path.contains("/~/control_panel");
    }

    public boolean isGroupFriendlyURL(String fullURL, String groupFriendlyURL, String layoutFriendlyURL) {
        return fullURL.endsWith(groupFriendlyURL) && !fullURL.endsWith(groupFriendlyURL.concat(layoutFriendlyURL));
    }

    public boolean isGroupOwner(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        return permissionChecker.isGroupOwner(groupId);
    }

    public boolean isLayoutDescendant(Layout layout, long layoutId) throws PortalException {
        if (layout.getLayoutId() == layoutId) {
            return true;
        }
        for (Layout childLayout : layout.getChildren()) {
            if (!this.isLayoutDescendant(childLayout, layoutId)) continue;
            return true;
        }
        return false;
    }

    public boolean isLayoutSitemapable(Layout layout) {
        if (layout.isPrivateLayout()) {
            return false;
        }
        LayoutType layoutType = layout.getLayoutType();
        return layoutType.isSitemapable();
    }

    public boolean isLoginRedirectRequired(HttpServletRequest httpServletRequest) {
        return PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !httpServletRequest.isSecure() || SSOUtil.isLoginRedirectRequired(this.getCompanyId(httpServletRequest));
    }

    public boolean isMethodGet(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)httpServletRequest.getMethod());
        return StringUtil.equalsIgnoreCase((String)method, (String)"GET");
    }

    public boolean isMethodPost(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString((String)httpServletRequest.getMethod());
        return StringUtil.equalsIgnoreCase((String)method, (String)"POST");
    }

    public boolean isMultipartRequest(HttpServletRequest httpServletRequest) {
        String contentType = httpServletRequest.getHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public boolean isOmniadmin(long userId) {
        return OmniadminUtil.isOmniadmin(userId);
    }

    public boolean isOmniadmin(User user) {
        return OmniadminUtil.isOmniadmin(user);
    }

    public boolean isReservedParameter(String name) {
        return this._reservedParams.contains(name);
    }

    public boolean isRightToLeft(HttpServletRequest httpServletRequest) {
        Locale locale = LocaleUtil.fromLanguageId((String)LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest));
        String langDir = LanguageUtil.get((Locale)locale, (String)"lang.dir");
        return langDir.equals("rtl");
    }

    public boolean isRSSFeedsEnabled() {
        return PropsValues.RSS_FEEDS_ENABLED;
    }

    public boolean isSecure(HttpServletRequest httpServletRequest) {
        if (PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_ENABLED) {
            return this.isForwardedSecure(httpServletRequest);
        }
        if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            return httpServletRequest.isSecure();
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            return httpServletRequest.isSecure();
        }
        Boolean httpsInitial = (Boolean)httpSession.getAttribute("HTTPS_INITIAL");
        if (httpsInitial == null || httpsInitial.booleanValue()) {
            return httpServletRequest.isSecure();
        }
        return false;
    }

    public boolean isSkipPortletContentRendering(Group group, LayoutTypePortlet layoutTypePortlet, PortletDisplay portletDisplay, String portletName) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)group.getCompanyId(), (String)portletDisplay.getId());
        if (portlet.isSystem()) {
            return false;
        }
        return group.isLayoutPrototype() && layoutTypePortlet.hasPortletId(portletDisplay.getId()) && portletDisplay.isModeView() && !portletDisplay.isStatePopUp() && !portletName.equals("com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet");
    }

    public boolean isSystemGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemGroups, groupName = groupName.trim(), new StringComparator());
        return pos >= 0;
    }

    public boolean isSystemRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemRoles, roleName = roleName.trim(), new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemSiteRoles, roleName, new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemOrganizationRoles, roleName, new StringComparator());
        return pos >= 0;
    }

    public boolean isValidPortalDomain(long companyId, String domain) {
        if (this._validPortalDomainCheckDisabled) {
            return true;
        }
        if (!Validator.isHostName((String)domain)) {
            return false;
        }
        for (String virtualHost : PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) {
            if (!StringUtil.equalsIgnoreCase((String)domain, (String)virtualHost) && !StringUtil.wildcardMatches((String)domain, (String)virtualHost, (char)'?', (char)'*', (char)'%', (boolean)false)) continue;
            return true;
        }
        return StringUtil.equalsIgnoreCase((String)domain, (String)PropsValues.WEB_SERVER_HOST) || this.isValidVirtualHostname(domain) || StringUtil.equalsIgnoreCase((String)domain, (String)this.getCDNHostHttp(companyId)) || StringUtil.equalsIgnoreCase((String)domain, (String)this.getCDNHostHttps(companyId));
    }

    public boolean isValidResourceId(String resourceId) {
        if (Validator.isNull((String)resourceId)) {
            return true;
        }
        Matcher matcher = _bannedResourceIdPattern.matcher(resourceId);
        if (matcher.matches()) {
            return false;
        }
        int count = _PORTLET_RESOURCE_ID_URL_DECODE_COUNT;
        while (count > 0 && resourceId.contains("%")) {
            if (Validator.isNull((String)(resourceId = HttpComponentsUtil.decodePath((String)resourceId)))) {
                return false;
            }
            matcher = _bannedResourceIdPattern.matcher(resourceId);
            if (matcher.matches()) {
                return false;
            }
            if (--count != 0) continue;
            return false;
        }
        return true;
    }

    public boolean removePortalInetSocketAddressEventListener(PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        return this._portalInetSocketAddressEventListeners.remove(portalInetSocketAddressEventListener);
    }

    public void resetCDNHosts() {
        _cdnHostHttpMap.clear();
        _cdnHostHttpsMap.clear();
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)_resetCDNHostsMethodHandler, (boolean)true);
        try {
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to clear cluster wide CDN hosts", (Throwable)exception);
        }
    }

    public String resetPortletParameters(String url, String portletId) {
        if (Validator.isNull((String)url) || Validator.isNull((String)portletId)) {
            return url;
        }
        String portletNamespace = this.getPortletNamespace(portletId);
        Map parameterMap = HttpComponentsUtil.getParameterMap((String)url);
        for (String name : parameterMap.keySet()) {
            if (!name.startsWith(portletNamespace)) continue;
            url = HttpComponentsUtil.removeParameter((String)url, (String)name);
        }
        return url;
    }

    public void sendError(Exception exception, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.sendError(0, exception, actionRequest, actionResponse);
    }

    public void sendError(Exception exception, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.sendError(0, exception, httpServletRequest, httpServletResponse);
    }

    public void sendError(int status, Exception exception, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StringBundler sb = new StringBundler(7);
        sb.append(this._pathMain);
        sb.append("/portal/status?status=");
        sb.append(status);
        sb.append("&exception=");
        Class<?> clazz = exception.getClass();
        sb.append(clazz.getName());
        sb.append("&previousURL=");
        sb.append(URLCodec.encodeURL((String)this.getCurrentURL((PortletRequest)actionRequest)));
        actionResponse.sendRedirect(sb.toString());
    }

    public void sendError(int status, Exception exception, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (_log.isDebugEnabled()) {
            String currentURL = (String)httpServletRequest.getAttribute("CURRENT_URL");
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Current URL ", currentURL, " generates exception: ", exception.getMessage()}));
        }
        if (exception instanceof NoSuchImageException) {
            if (_webServerServletLog.isWarnEnabled()) {
                _webServerServletLog.warn((Object)exception, (Throwable)exception);
            }
        } else if (exception instanceof PortalException) {
            if (_log.isDebugEnabled()) {
                if (exception instanceof NoSuchLayoutException || exception instanceof PrincipalException) {
                    String msg = exception.getMessage();
                    if (Validator.isNotNull((String)msg)) {
                        _log.debug((Object)msg);
                    }
                } else {
                    _log.debug((Throwable)exception);
                }
            }
        } else if (_log.isWarnEnabled()) {
            _log.warn((Throwable)exception);
        }
        if (httpServletResponse.isCommitted()) {
            return;
        }
        if (status == 0) {
            if (exception instanceof PrincipalException) {
                status = 403;
            } else {
                Class<?> clazz = exception.getClass();
                String name = clazz.getName();
                if ((name = name.substring(name.lastIndexOf(46) + 1)).startsWith("NoSuch") && name.endsWith("Exception")) {
                    status = 404;
                }
            }
            if (status == 0) {
                status = 400;
            }
        }
        String redirect = null;
        if (exception instanceof NoSuchGroupException && Validator.isNotNull((String)PropsValues.SITES_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            redirect = this._get18nErrorRedirect(httpServletRequest, PropsValues.SITES_FRIENDLY_URL_PAGE_NOT_FOUND);
        } else if (exception instanceof NoSuchLayoutException && Validator.isNotNull((String)PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            redirect = this._get18nErrorRedirect(httpServletRequest, PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND);
            httpServletRequest.setAttribute(NoSuchLayoutException.class.getName(), (Object)Boolean.TRUE);
        } else if (PropsValues.LAYOUT_SHOW_HTTP_STATUS) {
            DynamicServletRequest dynamicRequest = new DynamicServletRequest(httpServletRequest);
            dynamicRequest.setParameter("p_l_id", "");
            dynamicRequest.setParameter("groupId", "");
            dynamicRequest.setParameter("layoutId", "");
            dynamicRequest.setParameter("privateLayout", "");
            httpServletRequest = dynamicRequest;
            redirect = "/c/portal/status";
        }
        if (Objects.equals(redirect, httpServletRequest.getRequestURI())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to redirect to missing URI: " + redirect));
            }
            redirect = null;
        }
        if (Validator.isNotNull((String)redirect)) {
            HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
            if (httpSession == null) {
                httpSession = httpServletRequest.getSession();
            }
            httpServletResponse.setStatus(status);
            SessionErrors.add((HttpSession)httpSession, exception.getClass(), (Object)exception);
            ServletContext servletContext = httpSession.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (exception != null) {
            httpServletResponse.sendError(status, "A " + exception.getClass() + " error occurred while processing your request");
        } else {
            String currentURL = (String)httpServletRequest.getAttribute("CURRENT_URL");
            httpServletResponse.sendError(status, "Current URL " + currentURL);
        }
    }

    public void sendRSSFeedsDisabledError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.sendError(404, (Exception)new RSSFeedException(), httpServletRequest, httpServletResponse);
    }

    public void sendRSSFeedsDisabledError(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, ServletException {
        this.sendRSSFeedsDisabledError(this.getHttpServletRequest(portletRequest), this.getHttpServletResponse(portletResponse));
    }

    public void setPageDescription(String description, HttpServletRequest httpServletRequest) {
        ListMergeable descriptionListMergeable = new ListMergeable();
        descriptionListMergeable.add((Object)description);
        httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", (Object)descriptionListMergeable);
    }

    public void setPageKeywords(String keywords, HttpServletRequest httpServletRequest) {
        httpServletRequest.removeAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        this.addPageKeywords(keywords, httpServletRequest);
    }

    public void setPageSubtitle(String subtitle, HttpServletRequest httpServletRequest) {
        ListMergeable subtitleListMergeable = new ListMergeable();
        subtitleListMergeable.add((Object)subtitle);
        httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", (Object)subtitleListMergeable);
    }

    public void setPageTitle(String title, HttpServletRequest httpServletRequest) {
        ListMergeable titleListMergeable = new ListMergeable();
        titleListMergeable.add((Object)title);
        httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_TITLE", (Object)titleListMergeable);
    }

    public void setPortalInetSocketAddresses(HttpServletRequest httpServletRequest) {
        boolean secure = httpServletRequest.isSecure();
        if (secure && this._securePortalLocalInetSocketAddress.get() != null && this._securePortalServerInetSocketAddress.get() != null || !secure && this._portalLocalInetSocketAddress.get() != null && this._portalServerInetSocketAddress.get() != null) {
            return;
        }
        InetAddress localInetAddress = null;
        InetAddress serverInetAddress = null;
        try {
            localInetAddress = InetAddress.getByName(httpServletRequest.getLocalAddr());
            serverInetAddress = InetAddress.getByName(httpServletRequest.getServerName());
        }
        catch (UnknownHostException unknownHostException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to resolve portal host", (Throwable)unknownHostException);
            }
            return;
        }
        InetSocketAddress localInetSocketAddress = new InetSocketAddress(localInetAddress, httpServletRequest.getLocalPort());
        InetSocketAddress serverInetSocketAddress = new InetSocketAddress(serverInetAddress, httpServletRequest.getServerPort());
        if (secure) {
            if (this._securePortalLocalInetSocketAddress.compareAndSet(null, localInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(localInetSocketAddress, true, true);
            }
            if (this._securePortalServerInetSocketAddress.compareAndSet(null, serverInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(serverInetSocketAddress, false, true);
            }
        } else {
            if (this._portalLocalInetSocketAddress.compareAndSet(null, localInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(localInetSocketAddress, true, false);
            }
            if (this._portalServerInetSocketAddress.compareAndSet(null, serverInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(serverInetSocketAddress, false, false);
            }
        }
    }

    public void storePreferences(javax.portlet.PortletPreferences portletPreferences) throws IOException, ValidatorException {
        PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletPreferences;
        PortletPreferencesImpl portletPreferencesImpl = portletPreferencesWrapper.getPortletPreferencesImpl();
        portletPreferencesImpl.store();
    }

    public String[] stripURLAnchor(String url, String separator) {
        String anchor = "";
        int pos = url.indexOf(separator);
        if (pos != -1) {
            anchor = url.substring(pos);
            url = url.substring(0, pos);
        }
        return new String[]{url, anchor};
    }

    public String transformCustomSQL(String sql) {
        if (this._customSqlKeys == null || this._customSqlValues == null) {
            this.initCustomSQL();
        }
        return StringUtil.replace((String)sql, (String[])this._customSqlKeys, (String[])this._customSqlValues);
    }

    public String transformSQL(String sql) {
        return SQLTransformer.transform(sql);
    }

    public void updateImageId(BaseModel<?> baseModel, boolean hasImage, byte[] bytes, String fieldName, long maxSize, int maxHeight, int maxWidth) throws PortalException {
        long imageId = BeanPropertiesUtil.getLong(baseModel, (String)fieldName);
        if (!hasImage) {
            if (imageId > 0L) {
                ImageLocalServiceUtil.deleteImage((long)imageId);
                BeanPropertiesUtil.setProperty(baseModel, (String)fieldName, (Object)0);
            }
            return;
        }
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return;
        }
        if (maxSize > 0L && (long)bytes.length > maxSize) {
            throw new ImageSizeException();
        }
        if (maxHeight > 0 || maxWidth > 0) {
            try {
                ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                if (renderedImage == null) {
                    throw new ImageTypeException();
                }
                renderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)maxHeight, (int)maxWidth);
                bytes = ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
            }
            catch (IOException ioException) {
                throw new ImageSizeException((Throwable)ioException);
            }
        }
        Image image = null;
        image = imageId > 0L ? ImageLocalServiceUtil.moveImage((long)imageId, (byte[])bytes) : ImageLocalServiceUtil.updateImage((long)BeanPropertiesUtil.getLong(baseModel, (String)"companyId"), (long)CounterLocalServiceUtil.increment(), (byte[])bytes);
        BeanPropertiesUtil.setProperty(baseModel, (String)fieldName, (Object)image.getImageId());
    }

    public PortletMode updatePortletMode(String portletId, User user, Layout layout, PortletMode portletMode, HttpServletRequest httpServletRequest) throws PortalException {
        LayoutClone layoutClone;
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            if (layoutType.hasModeAboutPortletId(portletId)) {
                return LiferayPortletMode.ABOUT;
            }
            if (layoutType.hasModeConfigPortletId(portletId)) {
                return LiferayPortletMode.CONFIG;
            }
            if (layoutType.hasModeEditPortletId(portletId)) {
                return PortletMode.EDIT;
            }
            if (layoutType.hasModeEditDefaultsPortletId(portletId)) {
                return LiferayPortletMode.EDIT_DEFAULTS;
            }
            if (layoutType.hasModeEditGuestPortletId(portletId)) {
                return LiferayPortletMode.EDIT_GUEST;
            }
            if (layoutType.hasModeHelpPortletId(portletId)) {
                return PortletMode.HELP;
            }
            if (layoutType.hasModePreviewPortletId(portletId)) {
                return LiferayPortletMode.PREVIEW;
            }
            if (layoutType.hasModePrintPortletId(portletId)) {
                return LiferayPortletMode.PRINT;
            }
            return PortletMode.VIEW;
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(httpServletRequest), (String)portletId);
        Set allPortletModes = portlet.getAllPortletModes();
        if (!allPortletModes.contains(portletMode.toString())) {
            return PortletModeFactory.getPortletMode(null, (int)3);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        boolean updateLayout = false;
        if (portletMode.equals((Object)LiferayPortletMode.ABOUT) && !layoutType.hasModeAboutPortletId(portletId)) {
            layoutType.addModeAboutPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG) && !layoutType.hasModeConfigPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(httpServletRequest), (Layout)layout, (Portlet)portlet, (String)"CONFIGURATION")) {
            layoutType.addModeConfigPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.EDIT) && !layoutType.hasModeEditPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(httpServletRequest), (Layout)layout, (Portlet)portlet, (String)"PREFERENCES")) {
            layoutType.addModeEditPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS) && !layoutType.hasModeEditDefaultsPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(httpServletRequest), (Layout)layout, (Portlet)portlet, (String)"PREFERENCES")) {
            layoutType.addModeEditDefaultsPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST) && !layoutType.hasModeEditGuestPortletId(portletId) && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(httpServletRequest), (Layout)layout, (Portlet)portlet, (String)"GUEST_PREFERENCES")) {
            layoutType.addModeEditGuestPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.HELP) && !layoutType.hasModeHelpPortletId(portletId)) {
            layoutType.addModeHelpPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW) && !layoutType.hasModePreviewPortletId(portletId)) {
            layoutType.addModePreviewPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT) && !layoutType.hasModePrintPortletId(portletId)) {
            layoutType.addModePrintPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.VIEW) && !layoutType.hasModeViewPortletId(portletId)) {
            layoutType.removeModesPortletId(portletId);
            updateLayout = true;
        } else if (this.isCustomPortletMode(portletMode) && !layoutType.hasModeCustomPortletId(portletId, portletMode.toString())) {
            layoutType.addModeCustomPortletId(portletId, portletMode.toString());
            updateLayout = true;
        }
        if (updateLayout && PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.getScopeGroupId(httpServletRequest), (Layout)layout, (Portlet)portlet, (String)"VIEW") && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
            layoutClone.update(httpServletRequest, layout.getPlid(), layout.getTypeSettings());
        }
        return portletMode;
    }

    public String updateRedirect(String redirect, String oldPath, String newPath) {
        if (Validator.isNull((String)redirect) || oldPath == null || oldPath.equals(newPath)) {
            return redirect;
        }
        String queryString = HttpComponentsUtil.getQueryString((String)redirect);
        String redirectParam = HttpComponentsUtil.getParameter((String)redirect, (String)"redirect", (boolean)false);
        if (Validator.isNotNull((String)redirectParam)) {
            String newRedirectParam = StringUtil.replace((String)redirectParam, (String)URLCodec.encodeURL((String)oldPath), (String)URLCodec.encodeURL((String)newPath));
            queryString = StringUtil.replace((String)queryString, (String)redirectParam, (String)newRedirectParam);
        }
        String redirectPath = HttpComponentsUtil.getPath((String)redirect);
        int pos = redirect.indexOf(redirectPath);
        String prefix = redirect.substring(0, pos);
        pos = redirectPath.lastIndexOf(oldPath);
        if (pos != -1) {
            prefix = prefix + redirectPath.substring(0, pos);
            String suffix = redirectPath.substring(pos + oldPath.length());
            redirect = prefix + newPath + suffix;
        } else {
            redirect = prefix + redirectPath;
        }
        if (Validator.isNotNull((String)queryString)) {
            redirect = redirect + "?" + queryString;
        }
        return redirect;
    }

    public WindowState updateWindowState(String portletId, User user, Layout layout, WindowState windowState, HttpServletRequest httpServletRequest) {
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (windowState == null || Validator.isNull((String)windowState.toString())) {
            windowState = layoutType.hasStateMaxPortletId(portletId) ? WindowState.MAXIMIZED : (layoutType.hasStateMinPortletId(portletId) ? WindowState.MINIMIZED : WindowState.NORMAL);
        } else {
            LayoutClone layoutClone;
            boolean updateLayout = false;
            if (windowState.equals((Object)WindowState.MAXIMIZED) && !layoutType.hasStateMaxPortletId(portletId)) {
                layoutType.addStateMaxPortletId(portletId);
                if (PropsValues.LAYOUT_REMEMBER_MAXIMIZED_WINDOW_STATE) {
                    updateLayout = true;
                }
            } else if (windowState.equals((Object)WindowState.MINIMIZED) && !layoutType.hasStateMinPortletId(portletId)) {
                layoutType.addStateMinPortletId(portletId);
                updateLayout = true;
            } else if (windowState.equals((Object)WindowState.NORMAL) && !layoutType.hasStateNormalPortletId(portletId)) {
                layoutType.removeStatesPortletId(portletId);
                updateLayout = true;
            }
            if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
                layoutClone.update(httpServletRequest, layout.getPlid(), layout.getTypeSettings());
            }
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setStateExclusive(windowState.equals((Object)LiferayWindowState.EXCLUSIVE));
        themeDisplay.setStateMaximized(windowState.equals((Object)WindowState.MAXIMIZED));
        themeDisplay.setStatePopUp(windowState.equals((Object)LiferayWindowState.POP_UP));
        httpServletRequest.setAttribute("WINDOW_STATE", (Object)windowState);
        return windowState;
    }

    protected void addRootModelResource(long companyId, long groupId, String name) throws PortalException {
        String primaryKey;
        int count;
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group != null && group.isStagingGroup()) {
            groupId = group.getLiveGroupId();
        }
        if ((count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)companyId, (String)name, (int)4, (String)(primaryKey = String.valueOf(groupId)))) > 0) {
            return;
        }
        ResourceLocalServiceUtil.addResources((long)companyId, (long)groupId, (long)0L, (String)name, (String)primaryKey, (boolean)false, (boolean)true, (boolean)true);
    }

    protected long doGetPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
                groupId = scopeLayout.getGroupId();
            }
            return this.getPlidFromPortletId(LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (String[])new String[]{"content", "collection", "full_page_application", "panel", "portlet"}), portletId, scopeGroupId);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return 0L;
        }
    }

    protected List<Portlet> filterControlPanelPortlets(Set<Portlet> portlets, ThemeDisplay themeDisplay) {
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>(portlets);
        Iterator iterator = filteredPortlets.iterator();
        while (iterator.hasNext()) {
            Portlet portlet = (Portlet)iterator.next();
            try {
                if (portlet.isActive() && !portlet.isInstanceable() && PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (Portlet)portlet)) continue;
                iterator.remove();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                iterator.remove();
            }
        }
        return filteredPortlets;
    }

    protected Set<Group> getAncestorSiteGroups(long groupId, boolean checkContentSharingWithChildrenEnabled) {
        Group siteGroup = this._getSiteGroup(groupId);
        if (siteGroup == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Group> groups = null;
        for (Group group : siteGroup.getAncestors()) {
            if (checkContentSharingWithChildrenEnabled && !SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) continue;
            if (groups == null) {
                groups = new LinkedHashSet<Group>();
            }
            groups.add(group);
        }
        if (!siteGroup.isCompany()) {
            String cacheKey;
            ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)Company.class.getName()));
            Group companyGroup = (Group)threadLocalCache.get(cacheKey = StringUtil.toHexString((long)siteGroup.getCompanyId()));
            if (companyGroup == null) {
                companyGroup = GroupLocalServiceUtil.fetchCompanyGroup((long)siteGroup.getCompanyId());
                threadLocalCache.put(cacheKey, (Object)companyGroup);
            }
            if (companyGroup != null) {
                if (groups == null) {
                    return Collections.singleton(companyGroup);
                }
                groups.add(companyGroup);
                return groups;
            }
        }
        if (groups == null) {
            return Collections.emptySet();
        }
        return groups;
    }

    protected Locale getAvailableLocale(long groupId, Locale locale) {
        if (Validator.isNull((String)locale.getCountry())) {
            locale = LanguageUtil.getLocale((String)locale.getLanguage());
        }
        if (!LanguageUtil.isAvailableLocale((long)groupId, (Locale)locale)) {
            return null;
        }
        return locale;
    }

    protected Layout getBrowsableLayout(Layout layout) {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (layoutTypeController.isBrowsable()) {
            return layout;
        }
        Layout browsableChildLayout = null;
        List childLayouts = layout.getAllChildren();
        for (Layout childLayout : childLayouts) {
            LayoutTypeController childLayoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(childLayout.getType());
            if (!childLayoutTypeController.isBrowsable()) continue;
            browsableChildLayout = childLayout;
            break;
        }
        if (browsableChildLayout != null) {
            return browsableChildLayout;
        }
        return LayoutLocalServiceUtil.fetchLayout((long)LayoutLocalServiceUtil.getDefaultPlid((long)layout.getGroupId(), (boolean)layout.isPrivateLayout()));
    }

    protected String getCanonicalDomain(TreeMap<String, String> virtualHostnames, String portalDomain, String defaultVirtualHostname) {
        if (Validator.isBlank((String)portalDomain) || StringUtil.equalsIgnoreCase((String)portalDomain, (String)defaultVirtualHostname) || !virtualHostnames.containsKey(defaultVirtualHostname)) {
            return virtualHostnames.firstKey();
        }
        int pos = portalDomain.indexOf(58);
        if (pos == -1) {
            return portalDomain;
        }
        return portalDomain.substring(0, pos);
    }

    protected String getContextPath(String contextPath) {
        if ((contextPath = GetterUtil.getString((String)contextPath)).length() == 0 || contextPath.equals("/")) {
            contextPath = "";
        } else if (!contextPath.startsWith("/")) {
            contextPath = "/".concat(contextPath);
        }
        return contextPath;
    }

    protected Group getControlPanelDisplayGroup(Group controlPanelGroup, Group scopeGroup, long doAsGroupId, String portletId) {
        Group doAsGroup;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)controlPanelGroup.getCompanyId(), (String)portletId);
        String portletCategory = portlet.getControlPanelEntryCategory();
        if (portletCategory.equals("control_panel.apps") || portletCategory.equals("control_panel.configuration") || portletCategory.equals("control_panel.sites") || portletCategory.equals("control_panel.system") || portletCategory.equals("control_panel.users") || portletCategory.equals("control_panel.workflow") || portletCategory.equals("user.my_account")) {
            return controlPanelGroup;
        }
        if (doAsGroupId > 0L && (doAsGroup = GroupLocalServiceUtil.fetchGroup((long)doAsGroupId)) != null) {
            return doAsGroup;
        }
        return scopeGroup;
    }

    protected Group getControlPanelDisplayGroup(long companyId, long scopeGroupId, long doAsGroupId, String portletId) {
        return this.getControlPanelDisplayGroup(GroupLocalServiceUtil.fetchGroup((long)companyId, (String)"Control Panel"), GroupLocalServiceUtil.fetchGroup((long)scopeGroupId), doAsGroupId, portletId);
    }

    protected Group getCurrentSiteGroup(long groupId) throws PortalException {
        Group siteGroup = this._getSiteGroup(groupId);
        if (siteGroup != null && !siteGroup.isLayoutPrototype()) {
            return siteGroup;
        }
        return null;
    }

    protected long getDoAsUserId(HttpServletRequest httpServletRequest, String doAsUserIdString, boolean alwaysAllowDoAsUser) throws Exception {
        if (Validator.isNull((String)doAsUserIdString)) {
            return 0L;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        Long realUserIdObj = (Long)httpSession.getAttribute("USER_ID");
        if (!alwaysAllowDoAsUser && realUserIdObj == null) {
            return 0L;
        }
        long doAsUserId = GetterUtil.getLong((String)doAsUserIdString);
        if (doAsUserId == 0L) {
            try {
                Company company = this.getCompany(httpServletRequest);
                doAsUserId = GetterUtil.getLong((String)EncryptorUtil.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to impersonate " + doAsUserIdString + " because the string cannot be decrypted"), (Throwable)exception);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to impersonate " + doAsUserIdString + " because the string cannot be decrypted"));
                }
                return 0L;
            }
        }
        if (_log.isDebugEnabled()) {
            if (alwaysAllowDoAsUser) {
                _log.debug((Object)"doAsUserId path or Struts action is always allowed");
            } else {
                _log.debug((Object)"doAsUserId path is Struts action not always allowed");
            }
        }
        if (alwaysAllowDoAsUser) {
            httpServletRequest.setAttribute("USER_ID", (Object)doAsUserId);
            return doAsUserId;
        }
        User doAsUser = UserLocalServiceUtil.getUserById((long)doAsUserId);
        User realUser = UserLocalServiceUtil.getUserById((long)realUserIdObj);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)realUser);
        if (doAsUser.isDefaultUser() || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)doAsUserId, (long[])doAsUser.getOrganizationIds(), (String)"IMPERSONATE")) {
            httpServletRequest.setAttribute("USER_ID", (Object)doAsUserId);
            return doAsUserId;
        }
        _log.error((Object)StringBundler.concat((Object[])new Object[]{"User ", realUserIdObj, " does not have the permission to impersonate ", doAsUserId}));
        return 0L;
    }

    protected String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL) throws PortalException {
        return this.getGroupFriendlyURL(layoutSet, themeDisplay, canonicalURL, false);
    }

    protected String[] getGroupPermissions(String[] groupPermissions, String className, String inputPermissionsShowOptions) {
        if (groupPermissions != null || inputPermissionsShowOptions != null) {
            return groupPermissions;
        }
        List groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)className);
        return groupDefaultActions.toArray(new String[0]);
    }

    protected String[] getGuestPermissions(String[] guestPermissions, String className, String inputPermissionsShowOptions) {
        if (guestPermissions != null || inputPermissionsShowOptions != null) {
            return guestPermissions;
        }
        List guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)className);
        return guestDefaultActions.toArray(new String[0]);
    }

    protected long getPlidFromPortletId(List<Layout> layouts, String portletId, long scopeGroupId) {
        for (Layout layout : layouts) {
            if (this.getScopeGroupId(layout, portletId) != scopeGroupId || !this._layoutContainsPortletId(layout, portletId)) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    protected String getPortletParam(HttpServletRequest httpServletRequest, String name) {
        String portletId1 = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
        if (Validator.isNull((String)portletId1)) {
            return "";
        }
        Object value = null;
        int valueCount = 0;
        String keyName = "_".concat(name);
        Map parameterMap = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String portletId2;
            String parameterName = (String)entry.getKey();
            int pos = parameterName.indexOf(keyName);
            if (pos == -1) continue;
            if (++valueCount > 1) {
                return "";
            }
            Object[] parameterValues = (String[])entry.getValue();
            if (ArrayUtil.isEmpty((Object[])parameterValues) || Validator.isNull((String)parameterValues[0]) || !portletId1.equals(portletId2 = parameterName.substring(1, pos))) continue;
            value = parameterValues[0];
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getServletURL(Portlet portlet, String servletPath, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        StringBundler sb = new StringBundler(9);
        sb.append(themeDisplay.getPortalURL());
        if (Validator.isNotNull((String)this._pathContext)) {
            sb.append(this._pathContext);
        }
        if (themeDisplay.isI18n()) {
            sb.append(themeDisplay.getI18nPath());
        }
        sb.append(servletPath);
        Group group = layout.getGroup();
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(_PRIVATE_USER_SERVLET_MAPPING);
            } else {
                sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
            }
        } else {
            sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
        }
        sb.append(group.getFriendlyURL());
        sb.append(themeDisplay.getLayoutFriendlyURL(layout));
        sb.append("/-/");
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper != null && !portlet.isInstanceable()) {
            sb.append(friendlyURLMapper.getMapping());
        } else {
            sb.append(portlet.getPortletId());
        }
        return sb.toString();
    }

    protected boolean isAlwaysAllowDoAsUser(HttpServletRequest httpServletRequest) throws Exception {
        String ticketKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ticketKey");
        if (Validator.isNull((String)ticketKey)) {
            return false;
        }
        Ticket ticket = TicketLocalServiceUtil.fetchTicket((String)ticketKey);
        if (ticket == null || ticket.getType() != 2) {
            return false;
        }
        String className = ticket.getClassName();
        if (!className.equals(User.class.getName())) {
            return false;
        }
        long doAsUserId = 0L;
        try {
            String doAsUserIdString = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"doAsUserId");
            if (Validator.isNotNull((String)doAsUserIdString)) {
                Company company = this.getCompany(httpServletRequest);
                doAsUserId = GetterUtil.getLong((String)EncryptorUtil.decrypt((Key)company.getKeyObj(), (String)doAsUserIdString));
            }
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
        if (ticket.getClassPK() != doAsUserId) {
            return false;
        }
        if (ticket.isExpired()) {
            TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
            return false;
        }
        Date expirationDate = new Date(System.currentTimeMillis() + (long)PropsValues.SESSION_TIMEOUT * 60000L);
        ticket.setExpirationDate(expirationDate);
        TicketLocalServiceUtil.updateTicket((Ticket)ticket);
        return true;
    }

    protected boolean isAlwaysAllowDoAsUser(String actionName, String mvcRenderCommandName, String path, String strutsAction) {
        for (AlwaysAllowDoAsUser alwaysAllowDoAsUser : this._alwaysAllowDoAsUsers) {
            Collection actionNames = alwaysAllowDoAsUser.getActionNames();
            if (actionNames.contains(actionName)) {
                return true;
            }
            Collection mvcRenderCommandNames = alwaysAllowDoAsUser.getMVCRenderCommandNames();
            if (mvcRenderCommandNames.contains(mvcRenderCommandName)) {
                return true;
            }
            Collection paths = alwaysAllowDoAsUser.getPaths();
            if (paths.contains(path)) {
                return true;
            }
            Collection strutsActions = alwaysAllowDoAsUser.getStrutsActions();
            if (!strutsActions.contains(strutsAction)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnwrapRequest(String currentRequestClassName) {
        for (String packageName : PropsValues.REQUEST_UNWRAP_PACKAGES) {
            if (!currentRequestClassName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidPortalDomain(String domain) {
        return this.isValidPortalDomain(CompanyThreadLocal.getCompanyId(), domain);
    }

    protected boolean isValidVirtualHostname(String virtualHostname) {
        block3: {
            try {
                virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
                VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)virtualHostname);
                if (virtualHost != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        return false;
    }

    protected void notifyPortalInetSocketAddressEventListeners(InetSocketAddress inetSocketAddress, boolean local, boolean secure) {
        for (PortalInetSocketAddressEventListener portalInetSocketAddressEventListener : this._portalInetSocketAddressEventListeners) {
            if (local) {
                portalInetSocketAddressEventListener.portalLocalInetSocketAddressConfigured(inetSocketAddress, secure);
                continue;
            }
            portalInetSocketAddressEventListener.portalServerInetSocketAddressConfigured(inetSocketAddress, secure);
        }
    }

    protected String removeRedirectParameter(String url) {
        Map parameterMap = HttpComponentsUtil.getParameterMap((String)HttpComponentsUtil.getQueryString((String)url));
        for (String parameter : parameterMap.keySet()) {
            if (!parameter.endsWith("redirect")) continue;
            url = HttpComponentsUtil.removeParameter((String)url, (String)parameter);
        }
        return url;
    }

    protected void resetThemeDisplayI18n(ThemeDisplay themeDisplay, String languageId, String path, Locale locale) {
        themeDisplay.setI18nLanguageId(languageId);
        themeDisplay.setI18nPath(path);
        themeDisplay.setLocale(locale);
    }

    protected void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("LOCALE", (Object)locale);
        LanguageUtil.updateCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Locale)locale);
    }

    protected void setThemeDisplayI18n(ThemeDisplay themeDisplay, Locale locale) {
        String i18nPath = null;
        Set<String> languageIds = I18nFilter.getLanguageIds();
        if (languageIds.contains(locale.toString()) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && !locale.equals(LocaleUtil.getDefault()) || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            i18nPath = this._buildI18NPath(locale, themeDisplay.getSiteGroup());
        }
        themeDisplay.setI18nLanguageId(locale.toString());
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setLocale(locale);
    }

    private String _buildI18NPath(Locale locale, Group group) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        return this._buildI18NPath(languageId, locale, group);
    }

    private String _buildI18NPath(String languageId, Locale locale) {
        if (Validator.isNull((String)languageId)) {
            return null;
        }
        if (LanguageUtil.isDuplicateLanguageCode((String)locale.getLanguage())) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                languageId = locale.getLanguage();
            }
        } else {
            languageId = locale.getLanguage();
        }
        return "/".concat(languageId);
    }

    private String _buildI18NPath(String languageId, Locale locale, Group group) {
        Locale siteDefaultLocale;
        block6: {
            if (Validator.isNull((String)languageId)) {
                return null;
            }
            siteDefaultLocale = null;
            try {
                siteDefaultLocale = this.getSiteDefaultLocale(group);
                if (!LanguageUtil.isSameLanguage((Locale)locale, (Locale)siteDefaultLocale)) {
                    siteDefaultLocale = LanguageUtil.getLocale((long)group.getGroupId(), (String)locale.getLanguage());
                }
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get default locale from group: " + group.getGroupId() + ".  Using portal defaults."), (Throwable)exception);
                }
                if (LanguageUtil.isSameLanguage((Locale)locale, (Locale)(siteDefaultLocale = LocaleUtil.getDefault()))) break block6;
                siteDefaultLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            }
        }
        String siteDefaultLanguageId = LanguageUtil.getLanguageId((Locale)siteDefaultLocale);
        if (siteDefaultLanguageId.startsWith(languageId)) {
            languageId = siteDefaultLocale.getLanguage();
        }
        return "/".concat(LocaleUtil.toW3cLanguageId((String)languageId));
    }

    private boolean _containsHostname(TreeMap<String, String> virtualHostnames, String portalDomain) {
        int pos = portalDomain.indexOf(58);
        if (pos > 0) {
            portalDomain = portalDomain.substring(0, pos);
        }
        return virtualHostnames.containsKey(portalDomain) || portalDomain.contains("xn--") && virtualHostnames.containsKey(IDN.toUnicode(portalDomain));
    }

    private String _get18nErrorRedirect(HttpServletRequest httpServletRequest, String redirect) {
        String i18nErrorPath = GetterUtil.getString((Object)httpServletRequest.getAttribute("I18N_ERROR_PATH"));
        if (Validator.isNull((String)i18nErrorPath)) {
            return redirect;
        }
        return i18nErrorPath.concat(redirect);
    }

    private List<Portlet> _getAllNonembeddedPortlets(Layout layout, LayoutTypePortlet layoutTypePortlet) {
        List staticPortlets = layoutTypePortlet.getStaticPortlets("layout.static.portlets.all");
        List<Portlet> explicitlyAddedPortlets = new ArrayList();
        if (layout.isTypeAssetDisplay() || layout.isTypeContent()) {
            List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferencesByPlid((long)layout.getPlid());
            for (PortletPreferences portletPreferences : portletPreferencesList) {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletPreferences.getPortletId());
                if (portlet == null) continue;
                explicitlyAddedPortlets.add(portlet);
            }
        } else {
            explicitlyAddedPortlets = layoutTypePortlet.getExplicitlyAddedPortlets(false);
        }
        return layoutTypePortlet.addStaticPortlets(explicitlyAddedPortlets, staticPortlets, null);
    }

    private Map<Locale, String> _getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout, Set<Locale> availableLocales) throws PortalException {
        String i18nPath;
        int y;
        String defaultVirtualHostname = this._getDefaultVirtualHostname(themeDisplay.getCompany());
        String portalDomain = themeDisplay.getPortalDomain();
        TreeMap<String, String> virtualHostnames = this.getVirtualHostnames(themeDisplay.getLayoutSet());
        String virtualHostname = this._getVirtualHostname(virtualHostnames, themeDisplay);
        if (!Validator.isBlank((String)portalDomain) && !StringUtil.equalsIgnoreCase((String)portalDomain, (String)defaultVirtualHostname) && StringUtil.equalsIgnoreCase((String)virtualHostname, (String)defaultVirtualHostname) || virtualHostnames.containsKey(portalDomain)) {
            virtualHostname = portalDomain;
        }
        HashMap<Locale, String> alternateURLs = new HashMap<Locale, String>();
        if (Validator.isNull((String)virtualHostname)) {
            for (Locale locale : availableLocales) {
                String i18nPath2 = this._buildI18NPath(locale, themeDisplay.getSiteGroup());
                alternateURLs.put(locale, canonicalURL.replaceFirst(_PUBLIC_GROUP_SERVLET_MAPPING, i18nPath2.concat(_PUBLIC_GROUP_SERVLET_MAPPING)));
            }
            return alternateURLs;
        }
        int pos = canonicalURL.indexOf(virtualHostname);
        if (pos < 0) {
            pos = canonicalURL.indexOf(portalDomain);
            virtualHostname = portalDomain;
        }
        if (pos > 0) {
            pos = canonicalURL.indexOf(47, pos + virtualHostname.length());
            if (Validator.isNotNull((String)this._pathContext)) {
                pos = canonicalURL.indexOf(47, pos + this._pathContext.length());
            }
        }
        Locale siteDefaultLocale = this.getSiteDefaultLocale(layout.getGroupId());
        if (pos <= 0 || pos >= canonicalURL.length()) {
            for (Locale locale : availableLocales) {
                if (siteDefaultLocale.equals(locale) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE != 2) {
                    alternateURLs.put(locale, canonicalURL);
                    continue;
                }
                alternateURLs.put(locale, StringBundler.concat((String[])new String[]{canonicalURL, this._buildI18NPath(locale, themeDisplay.getSiteGroup()), "/"}));
            }
            return alternateURLs;
        }
        boolean replaceFriendlyURL = true;
        String currentURL = canonicalURL.substring(pos);
        int[] groupFriendlyURLIndex = this.getGroupFriendlyURLIndex(currentURL);
        if (groupFriendlyURLIndex != null && (currentURL = currentURL.substring(y = groupFriendlyURLIndex[1])).equals("/")) {
            replaceFriendlyURL = false;
        }
        List layoutFriendlyURLs = null;
        String groupFriendlyURLPrefix = null;
        if (replaceFriendlyURL) {
            layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                layout = virtualLayout.getSourceLayout();
                Group group = layout.getGroup();
                groupFriendlyURLPrefix = "/~".concat(group.getFriendlyURL());
            }
        }
        String canonicalURLPrefix = canonicalURL.substring(0, pos);
        String canonicalURLSuffix = canonicalURL.substring(pos);
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2 && canonicalURLSuffix.startsWith(i18nPath = this._buildI18NPath(siteDefaultLocale, layout.getGroup()))) {
            canonicalURLSuffix = canonicalURLSuffix.substring(i18nPath.length());
        }
        String groupFriendlyURL = "";
        if (!currentURL.equals(canonicalURLSuffix) && groupFriendlyURLIndex != null) {
            groupFriendlyURL = canonicalURLSuffix.substring(0, groupFriendlyURLIndex[1]);
        }
        for (Locale locale : availableLocales) {
            String alternateURL = canonicalURL;
            String alternateURLSuffix = null;
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            if (replaceFriendlyURL) {
                String[] urlSeparators;
                for (String urlSeparator : urlSeparators = FriendlyURLResolverRegistryUtil.getURLSeparators()) {
                    if (!currentURL.startsWith(urlSeparator)) continue;
                    FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver((String)urlSeparator);
                    HttpServletRequest httpServletRequest = themeDisplay.getRequest();
                    try {
                        LayoutFriendlyURLComposite layoutFriendlyURLComposite = friendlyURLResolver.getLayoutFriendlyURLComposite(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), false, currentURL, httpServletRequest.getParameterMap(), (Map)HashMapBuilder.put((Object)"request", (Object)httpServletRequest).put((Object)"LOCALE", (Object)locale).build());
                        alternateURLSuffix = groupFriendlyURL + layoutFriendlyURLComposite.getFriendlyURL();
                        break;
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Throwable)portalException);
                    }
                }
                if (Validator.isNull(alternateURLSuffix)) {
                    alternateURLSuffix = canonicalURLSuffix;
                    String friendlyURL = null;
                    for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                        if (!languageId.equals(layoutFriendlyURL.getLanguageId())) continue;
                        friendlyURL = layoutFriendlyURL.getFriendlyURL();
                        if (groupFriendlyURLPrefix == null) break;
                        friendlyURL = groupFriendlyURLPrefix.concat(friendlyURL);
                        break;
                    }
                    if (friendlyURL != null) {
                        alternateURLSuffix = StringUtil.replaceFirst((String)alternateURLSuffix, (String)layout.getFriendlyURL(), friendlyURL);
                    }
                }
                alternateURL = canonicalURLPrefix.concat(alternateURLSuffix);
            }
            if (siteDefaultLocale.equals(locale) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE != 2) {
                alternateURLs.put(locale, alternateURL);
                continue;
            }
            alternateURLs.put(locale, StringBundler.concat((String[])new String[]{canonicalURLPrefix, this._buildI18NPath(languageId, locale, themeDisplay.getSiteGroup()), alternateURLSuffix}));
        }
        return alternateURLs;
    }

    private String _getDefaultVirtualHostname(Company company) {
        if (company != null && Validator.isNotNull((String)company.getVirtualHostname())) {
            return company.getVirtualHostname();
        }
        return _LOCALHOST;
    }

    private String _getGroupFriendlyURL(Group group, LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL, boolean controlPanel) throws PortalException {
        Layout refererLayout;
        long refererPlid;
        boolean privateLayoutSet = layoutSet.isPrivateLayout();
        String portalURL = themeDisplay.getPortalURL();
        boolean useGroupVirtualHostname = false;
        String defaultVirtualHostname = _LOCALHOST;
        Company company = themeDisplay.getCompany();
        if (company != null && Validator.isNotNull((String)company.getVirtualHostname())) {
            defaultVirtualHostname = company.getVirtualHostname();
        }
        if (canonicalURL || !StringUtil.equalsIgnoreCase((String)themeDisplay.getServerName(), (String)defaultVirtualHostname)) {
            useGroupVirtualHostname = true;
        }
        if ((refererPlid = themeDisplay.getRefererPlid()) > 0L && (refererLayout = LayoutLocalServiceUtil.fetchLayout((long)refererPlid)) != null && (refererLayout.getGroupId() != group.getGroupId() || refererLayout.isPrivateLayout() != privateLayoutSet)) {
            useGroupVirtualHostname = false;
        }
        String portalDomain = themeDisplay.getPortalDomain();
        TreeMap<String, String> virtualHostnames = this.getVirtualHostnames(layoutSet);
        if (useGroupVirtualHostname) {
            if (!(virtualHostnames.isEmpty() || !canonicalURL && virtualHostnames.containsKey(defaultVirtualHostname))) {
                if (!controlPanel || !privateLayoutSet) {
                    if (canonicalURL) {
                        String path = "";
                        if (themeDisplay.isWidget()) {
                            path = PropsValues.WIDGET_SERVLET_MAPPING;
                        }
                        if (!virtualHostnames.containsKey(defaultVirtualHostname) && !this._containsHostname(virtualHostnames, portalDomain)) {
                            portalURL = this.getPortalURL(virtualHostnames.firstKey(), themeDisplay.getServerPort(), themeDisplay.isSecure());
                        }
                        return StringBundler.concat((String[])new String[]{portalURL, this._pathContext, path});
                    }
                    if (this._containsHostname(virtualHostnames, portalDomain)) {
                        String path = "";
                        if (themeDisplay.isWidget()) {
                            path = PropsValues.WIDGET_SERVLET_MAPPING;
                        }
                        if (themeDisplay.isI18n()) {
                            path = themeDisplay.getI18nPath();
                        }
                        return StringBundler.concat((String[])new String[]{portalURL, this._pathContext, path});
                    }
                }
            } else if (canonicalURL || layoutSet.getGroupId() != themeDisplay.getSiteGroupId() && group.getClassPK() != themeDisplay.getUserId()) {
                if (group.isControlPanel() || controlPanel) {
                    virtualHostnames = new TreeMap();
                    String serverName = themeDisplay.getServerName();
                    if (Validator.isNotNull((String)serverName) && !serverName.equals(defaultVirtualHostname)) {
                        virtualHostnames.put(serverName, "");
                    } else {
                        LayoutSet curLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)themeDisplay.getSiteGroupId(), (boolean)privateLayoutSet);
                        virtualHostnames = curLayoutSet.getVirtualHostnames();
                    }
                }
                if (virtualHostnames.isEmpty() || virtualHostnames.containsKey(defaultVirtualHostname)) {
                    virtualHostnames = TreeMapBuilder.put((Object)defaultVirtualHostname, (Object)"").build();
                }
                if (canonicalURL || !virtualHostnames.containsKey(defaultVirtualHostname)) {
                    String virtualHostname = this.getCanonicalDomain(virtualHostnames, portalDomain, defaultVirtualHostname);
                    portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                }
            }
        }
        StringBundler sb = new StringBundler(6);
        sb.append(portalURL);
        sb.append(this._pathContext);
        if (themeDisplay.isI18n() && !canonicalURL && LanguageUtil.isAvailableLocale((long)group.getGroupId(), (String)themeDisplay.getI18nLanguageId())) {
            sb.append(themeDisplay.getI18nPath());
        }
        if (themeDisplay.isWidget()) {
            sb.append(PropsValues.WIDGET_SERVLET_MAPPING);
        }
        if (privateLayoutSet) {
            if (group.isUser()) {
                sb.append(_PRIVATE_USER_SERVLET_MAPPING);
            } else {
                sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
            }
            sb.append(group.getFriendlyURL());
        } else if (!StringUtil.equals((String)group.getGroupKey(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) || !StringUtil.equalsIgnoreCase((String)portalDomain, (String)defaultVirtualHostname) && !this._containsHostname(virtualHostnames, portalDomain)) {
            sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
            sb.append(group.getFriendlyURL());
        }
        return sb.toString();
    }

    private String _getPortalURL(String serverName, int serverPort, boolean secure) {
        StringBundler sb = new StringBundler(4);
        boolean https = false;
        if (secure || StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL)) {
            https = true;
        }
        if (https) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(serverName);
        if (!https) {
            if (PropsValues.WEB_SERVER_HTTP_PORT == -1) {
                if (serverPort != -1 && serverPort != 80 && serverPort != 443) {
                    sb.append(":");
                    sb.append(serverPort);
                }
            } else if (PropsValues.WEB_SERVER_HTTP_PORT != 80) {
                sb.append(":");
                sb.append(PropsValues.WEB_SERVER_HTTP_PORT);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT == -1) {
            if (serverPort != -1 && serverPort != 80 && serverPort != 443) {
                sb.append(":");
                sb.append(serverPort);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT != 443) {
            sb.append(":");
            sb.append(PropsValues.WEB_SERVER_HTTPS_PORT);
        }
        return sb.toString();
    }

    private String _getPortletBaseResource(Portlet portlet) {
        for (String modelName : ResourceActionsUtil.getPortletModelResources((String)portlet.getRootPortletId())) {
            if (modelName.contains(".model.")) continue;
            return modelName;
        }
        return null;
    }

    private LayoutQueryStringComposite _getPortletFriendlyURLMapperLayoutQueryStringComposite(String url, Map<String, String[]> params, Map<String, Object> requestContext) {
        int x;
        boolean foundFriendlyURLMapper = false;
        String friendlyURL = url;
        String queryString = "";
        List portlets = PortletLocalServiceUtil.getFriendlyURLMapperPortlets();
        for (Portlet portlet : portlets) {
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (url.endsWith("/" + friendlyURLMapper.getMapping())) {
                url = url + "/";
            }
            int pos = -1;
            pos = friendlyURLMapper.isCheckMappingWithPrefix() ? url.indexOf("/-/" + friendlyURLMapper.getMapping() + "/") : url.indexOf("/" + friendlyURLMapper.getMapping() + "/");
            if (pos == -1) continue;
            foundFriendlyURLMapper = true;
            friendlyURL = url.substring(0, pos);
            InheritableMap actualParams = new InheritableMap();
            if (params != null) {
                actualParams.setParentMap(params);
            }
            HashMap<String, String> prpIdentifiers = new HashMap<String, String>();
            Set publicRenderParameters = portlet.getPublicRenderParameters();
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                QName qName = publicRenderParameter.getQName();
                String publicRenderParameterIdentifier = qName.getLocalPart();
                prpIdentifiers.put(publicRenderParameterIdentifier, PortletQNameUtil.getPublicRenderParameterName((QName)qName));
            }
            FriendlyURLMapperThreadLocal.setPRPIdentifiers(prpIdentifiers);
            if (friendlyURLMapper.isCheckMappingWithPrefix()) {
                friendlyURLMapper.populateParams(url.substring(pos + 2), (Map)actualParams, requestContext);
            } else {
                friendlyURLMapper.populateParams(url.substring(pos), (Map)actualParams, requestContext);
            }
            String actualParamsString = HttpComponentsUtil.parameterMapToString((Map)actualParams, (boolean)false);
            queryString = "&" + actualParamsString;
            break;
        }
        if (!foundFriendlyURLMapper && (x = url.indexOf("/-/")) != -1) {
            String ppid;
            int y = url.indexOf(47, x + 3);
            if (y == -1) {
                y = url.length();
            }
            if (Validator.isNotNull((String)(ppid = url.substring(x + 3, y)))) {
                friendlyURL = url.substring(0, x);
                HashMap<Object, Object> actualParams = null;
                actualParams = params != null ? new HashMap<String, String[]>(params) : new HashMap();
                actualParams.put("p_p_id", new String[]{ppid});
                actualParams.put("p_p_lifecycle", new String[]{"0"});
                actualParams.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
                actualParams.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
                String result = HttpComponentsUtil.parameterMapToString(actualParams, (boolean)false);
                queryString = "&" + result;
            }
        }
        if ((friendlyURL = StringUtil.replace((String)friendlyURL, (String)"//", (String)"/")).endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        return new LayoutQueryStringComposite(null, friendlyURL, queryString);
    }

    private String _getPortletTitle(String rootPortletId, PortletConfig portletConfig, Locale locale) {
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)StringBundler.concat((String[])new String[]{"javax.portlet.title", ".", rootPortletId}), null);
        if (Validator.isNull((String)portletTitle)) {
            portletTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"javax.portlet.title");
        }
        return portletTitle;
    }

    private long _getScopeGroupId(ThemeDisplay themeDisplay, Layout layout, String portletId) {
        if (layout == null) {
            return 0L;
        }
        if (Validator.isNull((String)portletId)) {
            return layout.getGroupId();
        }
        javax.portlet.PortletPreferences portletSetup = null;
        portletSetup = themeDisplay == null ? PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup((Layout)layout, (String)portletId) : themeDisplay.getStrictLayoutPortletSetup(layout, portletId);
        String scopeType = GetterUtil.getString((String)portletSetup.getValue("lfrScopeType", null));
        if (Validator.isNull((String)scopeType)) {
            return layout.getGroupId();
        }
        if (scopeType.equals("company")) {
            Group companyGroup = GroupLocalServiceUtil.fetchCompanyGroup((long)layout.getCompanyId());
            if (companyGroup == null) {
                return layout.getGroupId();
            }
            return companyGroup.getGroupId();
        }
        String scopeLayoutUuid = GetterUtil.getString((String)portletSetup.getValue("lfrScopeLayoutUuid", null));
        Layout scopeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout());
        if (scopeLayout == null) {
            return layout.getGroupId();
        }
        Group scopeGroup = GroupLocalServiceUtil.fetchGroup((long)scopeLayout.getCompanyId(), (long)this.getClassNameId(Layout.class), (long)scopeLayout.getPlid());
        if (scopeGroup == null) {
            return layout.getGroupId();
        }
        return scopeGroup.getGroupId();
    }

    private Group _getSiteGroup(long groupId) {
        if (groupId <= 0L) {
            return null;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            return null;
        }
        if (group.isLayout()) {
            return group.getParentGroup();
        }
        return group;
    }

    private String _getVirtualHostname(TreeMap<String, String> virtualHostnames, ThemeDisplay themeDisplay) {
        if (virtualHostnames.isEmpty()) {
            Company company = themeDisplay.getCompany();
            return company.getVirtualHostname();
        }
        return virtualHostnames.firstKey();
    }

    private boolean _layoutContainsPortletId(Layout layout, String portletId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : this._getAllNonembeddedPortlets(layout, layoutTypePortlet)) {
            if (!portletId.equals(portlet.getPortletId()) && !portletId.equals(portlet.getRootPortletId())) continue;
            return true;
        }
        return false;
    }

    private boolean _requiresLayoutFriendlyURL(String siteGroupFriendlyURL, String layoutFriendlyURL, String groupFriendlyURL) {
        return groupFriendlyURL.contains(_PUBLIC_GROUP_SERVLET_MAPPING + "/") ? groupFriendlyURL.contains(StringBundler.concat((String[])new String[]{_PUBLIC_GROUP_SERVLET_MAPPING, siteGroupFriendlyURL, StringUtil.toLowerCase((String)layoutFriendlyURL)})) : groupFriendlyURL.contains(StringUtil.toLowerCase((String)layoutFriendlyURL));
    }

    static {
        _PORTLET_RESOURCE_ID_URL_DECODE_COUNT = GetterUtil.getInteger((String)PropsUtil.get("portlet.resource.id.url.decode.count"), (int)10);
        _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        _log = LogFactoryUtil.getLog(PortalImpl.class);
        _bannedResourceIdPattern = Pattern.compile(PropsValues.PORTLET_RESOURCE_ID_BANNED_PATHS_REGEXP, 2);
        _cdnHostHttpMap = new ConcurrentHashMap<Long, String>();
        _cdnHostHttpsMap = new ConcurrentHashMap<Long, String>();
        _resetCDNHostsMethodHandler = new MethodHandler(new MethodKey(PortalUtil.class, "resetCDNHosts", new Class[0]), new Object[0]);
        _upTime = new Date();
        _webServerServletLog = LogFactoryUtil.getLog(WebServerServlet.class);
        Locale locale = LocaleUtil.getDefault();
        _NULL_LOCALE = (Locale)locale.clone();
    }

    private class PortalInetSocketAddressEventListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInetSocketAddressEventListener, PortalInetSocketAddressEventListener> {
        private PortalInetSocketAddressEventListenerServiceTrackerCustomizer() {
        }

        public PortalInetSocketAddressEventListener addingService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference) {
            PortalInetSocketAddressEventListener portalInetSocketAddressEventListener = (PortalInetSocketAddressEventListener)PortalImpl.this._bundleContext.getService(serviceReference);
            PortalImpl.this.addPortalInetSocketAddressEventListener(portalInetSocketAddressEventListener);
            return portalInetSocketAddressEventListener;
        }

        public void modifiedService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference, PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        }

        public void removedService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference, PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
            PortalImpl.this._bundleContext.ungetService(serviceReference);
            PortalImpl.this.removePortalInetSocketAddressEventListener(portalInetSocketAddressEventListener);
        }
    }

    private class CommentsStrutsActionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<StrutsAction, StrutsAction> {
        private CommentsStrutsActionServiceTrackerCustomizer() {
        }

        public StrutsAction addingService(ServiceReference<StrutsAction> serviceReference) {
            String path = GetterUtil.getString((Object)serviceReference.getProperty("path"));
            StrutsAction strutsAction = (StrutsAction)PortalImpl.this._bundleContext.getService(serviceReference);
            if (Objects.equals(path, "/portal/comment/discussion/edit")) {
                PortalImpl.this._editDiscussionStrutsAction = strutsAction;
            } else if (Objects.equals(path, "/portal/comment/discussion/get_comments")) {
                PortalImpl.this._getCommentsStrutsAction = strutsAction;
            }
            return strutsAction;
        }

        public void modifiedService(ServiceReference<StrutsAction> serviceReference, StrutsAction strutsAction) {
            this.removedService(serviceReference, strutsAction);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<StrutsAction> serviceReference, StrutsAction strutsAction) {
            String path = GetterUtil.getString((Object)serviceReference.getProperty("path"));
            if (Objects.equals(path, "/portal/comment/discussion/edit")) {
                PortalImpl.this._editDiscussionStrutsAction = null;
            } else if (Objects.equals(path, "/portal/comment/discussion/get_comments")) {
                PortalImpl.this._getCommentsStrutsAction = null;
            }
            PortalImpl.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class AlwaysAllowDoAsUserServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AlwaysAllowDoAsUser, AlwaysAllowDoAsUser> {
        private AlwaysAllowDoAsUserServiceTrackerCustomizer() {
        }

        public AlwaysAllowDoAsUser addingService(ServiceReference<AlwaysAllowDoAsUser> serviceReference) {
            AlwaysAllowDoAsUser alwaysAllowDoAsUser = (AlwaysAllowDoAsUser)PortalImpl.this._bundleContext.getService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add alway sallow do as user " + ClassUtil.getClassName((Object)alwaysAllowDoAsUser)));
            }
            PortalImpl.this._alwaysAllowDoAsUsers.add(alwaysAllowDoAsUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("There are " + PortalImpl.this._alwaysAllowDoAsUsers.size() + " alway sallow do as user instances"));
            }
            return alwaysAllowDoAsUser;
        }

        public void modifiedService(ServiceReference<AlwaysAllowDoAsUser> serviceReference, AlwaysAllowDoAsUser alwaysAllowDoAsUser) {
        }

        public void removedService(ServiceReference<AlwaysAllowDoAsUser> serviceReference, AlwaysAllowDoAsUser alwaysAllowDoAsUser) {
            PortalImpl.this._bundleContext.ungetService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Delete alway sallow do as user " + ClassUtil.getClassName((Object)alwaysAllowDoAsUser)));
            }
            PortalImpl.this._alwaysAllowDoAsUsers.remove(alwaysAllowDoAsUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("There are " + PortalImpl.this._alwaysAllowDoAsUsers.size() + " alway sallow do as user instances"));
            }
        }
    }
}

