/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.TreeMap;

public class RobotsUtil {
    private static final Log _log = LogFactoryUtil.getLog(RobotsUtil.class);

    public static String getRobots(LayoutSet layoutSet, boolean secure) throws PortalException {
        if (layoutSet == null) {
            try {
                return com.liferay.petra.string.StringUtil.read((ClassLoader)RobotsUtil.class.getClassLoader(), (String)PropsValues.ROBOTS_TXT_WITHOUT_SITEMAP);
            }
            catch (IOException ioException) {
                _log.error((Object)("Unable to read the content for " + PropsValues.ROBOTS_TXT_WITHOUT_SITEMAP));
            }
        }
        int portalServerPort = PortalUtil.getPortalServerPort((boolean)secure);
        TreeMap virtualHostnames = PortalUtil.getVirtualHostnames((LayoutSet)layoutSet);
        String virtualHostname = "";
        if (!virtualHostnames.isEmpty()) {
            virtualHostname = (String)virtualHostnames.firstKey();
        }
        String robotsTxt = null;
        try {
            robotsTxt = GetterUtil.getString((String)layoutSet.getSettingsProperty(layoutSet.isPrivateLayout() + "-robots.txt"), (String)StringUtil.read((ClassLoader)RobotsUtil.class.getClassLoader(), (String)PropsValues.ROBOTS_TXT_WITH_SITEMAP));
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to read the content for " + PropsValues.ROBOTS_TXT_WITH_SITEMAP));
        }
        return RobotsUtil._replaceWildcards(robotsTxt, virtualHostname, secure, portalServerPort);
    }

    private static String _replaceWildcards(String robotsTxt, String virtualHostname, boolean secure, int port) {
        if (Validator.isNotNull((String)virtualHostname)) {
            robotsTxt = StringUtil.replace((String)robotsTxt, (String)"[$HOST$]", (String)virtualHostname);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)"Placeholder [$HOST$] could not be replaced with the actual host");
        }
        robotsTxt = StringUtil.replace((String)robotsTxt, (String)"[$PORT$]", (String)String.valueOf(port));
        if (secure) {
            return StringUtil.replace((String)robotsTxt, (String)"[$PROTOCOL$]", (String)"https");
        }
        return StringUtil.replace((String)robotsTxt, (String)"[$PROTOCOL$]", (String)"http");
    }
}

