/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.verify.model.VerifiableGroupedModel;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class VerifyGroupedModel
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyGroupedModel.class);

    public void verify(VerifiableGroupedModel ... verifiableGroupedModels) throws Exception {
        ArrayList<String> unverifiedTableNames = new ArrayList<String>();
        for (VerifiableGroupedModel verifiableGroupedModel2 : verifiableGroupedModels) {
            unverifiedTableNames.add(verifiableGroupedModel2.getTableName());
        }
        if (unverifiedTableNames.isEmpty()) {
            return;
        }
        int count = unverifiedTableNames.size();
        this.processConcurrently(verifiableGroupedModels, verifiableGroupedModel -> {
            if (unverifiedTableNames.contains(verifiableGroupedModel.getRelatedTableName()) || !unverifiedTableNames.contains(verifiableGroupedModel.getTableName())) {
                return;
            }
            unverifiedTableNames.remove(verifiableGroupedModel.getTableName());
            if (unverifiedTableNames.size() == count) {
                throw new VerifyException("Circular dependency detected " + unverifiedTableNames);
            }
            this.verifyGroupedModel((VerifiableGroupedModel)verifiableGroupedModel);
        }, null);
    }

    @Override
    protected void doVerify() throws Exception {
        Map verifiableGroupedModelsMap = PortalBeanLocatorUtil.locate(VerifiableGroupedModel.class);
        Collection verifiableGroupedModels = verifiableGroupedModelsMap.values();
        this.verify(verifiableGroupedModels.toArray(new VerifiableGroupedModel[0]));
    }

    /*
     * Exception decompiling
     */
    protected long getGroupId(Connection connection, String tableName, String primaryKeColumnName, long primKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean isForceConcurrent(Collection<? extends Callable<Void>> callables) {
        return true;
    }

    protected void verifyGroupedModel(VerifiableGroupedModel verifiableGroupedModel) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableGroupedModel.getTableName());
             Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement1 = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", verifiableGroupedModel.getPrimaryKeyColumnName(), ", ", verifiableGroupedModel.getRelatedPrimaryKeyColumnName(), " from ", verifiableGroupedModel.getTableName(), " where groupId is null"}));
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)StringBundler.concat((String[])new String[]{"update ", verifiableGroupedModel.getTableName(), " set groupId = ? where ", verifiableGroupedModel.getPrimaryKeyColumnName(), " = ?"}));){
            while (resultSet.next()) {
                long relatedPrimKey = resultSet.getLong(verifiableGroupedModel.getRelatedPrimaryKeyColumnName());
                long groupId = this.getGroupId(connection, verifiableGroupedModel.getRelatedTableName(), verifiableGroupedModel.getRelatedPrimaryKeyColumnName(), relatedPrimKey);
                if (groupId <= 0L) continue;
                preparedStatement2.setLong(1, groupId);
                long primKey = resultSet.getLong(verifiableGroupedModel.getPrimaryKeyColumnName());
                preparedStatement2.setLong(2, primKey);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

