/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.petra.xml.DocUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.service.WebDAVPropsLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePropMethodImpl
implements Method {
    public static final QName ALLPROP = BasePropMethodImpl.createQName("allprop");
    public static final QName CREATIONDATE = BasePropMethodImpl.createQName("creationdate");
    public static final QName DISPLAYNAME = BasePropMethodImpl.createQName("displayname");
    public static final QName GETCONTENTLENGTH = BasePropMethodImpl.createQName("getcontentlength");
    public static final QName GETCONTENTTYPE = BasePropMethodImpl.createQName("getcontenttype");
    public static final QName GETLASTMODIFIED = BasePropMethodImpl.createQName("getlastmodified");
    public static final QName ISREADONLY = BasePropMethodImpl.createQName("isreadonly");
    public static final QName LOCKDISCOVERY = BasePropMethodImpl.createQName("lockdiscovery");
    public static final QName RESOURCETYPE = BasePropMethodImpl.createQName("resourcetype");
    private static final Log _log = LogFactoryUtil.getLog(BasePropMethodImpl.class);
    private static final List<QName> _allCollectionProps = Arrays.asList(CREATIONDATE, DISPLAYNAME, GETLASTMODIFIED, GETCONTENTTYPE, LOCKDISCOVERY, RESOURCETYPE);
    private static final List<QName> _allSimpleProps = Arrays.asList(CREATIONDATE, DISPLAYNAME, GETLASTMODIFIED, GETCONTENTTYPE, GETCONTENTLENGTH, ISREADONLY, LOCKDISCOVERY, RESOURCETYPE);

    protected static QName createQName(String name) {
        return SAXReaderUtil.createQName((String)name, (Namespace)WebDAVUtil.DAV_URI);
    }

    protected void addResponse(String href, Element multistatusElement) throws Exception {
        Element responseElement = DocUtil.add((Element)multistatusElement, (QName)BasePropMethodImpl.createQName("response"));
        DocUtil.add((Element)responseElement, (QName)BasePropMethodImpl.createQName("href"), (String)href);
        Element propstatElement = DocUtil.add((Element)responseElement, (QName)BasePropMethodImpl.createQName("propstat"));
        DocUtil.add((Element)propstatElement, (QName)BasePropMethodImpl.createQName("status"), (String)"HTTP/1.1 404 Not Found");
    }

    protected void addResponse(WebDAVRequest webDAVRequest, Resource resource, Set<QName> props, Element multistatus) throws Exception {
        Lock lock;
        props = new HashSet<QName>(props);
        Element responseElement = DocUtil.add((Element)multistatus, (QName)BasePropMethodImpl.createQName("response"));
        DocUtil.add((Element)responseElement, (QName)BasePropMethodImpl.createQName("href"), (String)resource.getHREF());
        Element successStatElement = DocUtil.add((Element)responseElement, (QName)BasePropMethodImpl.createQName("propstat"));
        Element successPropElement = DocUtil.add((Element)successStatElement, (QName)BasePropMethodImpl.createQName("prop"));
        Element failureStatElement = DocUtil.add((Element)responseElement, (QName)BasePropMethodImpl.createQName("propstat"));
        Element failurePropElement = DocUtil.add((Element)failureStatElement, (QName)BasePropMethodImpl.createQName("prop"));
        boolean hasSuccess = false;
        boolean hasFailure = false;
        if (props.contains(ALLPROP)) {
            props.remove(ALLPROP);
            if (resource.isCollection()) {
                props.addAll(_allCollectionProps);
            } else {
                props.addAll(_allSimpleProps);
            }
        }
        if (props.contains(CREATIONDATE)) {
            props.remove(CREATIONDATE);
            DocUtil.add((Element)successPropElement, (QName)CREATIONDATE, (String)resource.getCreateDateString());
            hasSuccess = true;
        }
        if (props.contains(DISPLAYNAME)) {
            props.remove(DISPLAYNAME);
            DocUtil.add((Element)successPropElement, (QName)DISPLAYNAME, (String)resource.getDisplayName());
            hasSuccess = true;
        }
        if (props.contains(GETLASTMODIFIED)) {
            props.remove(GETLASTMODIFIED);
            DocUtil.add((Element)successPropElement, (QName)GETLASTMODIFIED, (String)resource.getModifiedDate());
            hasSuccess = true;
        }
        if (props.contains(GETCONTENTTYPE)) {
            props.remove(GETCONTENTTYPE);
            DocUtil.add((Element)successPropElement, (QName)GETCONTENTTYPE, (String)resource.getContentType());
            hasSuccess = true;
        }
        if (props.contains(GETCONTENTLENGTH)) {
            props.remove(GETCONTENTLENGTH);
            if (!resource.isCollection()) {
                DocUtil.add((Element)successPropElement, (QName)GETCONTENTLENGTH, (long)resource.getSize());
                hasSuccess = true;
            } else {
                DocUtil.add((Element)failurePropElement, (QName)GETCONTENTLENGTH);
                hasFailure = true;
            }
        }
        if (props.contains(ISREADONLY)) {
            props.remove(ISREADONLY);
            lock = resource.getLock();
            if (lock == null || resource.isLocked()) {
                DocUtil.add((Element)successPropElement, (QName)ISREADONLY, (String)Boolean.FALSE.toString());
            } else {
                DocUtil.add((Element)successPropElement, (QName)ISREADONLY, (String)Boolean.TRUE.toString());
            }
            hasSuccess = true;
        }
        if (props.contains(LOCKDISCOVERY)) {
            props.remove(LOCKDISCOVERY);
            lock = resource.getLock();
            if (lock != null) {
                Element lockDiscoveryElement = DocUtil.add((Element)successPropElement, (QName)LOCKDISCOVERY);
                Element activeLockElement = DocUtil.add((Element)lockDiscoveryElement, (QName)BasePropMethodImpl.createQName("activelock"));
                Element lockTypeElement = DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("locktype"));
                DocUtil.add((Element)lockTypeElement, (QName)BasePropMethodImpl.createQName("write"));
                Element lockScopeElement = DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("lockscope"));
                DocUtil.add((Element)lockScopeElement, (QName)BasePropMethodImpl.createQName("exclusive"));
                if (resource.isCollection()) {
                    DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("depth"), (String)"Infinity");
                }
                DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("owner"), (String)lock.getOwner());
                long timeRemaining = 0L;
                Date expirationDate = lock.getExpirationDate();
                if (expirationDate != null) {
                    long now = System.currentTimeMillis();
                    timeRemaining = (expirationDate.getTime() - now) / 1000L;
                    if (timeRemaining <= 0L) {
                        timeRemaining = 1L;
                    }
                }
                if (timeRemaining > 0L) {
                    DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("timeout"), (String)("Second-" + timeRemaining));
                } else {
                    DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("timeout"), (String)"Infinite");
                }
                if (webDAVRequest.getUserId() == lock.getUserId()) {
                    Element lockTokenElement = DocUtil.add((Element)activeLockElement, (QName)BasePropMethodImpl.createQName("locktoken"));
                    DocUtil.add((Element)lockTokenElement, (QName)BasePropMethodImpl.createQName("href"), (String)("opaquelocktoken:" + lock.getUuid()));
                }
                hasSuccess = true;
            } else {
                DocUtil.add((Element)failurePropElement, (QName)LOCKDISCOVERY);
                hasFailure = true;
            }
        }
        if (props.contains(RESOURCETYPE)) {
            props.remove(RESOURCETYPE);
            Element resourceTypeElement = DocUtil.add((Element)successPropElement, (QName)RESOURCETYPE);
            if (resource.isCollection()) {
                DocUtil.add((Element)resourceTypeElement, (QName)BasePropMethodImpl.createQName("collection"));
            }
            hasSuccess = true;
        }
        WebDAVProps webDAVProps = WebDAVPropsLocalServiceUtil.getWebDAVProps((long)webDAVRequest.getCompanyId(), (String)resource.getClassName(), (long)resource.getPrimaryKey());
        Set customProps = webDAVProps.getPropsSet();
        for (QName qName : props) {
            if (customProps.contains(qName)) {
                Namespace namespace = qName.getNamespace();
                String text = webDAVProps.getText(qName.getName(), namespace.getPrefix(), namespace.getURI());
                DocUtil.add((Element)successPropElement, (QName)qName, (String)text);
                hasSuccess = true;
                continue;
            }
            DocUtil.add((Element)failurePropElement, (QName)qName);
            hasFailure = true;
        }
        if (hasSuccess) {
            DocUtil.add((Element)successStatElement, (QName)BasePropMethodImpl.createQName("status"), (String)"HTTP/1.1 200 OK");
        } else {
            responseElement.remove(successStatElement);
        }
        if (!hasSuccess && hasFailure) {
            DocUtil.add((Element)failureStatElement, (QName)BasePropMethodImpl.createQName("status"), (String)"HTTP/1.1 404 Not Found");
        } else {
            responseElement.remove(failureStatElement);
        }
    }

    protected void addResponse(WebDAVStorage storage, WebDAVRequest webDAVRequest, Resource resource, Set<QName> props, Element multistatusElement, long depth) throws Exception {
        this.addResponse(webDAVRequest, resource, props, multistatusElement);
        if (resource.isCollection() && depth != 0L) {
            List storageResources = storage.getResources(webDAVRequest);
            for (Resource storageResource : storageResources) {
                this.addResponse(webDAVRequest, storageResource, props, multistatusElement);
            }
        }
    }

    protected int writeResponseXML(WebDAVRequest webDAVRequest, Set<QName> props) throws Exception {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        Document document = SAXReaderUtil.createDocument();
        Element multistatusElement = SAXReaderUtil.createElement((QName)BasePropMethodImpl.createQName("multistatus"));
        document.setRootElement(multistatusElement);
        Resource resource = storage.getResource(webDAVRequest);
        if (resource != null) {
            int status;
            block5: {
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDAVRequest.getHttpServletRequest());
                this.addResponse(storage, webDAVRequest, resource, props, multistatusElement, depth);
                String xml = document.formattedString("    ");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Response XML\n" + xml));
                }
                status = 207;
                HttpServletResponse httpServletResponse = webDAVRequest.getHttpServletResponse();
                httpServletResponse.setContentType("text/xml; charset=UTF-8");
                httpServletResponse.setStatus(status);
                try {
                    ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)xml);
                    httpServletResponse.flushBuffer();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Throwable)exception);
                }
            }
            return status;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("No resource found for " + storage.getRootPath() + webDAVRequest.getPath()));
        }
        return 404;
    }
}

