/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset.model;

import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryClassType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DLFileEntryClassTypeReader
implements ClassTypeReader {
    public List<ClassType> getAvailableClassTypes(long[] groupIds, Locale locale) {
        ArrayList<ClassType> classTypes = new ArrayList<ClassType>();
        classTypes.add(this.getBasicDocumentClassType(locale));
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        List dlFileEntryTypes = DLFileEntryTypeServiceUtil.getFileEntryTypes((long[])groupIds);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            classTypes.add((ClassType)new DLFileEntryClassType(dlFileEntryType.getFileEntryTypeId(), dlFileEntryType.getName(locale), languageId));
        }
        return classTypes;
    }

    public ClassType getClassType(long classTypeId, Locale locale) throws PortalException {
        if (classTypeId == 0L) {
            return this.getBasicDocumentClassType(locale);
        }
        DLFileEntryType dlFileEntryType = DLFileEntryTypeServiceUtil.getFileEntryType((long)classTypeId);
        return new DLFileEntryClassType(dlFileEntryType.getFileEntryTypeId(), dlFileEntryType.getName(locale), LocaleUtil.toLanguageId((Locale)locale));
    }

    protected ClassType getBasicDocumentClassType(Locale locale) {
        DLFileEntryType basicDocumentDLFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)0L);
        return new DLFileEntryClassType(basicDocumentDLFileEntryType.getFileEntryTypeId(), LanguageUtil.get((Locale)locale, (String)"basic-document"), LocaleUtil.toLanguageId((Locale)locale));
    }
}

