/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.messaging;

import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portlet.documentlibrary.messaging.BaseProcessorMessageListener;

public class PDFProcessorMessageListener
extends BaseProcessorMessageListener {
    @Override
    protected void generate(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        if (CTCollectionThreadLocal.isProductionMode() || !(destinationFileVersion instanceof LiferayFileVersion)) {
            PDFProcessorUtil.generateImages((FileVersion)sourceFileVersion, (FileVersion)destinationFileVersion);
            return;
        }
        LiferayFileVersion liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
        long ctCollectionId = liferayFileVersion.getCTCollectionId();
        if (ctCollectionId == CTCollectionThreadLocal.getCTCollectionId()) {
            PDFProcessorUtil.generateImages((FileVersion)sourceFileVersion, (FileVersion)destinationFileVersion);
        } else {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                PDFProcessorUtil.generateImages((FileVersion)sourceFileVersion, (FileVersion)destinationFileVersion);
            }
        }
    }
}

