/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordPolicyModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the PasswordPolicy service. Represents a row in the &quot;PasswordPolicy&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>PasswordPolicyModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PasswordPolicyImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PasswordPolicyImpl
 * @generated
 */
@JSON(strict = true)
public class PasswordPolicyModelImpl
	extends BaseModelImpl<PasswordPolicy> implements PasswordPolicyModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a password policy model instance should use the <code>PasswordPolicy</code> interface instead.
	 */
	public static final String TABLE_NAME = "PasswordPolicy";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"passwordPolicyId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"defaultPolicy", Types.BOOLEAN}, {"name", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"changeable", Types.BOOLEAN},
		{"changeRequired", Types.BOOLEAN}, {"minAge", Types.BIGINT},
		{"checkSyntax", Types.BOOLEAN}, {"allowDictionaryWords", Types.BOOLEAN},
		{"minAlphanumeric", Types.INTEGER}, {"minLength", Types.INTEGER},
		{"minLowerCase", Types.INTEGER}, {"minNumbers", Types.INTEGER},
		{"minSymbols", Types.INTEGER}, {"minUpperCase", Types.INTEGER},
		{"regex", Types.VARCHAR}, {"history", Types.BOOLEAN},
		{"historyCount", Types.INTEGER}, {"expireable", Types.BOOLEAN},
		{"maxAge", Types.BIGINT}, {"warningTime", Types.BIGINT},
		{"graceLimit", Types.INTEGER}, {"lockout", Types.BOOLEAN},
		{"maxFailure", Types.INTEGER}, {"lockoutDuration", Types.BIGINT},
		{"requireUnlock", Types.BOOLEAN}, {"resetFailureCount", Types.BIGINT},
		{"resetTicketMaxAge", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("passwordPolicyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("defaultPolicy", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("changeable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("changeRequired", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("minAge", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("checkSyntax", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("allowDictionaryWords", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("minAlphanumeric", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minLowerCase", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minNumbers", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minSymbols", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minUpperCase", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("regex", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("history", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("historyCount", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("expireable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("maxAge", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("warningTime", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("graceLimit", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lockout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("maxFailure", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lockoutDuration", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("requireUnlock", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("resetFailureCount", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("resetTicketMaxAge", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table PasswordPolicy (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,passwordPolicyId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,defaultPolicy BOOLEAN,name VARCHAR(75) null,description STRING null,changeable BOOLEAN,changeRequired BOOLEAN,minAge LONG,checkSyntax BOOLEAN,allowDictionaryWords BOOLEAN,minAlphanumeric INTEGER,minLength INTEGER,minLowerCase INTEGER,minNumbers INTEGER,minSymbols INTEGER,minUpperCase INTEGER,regex STRING null,history BOOLEAN,historyCount INTEGER,expireable BOOLEAN,maxAge LONG,warningTime LONG,graceLimit INTEGER,lockout BOOLEAN,maxFailure INTEGER,lockoutDuration LONG,requireUnlock BOOLEAN,resetFailureCount LONG,resetTicketMaxAge LONG)";

	public static final String TABLE_SQL_DROP = "drop table PasswordPolicy";

	public static final String ORDER_BY_JPQL =
		" ORDER BY passwordPolicy.passwordPolicyId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY PasswordPolicy.passwordPolicyId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEFAULTPOLICY_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PASSWORDPOLICYID_COLUMN_BITMASK = 16L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.PasswordPolicy"));

	public PasswordPolicyModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _passwordPolicyId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setPasswordPolicyId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _passwordPolicyId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return PasswordPolicy.class;
	}

	@Override
	public String getModelClassName() {
		return PasswordPolicy.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<PasswordPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PasswordPolicy, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((PasswordPolicy)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<PasswordPolicy, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<PasswordPolicy, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(PasswordPolicy)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<PasswordPolicy, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<PasswordPolicy, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<PasswordPolicy, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<PasswordPolicy, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<PasswordPolicy, Object>>();
		Map<String, BiConsumer<PasswordPolicy, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<PasswordPolicy, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", PasswordPolicy::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setMvccVersion);
		attributeGetterFunctions.put("uuid", PasswordPolicy::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setUuid);
		attributeGetterFunctions.put(
			"passwordPolicyId", PasswordPolicy::getPasswordPolicyId);
		attributeSetterBiConsumers.put(
			"passwordPolicyId",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setPasswordPolicyId);
		attributeGetterFunctions.put("companyId", PasswordPolicy::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setCompanyId);
		attributeGetterFunctions.put("userId", PasswordPolicy::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setUserId);
		attributeGetterFunctions.put("userName", PasswordPolicy::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setUserName);
		attributeGetterFunctions.put(
			"createDate", PasswordPolicy::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<PasswordPolicy, Date>)PasswordPolicy::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", PasswordPolicy::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<PasswordPolicy, Date>)PasswordPolicy::setModifiedDate);
		attributeGetterFunctions.put(
			"defaultPolicy", PasswordPolicy::getDefaultPolicy);
		attributeSetterBiConsumers.put(
			"defaultPolicy",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setDefaultPolicy);
		attributeGetterFunctions.put("name", PasswordPolicy::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setName);
		attributeGetterFunctions.put(
			"description", PasswordPolicy::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setDescription);
		attributeGetterFunctions.put(
			"changeable", PasswordPolicy::getChangeable);
		attributeSetterBiConsumers.put(
			"changeable",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setChangeable);
		attributeGetterFunctions.put(
			"changeRequired", PasswordPolicy::getChangeRequired);
		attributeSetterBiConsumers.put(
			"changeRequired",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setChangeRequired);
		attributeGetterFunctions.put("minAge", PasswordPolicy::getMinAge);
		attributeSetterBiConsumers.put(
			"minAge",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setMinAge);
		attributeGetterFunctions.put(
			"checkSyntax", PasswordPolicy::getCheckSyntax);
		attributeSetterBiConsumers.put(
			"checkSyntax",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setCheckSyntax);
		attributeGetterFunctions.put(
			"allowDictionaryWords", PasswordPolicy::getAllowDictionaryWords);
		attributeSetterBiConsumers.put(
			"allowDictionaryWords",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setAllowDictionaryWords);
		attributeGetterFunctions.put(
			"minAlphanumeric", PasswordPolicy::getMinAlphanumeric);
		attributeSetterBiConsumers.put(
			"minAlphanumeric",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setMinAlphanumeric);
		attributeGetterFunctions.put("minLength", PasswordPolicy::getMinLength);
		attributeSetterBiConsumers.put(
			"minLength",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMinLength);
		attributeGetterFunctions.put(
			"minLowerCase", PasswordPolicy::getMinLowerCase);
		attributeSetterBiConsumers.put(
			"minLowerCase",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setMinLowerCase);
		attributeGetterFunctions.put(
			"minNumbers", PasswordPolicy::getMinNumbers);
		attributeSetterBiConsumers.put(
			"minNumbers",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMinNumbers);
		attributeGetterFunctions.put(
			"minSymbols", PasswordPolicy::getMinSymbols);
		attributeSetterBiConsumers.put(
			"minSymbols",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMinSymbols);
		attributeGetterFunctions.put(
			"minUpperCase", PasswordPolicy::getMinUpperCase);
		attributeSetterBiConsumers.put(
			"minUpperCase",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setMinUpperCase);
		attributeGetterFunctions.put("regex", PasswordPolicy::getRegex);
		attributeSetterBiConsumers.put(
			"regex",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setRegex);
		attributeGetterFunctions.put("history", PasswordPolicy::getHistory);
		attributeSetterBiConsumers.put(
			"history",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setHistory);
		attributeGetterFunctions.put(
			"historyCount", PasswordPolicy::getHistoryCount);
		attributeSetterBiConsumers.put(
			"historyCount",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setHistoryCount);
		attributeGetterFunctions.put(
			"expireable", PasswordPolicy::getExpireable);
		attributeSetterBiConsumers.put(
			"expireable",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setExpireable);
		attributeGetterFunctions.put("maxAge", PasswordPolicy::getMaxAge);
		attributeSetterBiConsumers.put(
			"maxAge",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setMaxAge);
		attributeGetterFunctions.put(
			"warningTime", PasswordPolicy::getWarningTime);
		attributeSetterBiConsumers.put(
			"warningTime",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setWarningTime);
		attributeGetterFunctions.put(
			"graceLimit", PasswordPolicy::getGraceLimit);
		attributeSetterBiConsumers.put(
			"graceLimit",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setGraceLimit);
		attributeGetterFunctions.put("lockout", PasswordPolicy::getLockout);
		attributeSetterBiConsumers.put(
			"lockout",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setLockout);
		attributeGetterFunctions.put(
			"maxFailure", PasswordPolicy::getMaxFailure);
		attributeSetterBiConsumers.put(
			"maxFailure",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMaxFailure);
		attributeGetterFunctions.put(
			"lockoutDuration", PasswordPolicy::getLockoutDuration);
		attributeSetterBiConsumers.put(
			"lockoutDuration",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setLockoutDuration);
		attributeGetterFunctions.put(
			"requireUnlock", PasswordPolicy::getRequireUnlock);
		attributeSetterBiConsumers.put(
			"requireUnlock",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setRequireUnlock);
		attributeGetterFunctions.put(
			"resetFailureCount", PasswordPolicy::getResetFailureCount);
		attributeSetterBiConsumers.put(
			"resetFailureCount",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setResetFailureCount);
		attributeGetterFunctions.put(
			"resetTicketMaxAge", PasswordPolicy::getResetTicketMaxAge);
		attributeSetterBiConsumers.put(
			"resetTicketMaxAge",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setResetTicketMaxAge);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getPasswordPolicyId() {
		return _passwordPolicyId;
	}

	@Override
	public void setPasswordPolicyId(long passwordPolicyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_passwordPolicyId = passwordPolicyId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public boolean getDefaultPolicy() {
		return _defaultPolicy;
	}

	@JSON
	@Override
	public boolean isDefaultPolicy() {
		return _defaultPolicy;
	}

	@Override
	public void setDefaultPolicy(boolean defaultPolicy) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultPolicy = defaultPolicy;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDefaultPolicy() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("defaultPolicy"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public boolean getChangeable() {
		return _changeable;
	}

	@JSON
	@Override
	public boolean isChangeable() {
		return _changeable;
	}

	@Override
	public void setChangeable(boolean changeable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_changeable = changeable;
	}

	@JSON
	@Override
	public boolean getChangeRequired() {
		return _changeRequired;
	}

	@JSON
	@Override
	public boolean isChangeRequired() {
		return _changeRequired;
	}

	@Override
	public void setChangeRequired(boolean changeRequired) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_changeRequired = changeRequired;
	}

	@JSON
	@Override
	public long getMinAge() {
		return _minAge;
	}

	@Override
	public void setMinAge(long minAge) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minAge = minAge;
	}

	@JSON
	@Override
	public boolean getCheckSyntax() {
		return _checkSyntax;
	}

	@JSON
	@Override
	public boolean isCheckSyntax() {
		return _checkSyntax;
	}

	@Override
	public void setCheckSyntax(boolean checkSyntax) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_checkSyntax = checkSyntax;
	}

	@JSON
	@Override
	public boolean getAllowDictionaryWords() {
		return _allowDictionaryWords;
	}

	@JSON
	@Override
	public boolean isAllowDictionaryWords() {
		return _allowDictionaryWords;
	}

	@Override
	public void setAllowDictionaryWords(boolean allowDictionaryWords) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_allowDictionaryWords = allowDictionaryWords;
	}

	@JSON
	@Override
	public int getMinAlphanumeric() {
		return _minAlphanumeric;
	}

	@Override
	public void setMinAlphanumeric(int minAlphanumeric) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minAlphanumeric = minAlphanumeric;
	}

	@JSON
	@Override
	public int getMinLength() {
		return _minLength;
	}

	@Override
	public void setMinLength(int minLength) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minLength = minLength;
	}

	@JSON
	@Override
	public int getMinLowerCase() {
		return _minLowerCase;
	}

	@Override
	public void setMinLowerCase(int minLowerCase) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minLowerCase = minLowerCase;
	}

	@JSON
	@Override
	public int getMinNumbers() {
		return _minNumbers;
	}

	@Override
	public void setMinNumbers(int minNumbers) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minNumbers = minNumbers;
	}

	@JSON
	@Override
	public int getMinSymbols() {
		return _minSymbols;
	}

	@Override
	public void setMinSymbols(int minSymbols) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minSymbols = minSymbols;
	}

	@JSON
	@Override
	public int getMinUpperCase() {
		return _minUpperCase;
	}

	@Override
	public void setMinUpperCase(int minUpperCase) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_minUpperCase = minUpperCase;
	}

	@JSON
	@Override
	public String getRegex() {
		if (_regex == null) {
			return "";
		}
		else {
			return _regex;
		}
	}

	@Override
	public void setRegex(String regex) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_regex = regex;
	}

	@JSON
	@Override
	public boolean getHistory() {
		return _history;
	}

	@JSON
	@Override
	public boolean isHistory() {
		return _history;
	}

	@Override
	public void setHistory(boolean history) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_history = history;
	}

	@JSON
	@Override
	public int getHistoryCount() {
		return _historyCount;
	}

	@Override
	public void setHistoryCount(int historyCount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_historyCount = historyCount;
	}

	@JSON
	@Override
	public boolean getExpireable() {
		return _expireable;
	}

	@JSON
	@Override
	public boolean isExpireable() {
		return _expireable;
	}

	@Override
	public void setExpireable(boolean expireable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expireable = expireable;
	}

	@JSON
	@Override
	public long getMaxAge() {
		return _maxAge;
	}

	@Override
	public void setMaxAge(long maxAge) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_maxAge = maxAge;
	}

	@JSON
	@Override
	public long getWarningTime() {
		return _warningTime;
	}

	@Override
	public void setWarningTime(long warningTime) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_warningTime = warningTime;
	}

	@JSON
	@Override
	public int getGraceLimit() {
		return _graceLimit;
	}

	@Override
	public void setGraceLimit(int graceLimit) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_graceLimit = graceLimit;
	}

	@JSON
	@Override
	public boolean getLockout() {
		return _lockout;
	}

	@JSON
	@Override
	public boolean isLockout() {
		return _lockout;
	}

	@Override
	public void setLockout(boolean lockout) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockout = lockout;
	}

	@JSON
	@Override
	public int getMaxFailure() {
		return _maxFailure;
	}

	@Override
	public void setMaxFailure(int maxFailure) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_maxFailure = maxFailure;
	}

	@JSON
	@Override
	public long getLockoutDuration() {
		return _lockoutDuration;
	}

	@Override
	public void setLockoutDuration(long lockoutDuration) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockoutDuration = lockoutDuration;
	}

	@JSON
	@Override
	public boolean getRequireUnlock() {
		return _requireUnlock;
	}

	@JSON
	@Override
	public boolean isRequireUnlock() {
		return _requireUnlock;
	}

	@Override
	public void setRequireUnlock(boolean requireUnlock) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_requireUnlock = requireUnlock;
	}

	@JSON
	@Override
	public long getResetFailureCount() {
		return _resetFailureCount;
	}

	@Override
	public void setResetFailureCount(long resetFailureCount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_resetFailureCount = resetFailureCount;
	}

	@JSON
	@Override
	public long getResetTicketMaxAge() {
		return _resetTicketMaxAge;
	}

	@Override
	public void setResetTicketMaxAge(long resetTicketMaxAge) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_resetTicketMaxAge = resetTicketMaxAge;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(PasswordPolicy.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), PasswordPolicy.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public PasswordPolicy toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, PasswordPolicy>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		PasswordPolicyImpl passwordPolicyImpl = new PasswordPolicyImpl();

		passwordPolicyImpl.setMvccVersion(getMvccVersion());
		passwordPolicyImpl.setUuid(getUuid());
		passwordPolicyImpl.setPasswordPolicyId(getPasswordPolicyId());
		passwordPolicyImpl.setCompanyId(getCompanyId());
		passwordPolicyImpl.setUserId(getUserId());
		passwordPolicyImpl.setUserName(getUserName());
		passwordPolicyImpl.setCreateDate(getCreateDate());
		passwordPolicyImpl.setModifiedDate(getModifiedDate());
		passwordPolicyImpl.setDefaultPolicy(isDefaultPolicy());
		passwordPolicyImpl.setName(getName());
		passwordPolicyImpl.setDescription(getDescription());
		passwordPolicyImpl.setChangeable(isChangeable());
		passwordPolicyImpl.setChangeRequired(isChangeRequired());
		passwordPolicyImpl.setMinAge(getMinAge());
		passwordPolicyImpl.setCheckSyntax(isCheckSyntax());
		passwordPolicyImpl.setAllowDictionaryWords(isAllowDictionaryWords());
		passwordPolicyImpl.setMinAlphanumeric(getMinAlphanumeric());
		passwordPolicyImpl.setMinLength(getMinLength());
		passwordPolicyImpl.setMinLowerCase(getMinLowerCase());
		passwordPolicyImpl.setMinNumbers(getMinNumbers());
		passwordPolicyImpl.setMinSymbols(getMinSymbols());
		passwordPolicyImpl.setMinUpperCase(getMinUpperCase());
		passwordPolicyImpl.setRegex(getRegex());
		passwordPolicyImpl.setHistory(isHistory());
		passwordPolicyImpl.setHistoryCount(getHistoryCount());
		passwordPolicyImpl.setExpireable(isExpireable());
		passwordPolicyImpl.setMaxAge(getMaxAge());
		passwordPolicyImpl.setWarningTime(getWarningTime());
		passwordPolicyImpl.setGraceLimit(getGraceLimit());
		passwordPolicyImpl.setLockout(isLockout());
		passwordPolicyImpl.setMaxFailure(getMaxFailure());
		passwordPolicyImpl.setLockoutDuration(getLockoutDuration());
		passwordPolicyImpl.setRequireUnlock(isRequireUnlock());
		passwordPolicyImpl.setResetFailureCount(getResetFailureCount());
		passwordPolicyImpl.setResetTicketMaxAge(getResetTicketMaxAge());

		passwordPolicyImpl.resetOriginalValues();

		return passwordPolicyImpl;
	}

	@Override
	public PasswordPolicy cloneWithOriginalValues() {
		PasswordPolicyImpl passwordPolicyImpl = new PasswordPolicyImpl();

		passwordPolicyImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		passwordPolicyImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		passwordPolicyImpl.setPasswordPolicyId(
			this.<Long>getColumnOriginalValue("passwordPolicyId"));
		passwordPolicyImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		passwordPolicyImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		passwordPolicyImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		passwordPolicyImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		passwordPolicyImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		passwordPolicyImpl.setDefaultPolicy(
			this.<Boolean>getColumnOriginalValue("defaultPolicy"));
		passwordPolicyImpl.setName(this.<String>getColumnOriginalValue("name"));
		passwordPolicyImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		passwordPolicyImpl.setChangeable(
			this.<Boolean>getColumnOriginalValue("changeable"));
		passwordPolicyImpl.setChangeRequired(
			this.<Boolean>getColumnOriginalValue("changeRequired"));
		passwordPolicyImpl.setMinAge(
			this.<Long>getColumnOriginalValue("minAge"));
		passwordPolicyImpl.setCheckSyntax(
			this.<Boolean>getColumnOriginalValue("checkSyntax"));
		passwordPolicyImpl.setAllowDictionaryWords(
			this.<Boolean>getColumnOriginalValue("allowDictionaryWords"));
		passwordPolicyImpl.setMinAlphanumeric(
			this.<Integer>getColumnOriginalValue("minAlphanumeric"));
		passwordPolicyImpl.setMinLength(
			this.<Integer>getColumnOriginalValue("minLength"));
		passwordPolicyImpl.setMinLowerCase(
			this.<Integer>getColumnOriginalValue("minLowerCase"));
		passwordPolicyImpl.setMinNumbers(
			this.<Integer>getColumnOriginalValue("minNumbers"));
		passwordPolicyImpl.setMinSymbols(
			this.<Integer>getColumnOriginalValue("minSymbols"));
		passwordPolicyImpl.setMinUpperCase(
			this.<Integer>getColumnOriginalValue("minUpperCase"));
		passwordPolicyImpl.setRegex(
			this.<String>getColumnOriginalValue("regex"));
		passwordPolicyImpl.setHistory(
			this.<Boolean>getColumnOriginalValue("history"));
		passwordPolicyImpl.setHistoryCount(
			this.<Integer>getColumnOriginalValue("historyCount"));
		passwordPolicyImpl.setExpireable(
			this.<Boolean>getColumnOriginalValue("expireable"));
		passwordPolicyImpl.setMaxAge(
			this.<Long>getColumnOriginalValue("maxAge"));
		passwordPolicyImpl.setWarningTime(
			this.<Long>getColumnOriginalValue("warningTime"));
		passwordPolicyImpl.setGraceLimit(
			this.<Integer>getColumnOriginalValue("graceLimit"));
		passwordPolicyImpl.setLockout(
			this.<Boolean>getColumnOriginalValue("lockout"));
		passwordPolicyImpl.setMaxFailure(
			this.<Integer>getColumnOriginalValue("maxFailure"));
		passwordPolicyImpl.setLockoutDuration(
			this.<Long>getColumnOriginalValue("lockoutDuration"));
		passwordPolicyImpl.setRequireUnlock(
			this.<Boolean>getColumnOriginalValue("requireUnlock"));
		passwordPolicyImpl.setResetFailureCount(
			this.<Long>getColumnOriginalValue("resetFailureCount"));
		passwordPolicyImpl.setResetTicketMaxAge(
			this.<Long>getColumnOriginalValue("resetTicketMaxAge"));

		return passwordPolicyImpl;
	}

	@Override
	public int compareTo(PasswordPolicy passwordPolicy) {
		long primaryKey = passwordPolicy.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof PasswordPolicy)) {
			return false;
		}

		PasswordPolicy passwordPolicy = (PasswordPolicy)object;

		long primaryKey = passwordPolicy.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<PasswordPolicy> toCacheModel() {
		PasswordPolicyCacheModel passwordPolicyCacheModel =
			new PasswordPolicyCacheModel();

		passwordPolicyCacheModel.mvccVersion = getMvccVersion();

		passwordPolicyCacheModel.uuid = getUuid();

		String uuid = passwordPolicyCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			passwordPolicyCacheModel.uuid = null;
		}

		passwordPolicyCacheModel.passwordPolicyId = getPasswordPolicyId();

		passwordPolicyCacheModel.companyId = getCompanyId();

		passwordPolicyCacheModel.userId = getUserId();

		passwordPolicyCacheModel.userName = getUserName();

		String userName = passwordPolicyCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			passwordPolicyCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			passwordPolicyCacheModel.createDate = createDate.getTime();
		}
		else {
			passwordPolicyCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			passwordPolicyCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			passwordPolicyCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		passwordPolicyCacheModel.defaultPolicy = isDefaultPolicy();

		passwordPolicyCacheModel.name = getName();

		String name = passwordPolicyCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			passwordPolicyCacheModel.name = null;
		}

		passwordPolicyCacheModel.description = getDescription();

		String description = passwordPolicyCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			passwordPolicyCacheModel.description = null;
		}

		passwordPolicyCacheModel.changeable = isChangeable();

		passwordPolicyCacheModel.changeRequired = isChangeRequired();

		passwordPolicyCacheModel.minAge = getMinAge();

		passwordPolicyCacheModel.checkSyntax = isCheckSyntax();

		passwordPolicyCacheModel.allowDictionaryWords =
			isAllowDictionaryWords();

		passwordPolicyCacheModel.minAlphanumeric = getMinAlphanumeric();

		passwordPolicyCacheModel.minLength = getMinLength();

		passwordPolicyCacheModel.minLowerCase = getMinLowerCase();

		passwordPolicyCacheModel.minNumbers = getMinNumbers();

		passwordPolicyCacheModel.minSymbols = getMinSymbols();

		passwordPolicyCacheModel.minUpperCase = getMinUpperCase();

		passwordPolicyCacheModel.regex = getRegex();

		String regex = passwordPolicyCacheModel.regex;

		if ((regex != null) && (regex.length() == 0)) {
			passwordPolicyCacheModel.regex = null;
		}

		passwordPolicyCacheModel.history = isHistory();

		passwordPolicyCacheModel.historyCount = getHistoryCount();

		passwordPolicyCacheModel.expireable = isExpireable();

		passwordPolicyCacheModel.maxAge = getMaxAge();

		passwordPolicyCacheModel.warningTime = getWarningTime();

		passwordPolicyCacheModel.graceLimit = getGraceLimit();

		passwordPolicyCacheModel.lockout = isLockout();

		passwordPolicyCacheModel.maxFailure = getMaxFailure();

		passwordPolicyCacheModel.lockoutDuration = getLockoutDuration();

		passwordPolicyCacheModel.requireUnlock = isRequireUnlock();

		passwordPolicyCacheModel.resetFailureCount = getResetFailureCount();

		passwordPolicyCacheModel.resetTicketMaxAge = getResetTicketMaxAge();

		return passwordPolicyCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<PasswordPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PasswordPolicy, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((PasswordPolicy)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, PasswordPolicy>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					PasswordPolicy.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _passwordPolicyId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _defaultPolicy;
	private String _name;
	private String _description;
	private boolean _changeable;
	private boolean _changeRequired;
	private long _minAge;
	private boolean _checkSyntax;
	private boolean _allowDictionaryWords;
	private int _minAlphanumeric;
	private int _minLength;
	private int _minLowerCase;
	private int _minNumbers;
	private int _minSymbols;
	private int _minUpperCase;
	private String _regex;
	private boolean _history;
	private int _historyCount;
	private boolean _expireable;
	private long _maxAge;
	private long _warningTime;
	private int _graceLimit;
	private boolean _lockout;
	private int _maxFailure;
	private long _lockoutDuration;
	private boolean _requireUnlock;
	private long _resetFailureCount;
	private long _resetTicketMaxAge;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<PasswordPolicy, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((PasswordPolicy)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("passwordPolicyId", _passwordPolicyId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("defaultPolicy", _defaultPolicy);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("changeable", _changeable);
		_columnOriginalValues.put("changeRequired", _changeRequired);
		_columnOriginalValues.put("minAge", _minAge);
		_columnOriginalValues.put("checkSyntax", _checkSyntax);
		_columnOriginalValues.put(
			"allowDictionaryWords", _allowDictionaryWords);
		_columnOriginalValues.put("minAlphanumeric", _minAlphanumeric);
		_columnOriginalValues.put("minLength", _minLength);
		_columnOriginalValues.put("minLowerCase", _minLowerCase);
		_columnOriginalValues.put("minNumbers", _minNumbers);
		_columnOriginalValues.put("minSymbols", _minSymbols);
		_columnOriginalValues.put("minUpperCase", _minUpperCase);
		_columnOriginalValues.put("regex", _regex);
		_columnOriginalValues.put("history", _history);
		_columnOriginalValues.put("historyCount", _historyCount);
		_columnOriginalValues.put("expireable", _expireable);
		_columnOriginalValues.put("maxAge", _maxAge);
		_columnOriginalValues.put("warningTime", _warningTime);
		_columnOriginalValues.put("graceLimit", _graceLimit);
		_columnOriginalValues.put("lockout", _lockout);
		_columnOriginalValues.put("maxFailure", _maxFailure);
		_columnOriginalValues.put("lockoutDuration", _lockoutDuration);
		_columnOriginalValues.put("requireUnlock", _requireUnlock);
		_columnOriginalValues.put("resetFailureCount", _resetFailureCount);
		_columnOriginalValues.put("resetTicketMaxAge", _resetTicketMaxAge);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("passwordPolicyId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("defaultPolicy", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("description", 1024L);

		columnBitmasks.put("changeable", 2048L);

		columnBitmasks.put("changeRequired", 4096L);

		columnBitmasks.put("minAge", 8192L);

		columnBitmasks.put("checkSyntax", 16384L);

		columnBitmasks.put("allowDictionaryWords", 32768L);

		columnBitmasks.put("minAlphanumeric", 65536L);

		columnBitmasks.put("minLength", 131072L);

		columnBitmasks.put("minLowerCase", 262144L);

		columnBitmasks.put("minNumbers", 524288L);

		columnBitmasks.put("minSymbols", 1048576L);

		columnBitmasks.put("minUpperCase", 2097152L);

		columnBitmasks.put("regex", 4194304L);

		columnBitmasks.put("history", 8388608L);

		columnBitmasks.put("historyCount", 16777216L);

		columnBitmasks.put("expireable", 33554432L);

		columnBitmasks.put("maxAge", 67108864L);

		columnBitmasks.put("warningTime", 134217728L);

		columnBitmasks.put("graceLimit", 268435456L);

		columnBitmasks.put("lockout", 536870912L);

		columnBitmasks.put("maxFailure", 1073741824L);

		columnBitmasks.put("lockoutDuration", 2147483648L);

		columnBitmasks.put("requireUnlock", 4294967296L);

		columnBitmasks.put("resetFailureCount", 8589934592L);

		columnBitmasks.put("resetTicketMaxAge", 17179869184L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private PasswordPolicy _escapedModel;

}