/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.internal.RenderData;
import com.liferay.portlet.internal.RenderStateUtil;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LayoutAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(LayoutAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean layoutDefault = (Boolean)httpServletRequest.getAttribute("LAYOUT_DEFAULT");
        if (Boolean.TRUE.equals(layoutDefault)) {
            Layout requestedLayout = (Layout)httpServletRequest.getAttribute("REQUESTED_LAYOUT");
            if (requestedLayout != null) {
                String authLoginURL;
                String redirectParam = "redirect";
                if (Validator.isNotNull((String)PropsValues.AUTH_LOGIN_PORTLET_NAME)) {
                    String portletNamespace = PortalUtil.getPortletNamespace((String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                    redirectParam = portletNamespace + redirectParam;
                }
                if (Validator.isNull((String)(authLoginURL = SSOUtil.getSignInURL(themeDisplay.getCompanyId(), themeDisplay.getURLSignIn())))) {
                    authLoginURL = PortalUtil.getSiteLoginURL((ThemeDisplay)themeDisplay);
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PropsValues.AUTH_LOGIN_URL;
                }
                if (Validator.isNull((String)authLoginURL)) {
                    authLoginURL = PortletURLBuilder.create((PortletURL)PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE")).setMVCRenderCommandName("/login/login").setParameter("saveLastPath", (Object)false).setPortletMode(PortletMode.VIEW).setWindowState(WindowState.MAXIMIZED).buildString();
                }
                authLoginURL = HttpComponentsUtil.setParameter((String)authLoginURL, (String)"p_p_id", (String)PropsValues.AUTH_LOGIN_PORTLET_NAME);
                authLoginURL = HttpComponentsUtil.setParameter((String)authLoginURL, (String)redirectParam, (String)PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest));
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect requested layout to " + authLoginURL));
                }
                httpServletResponse.sendRedirect(authLoginURL);
            } else {
                String redirect = PortalUtil.getLayoutURL((Layout)themeDisplay.getLayout(), (ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Redirect default layout to " + redirect));
                }
                httpServletResponse.sendRedirect(redirect);
            }
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"p_l_id");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("p_l_id is " + plid));
        }
        if (plid > 0L) {
            Layout layout = themeDisplay.getLayout();
            if (layout != null) {
                plid = layout.getPlid();
            }
            if (!layout.isTypeLinkToLayout()) {
                return this.processLayout(actionMapping, httpServletRequest, httpServletResponse, plid);
            }
        }
        try {
            this.forwardLayout(httpServletRequest);
            return actionMapping.getActionForward("/common/forward_jsp.jsp");
        }
        catch (Exception exception) {
            PortalUtil.sendError((Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return null;
        }
    }

    protected void forwardLayout(HttpServletRequest httpServletRequest) throws Exception {
        String forwardURL;
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        long plid = 0L;
        String layoutFriendlyURL = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (layout != null) {
            plid = layout.getPlid();
            layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        if (Validator.isNull(forwardURL = layoutFriendlyURL)) {
            forwardURL = themeDisplay.getPathMain() + "/portal/layout?p_l_id=" + plid;
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserId())) {
            forwardURL = HttpComponentsUtil.addParameter((String)forwardURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull((String)themeDisplay.getDoAsUserLanguageId())) {
            forwardURL = HttpComponentsUtil.addParameter((String)forwardURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Forward layout to " + forwardURL));
        }
        httpServletRequest.setAttribute("FORWARD_URL", (Object)forwardURL);
    }

    protected String getRenderStateJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ThemeDisplay themeDisplay, String portletId, LayoutTypePortlet layoutTypePortlet) throws Exception {
        HashMap<String, RenderData> renderDataMap = new HashMap<String, RenderData>();
        List allPortlets = layoutTypePortlet.getAllPortlets();
        for (Portlet curPortlet : allPortlets) {
            String curPortletId = curPortlet.getPortletId();
            if (!curPortletId.equals(portletId) && !curPortlet.isPartialActionServeResource()) continue;
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
            PortletContainerUtil.preparePortlet((HttpServletRequest)httpServletRequest, (Portlet)curPortlet);
            PortletContainerUtil.serveResource((HttpServletRequest)httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, (Portlet)curPortlet);
            RenderData renderData = new RenderData(bufferCacheServletResponse.getContentType(), bufferCacheServletResponse.getString());
            renderDataMap.put(curPortletId, renderData);
        }
        return RenderStateUtil.generateJSON(httpServletRequest, themeDisplay, renderDataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward processLayout(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long plid) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            ActionForward actionForward;
            AuditMessage auditMessage;
            Layout layout = themeDisplay.getLayout();
            if (layout != null && layout.isTypeURL()) {
                String redirect = PortalUtil.getLayoutActualURL((Layout)layout);
                httpServletResponse.sendRedirect(redirect);
                ActionForward actionForward2 = null;
                return actionForward2;
            }
            Long previousLayoutPlid = (Long)httpSession.getAttribute("PREVIOUS_LAYOUT_PLID");
            if (previousLayoutPlid == null || layout.getPlid() != previousLayoutPlid.longValue()) {
                httpSession.setAttribute("PREVIOUS_LAYOUT_PLID", (Object)layout.getPlid());
                if (themeDisplay.isSignedIn() && PropsValues.AUDIT_MESSAGE_COM_LIFERAY_PORTAL_MODEL_LAYOUT_VIEW && AuditRouterUtil.isDeployed()) {
                    User realUser = themeDisplay.getRealUser();
                    User user = themeDisplay.getUser();
                    JSONObject additionalInfoJSONObject = null;
                    if (Validator.isNotNull((String)themeDisplay.getDoAsUserId()) && realUser.getUserId() != user.getUserId()) {
                        additionalInfoJSONObject = JSONUtil.put((String)"userId", (Object)user.getUserId()).put("userName", user.getFullName());
                    }
                    auditMessage = new AuditMessage("VIEW", realUser.getCompanyId(), realUser.getUserId(), realUser.getFullName(), Layout.class.getName(), String.valueOf(layout.getPlid()), null, additionalInfoJSONObject);
                    AuditRouterUtil.route((AuditMessage)auditMessage);
                }
            }
            boolean resetLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"p_l_reset", (boolean)PropsValues.LAYOUT_DEFAULT_P_L_RESET);
            String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id");
            if (resetLayout && (Validator.isNull((String)portletId) || previousLayoutPlid != null && layout.getPlid() != previousLayoutPlid.longValue())) {
                RenderParametersPool.clear(httpServletRequest, plid);
            }
            Portlet portlet = null;
            if (Validator.isNotNull((String)portletId)) {
                portlet = PortletLocalServiceUtil.getPortletById((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest), (String)portletId);
            }
            if (portlet != null) {
                PortletContainerUtil.preparePortlet((HttpServletRequest)httpServletRequest, (Portlet)portlet);
                if (themeDisplay.isLifecycleAction()) {
                    LayoutTypePortlet layoutTypePortlet;
                    PortletContainerUtil.processAction((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Portlet)portlet);
                    if (httpServletResponse.isCommitted()) {
                        auditMessage = null;
                        return auditMessage;
                    }
                    String renderStateJSON = "";
                    if (themeDisplay.isHubAction()) {
                        renderStateJSON = RenderStateUtil.generateJSON(httpServletRequest, themeDisplay);
                    } else if (themeDisplay.isHubPartialAction() && (layoutTypePortlet = themeDisplay.getLayoutTypePortlet()) != null) {
                        renderStateJSON = this.getRenderStateJSON(httpServletRequest, httpServletResponse, themeDisplay, portlet.getPortletId(), layoutTypePortlet);
                    }
                    if (themeDisplay.isHubAction() || themeDisplay.isHubPartialAction()) {
                        httpServletResponse.setContentLength(renderStateJSON.length());
                        httpServletResponse.setContentType("application/json");
                        PrintWriter printWriter = httpServletResponse.getWriter();
                        printWriter.write(renderStateJSON);
                        ActionForward liferayPortletRequest = null;
                        return liferayPortletRequest;
                    }
                } else if (themeDisplay.isLifecycleResource()) {
                    PortletContainerUtil.serveResource((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Portlet)portlet);
                    actionForward = null;
                    return actionForward;
                }
            }
            if (layout != null) {
                if (themeDisplay.isStateExclusive()) {
                    PortletContainerUtil.renderHeaders((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Portlet)portlet);
                    PortletContainerUtil.render((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Portlet)portlet);
                    actionForward = null;
                    return actionForward;
                }
                PortletContainerUtil.processPublicRenderParameters((HttpServletRequest)httpServletRequest, (Layout)layout, (Portlet)portlet);
                if (layout.includeLayoutContent(httpServletRequest, httpServletResponse)) {
                    actionForward = null;
                    return actionForward;
                }
            }
            actionForward = actionMapping.getActionForward("portal.layout");
            return actionForward;
        }
        catch (Exception exception) {
            PortalUtil.sendError((Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            ActionForward actionForward = null;
            return actionForward;
        }
        finally {
            PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
            if (portletRequest != null) {
                LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
                if (liferayPortletRequest instanceof ResourceRequest) {
                    ResourceRequest resourceRequest = (ResourceRequest)liferayPortletRequest;
                    if (!resourceRequest.isAsyncStarted()) {
                        liferayPortletRequest.cleanUp();
                    }
                } else {
                    liferayPortletRequest.cleanUp();
                }
            }
        }
    }
}

