/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.init;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.partition.DBPartitionUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSync;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ReleaseConstants;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.util.PropsUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import javax.sql.DataSource;

public class DBInitUtil {
    private static final Log _log = LogFactoryUtil.getLog(DBInitUtil.class);
    private static DataSource _dataSource;
    private static DataSource _readDataSource;
    private static DataSource _writeDataSource;

    public static DataSource getDataSource() {
        return _dataSource;
    }

    public static DataSource getReadDataSource() {
        return _readDataSource;
    }

    public static DataSource getWriteDataSource() {
        return _writeDataSource;
    }

    public static void init() throws Exception {
        _readDataSource = DBInitUtil._initDataSource("jdbc.read.");
        _dataSource = _writeDataSource = DBInitUtil._initDataSource("jdbc.write.");
        if (_readDataSource == null && _writeDataSource == null) {
            _dataSource = DBInitUtil._initDataSource("jdbc.default.");
        }
        try (Connection connection = _dataSource.getConnection();){
            DBInitUtil._init(DBManagerUtil.getDB(), connection);
            _dataSource = DBPartitionUtil.wrapDataSource(_dataSource);
            DBPartitionUtil.setDefaultCompanyId(connection);
        }
    }

    private static void _addReleaseInfo(Connection connection) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"insert into Release_ (releaseId, createDate, ", "modifiedDate, servletContextName, schemaVersion, ", "buildNumber, verified, testString) values (", 1L, ", ?, ?, ?, ?, ?, ?, ?)"}));){
            Date date = new Date(System.currentTimeMillis());
            preparedStatement.setDate(1, date);
            preparedStatement.setDate(2, date);
            preparedStatement.setString(3, "portal");
            preparedStatement.setString(4, String.valueOf(PortalUpgradeProcess.getLatestSchemaVersion()));
            preparedStatement.setInt(5, ReleaseInfo.getBuildNumber());
            preparedStatement.setBoolean(6, false);
            preparedStatement.setString(7, ReleaseConstants.TEST_STRING);
            preparedStatement.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean _checkDefaultRelease(Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void _createTablesAndPopulate(DB db, Connection connection) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Create tables and populate with default data");
        }
        ClassLoader classLoader = DBInitUtil.class.getClassLoader();
        DBInitUtil._runSQLTemplate(db, connection, classLoader, "portal-tables.sql");
        DBInitUtil._runSQLTemplate(db, connection, classLoader, "portal-data-common.sql");
        DBInitUtil._runSQLTemplate(db, connection, classLoader, "portal-data-counter.sql");
        DBInitUtil._runSQLTemplate(db, connection, classLoader, "indexes.sql");
        DBInitUtil._runSQLTemplate(db, connection, classLoader, "sequences.sql");
        DBInitUtil._addReleaseInfo(connection);
        StartupHelperUtil.setDbNew(true);
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        serviceLatch.waitFor(DependencyManagerSync.class, dependencyManagerSync -> dependencyManagerSync.registerSyncCallable(() -> {
            StartupHelperUtil.setDbNew(false);
            return null;
        }));
        serviceLatch.openOn(() -> {});
    }

    private static boolean _hasDefaultReleaseWithTestString(Connection connection, String testString) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from Release_ where releaseId = ? and testString = ?");){
            preparedStatement.setLong(1, 1L);
            preparedStatement.setString(2, testString);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next() && resultSet.getInt(1) > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private static void _init(DB db, Connection connection) throws Exception {
        block11: {
            block10: {
                block9: {
                    if (DBInitUtil._checkDefaultRelease(connection)) {
                        DBInitUtil._setSupportsStringCaseSensitiveQuery(db, connection);
                        return;
                    }
                    try {
                        db.runSQL(connection, "alter table Release_ add mvccVersion LONG default 0 not null");
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block9;
                        _log.debug((Throwable)exception);
                    }
                }
                try {
                    db.runSQL(connection, "alter table Release_ add schemaVersion VARCHAR(75) null");
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block10;
                    _log.debug((Throwable)exception);
                }
            }
            try {
                db.runSQL(connection, "alter table Release_ add state_ INTEGER");
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block11;
                _log.debug((Throwable)exception);
            }
        }
        if (DBInitUtil._checkDefaultRelease(connection)) {
            DBInitUtil._setSupportsStringCaseSensitiveQuery(db, connection);
            return;
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("schema.run.enabled"))) {
            DBInitUtil._createTablesAndPopulate(db, connection);
            DBInitUtil._setSupportsStringCaseSensitiveQuery(db, connection);
        }
    }

    private static DataSource _initDataSource(String prefix) throws Exception {
        Properties properties = PropsUtil.getProperties(prefix, true);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        DataSource dataSource = DataSourceFactoryUtil.initDataSource((Properties)properties);
        DBManagerUtil.setDB((Object)DialectDetector.getDialect(dataSource), (DataSource)dataSource);
        return dataSource;
    }

    private static void _runSQLTemplate(DB db, Connection connection, ClassLoader classLoader, String path) throws Exception {
        db.runSQLTemplateString(connection, StreamUtil.toString((InputStream)classLoader.getResourceAsStream("com/liferay/portal/tools/sql/dependencies/".concat(path))), false);
    }

    private static void _setSupportsStringCaseSensitiveQuery(DB db, Connection connection) throws Exception {
        if (!DBInitUtil._hasDefaultReleaseWithTestString(connection, ReleaseConstants.TEST_STRING)) {
            throw new SystemException("Release_ table was not initialized properly");
        }
        if (DBInitUtil._hasDefaultReleaseWithTestString(connection, StringUtil.toUpperCase((String)ReleaseConstants.TEST_STRING))) {
            db.setSupportsStringCaseSensitiveQuery(false);
        } else {
            db.setSupportsStringCaseSensitiveQuery(true);
        }
    }

    private DBInitUtil() {
    }
}

