/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.deploy.BaseAutoDeployer;
import java.io.File;
import java.util.Map;

public class ThemeAutoDeployer
extends BaseAutoDeployer
implements AutoDeployer {
    private static final Log _log = LogFactoryUtil.getLog(ThemeAutoDeployer.class);

    public ThemeAutoDeployer() {
        super("theme");
        try {
            this.themeTaglibDTD = DeployUtil.getResourcePath(this.tempDirPaths, "liferay-theme.tld");
            if (Validator.isNull((String)this.themeTaglibDTD)) {
                throw new IllegalArgumentException("The system property deployer.theme.taglib.dtd is not set");
            }
            this.utilTaglibDTD = DeployUtil.getResourcePath(this.tempDirPaths, "liferay-util.tld");
            if (Validator.isNull((String)this.utilTaglibDTD)) {
                throw new IllegalArgumentException("The system property deployer.util.taglib.dtd is not set");
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    @Override
    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        if (file.isDirectory()) {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Modifying themes for " + file.getPath()));
                }
                this.deployDirectory(file, autoDeploymentContext.getContext(), autoDeploymentContext.getPluginPackage());
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Themes for " + file.getPath() + " modified successfully"));
                }
                return 1;
            }
            catch (Exception exception) {
                throw new AutoDeployException((Throwable)exception);
            }
        }
        return super.autoDeploy(autoDeploymentContext);
    }

    @Override
    public Map<String, String> processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        Map<String, String> filterMap = super.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        if (filterMap == null) {
            return null;
        }
        String moduleArtifactId = filterMap.get("module_artifact_id");
        int pos = moduleArtifactId.indexOf("-theme");
        String themeId = moduleArtifactId.substring(0, pos);
        filterMap.put("theme_id", themeId);
        String themeName = filterMap.get("plugin_name");
        filterMap.put("theme_name", StringUtil.stripCDATA((String)themeName));
        String liferayVersions = filterMap.get("liferay_versions");
        filterMap.put("theme_versions", StringUtil.replace((String)liferayVersions, (String)"liferay-version", (String)"version"));
        this.copyDependencyXml("liferay-look-and-feel.xml", srcFile + "/WEB-INF", filterMap, true);
        return filterMap;
    }
}

