/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageBuilderUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageOverrideProvider;
import com.liferay.portal.language.ResourceBundleEnumeration;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LanguageResources {
    public static ResourceBundleLoader PORTAL_RESOURCE_BUNDLE_LOADER = new ResourceBundleLoader(){

        public ResourceBundle loadResourceBundle(Locale locale) {
            return LanguageResources.getResourceBundle(locale);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(LanguageResources.class);
    private static final Locale _blankLocale = new Locale("");
    private static String[] _configNames = new String[0];
    private static final Map<Locale, Map<String, String>> _languageMaps = new ConcurrentHashMap<Locale, Map<String, String>>(64);
    private static volatile LanguageOverrideProvider _languageOverrideProvider = (LanguageOverrideProvider)ServiceProxyFactory.newServiceTrackedInstance(LanguageOverrideProvider.class, LanguageResources.class, (String)"_languageOverrideProvider", (boolean)false);
    private static final Locale _nullLocale = new Locale("");
    private static final Map<Locale, Locale> _superLocales = new ConcurrentHashMap<Locale, Locale>();
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private ServiceTracker<?, ?> _serviceTracker;

    public static String getMessage(Locale locale, String key) {
        String value;
        if (locale == null) {
            return null;
        }
        String overrideValue = LanguageResources._getOverrideValue(key, locale);
        if (overrideValue != null) {
            return overrideValue;
        }
        Map<String, String> languageMap = _languageMaps.get(locale);
        if (languageMap == null) {
            languageMap = LanguageResources._loadLocale(locale);
        }
        if ((value = languageMap.get(key)) == null) {
            return LanguageResources.getMessage(LanguageResources.getSuperLocale(locale), key);
        }
        return value;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return new LanguageResourcesBundle(locale);
    }

    public static Locale getSuperLocale(Locale locale) {
        Locale superLocale = _superLocales.get(locale);
        if (superLocale != null) {
            if (superLocale == _nullLocale) {
                return null;
            }
            return superLocale;
        }
        superLocale = LanguageResources._getSuperLocale(locale);
        if (superLocale == null) {
            _superLocales.put(locale, _nullLocale);
        } else {
            _superLocales.put(locale, superLocale);
        }
        return superLocale;
    }

    public void afterPropertiesSet() {
        Filter languageResourceFilter = SystemBundleUtil.createFilter((String)("(&(!(javax.portlet.name=*))(language.id=*)(objectClass=" + ResourceBundle.class.getName() + "))"));
        this._serviceTracker = new ServiceTracker(this._bundleContext, languageResourceFilter, (ServiceTrackerCustomizer)new LanguageResourceServiceTrackerCustomizer());
        this._serviceTracker.open();
        ResourceBundleLoaderUtil.setPortalResourceBundleLoader((ResourceBundleLoader)PORTAL_RESOURCE_BUNDLE_LOADER);
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    public void setConfig(String config) {
        _configNames = StringUtil.split((String)StringUtil.replace((String)config, (char)'.', (char)'/'));
    }

    private static void _fixValues(Map<String, String> languageMap, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = LanguageBuilderUtil.fixValue((String)value);
            languageMap.put(key, value);
        }
    }

    private static String _getOverrideValue(String key, Locale locale) {
        LanguageOverrideProvider languageOverrideProvider = _languageOverrideProvider;
        if (languageOverrideProvider == null) {
            return null;
        }
        String value = languageOverrideProvider.get(key, locale);
        if (value == null) {
            return null;
        }
        return value;
    }

    private static Set<String> _getSetWithOverrideKeys(Set<String> keySet, Locale locale) {
        LanguageOverrideProvider languageOverrideProvider = _languageOverrideProvider;
        if (languageOverrideProvider == null) {
            return keySet;
        }
        Set<String> overrideKeySet = languageOverrideProvider.keySet(locale);
        if (SetUtil.isEmpty(overrideKeySet)) {
            return keySet;
        }
        HashSet<String> resultSet = new HashSet<String>(keySet);
        resultSet.addAll(overrideKeySet);
        return resultSet;
    }

    private static Locale _getSuperLocale(Locale locale) {
        String variant = locale.getVariant();
        if (variant.length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        String country = locale.getCountry();
        if (country.length() > 0) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (priorityLocale != null) {
                variant = priorityLocale.getVariant();
            }
            if (priorityLocale != null && !locale.equals(priorityLocale) && variant.length() <= 0) {
                return new Locale(priorityLocale.getLanguage(), priorityLocale.getCountry());
            }
            return LocaleUtil.fromLanguageId((String)locale.getLanguage(), (boolean)false, (boolean)true);
        }
        String language = locale.getLanguage();
        if (language.length() > 0) {
            return _blankLocale;
        }
        return null;
    }

    private static Map<String, String> _loadLocale(Locale locale) {
        Map<String, String> languageMap = null;
        if (_configNames.length > 0) {
            String localeName = locale.toString();
            languageMap = new HashMap();
            for (String name : _configNames) {
                StringBundler sb = new StringBundler(4);
                sb.append(name);
                if (localeName.length() > 0) {
                    sb.append("_");
                    sb.append(localeName);
                }
                sb.append(".properties");
                Properties properties = LanguageResources._loadProperties(sb.toString());
                LanguageResources._fixValues(languageMap, properties);
            }
        } else {
            languageMap = Collections.emptyMap();
        }
        _languageMaps.put(locale, languageMap);
        return languageMap;
    }

    private static Properties _loadProperties(String name) {
        Properties properties;
        block15: {
            properties = new Properties();
            try {
                ClassLoader classLoader = LanguageResources.class.getClassLoader();
                Enumeration<URL> enumeration = classLoader.getResources(name);
                if (_log.isDebugEnabled() && !enumeration.hasMoreElements()) {
                    _log.debug((Object)("No resources found for " + name));
                }
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Loading ", name, " from ", url}));
                    }
                    InputStream inputStream = url.openStream();
                    Throwable throwable = null;
                    try {
                        Properties inputStreamProperties = PropertiesUtil.load((InputStream)inputStream, (String)"UTF-8");
                        properties.putAll((Map<?, ?>)inputStreamProperties);
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Loading ", url, " with ", inputStreamProperties.size(), " values"}));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block15;
                _log.warn((Throwable)exception);
            }
        }
        return properties;
    }

    private Map<String, String> _putLanguageMap(Locale locale, Map<String, String> languageMap) {
        Map<String, String> oldLanguageMap = _languageMaps.get(locale);
        if (oldLanguageMap == null) {
            LanguageResources._loadLocale(locale);
            oldLanguageMap = _languageMaps.get(locale);
        }
        HashMap<String, String> newLanguageMap = new HashMap<String, String>();
        if (oldLanguageMap != null) {
            newLanguageMap.putAll(oldLanguageMap);
        }
        HashMap<String, String> diffLanguageMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : languageMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String oldValue = null;
            oldValue = value == null ? (String)newLanguageMap.remove(key) : newLanguageMap.put(key, value);
            diffLanguageMap.put(entry.getKey(), oldValue);
        }
        _languageMaps.put(locale, newLanguageMap);
        return diffLanguageMap;
    }

    private class LanguageResourceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ResourceBundle, ResourceBundleInfo> {
        private final Map<String, List<ResourceBundleInfo>> _languageResourceExtensions = new HashMap<String, List<ResourceBundleInfo>>();

        private LanguageResourceServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceBundleInfo addingService(ServiceReference<ResourceBundle> serviceReference) {
            ResourceBundle resourceBundle = (ResourceBundle)LanguageResources.this._bundleContext.getService(serviceReference);
            String languageId = GetterUtil.getString((Object)serviceReference.getProperty("language.id"));
            Locale locale = null;
            if (Validator.isNotNull((String)languageId)) {
                locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)false);
            } else {
                languageId = "";
                locale = new Locale("");
            }
            Map<String, String> languageMap = this._getLanguageMap(resourceBundle);
            String string = languageId.intern();
            synchronized (string) {
                List resourceBundleInfos = this._languageResourceExtensions.computeIfAbsent(languageId, key -> new ArrayList());
                ResourceBundleInfo resourceBundleInfo = new ResourceBundleInfo(languageId, locale, serviceReference);
                int index = Collections.binarySearch(resourceBundleInfos, resourceBundleInfo);
                index = -index - 1;
                resourceBundleInfos.add(index, resourceBundleInfo);
                Map diffLanguageMap = new HashMap();
                for (int i = index + 1; i < resourceBundleInfos.size(); ++i) {
                    ResourceBundleInfo nextResourceBundleInfo = (ResourceBundleInfo)resourceBundleInfos.get(i);
                    Map nextDiffLanguageMap = nextResourceBundleInfo._diffLanguageMap;
                    for (Map.Entry entry : nextDiffLanguageMap.entrySet()) {
                        String key2 = (String)entry.getKey();
                        if (!languageMap.containsKey(key2)) continue;
                        diffLanguageMap.put(key2, entry.getValue());
                        entry.setValue(languageMap.remove(key2));
                    }
                }
                if (diffLanguageMap.isEmpty()) {
                    diffLanguageMap = LanguageResources.this._putLanguageMap(locale, languageMap);
                } else {
                    diffLanguageMap.putAll(LanguageResources.this._putLanguageMap(locale, languageMap));
                }
                resourceBundleInfo._diffLanguageMap = diffLanguageMap;
                return resourceBundleInfo;
            }
        }

        public void modifiedService(ServiceReference<ResourceBundle> serviceReference, ResourceBundleInfo resourceBundleInfo) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ResourceBundle> serviceReference, ResourceBundleInfo resourceBundleInfo) {
            LanguageResources.this._bundleContext.ungetService(serviceReference);
            String languageId = resourceBundleInfo._languageId;
            String string = languageId.intern();
            synchronized (string) {
                List<ResourceBundleInfo> resourceBundleInfos = this._languageResourceExtensions.get(languageId);
                int index = Collections.binarySearch(resourceBundleInfos, resourceBundleInfo);
                Map diffLanguageMap = resourceBundleInfo._diffLanguageMap;
                for (int i = index + 1; i < resourceBundleInfos.size(); ++i) {
                    ResourceBundleInfo nextResourceBundleInfo = resourceBundleInfos.get(i);
                    Map nextDiffLanguageMap = nextResourceBundleInfo._diffLanguageMap;
                    for (Map.Entry entry : nextDiffLanguageMap.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!diffLanguageMap.containsKey(key)) continue;
                        entry.setValue(diffLanguageMap.remove(key));
                    }
                }
                LanguageResources.this._putLanguageMap(resourceBundleInfo._locale, diffLanguageMap);
                resourceBundleInfos.remove(index);
            }
        }

        private Map<String, String> _getLanguageMap(ResourceBundle resourceBundle) {
            HashMap<String, String> languageMap = new HashMap<String, String>();
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
                languageMap.put(key, value);
            }
            return languageMap;
        }
    }

    private static class ResourceBundleInfo
    implements Comparable<ResourceBundleInfo> {
        private Map<String, String> _diffLanguageMap;
        private final String _languageId;
        private final Locale _locale;
        private final ServiceReference<?> _serviceReference;

        @Override
        public int compareTo(ResourceBundleInfo resourceBundleInfo) {
            return this._serviceReference.compareTo(resourceBundleInfo._serviceReference);
        }

        private ResourceBundleInfo(String languageId, Locale locale, ServiceReference<?> serviceReference) {
            this._languageId = languageId;
            this._locale = locale;
            this._serviceReference = serviceReference;
        }
    }

    private static class LanguageResourcesBundle
    extends ResourceBundle {
        private final Locale _locale;

        @Override
        public Enumeration<String> getKeys() {
            Map<String, String> languageMap = this._getLanguageMap();
            Set keySet = LanguageResources._getSetWithOverrideKeys(languageMap.keySet(), this._locale);
            if (this.parent == null) {
                return Collections.enumeration(keySet);
            }
            return new ResourceBundleEnumeration(keySet, this.parent.getKeys());
        }

        @Override
        public Locale getLocale() {
            return this._locale;
        }

        @Override
        protected Object handleGetObject(String key) {
            String overrideValue = LanguageResources._getOverrideValue(key, this._locale);
            if (overrideValue != null) {
                return overrideValue;
            }
            Map<String, String> languageMap = this._getLanguageMap();
            return languageMap.get(key);
        }

        @Override
        protected Set<String> handleKeySet() {
            Map<String, String> languageMap = this._getLanguageMap();
            return LanguageResources._getSetWithOverrideKeys(languageMap.keySet(), this._locale);
        }

        private LanguageResourcesBundle(Locale locale) {
            this._locale = locale;
            Locale superLocale = LanguageResources.getSuperLocale(locale);
            if (superLocale != null) {
                this.setParent(new LanguageResourcesBundle(superLocale));
            }
        }

        private Map<String, String> _getLanguageMap() {
            Map languageMap = (Map)_languageMaps.get(this._locale);
            if (languageMap == null) {
                languageMap = LanguageResources._loadLocale(this._locale);
            }
            return languageMap;
        }
    }
}

