/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PortalService;
import com.liferay.portal.kernel.service.persistence.ClassNamePersistence;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.service.base.PortalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;

@JSONWebService(mode=JSONWebServiceMode.MANUAL)
public class PortalServiceImpl
extends PortalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalServiceImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[0], (Class[])new Class[0]);
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ClassNamePersistence.class)
    private ClassNamePersistence _classNamePersistence;

    public String getAutoDeployDirectory() {
        return PropsValues.AUTO_DEPLOY_DEPLOY_DIR;
    }

    @JSONWebService
    public int getBuildNumber() {
        return ReleaseInfo.getBuildNumber();
    }

    @JSONWebService
    public String getVersion() {
        return ReleaseInfo.getVersion();
    }

    public void testAddClassName_Rollback(String classNameValue) {
        this.addClassName(classNameValue);
        throw new SystemException();
    }

    public void testAddClassName_Success(String classNameValue) {
        this.addClassName(classNameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void testAutoSyncHibernateSessionStateOnTxCreation() {
        ClassName className = this._classNameLocalService.addClassName("testAutoSyncHibernateSessionStateOnTxCreation1");
        try {
            EntityCacheUtil.clearCache();
            className = this._classNamePersistence.fetchByPrimaryKey(className.getClassNameId());
            Session currentSession = this._classNamePersistence.getCurrentSession();
            if (!currentSession.contains((Object)className)) {
                throw new IllegalStateException("Entities are not available in Hibernate's first level cache");
            }
            String newValue = "testAutoSyncHibernateSessionStateOnTxCreation2";
            long classNameId = className.getClassNameId();
            try {
                TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                    ClassName localClassName = this._classNamePersistence.findByPrimaryKey(classNameId);
                    localClassName.setValue(newValue);
                    this._classNameLocalService.updateClassName(localClassName);
                    return null;
                });
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            if (currentSession.contains((Object)className)) {
                throw new IllegalStateException("Entities are still available in Hibernate's first level cache");
            }
            EntityCacheUtil.clearCache();
            className = this._classNamePersistence.fetchByPrimaryKey(className.getClassNameId());
            if (!newValue.equals(className.getValue())) {
                throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Expected ", newValue, " but found ", className.getClassName()}));
            }
        }
        finally {
            this._classNameLocalService.deleteClassName(className);
        }
    }

    public void testDeleteClassName() throws PortalException {
        this._classNamePersistence.removeByValue(PortalService.class.getName());
    }

    public int testGetBuildNumber() {
        return this.portalService.getBuildNumber();
    }

    public void testGetUserId() {
        long userId = 0L;
        try {
            userId = this.getUserId();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("User id " + userId));
        }
    }

    public boolean testHasClassName() {
        int count = this._classNamePersistence.countByValue(PortalService.class.getName());
        return count > 0;
    }

    protected void addClassName(String classNameValue) {
        long classNameId = this.counterLocalService.increment();
        ClassName className = this._classNamePersistence.create(classNameId);
        className.setValue(classNameValue);
        this._classNamePersistence.update((BaseModel)className);
    }
}

