/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.service.base.UserGroupRoleServiceBaseImpl;
import java.util.ArrayList;

public class UserGroupRoleServiceImpl
extends UserGroupRoleServiceBaseImpl {
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;
    @BeanReference(type=RolePersistence.class)
    private RolePersistence _rolePersistence;

    public void addUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException {
        ArrayList<UserGroupRole> organizationUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> siteUserGroupRoles = new ArrayList<UserGroupRole>();
        Group group = this._groupLocalService.getGroup(groupId);
        for (long roleId : roleIds) {
            Role role = this._rolePersistence.findByPrimaryKey(roleId);
            UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (Role)role);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(0L);
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupId);
            userGroupRole.setRoleId(roleId);
            if (role.getType() == 3) {
                organizationUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() != 2) continue;
            siteUserGroupRoles.add(userGroupRole);
        }
        if (!siteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.checkRoles(siteUserGroupRoles, null);
        }
        if (!organizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.checkRoles(organizationUserGroupRoles, null);
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, roleIds);
        if (!siteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.propagateRoles(siteUserGroupRoles, null);
        }
        if (!organizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateRoles(organizationUserGroupRoles, null);
        }
    }

    public void addUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException {
        UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)roleId);
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long userId : userIds) {
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(0L);
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupId);
            userGroupRole.setRoleId(roleId);
            userGroupRoles.add(userGroupRole);
        }
        if (userGroupRoles.isEmpty()) {
            return;
        }
        Role role = this._rolePersistence.findByPrimaryKey(roleId);
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.checkRoles(userGroupRoles, null);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.checkRoles(userGroupRoles, null);
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userIds, groupId, roleId);
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.propagateRoles(userGroupRoles, null);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.propagateRoles(userGroupRoles, null);
        }
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException {
        ArrayList<UserGroupRole> filteredDepotUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> filteredOrganizationUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> filteredSiteUserGroupRoles = new ArrayList<UserGroupRole>();
        Group group = this._groupLocalService.getGroup(groupId);
        for (long roleId : roleIds) {
            Role role = this._roleLocalService.getRole(roleId);
            UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (Role)role);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(0L);
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupId);
            userGroupRole.setRoleId(roleId);
            if (role.getType() == 5) {
                filteredDepotUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() == 3) {
                if (OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)group.getOrganizationId(), (long)roleId)) continue;
                filteredOrganizationUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() != 2 || SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)groupId, (long)roleId)) continue;
            filteredSiteUserGroupRoles.add(userGroupRole);
        }
        if (filteredDepotUserGroupRoles.isEmpty() && filteredOrganizationUserGroupRoles.isEmpty() && filteredSiteUserGroupRoles.isEmpty()) {
            return;
        }
        if (!filteredOrganizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.checkRoles(null, filteredOrganizationUserGroupRoles);
        }
        if (!filteredSiteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.checkRoles(null, filteredSiteUserGroupRoles);
        }
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupId, roleIds);
        if (!filteredOrganizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateRoles(null, filteredOrganizationUserGroupRoles);
        }
        if (!filteredSiteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.propagateRoles(null, filteredSiteUserGroupRoles);
        }
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException {
        UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)roleId);
        ArrayList<UserGroupRole> filteredUserGroupRoles = new ArrayList<UserGroupRole>();
        Role role = this._rolePersistence.findByPrimaryKey(roleId);
        for (long userId : userIds) {
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(0L);
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupId);
            userGroupRole.setRoleId(roleId);
            if (role.getType() == 5) {
                filteredUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() == 3) {
                Group group = this._groupPersistence.findByPrimaryKey(groupId);
                if (OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)group.getOrganizationId(), (long)roleId)) continue;
                filteredUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() != 2 || SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)groupId, (long)roleId)) continue;
            filteredUserGroupRoles.add(userGroupRole);
        }
        if (filteredUserGroupRoles.isEmpty()) {
            return;
        }
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.checkRoles(null, filteredUserGroupRoles);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.checkRoles(null, filteredUserGroupRoles);
        }
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, roleId);
        if (role.getType() == 2) {
            SiteMembershipPolicyUtil.propagateRoles(null, filteredUserGroupRoles);
        } else if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.propagateRoles(null, filteredUserGroupRoles);
        }
    }

    public void updateUserGroupRoles(long userId, long groupId, long[] addedRoleIds, long[] deletedRoleIds) throws PortalException {
        this.addUserGroupRoles(userId, groupId, addedRoleIds);
        this.deleteUserGroupRoles(userId, groupId, deletedRoleIds);
    }
}

