/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.authverifier;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierConfiguration;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthVerifierFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog((String)AuthVerifierFilter.class.getName());
    private boolean _guestAllowed = true;
    private final Set<String> _hostsAllowed = new HashSet<String>();
    private boolean _httpsRequired;
    private final Map<String, Object> _initParametersMap = new HashMap<String, Object>();

    public void init(FilterConfig filterConfig) {
        ServletContext servletContext;
        super.init(filterConfig);
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = filterConfig.getInitParameter(name);
            this._initParametersMap.put(name, value);
        }
        String portalPropertyPrefix = GetterUtil.getString((Object)this._initParametersMap.get("portal_property_prefix"));
        if (Validator.isNotNull((String)portalPropertyPrefix)) {
            Properties properties = PropsUtil.getProperties(portalPropertyPrefix, true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._initParametersMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (this._initParametersMap.containsKey("guest.allowed")) {
            this._guestAllowed = GetterUtil.getBoolean((Object)this._initParametersMap.get("guest.allowed"), (boolean)true);
            this._initParametersMap.remove("guest.allowed");
        }
        if (this._initParametersMap.containsKey("hosts.allowed")) {
            String[] hostsAllowed;
            String hostsAllowedString = (String)this._initParametersMap.get("hosts.allowed");
            for (String hostAllowed : hostsAllowed = StringUtil.split((String)hostsAllowedString)) {
                this._hostsAllowed.add(hostAllowed);
            }
            this._initParametersMap.remove("hosts.allowed");
        }
        if (this._initParametersMap.containsKey("https.required")) {
            this._httpsRequired = GetterUtil.getBoolean((Object)this._initParametersMap.get("https.required"));
            this._initParametersMap.remove("https.required");
        }
        if (this._initParametersMap.containsKey("use_permission_checker")) {
            this._initParametersMap.remove("use_permission_checker");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"use_permission_checker is deprecated");
            }
        }
        if (!(servletContext = filterConfig.getServletContext()).equals(ServletContextPool.get((String)PortalUtil.getServletContextName()))) {
            this._initParametersMap.put(AuthVerifierPipeline.class.getName(), new AuthVerifierPipeline(this._buildAuthVerifierConfigurations(this._initParametersMap), servletContext.getContextPath()));
        }
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (!this._isAccessAllowed(httpServletRequest, httpServletResponse) || this._isApplySSL(httpServletRequest, httpServletResponse)) {
            return;
        }
        if (this._isCORSPreflightRequest(httpServletRequest)) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            this.processFilter(clazz.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        AccessControlUtil.initAccessControlContext((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, this._initParametersMap);
        AuthVerifierResult.State state = AccessControlUtil.verifyRequest();
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        AuthVerifierResult authVerifierResult = accessControlContext.getAuthVerifierResult();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Auth verifier result " + authVerifierResult));
        }
        if (state == AuthVerifierResult.State.INVALID_CREDENTIALS) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Result state does not allow us to continue");
            }
        } else if (state == AuthVerifierResult.State.NOT_APPLICABLE) {
            _log.error((Object)("Invalid state " + state));
        } else if (!this._guestAllowed && state == AuthVerifierResult.State.UNSUCCESSFUL) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Guest is not allowed to access " + httpServletRequest.getRequestURI()));
            }
            httpServletResponse.sendError(403, "Authorization required");
        } else if (this._guestAllowed || state == AuthVerifierResult.State.SUCCESS) {
            long userId = authVerifierResult.getUserId();
            AccessControlUtil.initContextUser((long)userId);
            String authType = MapUtil.getString((Map)accessControlContext.getSettings(), (String)"auth.type");
            ProtectedServletRequest protectedServletRequest = new ProtectedServletRequest(httpServletRequest, String.valueOf(userId), authType);
            accessControlContext.setRequest((HttpServletRequest)protectedServletRequest);
            Class<?> clazz = ((Object)((Object)this)).getClass();
            this.processFilter(clazz.getName(), (HttpServletRequest)protectedServletRequest, httpServletResponse, filterChain);
        } else {
            _log.error((Object)("Unimplemented state " + state));
        }
    }

    private List<AuthVerifierConfiguration> _buildAuthVerifierConfigurations(Map<String, Object> initParametersMap) {
        HashMap<String, Integer> authVerifierConfigurationIndexs = new HashMap<String, Integer>();
        ArrayList<AuthVerifierConfiguration> authVerifierConfigurations = new ArrayList<AuthVerifierConfiguration>();
        for (Map.Entry<String, Object> entry : initParametersMap.entrySet()) {
            AuthVerifierConfiguration authVerifierConfiguration;
            int index;
            String propertyName = entry.getKey();
            if (!propertyName.startsWith("auth.verifier.")) continue;
            String authVerifierPropertyName = propertyName.substring("auth.verifier.".length());
            String authVerifierClassName = authVerifierPropertyName.substring(0, index = authVerifierPropertyName.indexOf(46));
            Integer authVerifierConfigurationIndex = (Integer)authVerifierConfigurationIndexs.get(authVerifierClassName);
            if (authVerifierConfigurationIndex == null) {
                authVerifierConfigurations.add(new AuthVerifierConfiguration());
                authVerifierConfigurationIndex = authVerifierConfigurations.size() - 1;
                authVerifierConfigurationIndexs.put(authVerifierClassName, authVerifierConfigurationIndex);
            }
            if ((authVerifierConfiguration = authVerifierConfigurations.get(authVerifierConfigurationIndex)).getAuthVerifierClassName() == null) {
                authVerifierConfiguration.setAuthVerifierClassName(authVerifierClassName);
            }
            if (authVerifierConfiguration.getProperties() == null) {
                authVerifierConfiguration.setProperties(new Properties());
            }
            Properties properties = authVerifierConfiguration.getProperties();
            properties.put(authVerifierPropertyName.substring(index + 1), entry.getValue());
        }
        return authVerifierConfigurations;
    }

    private boolean _isAccessAllowed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String remoteAddr = httpServletRequest.getRemoteAddr();
        if (AccessControlUtil.isAccessAllowed((HttpServletRequest)httpServletRequest, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Access denied for " + remoteAddr));
        }
        httpServletResponse.sendError(403, "Access denied for " + remoteAddr);
        return false;
    }

    private boolean _isApplySSL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this._httpsRequired || PortalUtil.isSecure((HttpServletRequest)httpServletRequest)) {
            return false;
        }
        if (_log.isDebugEnabled()) {
            String completeURL = HttpComponentsUtil.getCompleteURL((HttpServletRequest)httpServletRequest);
            _log.debug((Object)("Securing " + completeURL));
        }
        StringBundler sb = new StringBundler(5);
        sb.append(PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest, (boolean)true));
        sb.append(PortalUtil.getPathContext((HttpServletRequest)httpServletRequest));
        sb.append(httpServletRequest.getRequestURI());
        if (Validator.isNotNull((String)httpServletRequest.getQueryString())) {
            sb.append("?");
            sb.append(httpServletRequest.getQueryString());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect to " + sb.toString()));
        }
        httpServletResponse.sendRedirect(sb.toString());
        return true;
    }

    private boolean _isCORSPreflightRequest(HttpServletRequest httpServletRequest) {
        return StringUtil.equals((String)httpServletRequest.getMethod(), (String)"OPTIONS") && Validator.isNotNull((String)httpServletRequest.getHeader("Origin"));
    }
}

