/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.propertiesdoc;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.propertiesdoc.PropertiesSection;
import com.liferay.portal.tools.propertiesdoc.PropertyComment;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertiesDocBuilder {
    protected static final String DOUBLE_INDENT = "        ";
    protected static final String INDENT = "    ";
    private static final Log _log = LogFactoryUtil.getLog(PropertiesDocBuilder.class);
    private static final FileImpl _fileImpl = FileImpl.getInstance();

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            new PropertiesDocBuilder(arguments);
        }
        catch (Exception exception) {
            ArgumentsUtil.processMainException(arguments, exception);
        }
    }

    public PropertiesDocBuilder(Map<String, String> arguments) throws IOException {
        String propertiesFileName = GetterUtil.getString((String)arguments.get("properties.file"));
        System.out.println("Converting " + propertiesFileName + " to HTML");
        File propertiesFile = new File(propertiesFileName);
        List<PropertiesSection> propertiesSections = this.getPropertiesSections(propertiesFile);
        if (propertiesSections == null) {
            return;
        }
        int pos = propertiesFileName.lastIndexOf("/");
        if (pos != -1) {
            propertiesFileName = propertiesFileName.substring(pos + 1);
        }
        HashMap context = HashMapBuilder.put((Object)"pageTitle", (Object)GetterUtil.getString((String)arguments.get("properties.title"))).put((Object)"propertiesFileName", (Object)propertiesFileName).put((Object)"sections", propertiesSections).put((Object)"toc", (Object)GetterUtil.getBoolean((String)arguments.get("properties.toc"))).build();
        try {
            StringBundler sb = new StringBundler(4);
            String propertiesDestDirName = GetterUtil.getString((String)arguments.get("properties.dest.dir"));
            sb.append(propertiesDestDirName);
            sb.append("/");
            sb.append(propertiesFileName);
            sb.append(".html");
            String propertiesHTMLFileName = sb.toString();
            File propertiesHTMLFile = new File(propertiesHTMLFileName);
            System.out.println("Writing " + propertiesHTMLFile);
            Charset charset = Charset.forName("UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesHTMLFile), charset.newEncoder());
            try {
                FreeMarkerUtil.process("com/liferay/portal/tools/propertiesdoc/dependencies/properties.ftl", context, writer);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            ((Writer)writer).flush();
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
    }

    protected void addPropertyComment(List<PropertyComment> propertyComments, String comment) {
        if (Validator.isNotNull((String)comment)) {
            PropertyComment propertyComment = new PropertyComment(comment);
            propertyComments.add(propertyComment);
        }
    }

    protected List<String> extractComments(String[] lines) {
        ArrayList<String> comments = new ArrayList<String>();
        StringBundler sb = new StringBundler();
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("## ")) {
                trimmedLine = trimmedLine.substring(2);
                sb.append(trimmedLine.trim());
            }
            if (trimmedLine.length() >= 3 || sb.index() == 0) continue;
            comments.add(sb.toString());
            sb = new StringBundler();
        }
        return comments;
    }

    protected String extractDefaultProperties(String[] lines) {
        StringBundler sb = new StringBundler();
        boolean previousLineIsDefaultProperty = false;
        for (String line : lines) {
            if (!previousLineIsDefaultProperty) {
                if (line.startsWith("#") || line.startsWith("    #")) continue;
                previousLineIsDefaultProperty = true;
                sb.append(line);
                sb.append("\n");
                continue;
            }
            if (line.startsWith("#") || line.startsWith("    #")) {
                previousLineIsDefaultProperty = false;
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String extractExampleProperties(String[] lines) {
        StringBundler sb = new StringBundler();
        boolean previousLineIsExample = false;
        for (String line : lines) {
            String exampleProperty;
            String trimmedLine = line.trim();
            if (!previousLineIsExample) {
                if (line.startsWith("    # ") || trimmedLine.equals("#") || !line.startsWith("    #")) continue;
                previousLineIsExample = true;
                exampleProperty = StringUtil.replaceFirst((String)line, (char)'#', (String)"") + "\n";
                sb.append(exampleProperty);
                continue;
            }
            if (!trimmedLine.startsWith("#")) {
                previousLineIsExample = false;
                continue;
            }
            exampleProperty = line.replaceFirst("#", "") + "\n";
            sb.append(exampleProperty);
        }
        return sb.toString();
    }

    protected List<PropertyComment> extractPropertyComments(String[] lines) {
        ArrayList<PropertyComment> propertyComments = new ArrayList<PropertyComment>();
        StringBundler sb = new StringBundler();
        boolean previousLineIsPreformatted = false;
        for (String line : lines) {
            if ((line = StringUtil.trimTrailing((String)line)).startsWith("        #")) break;
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("#     ")) {
                if (previousLineIsPreformatted) {
                    sb.append(StringUtil.replaceFirst((String)trimmedLine, (char)'#', (String)""));
                } else {
                    this.addPropertyComment(propertyComments, sb.toString());
                    sb = new StringBundler();
                    sb.append(StringUtil.replaceFirst((String)trimmedLine, (char)'#', (String)""));
                }
                sb.append("\n");
                previousLineIsPreformatted = true;
                continue;
            }
            if (trimmedLine.startsWith("# ")) {
                if (previousLineIsPreformatted) {
                    this.addPropertyComment(propertyComments, sb.toString());
                    sb = new StringBundler();
                    trimmedLine = StringUtil.replaceFirst((String)trimmedLine, (char)'#', (String)"");
                    sb.append(trimmedLine.trim());
                } else {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    line = StringUtil.replaceFirst((String)line, (char)'#', (String)"");
                    sb.append(line.trim());
                }
                sb.append("\n");
                previousLineIsPreformatted = false;
                continue;
            }
            if (trimmedLine.startsWith("#") && trimmedLine.length() < 2) {
                this.addPropertyComment(propertyComments, sb.toString());
                sb = new StringBundler();
                continue;
            }
            this.addPropertyComment(propertyComments, sb.toString());
            break;
        }
        return propertyComments;
    }

    protected String extractTitle(String[] lines) {
        if (lines == null || lines.length <= 1) {
            return null;
        }
        String title = lines[1];
        title = StringUtil.replaceFirst((String)title, (String)"##", (String)"");
        return title.trim();
    }

    protected int getLineCount(String sectionString) {
        String[] lines = sectionString.split("\r\n|\r|\n");
        return lines.length;
    }

    protected List<PropertiesSection> getPropertiesSections(File propertiesFile) throws IOException {
        String content = _fileImpl.read(propertiesFile);
        String[] sections = content.split("\n\n");
        ArrayList<PropertiesSection> propertiesSections = new ArrayList<PropertiesSection>(sections.length);
        for (String section : sections) {
            section = StringUtil.trimLeading((String)section, (char)' ');
            PropertiesSection propertiesSection = new PropertiesSection(section);
            String[] lines = section.split("\n");
            if (section.startsWith("##")) {
                int lineCount = this.getLineCount(section);
                if (lineCount == 3) {
                    propertiesSection.setTitle(this.extractTitle(lines));
                    propertiesSections.add(propertiesSection);
                    continue;
                }
                if (lineCount > 3) {
                    propertiesSection.setComments(this.extractComments(lines));
                    propertiesSections.add(propertiesSection);
                    continue;
                }
                System.out.println(StringBundler.concat((String[])new String[]{"Properties section should consist of 3 or more ", "lines:", "\n", "##", "\n", "## Comments", "\n", "##"}));
                return null;
            }
            propertiesSection.setDefaultProperties(this.extractDefaultProperties(lines));
            propertiesSection.setExampleProperties(this.extractExampleProperties(lines));
            propertiesSection.setPropertyComments(this.extractPropertyComments(lines));
            propertiesSections.add(propertiesSection);
        }
        return propertiesSections;
    }
}

