/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;

public class VerifyRole
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyRole.class);

    protected void addViewSiteAdministrationPermission(Role role) throws Exception {
        String name = Group.class.getName();
        Group group = GroupLocalServiceUtil.getGroup((long)role.getCompanyId(), (String)"User Personal Site");
        String primKey = String.valueOf(group.getGroupId());
        if (!ResourcePermissionLocalServiceUtil.hasResourcePermission((long)role.getCompanyId(), (String)name, (int)2, (String)primKey, (long)role.getRoleId(), (String)"MANAGE_LAYOUTS") || ResourcePermissionLocalServiceUtil.hasResourcePermission((long)role.getCompanyId(), (String)name, (int)2, (String)primKey, (long)role.getRoleId(), (String)"VIEW_SITE_ADMINISTRATION")) {
            return;
        }
        ResourcePermissionLocalServiceUtil.addResourcePermission((long)role.getCompanyId(), (String)name, (int)2, (String)primKey, (long)role.getRoleId(), (String)"VIEW_SITE_ADMINISTRATION");
    }

    @Override
    protected void doVerify() throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> this.verifyRoles((long)companyId), (long[])PortalInstances.getCompanyIdsBySQL());
    }

    protected void verifyRoles(long companyId) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(String.valueOf(companyId));){
            try {
                Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
                this.addViewSiteAdministrationPermission(powerUserRole);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchRoleException);
                }
            }
        }
    }
}

