/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.AssetCategoryNameException;
import com.liferay.asset.kernel.exception.DuplicateCategoryException;
import com.liferay.asset.kernel.exception.DuplicateCategoryExternalReferenceCodeException;
import com.liferay.asset.kernel.exception.InvalidAssetCategoryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.persistence.AssetVocabularyPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetCategoryLocalServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetCategoryLocalServiceImpl
extends AssetCategoryLocalServiceBaseImpl {
    @BeanReference(type=AssetVocabularyPersistence.class)
    private AssetVocabularyPersistence _assetVocabularyPersistence;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public AssetCategory addCategory(long userId, long groupId, String title, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        Locale locale = PortalUtil.getSiteDefaultLocale((long)groupId);
        return this.assetCategoryLocalService.addCategory(null, userId, groupId, 0L, (Map)HashMapBuilder.put((Object)locale, (Object)title).build(), (Map)HashMapBuilder.put((Object)locale, (Object)"").build(), vocabularyId, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory addCategory(String externalReferenceCode, long userId, long groupId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Locale defaultLocale = PortalUtil.getSiteDefaultLocale((long)groupId);
        String name = titleMap.get(defaultLocale);
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        if (categoryProperties == null) {
            categoryProperties = new String[]{};
        }
        this.validate(0L, parentCategoryId, name, vocabularyId);
        AssetCategory parentCategory = null;
        if (parentCategoryId > 0L) {
            parentCategory = this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        this._assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
        long categoryId = this.counterLocalService.increment();
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        AssetCategory category = this.assetCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setExternalReferenceCode(externalReferenceCode);
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setParentCategoryId(parentCategoryId);
        if (parentCategory == null) {
            category.setTreePath("/" + categoryId + "/");
        } else {
            category.setTreePath(parentCategory.getTreePath() + categoryId + "/");
        }
        category.setName(name);
        category.setTitleMap(titleMap);
        category.setDescriptionMap(descriptionMap);
        category.setVocabularyId(vocabularyId);
        category = (AssetCategory)this.assetCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getModelPermissions());
        }
        return category;
    }

    public void addCategoryResources(AssetCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), AssetCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(AssetCategory category, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), AssetCategory.class.getName(), category.getCategoryId(), modelPermissions);
    }

    public void deleteCategories(List<AssetCategory> categories) throws PortalException {
        for (AssetCategory category : categories) {
            this.assetCategoryLocalService.deleteCategory(category, true);
        }
    }

    public void deleteCategories(long[] categoryIds) throws PortalException {
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>();
        for (long categoryId : categoryIds) {
            AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
            categories.add(category);
        }
        this.deleteCategories(categories);
    }

    public AssetCategory deleteCategory(AssetCategory category) throws PortalException {
        return this.assetCategoryLocalService.deleteCategory(category, false);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public AssetCategory deleteCategory(AssetCategory category, boolean skipRebuildTree) throws PortalException {
        List categories = this.assetCategoryPersistence.findByParentCategoryId(category.getCategoryId());
        for (AssetCategory curCategory : categories) {
            this.assetCategoryLocalService.deleteCategory(curCategory, true);
        }
        this.assetCategoryPersistence.remove((BaseModel)category);
        this._resourceLocalService.deleteResource(category.getCompanyId(), AssetCategory.class.getName(), 4, category.getCategoryId());
        return category;
    }

    public AssetCategory deleteCategory(long categoryId) throws PortalException {
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        return this.assetCategoryLocalService.deleteCategory(category);
    }

    public void deleteVocabularyCategories(long vocabularyId) throws PortalException {
        List categories = this.assetCategoryPersistence.findByP_V(0L, vocabularyId);
        this.assetCategoryLocalService.deleteCategories(categories);
    }

    public AssetCategory fetchCategory(long categoryId) {
        return this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
    }

    public AssetCategory fetchCategory(long groupId, long parentCategoryId, String name, long vocabularyId) {
        return this.assetCategoryPersistence.fetchByP_N_V(parentCategoryId, name, vocabularyId);
    }

    public List<AssetCategory> getCategories() {
        return this.assetCategoryPersistence.findAll();
    }

    public List<AssetCategory> getCategories(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>(documents.size());
        for (Document document : documents) {
            long categoryId = GetterUtil.getLong((String)document.get("assetCategoryId"));
            AssetCategory category = this.fetchCategory(categoryId);
            if (category == null) {
                categories = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(AssetCategory.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (categories == null) continue;
            categories.add(category);
        }
        return categories;
    }

    @ThreadLocalCachable
    public List<AssetCategory> getCategories(long classNameId, long classPK) {
        return Collections.emptyList();
    }

    public List<AssetCategory> getCategories(String className, long classPK) {
        return this.assetCategoryLocalService.getCategories(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public AssetCategory getCategory(long categoryId) throws PortalException {
        return this.assetCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public AssetCategory getCategory(String uuid, long groupId) throws PortalException {
        return this.assetCategoryPersistence.findByUUID_G(uuid, groupId);
    }

    public long[] getCategoryIds(String className, long classPK) {
        return this.getCategoryIds(this.getCategories(className, classPK));
    }

    public String[] getCategoryNames() {
        return this.getCategoryNames(this.getCategories());
    }

    public String[] getCategoryNames(long classNameId, long classPK) {
        return this.getCategoryNames(this.getCategories(classNameId, classPK));
    }

    public String[] getCategoryNames(String className, long classPK) {
        return this.getCategoryNames(this.getCategories(className, classPK));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) {
        return this.assetCategoryPersistence.findByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.assetCategoryPersistence.findByParentCategoryId(parentCategoryId, start, end, orderByComparator);
    }

    public int getChildCategoriesCount(long parentCategoryId) {
        return this.assetCategoryPersistence.countByParentCategoryId(parentCategoryId);
    }

    public List<AssetCategory> getDescendantCategories(AssetCategory category) {
        return this.assetCategoryPersistence.findByG_LikeT_V(category.getGroupId(), category.getTreePath() + "%", category.getVocabularyId());
    }

    public List<AssetCategory> getEntryCategories(long entryId) {
        return Collections.emptyList();
    }

    public List<Long> getSubcategoryIds(long parentCategoryId) {
        AssetCategory parentAssetCategory = this.assetCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentAssetCategory == null) {
            return Collections.emptyList();
        }
        return ListUtil.toList(this.getDescendantCategories(parentAssetCategory), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    public long[] getViewableCategoryIds(String className, long classPK, long[] categoryIds) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return categoryIds;
        }
        List oldCategories = this.assetCategoryLocalService.getCategories(className, classPK);
        for (AssetCategory category : oldCategories) {
            if (ArrayUtil.contains((long[])categoryIds, (long)category.getCategoryId()) || AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            categoryIds = ArrayUtil.append((long[])categoryIds, (long)category.getCategoryId());
        }
        return categoryIds;
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.assetCategoryPersistence.findByVocabularyId(vocabularyId, start, end, orderByComparator);
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.assetCategoryPersistence.findByP_V(parentCategoryId, vocabularyId, start, end, orderByComparator);
    }

    public int getVocabularyCategoriesCount(long vocabularyId) {
        return this.assetCategoryPersistence.countByVocabularyId(vocabularyId);
    }

    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.getVocabularyCategories(0L, vocabularyId, start, end, orderByComparator);
    }

    public int getVocabularyRootCategoriesCount(long vocabularyId) {
        return this.assetCategoryPersistence.countByP_V(0L, vocabularyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory mergeCategories(long fromCategoryId, long toCategoryId) throws PortalException {
        this.assetCategoryLocalService.deleteCategory(fromCategoryId);
        return this.getCategory(toCategoryId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        String treePath;
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        this.validate(categoryId, parentCategoryId, category.getName(), vocabularyId);
        if (categoryId == parentCategoryId) {
            throw new InvalidAssetCategoryException(parentCategoryId, 2);
        }
        AssetCategory parentCategory = null;
        if (parentCategoryId > 0L && (treePath = (parentCategory = this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId)).getTreePath()).startsWith(category.getTreePath())) {
            throw new InvalidAssetCategoryException(categoryId, 1);
        }
        if (vocabularyId != category.getVocabularyId()) {
            this._assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
            this.updateChildrenVocabularyId(category, vocabularyId);
            category.setVocabularyId(vocabularyId);
        }
        if (parentCategoryId != category.getParentCategoryId()) {
            this._rebuildTreePath(category, parentCategory);
            category.setParentCategoryId(parentCategoryId);
        }
        return (AssetCategory)this.assetCategoryPersistence.update((BaseModel)category);
    }

    public List<AssetCategory> search(long groupId, String name, String[] categoryProperties, int start, int end) {
        return this.assetCategoryFinder.findByG_N_P(groupId, name, categoryProperties, start, end);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long groupIds, String title, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategories(companyId, new long[]{groupIds}, title, new long[]{vocabularyId}, start, end);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, new long[0], vocabularyIds, start, end, null);
        return this.searchCategories(searchContext);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, parentCategoryIds, vocabularyIds, start, end, null);
        return this.searchCategories(searchContext);
    }

    public BaseModelSearchResult<AssetCategory> searchCategories(long companyId, long[] groupIds, String title, long[] vocabularyIds, long[] parentCategoryIds, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, title, parentCategoryIds, vocabularyIds, start, end, sort);
        return this.searchCategories(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AssetCategory updateCategory(long userId, long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategory category = this.assetCategoryPersistence.findByPrimaryKey(categoryId);
        Locale defaultLocale = PortalUtil.getSiteDefaultLocale((long)category.getGroupId());
        String name = titleMap.get(defaultLocale);
        name = ModelHintsUtil.trimString((String)AssetCategory.class.getName(), (String)"name", (String)name);
        if (categoryProperties == null) {
            categoryProperties = new String[]{};
        }
        this.validate(categoryId, parentCategoryId, name, vocabularyId);
        AssetCategory parentCategory = null;
        if (parentCategoryId > 0L) {
            parentCategory = this.assetCategoryPersistence.findByPrimaryKey(parentCategoryId);
        }
        if (vocabularyId != category.getVocabularyId()) {
            this._assetVocabularyPersistence.findByPrimaryKey(vocabularyId);
            parentCategoryId = 0L;
            category.setVocabularyId(vocabularyId);
            this.updateChildrenVocabularyId(category, vocabularyId);
        }
        if (parentCategoryId != category.getParentCategoryId()) {
            this._rebuildTreePath(category, parentCategory);
            category.setParentCategoryId(parentCategoryId);
        }
        category.setName(name);
        category.setTitleMap(titleMap);
        category.setDescriptionMap(descriptionMap);
        return (AssetCategory)this.assetCategoryPersistence.update((BaseModel)category);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"parentCategoryIds", (Object)parentCategoryIds).put((Object)"assetVocabularyIds", (Object)vocabularyIds).put((Object)"title", (Object)title).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(title);
        searchContext.setSorts(new Sort[]{sort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected long[] getCategoryIds(List<AssetCategory> categories) {
        return ListUtil.toLongArray(categories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    protected String[] getCategoryNames(List<AssetCategory> categories) {
        return (String[])ListUtil.toArray(categories, (Accessor)AssetCategory.NAME_ACCESSOR);
    }

    protected BaseModelSearchResult<AssetCategory> searchCategories(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetCategory.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetCategory> categories = this.getCategories(hits);
            if (categories == null) continue;
            return new BaseModelSearchResult(categories, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void updateChildrenVocabularyId(AssetCategory category, long vocabularyId) {
        for (AssetCategory childCategory : this.getDescendantCategories(category)) {
            if (childCategory.getCategoryId() == category.getCategoryId()) continue;
            childCategory.setVocabularyId(vocabularyId);
            this.assetCategoryPersistence.update((BaseModel)childCategory);
        }
    }

    protected void validate(long categoryId, long parentCategoryId, String name, long vocabularyId) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AssetCategoryNameException(StringBundler.concat((Object[])new Object[]{"Category name cannot be null for category ", categoryId, " and vocabulary ", vocabularyId}));
        }
        AssetCategory category = this.assetCategoryPersistence.fetchByP_N_V(parentCategoryId, name, vocabularyId);
        if (category != null && category.getCategoryId() != categoryId) {
            throw new DuplicateCategoryException(StringBundler.concat((Object[])new Object[]{"There is another category named ", name, " as a child of category ", parentCategoryId}));
        }
    }

    private void _rebuildTreePath(AssetCategory category, AssetCategory parentCategory) {
        String oldTreePath = category.getTreePath();
        String newTreePath = null;
        long categoryId = category.getCategoryId();
        newTreePath = parentCategory == null ? "/" + categoryId + "/" : parentCategory.getTreePath() + categoryId + "/";
        List<AssetCategory> childrenCategories = this.getDescendantCategories(category);
        for (AssetCategory childCategory : childrenCategories) {
            if (childCategory.getCategoryId() == category.getCategoryId()) continue;
            String childTreePath = childCategory.getTreePath();
            childCategory.setTreePath(newTreePath.concat(childTreePath.substring(oldTreePath.length())));
            this.assetCategoryPersistence.update((BaseModel)childCategory);
        }
        category.setTreePath(newTreePath);
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        AssetCategory assetCategory = this.assetCategoryPersistence.fetchByERC_G(externalReferenceCode, groupId);
        if (assetCategory != null) {
            throw new DuplicateCategoryExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate category external reference code ", externalReferenceCode, " in group", groupId}));
        }
    }
}

