/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryTypePersistence;
import com.liferay.document.library.kernel.service.persistence.DLFolderFinder;
import com.liferay.document.library.kernel.service.persistence.DLFolderPersistence;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;

public abstract class DLFolderLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements DLFolderLocalService,
IdentifiableOSGiService {
    @BeanReference(type=DLFolderLocalService.class)
    protected DLFolderLocalService dlFolderLocalService;
    @BeanReference(type=DLFolderPersistence.class)
    protected DLFolderPersistence dlFolderPersistence;
    @BeanReference(type=DLFolderFinder.class)
    protected DLFolderFinder dlFolderFinder;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=DLFileEntryTypePersistence.class)
    protected DLFileEntryTypePersistence dlFileEntryTypePersistence;
    private static final Log _log = LogFactoryUtil.getLog(DLFolderLocalServiceBaseImpl.class);
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder addDLFolder(DLFolder dlFolder) {
        dlFolder.setNew(true);
        return (DLFolder)this.dlFolderPersistence.update((BaseModel)dlFolder);
    }

    @Transactional(enabled=false)
    public DLFolder createDLFolder(long folderId) {
        return this.dlFolderPersistence.create(folderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteDLFolder(long folderId) throws PortalException {
        return this.dlFolderPersistence.remove(folderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteDLFolder(DLFolder dlFolder) {
        return (DLFolder)this.dlFolderPersistence.remove((BaseModel)dlFolder);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.dlFolderPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(DLFolder.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.dlFolderPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.dlFolderPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.dlFolderPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.dlFolderPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.dlFolderPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public DLFolder fetchDLFolder(long folderId) {
        return this.dlFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public DLFolder fetchDLFolderByUuidAndGroupId(String uuid, long groupId) {
        return this.dlFolderPersistence.fetchByUUID_G(uuid, groupId);
    }

    public DLFolder fetchDLFolderByExternalReferenceCode(String externalReferenceCode, long groupId) {
        return this.dlFolderPersistence.fetchByERC_G(externalReferenceCode, groupId);
    }

    public DLFolder getDLFolderByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        return this.dlFolderPersistence.findByERC_G(externalReferenceCode, groupId);
    }

    public DLFolder getDLFolder(long folderId) throws PortalException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.dlFolderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DLFolder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.dlFolderLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(DLFolder.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.dlFolderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DLFolder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("folderId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)DLFolder.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DLFolder>(){

            public void performAction(DLFolder dlFolder) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)dlFolder);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)DLFolder.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.dlFolderPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement DLFolderLocalServiceImpl#deleteDLFolder(DLFolder) to avoid orphaned data");
        }
        return this.dlFolderLocalService.deleteDLFolder((DLFolder)persistedModel);
    }

    public BasePersistence<DLFolder> getBasePersistence() {
        return this.dlFolderPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.dlFolderPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<DLFolder> getDLFoldersByUuidAndCompanyId(String uuid, long companyId) {
        return this.dlFolderPersistence.findByUuid_C(uuid, companyId);
    }

    public List<DLFolder> getDLFoldersByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<DLFolder> orderByComparator) {
        return this.dlFolderPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public DLFolder getDLFolderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.dlFolderPersistence.findByUUID_G(uuid, groupId);
    }

    public List<DLFolder> getDLFolders(int start, int end) {
        return this.dlFolderPersistence.findAll(start, end);
    }

    public int getDLFoldersCount() {
        return this.dlFolderPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateDLFolder(DLFolder dlFolder) {
        return (DLFolder)this.dlFolderPersistence.update((BaseModel)dlFolder);
    }

    public void addDLFileEntryTypeDLFolder(long fileEntryTypeId, long folderId) {
        this.dlFileEntryTypePersistence.addDLFolder(fileEntryTypeId, folderId);
    }

    public void addDLFileEntryTypeDLFolder(long fileEntryTypeId, DLFolder dlFolder) {
        this.dlFileEntryTypePersistence.addDLFolder(fileEntryTypeId, dlFolder);
    }

    public void addDLFileEntryTypeDLFolders(long fileEntryTypeId, long[] folderIds) {
        this.dlFileEntryTypePersistence.addDLFolders(fileEntryTypeId, folderIds);
    }

    public void addDLFileEntryTypeDLFolders(long fileEntryTypeId, List<DLFolder> dlFolders) {
        this.dlFileEntryTypePersistence.addDLFolders(fileEntryTypeId, dlFolders);
    }

    public void clearDLFileEntryTypeDLFolders(long fileEntryTypeId) {
        this.dlFileEntryTypePersistence.clearDLFolders(fileEntryTypeId);
    }

    public void deleteDLFileEntryTypeDLFolder(long fileEntryTypeId, long folderId) {
        this.dlFileEntryTypePersistence.removeDLFolder(fileEntryTypeId, folderId);
    }

    public void deleteDLFileEntryTypeDLFolder(long fileEntryTypeId, DLFolder dlFolder) {
        this.dlFileEntryTypePersistence.removeDLFolder(fileEntryTypeId, dlFolder);
    }

    public void deleteDLFileEntryTypeDLFolders(long fileEntryTypeId, long[] folderIds) {
        this.dlFileEntryTypePersistence.removeDLFolders(fileEntryTypeId, folderIds);
    }

    public void deleteDLFileEntryTypeDLFolders(long fileEntryTypeId, List<DLFolder> dlFolders) {
        this.dlFileEntryTypePersistence.removeDLFolders(fileEntryTypeId, dlFolders);
    }

    public long[] getDLFileEntryTypePrimaryKeys(long folderId) {
        return this.dlFolderPersistence.getDLFileEntryTypePrimaryKeys(folderId);
    }

    public List<DLFolder> getDLFileEntryTypeDLFolders(long fileEntryTypeId) {
        return this.dlFileEntryTypePersistence.getDLFolders(fileEntryTypeId);
    }

    public List<DLFolder> getDLFileEntryTypeDLFolders(long fileEntryTypeId, int start, int end) {
        return this.dlFileEntryTypePersistence.getDLFolders(fileEntryTypeId, start, end);
    }

    public List<DLFolder> getDLFileEntryTypeDLFolders(long fileEntryTypeId, int start, int end, OrderByComparator<DLFolder> orderByComparator) {
        return this.dlFileEntryTypePersistence.getDLFolders(fileEntryTypeId, start, end, orderByComparator);
    }

    public int getDLFileEntryTypeDLFoldersCount(long fileEntryTypeId) {
        return this.dlFileEntryTypePersistence.getDLFoldersSize(fileEntryTypeId);
    }

    public boolean hasDLFileEntryTypeDLFolder(long fileEntryTypeId, long folderId) {
        return this.dlFileEntryTypePersistence.containsDLFolder(fileEntryTypeId, folderId);
    }

    public boolean hasDLFileEntryTypeDLFolders(long fileEntryTypeId) {
        return this.dlFileEntryTypePersistence.containsDLFolders(fileEntryTypeId);
    }

    public void setDLFileEntryTypeDLFolders(long fileEntryTypeId, long[] folderIds) {
        this.dlFileEntryTypePersistence.setDLFolders(fileEntryTypeId, folderIds);
    }

    public DLFolderLocalService getDLFolderLocalService() {
        return this.dlFolderLocalService;
    }

    public void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this.dlFolderLocalService = dlFolderLocalService;
    }

    public DLFolderPersistence getDLFolderPersistence() {
        return this.dlFolderPersistence;
    }

    public void setDLFolderPersistence(DLFolderPersistence dlFolderPersistence) {
        this.dlFolderPersistence = dlFolderPersistence;
    }

    public DLFolderFinder getDLFolderFinder() {
        return this.dlFolderFinder;
    }

    public void setDLFolderFinder(DLFolderFinder dlFolderFinder) {
        this.dlFolderFinder = dlFolderFinder;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.document.library.kernel.model.DLFolder", (PersistedModelLocalService)this.dlFolderLocalService);
        this._setLocalServiceUtilService(this.dlFolderLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.document.library.kernel.model.DLFolder");
        this._setLocalServiceUtilService(null);
    }

    public String getOSGiServiceIdentifier() {
        return DLFolderLocalService.class.getName();
    }

    public CTPersistence<DLFolder> getCTPersistence() {
        return this.dlFolderPersistence;
    }

    public Class<DLFolder> getModelClass() {
        return DLFolder.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<DLFolder>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.dlFolderPersistence);
    }

    protected String getModelClassName() {
        return DLFolder.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.dlFolderPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(DLFolderLocalService dlFolderLocalService) {
        try {
            Field field = DLFolderLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, dlFolderLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

