/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.ClassLoaderAggregateProperties;
import com.liferay.portal.configuration.ClassLoaderAggregatePropertiesUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.MapConfiguration;

public class ConfigurationImpl
implements Configuration {
    private static final String[] _EMPTY_ARRAY = new String[0];
    private static final boolean _PRINT_DUPLICATE_CALLS_TO_GET = false;
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationImpl.class);
    private static final Object _nullValue = new Object();
    private final ClassLoaderAggregateProperties _classLoaderAggregateProperties;
    private final Map<String, Object> _configurationArrayCache = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> _configurationCache = new ConcurrentHashMap<String, Object>();
    private final Map<FilterCacheKey, Object> _configurationFilterArrayCache = new ConcurrentHashMap<FilterCacheKey, Object>();
    private final Map<FilterCacheKey, Object> _configurationFilterCache = new ConcurrentHashMap<FilterCacheKey, Object>();
    private final Set<String> _printedSources = new HashSet<String>();
    private Properties _properties;

    public ConfigurationImpl(ClassLoader classLoader, String name, long companyId, String webId) {
        this._classLoaderAggregateProperties = ClassLoaderAggregatePropertiesUtil.create(classLoader, companyId, webId, name);
        this.printSources(companyId, webId);
    }

    public void addProperties(Properties properties) {
        try {
            Field field1 = CompositeConfiguration.class.getDeclaredField("configList");
            field1.setAccessible(true);
            LinkedList<MapConfiguration> configurations = new LinkedList<MapConfiguration>((List)field1.get((Object)this._classLoaderAggregateProperties));
            MapConfiguration newConfiguration = new MapConfiguration(this._castPropertiesToMap(properties));
            newConfiguration.setTrimmingDisabled(true);
            configurations.add(0, newConfiguration);
            field1.set((Object)this._classLoaderAggregateProperties, configurations);
            CompositeConfiguration compositeConfiguration = this._classLoaderAggregateProperties.getBaseConfiguration();
            configurations = new LinkedList((List)field1.get(compositeConfiguration));
            configurations.add(0, newConfiguration);
            field1.set(compositeConfiguration, configurations);
            this._properties = null;
            this.clearCache();
        }
        catch (Exception exception) {
            _log.error((Object)"The properties could not be added", (Throwable)exception);
        }
    }

    public void clearCache() {
        this._configurationArrayCache.clear();
        this._configurationCache.clear();
        this._configurationFilterArrayCache.clear();
        this._configurationFilterCache.clear();
        this._properties = null;
    }

    public boolean contains(String key) {
        Object value = this._configurationCache.get(key);
        if (value == null) {
            value = this._classLoaderAggregateProperties.getProperty(key);
            if (value == null) {
                value = _nullValue;
            }
            this._configurationCache.put(key, value);
        }
        return value != _nullValue;
    }

    public String get(String key) {
        Object value = this._configurationCache.get(key);
        if (value == null) {
            value = this._classLoaderAggregateProperties.getString(key);
            if (value == null) {
                value = _nullValue;
            }
            this._configurationCache.put(key, value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String get(String key, Filter filter) {
        FilterCacheKey filterCacheKey = new FilterCacheKey(key, filter);
        Object value = null;
        if (filterCacheKey != null) {
            value = this._configurationFilterCache.get(filterCacheKey);
        }
        if (value == null) {
            value = this._classLoaderAggregateProperties.getString(key, filter);
            if (filterCacheKey != null) {
                if (value == null) {
                    value = _nullValue;
                }
                this._configurationFilterCache.put(filterCacheKey, value);
            }
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String[] getArray(String key) {
        Object value = this._configurationArrayCache.get(key);
        if (value == null) {
            String[] array = this._classLoaderAggregateProperties.getStringArray(key);
            value = this._fixArrayValue(array);
            this._configurationArrayCache.put(key, value);
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return _EMPTY_ARRAY;
    }

    public String[] getArray(String key, Filter filter) {
        FilterCacheKey filterCacheKey = new FilterCacheKey(key, filter);
        Object value = null;
        if (filterCacheKey != null) {
            value = this._configurationFilterArrayCache.get(filterCacheKey);
        }
        if (value == null) {
            String[] array = this._classLoaderAggregateProperties.getStringArray(key, filter);
            value = this._fixArrayValue(array);
            if (filterCacheKey != null) {
                this._configurationFilterArrayCache.put(filterCacheKey, value);
            }
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return _EMPTY_ARRAY;
    }

    public Properties getProperties() {
        if (this._properties != null) {
            return this._properties;
        }
        Properties properties = new Properties();
        Properties componentPropertiesProperties = this._classLoaderAggregateProperties.getProperties();
        for (String key : componentPropertiesProperties.stringPropertyNames()) {
            properties.setProperty(key, this._classLoaderAggregateProperties.getString(key));
        }
        this._properties = properties;
        return properties;
    }

    public Properties getProperties(String prefix, boolean removePrefix) {
        return PropertiesUtil.getProperties((Properties)this.getProperties(), (String)prefix, (boolean)removePrefix);
    }

    public void removeProperties(Properties properties) {
        try {
            org.apache.commons.configuration.Configuration configuration;
            CompositeConfiguration compositeConfiguration = this._classLoaderAggregateProperties.getBaseConfiguration();
            Field field2 = CompositeConfiguration.class.getDeclaredField("configList");
            field2.setAccessible(true);
            List configurations = (List)field2.get(compositeConfiguration);
            Iterator iterator = configurations.iterator();
            while (iterator.hasNext() && (configuration = (org.apache.commons.configuration.Configuration)iterator.next()) instanceof MapConfiguration) {
                MapConfiguration mapConfiguration = (MapConfiguration)configuration;
                if (mapConfiguration.getMap() != properties) continue;
                iterator.remove();
                this._classLoaderAggregateProperties.removeConfiguration(configuration);
            }
            this._properties = null;
            this.clearCache();
        }
        catch (Exception exception) {
            _log.error((Object)"The properties could not be removed", (Throwable)exception);
        }
    }

    public void set(String key, String value) {
        this._classLoaderAggregateProperties.setProperty(key, value);
        this.clearCache();
    }

    protected void printSources(long companyId, String webId) {
        if (GetterUtil.getBoolean((String)System.getProperty("configuration.impl.quiet"))) {
            return;
        }
        List<String> sources = this._classLoaderAggregateProperties.loadedSources();
        for (int i = sources.size() - 1; i >= 0; --i) {
            String source = sources.get(i);
            if (this._printedSources.contains(source)) continue;
            this._printedSources.add(source);
            if (source.startsWith("bundleresource://")) continue;
            String info = "Loading " + source;
            if (companyId > 0L) {
                info = info + StringBundler.concat((Object[])new Object[]{" for company ID ", companyId, " and web ID ", webId, "\nCompany properties can be overwrritten by setting the ", "environment variable LIFERAY_PROPS_BY_COMPANY_", companyId});
            }
            System.out.println(info);
        }
    }

    private Map<String, Object> _castPropertiesToMap(Properties properties) {
        return properties;
    }

    private Object _fixArrayValue(String[] array) {
        String[] value = _nullValue;
        if (ArrayUtil.isNotEmpty((Object[])array)) {
            if (Validator.isNull((String)array[array.length - 1])) {
                String[] subarray = new String[array.length - 1];
                System.arraycopy(array, 0, subarray, 0, subarray.length);
                array = subarray;
            }
            if (array.length > 0) {
                value = array;
            }
        }
        return value;
    }

    private static class FilterCacheKey {
        private final String _key;
        private final String[] _selectors;

        public boolean equals(Object object) {
            FilterCacheKey filterCacheKey = (FilterCacheKey)object;
            return Objects.equals(this._key, filterCacheKey._key) && Arrays.equals(this._selectors, filterCacheKey._selectors);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (Object)this._key);
            for (String selector : this._selectors) {
                hashCode = HashUtil.hash((int)hashCode, (Object)selector);
            }
            return hashCode;
        }

        private FilterCacheKey(String key, Filter filter) {
            this._key = key;
            this._selectors = filter.getSelectors();
        }
    }
}

