/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JPQLToHQLTransformerLogic {
    private static final String _HQL_COUNT_SQL = "SELECT COUNT(*) FROM $2 $3";
    private static final Pattern _jpqlCountPattern = Pattern.compile("SELECT COUNT\\((\\S+)\\) FROM (\\S+) (\\S+)");

    public static Function<String, String> getCountFunction() {
        return sql -> {
            Matcher matcher = _jpqlCountPattern.matcher((CharSequence)sql);
            if (matcher.find()) {
                String countExpression = matcher.group(1);
                String entityAlias = matcher.group(3);
                if (entityAlias.equals(countExpression)) {
                    return matcher.replaceFirst(_HQL_COUNT_SQL);
                }
            }
            return sql;
        };
    }
}

