/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.AutoDeployUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.util.BrowserLauncher;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class GlobalStartupAction
extends SimpleAction {
    private static final Log _log = LogFactoryUtil.getLog(GlobalStartupAction.class);
    private static List<HotDeployListener> _hotDeployListeners;

    public static List<HotDeployListener> getHotDeployListeners() {
        String[] hotDeployListenerClassNames;
        if (_hotDeployListeners != null) {
            return _hotDeployListeners;
        }
        ArrayList<HotDeployListener> hotDeployListeners = new ArrayList<HotDeployListener>();
        for (String hotDeployListenerClassName : hotDeployListenerClassNames = PropsUtil.getArray("hot.deploy.listeners")) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + hotDeployListenerClassName));
                }
                HotDeployListener hotDeployListener = (HotDeployListener)InstanceFactory.newInstance((String)hotDeployListenerClassName);
                hotDeployListeners.add(hotDeployListener);
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to initialiaze hot deploy listener", (Throwable)exception);
            }
        }
        _hotDeployListeners = hotDeployListeners;
        return _hotDeployListeners;
    }

    public void run(String[] ids) {
        try {
            File deployDir = new File(PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
            long interval = PropsValues.AUTO_DEPLOY_INTERVAL;
            AutoDeployDir autoDeployDir = new AutoDeployDir("defaultAutoDeployDir", deployDir, interval);
            if (PropsValues.AUTO_DEPLOY_ENABLED) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Registering auto deploy directories");
                }
                AutoDeployUtil.registerDir((AutoDeployDir)autoDeployDir);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)"Not registering auto deploy directories");
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to register auto deploy directories", (Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Registering hot deploy listeners");
        }
        for (HotDeployListener hotDeployListener : GlobalStartupAction.getHotDeployListeners()) {
            HotDeployUtil.registerListener((HotDeployListener)hotDeployListener);
        }
        AuthPublicPathRegistry.register(PropsValues.AUTH_PUBLIC_PATHS);
        ServletContext servletContext = ServletContextPool.get((String)PortalContextLoaderListener.getPortalServletContextName());
        JSONWebServiceActionsManagerUtil.registerServletContext((ServletContext)servletContext);
        if (Validator.isNotNull((String)PropsValues.BROWSER_LAUNCHER_URL)) {
            Thread browserLauncherThread = new Thread(new BrowserLauncher());
            browserLauncherThread.start();
        }
    }
}

