/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.language.LanguageOverrideProvider;
import com.liferay.portal.language.ResourceBundleEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LanguageResources {
    public static ResourceBundleLoader PORTAL_RESOURCE_BUNDLE_LOADER = new ResourceBundleLoader(){

        public ResourceBundle loadResourceBundle(Locale locale) {
            return LanguageResources.getResourceBundle(locale);
        }
    };
    private static final Locale _blankLocale = new Locale("");
    private static volatile LanguageOverrideProvider _languageOverrideProvider = (LanguageOverrideProvider)ServiceProxyFactory.newServiceTrackedInstance(LanguageOverrideProvider.class, LanguageResources.class, (String)"_languageOverrideProvider", (boolean)false, (boolean)true);
    private static final Locale _nullLocale = new Locale("");
    private static final ServiceTrackerMap<Locale, MapHolder> _serviceTrackerMap;
    private static final Map<Locale, Locale> _superLocales;

    public static String getMessage(Locale locale, String key) {
        if (locale == null) {
            return null;
        }
        String overrideValue = LanguageResources._getOverrideValue(key, locale);
        if (overrideValue != null) {
            return overrideValue;
        }
        String value = null;
        MapHolder mapHolder = (MapHolder)_serviceTrackerMap.getService((Object)locale);
        if (mapHolder != null) {
            Map<String, String> languageMap = mapHolder.getMap();
            value = languageMap.get(key);
        }
        if (value == null) {
            return LanguageResources.getMessage(LanguageResources.getSuperLocale(locale), key);
        }
        return value;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return new LanguageResourcesBundle(locale);
    }

    public static Locale getSuperLocale(Locale locale) {
        Locale superLocale = _superLocales.get(locale);
        if (superLocale != null) {
            if (superLocale == _nullLocale) {
                return null;
            }
            return superLocale;
        }
        superLocale = LanguageResources._getSuperLocale(locale);
        if (superLocale == null) {
            _superLocales.put(locale, _nullLocale);
        } else {
            _superLocales.put(locale, superLocale);
        }
        return superLocale;
    }

    public void afterPropertiesSet() {
        ResourceBundleLoaderUtil.setPortalResourceBundleLoader((ResourceBundleLoader)PORTAL_RESOURCE_BUNDLE_LOADER);
    }

    public void destroy() {
        _serviceTrackerMap.close();
    }

    private static String _getOverrideValue(String key, Locale locale) {
        LanguageOverrideProvider languageOverrideProvider = _languageOverrideProvider;
        if (languageOverrideProvider == null) {
            return null;
        }
        String value = languageOverrideProvider.get(key, locale);
        if (value == null) {
            return null;
        }
        return value;
    }

    private static Set<String> _getSetWithOverrideKeys(Set<String> keySet, Locale locale) {
        LanguageOverrideProvider languageOverrideProvider = _languageOverrideProvider;
        if (languageOverrideProvider == null) {
            return keySet;
        }
        Set<String> overrideKeySet = languageOverrideProvider.keySet(locale);
        if (SetUtil.isEmpty(overrideKeySet)) {
            return keySet;
        }
        HashSet<String> resultSet = new HashSet<String>(keySet);
        resultSet.addAll(overrideKeySet);
        return resultSet;
    }

    private static Locale _getSuperLocale(Locale locale) {
        String variant = locale.getVariant();
        if (variant.length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        String country = locale.getCountry();
        if (country.length() > 0) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (priorityLocale != null) {
                variant = priorityLocale.getVariant();
            }
            if (priorityLocale != null && !locale.equals(priorityLocale) && variant.length() <= 0) {
                return new Locale(priorityLocale.getLanguage(), priorityLocale.getCountry());
            }
            return LocaleUtil.fromLanguageId((String)locale.getLanguage(), (boolean)false, (boolean)true);
        }
        String language = locale.getLanguage();
        if (language.length() > 0) {
            return _blankLocale;
        }
        return null;
    }

    static {
        _superLocales = new ConcurrentHashMap<Locale, Locale>();
        final BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ResourceBundle.class, (String)"(&(!(javax.portlet.name=*))(language.id=*))", (serviceReference, emitter) -> {
            String languageId = GetterUtil.getString((Object)serviceReference.getProperty("language.id"));
            emitter.emit((Object)LocaleUtil.fromLanguageId((String)languageId, (boolean)false));
        }, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ResourceBundle, MapHolder>(){

            public MapHolder addingService(ServiceReference<ResourceBundle> serviceReference) {
                return new MapHolder(bundleContext, serviceReference);
            }

            public void modifiedService(ServiceReference<ResourceBundle> serviceReference, MapHolder mapHolder) {
            }

            public void removedService(ServiceReference<ResourceBundle> serviceReference, MapHolder mapHolder) {
                mapHolder.close();
            }
        });
    }

    private static class MapHolder {
        private final BundleContext _bundleContext;
        private Map<String, String> _map;
        private final ServiceReference<ResourceBundle> _serviceReference;

        public void close() {
            if (this._map != null) {
                this._bundleContext.ungetService(this._serviceReference);
            }
        }

        public Map<String, String> getMap() {
            if (this._map == null) {
                ResourceBundle resourceBundle = (ResourceBundle)this._bundleContext.getService(this._serviceReference);
                HashMap<String, String> languageMap = new HashMap<String, String>();
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String key = enumeration.nextElement();
                    String value = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
                    languageMap.put(key, value);
                }
                this._map = languageMap;
            }
            return this._map;
        }

        private MapHolder(BundleContext bundleContext, ServiceReference<ResourceBundle> serviceReference) {
            this._bundleContext = bundleContext;
            this._serviceReference = serviceReference;
        }
    }

    private static class LanguageResourcesBundle
    extends ResourceBundle {
        private final Locale _locale;

        @Override
        public Enumeration<String> getKeys() {
            Set<String> keySet = Collections.emptySet();
            MapHolder mapHolder = (MapHolder)_serviceTrackerMap.getService((Object)this._locale);
            if (mapHolder != null) {
                Map<String, String> languageMap = mapHolder.getMap();
                keySet = languageMap.keySet();
            }
            keySet = LanguageResources._getSetWithOverrideKeys(keySet, this._locale);
            if (this.parent == null) {
                return Collections.enumeration(keySet);
            }
            return new ResourceBundleEnumeration(keySet, this.parent.getKeys());
        }

        @Override
        public Locale getLocale() {
            return this._locale;
        }

        @Override
        protected Object handleGetObject(String key) {
            String overrideValue = LanguageResources._getOverrideValue(key, this._locale);
            if (overrideValue != null) {
                return overrideValue;
            }
            MapHolder mapHolder = (MapHolder)_serviceTrackerMap.getService((Object)this._locale);
            if (mapHolder == null) {
                return null;
            }
            Map<String, String> languageMap = mapHolder.getMap();
            return languageMap.get(key);
        }

        @Override
        protected Set<String> handleKeySet() {
            Set<Object> keySet = Collections.emptySet();
            MapHolder mapHolder = (MapHolder)_serviceTrackerMap.getService((Object)this._locale);
            if (mapHolder != null) {
                Map<String, String> languageMap = mapHolder.getMap();
                keySet = languageMap.keySet();
            }
            return LanguageResources._getSetWithOverrideKeys(keySet, this._locale);
        }

        private LanguageResourcesBundle(Locale locale) {
            this._locale = locale;
            Locale superLocale = LanguageResources.getSuperLocale(locale);
            if (superLocale != null) {
                this.setParent(new LanguageResourcesBundle(superLocale));
            }
        }
    }
}

