/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.log.LogContextRegistryUtil;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;

public class Log4jLogContextLogWrapper
extends LogWrapper {
    private final String _name;

    public Log4jLogContextLogWrapper(Log log, String name) {
        super(log);
        this._name = name;
        this.setLogWrapperClassName(Log4jLogContextLogWrapper.class.getName());
    }

    public void debug(Object message) {
        this._populateThreadContext();
        super.debug(message);
        this._cleanThreadContext();
    }

    public void debug(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.debug(message, throwable);
        this._cleanThreadContext();
    }

    public void debug(Throwable throwable) {
        this._populateThreadContext();
        super.debug(null, throwable);
        this._cleanThreadContext();
    }

    public void error(Object message) {
        this._populateThreadContext();
        super.error(message);
        this._cleanThreadContext();
    }

    public void error(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.error(message, throwable);
        this._cleanThreadContext();
    }

    public void error(Throwable throwable) {
        this._populateThreadContext();
        super.error(null, throwable);
        this._cleanThreadContext();
    }

    public void fatal(Object message) {
        this._populateThreadContext();
        super.fatal(message);
        this._cleanThreadContext();
    }

    public void fatal(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.fatal(message, throwable);
        this._cleanThreadContext();
    }

    public void fatal(Throwable throwable) {
        this._populateThreadContext();
        super.fatal(null, throwable);
        this._cleanThreadContext();
    }

    public void info(Object message) {
        this._populateThreadContext();
        super.info(message);
        this._cleanThreadContext();
    }

    public void info(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.info(message, throwable);
        this._cleanThreadContext();
    }

    public void info(Throwable throwable) {
        this._populateThreadContext();
        super.info(null, throwable);
        this._cleanThreadContext();
    }

    public void trace(Object message) {
        this._populateThreadContext();
        super.trace(message);
        this._cleanThreadContext();
    }

    public void trace(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.trace(message, throwable);
        this._cleanThreadContext();
    }

    public void trace(Throwable throwable) {
        this._populateThreadContext();
        super.trace(null, throwable);
        this._cleanThreadContext();
    }

    public void warn(Object message) {
        this._populateThreadContext();
        super.warn(message);
        this._cleanThreadContext();
    }

    public void warn(Object message, Throwable throwable) {
        this._populateThreadContext();
        super.warn(message, throwable);
        this._cleanThreadContext();
    }

    public void warn(Throwable throwable) {
        this._populateThreadContext();
        super.warn(null, throwable);
        this._cleanThreadContext();
    }

    private void _cleanThreadContext() {
        ThreadContext.clearMap();
    }

    private void _populateThreadContext() {
        for (LogContext logContext : LogContextRegistryUtil.getLogContexts()) {
            Map context = logContext.getContext(this._name);
            for (Map.Entry entry : context.entrySet()) {
                String key = (String)entry.getKey();
                String logContextName = logContext.getName();
                if (Validator.isNotNull((String)logContextName)) {
                    key = logContextName + "." + key;
                }
                ThreadContext.put((String)key, (String)((String)entry.getValue()));
            }
        }
    }
}

