/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.Screenshot;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParserUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.plugin.LocalPluginPackageRepository;
import com.liferay.portal.plugin.PluginPackageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;

public class PluginPackageUtil {
    private static final String _TYPE_EXT = "ext";
    private static final Log _log = LogFactoryUtil.getLog(PluginPackageUtil.class);
    private static final PluginPackageUtil _pluginPackageUtil = new PluginPackageUtil();
    private final LocalPluginPackageRepository _installedPluginPackages = new LocalPluginPackageRepository();

    public static void endPluginPackageInstallation(String preliminaryContext) {
        _pluginPackageUtil._endPluginPackageInstallation(preliminaryContext);
    }

    public static PluginPackage getInstalledPluginPackage(String context) {
        return _pluginPackageUtil._getInstalledPluginPackage(context);
    }

    public static List<PluginPackage> getInstalledPluginPackages() {
        return _pluginPackageUtil._getInstalledPluginPackages();
    }

    public static boolean isCurrentVersionSupported(List<String> versions) {
        return _pluginPackageUtil._isCurrentVersionSupported(versions);
    }

    public static boolean isInstalled(String context) {
        return _pluginPackageUtil._isInstalled(context);
    }

    public static PluginPackage readPluginPackageProperties(String displayName, Properties properties) {
        return _pluginPackageUtil._readPluginPackageProperties(displayName, properties);
    }

    public static PluginPackage readPluginPackageServletContext(ServletContext servletContext) throws DocumentException, IOException {
        return _pluginPackageUtil._readPluginPackageServletContext(servletContext);
    }

    public static PluginPackage readPluginPackageXml(String xml) throws DocumentException {
        return _pluginPackageUtil._readPluginPackageXml(xml);
    }

    public static void registerInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        _pluginPackageUtil._registerInstalledPluginPackage(pluginPackage);
    }

    public static void unregisterInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        _pluginPackageUtil._unregisterInstalledPluginPackage(pluginPackage);
    }

    public static void updateInstallingPluginPackage(String preliminaryContext, PluginPackage pluginPackage) {
        _pluginPackageUtil._updateInstallingPluginPackage(preliminaryContext, pluginPackage);
    }

    private PluginPackageUtil() {
    }

    private void _endPluginPackageInstallation(String preliminaryContext) {
        this._installedPluginPackages.unregisterPluginPackageInstallation(preliminaryContext);
    }

    private PluginPackage _getInstalledPluginPackage(String context) {
        return this._installedPluginPackages.getPluginPackage(context);
    }

    private List<PluginPackage> _getInstalledPluginPackages() {
        return this._installedPluginPackages.getSortedPluginPackages();
    }

    private boolean _isCurrentVersionSupported(List<String> versions) {
        Version currentVersion = Version.getInstance((String)ReleaseInfo.getVersion());
        for (String version : versions) {
            Version supportedVersion = Version.getInstance((String)version);
            if (!supportedVersion.includes(currentVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean _isInstalled(String context) {
        PluginPackage pluginPackage = this._installedPluginPackages.getPluginPackage(context);
        return pluginPackage != null;
    }

    private Date _readDate(String text) {
        block3: {
            if (Validator.isNotNull((String)text)) {
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)LocaleUtil.US);
                try {
                    return dateFormat.parse(text);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to parse date " + text), (Throwable)exception);
                }
            }
        }
        return new Date();
    }

    private String _readHtml(String text) {
        return GetterUtil.getString((String)text);
    }

    private List<License> _readLicenseList(Element parentElement, String name) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (Element licenseElement : parentElement.elements(name)) {
            Attribute url;
            License license = new License();
            license.setName(licenseElement.getText());
            Attribute osiApproved = licenseElement.attribute("osi-approved");
            if (osiApproved != null) {
                license.setOsiApproved(GetterUtil.getBoolean((String)osiApproved.getText()));
            }
            if ((url = licenseElement.attribute("url")) != null) {
                license.setUrl(url.getText());
            }
            licenses.add(license);
        }
        return licenses;
    }

    private List<String> _readList(Element parentElement, String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (parentElement == null) {
            return list;
        }
        for (Element element : parentElement.elements(name)) {
            String text = StringUtil.toLowerCase((String)StringUtil.trim((String)element.getText()));
            list.add(text);
        }
        return list;
    }

    private PluginPackage _readPluginPackageProperties(String displayName, Properties properties) {
        String[] tagsArray;
        String[] liferayVersionsArray;
        String[] licensesArray;
        int pos = displayName.indexOf("-portlet");
        String pluginType = "portlet";
        if (pos == -1) {
            pos = displayName.indexOf("-ext");
            pluginType = _TYPE_EXT;
        }
        if (pos == -1) {
            pos = displayName.indexOf("-hook");
            pluginType = "hook";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-layouttpl");
            pluginType = "layouttpl";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-theme");
            pluginType = "theme";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-web");
            pluginType = "web";
        }
        if (pos == -1) {
            return null;
        }
        String displayPrefix = displayName.substring(0, pos);
        String moduleGroupId = GetterUtil.getString((String)properties.getProperty("module-group-id"));
        String moduleArtifactId = displayPrefix + "-" + pluginType;
        String moduleVersion = GetterUtil.getString((String)properties.getProperty("module-version"));
        if (Validator.isNull((String)moduleVersion)) {
            String moduleIncrementalVersion;
            int moduleVersionPos = pos + pluginType.length() + 2;
            moduleVersion = displayName.length() > moduleVersionPos ? displayName.substring(moduleVersionPos) : (Validator.isNull((String)(moduleIncrementalVersion = GetterUtil.getString((String)properties.getProperty("module-incremental-version")))) ? ReleaseInfo.getVersion() : ReleaseInfo.getVersion() + "." + moduleIncrementalVersion);
        }
        String moduleId = StringBundler.concat((String[])new String[]{moduleGroupId, "/", moduleArtifactId, "/", moduleVersion, "/war"});
        String pluginName = GetterUtil.getString((String)properties.getProperty("name"));
        String deploymentContext = GetterUtil.getString((String)properties.getProperty("recommended-deployment-context"), (String)moduleArtifactId);
        ArrayList<String> types = new ArrayList<String>();
        types.add(pluginType);
        ArrayList<License> licenses = new ArrayList<License>();
        for (String curLicenses : licensesArray = StringUtil.split((String)properties.getProperty("licenses"))) {
            License license = new License();
            license.setName(curLicenses.trim());
            license.setOsiApproved(true);
            licenses.add(license);
        }
        ArrayList<String> liferayVersions = new ArrayList<String>();
        for (String liferayVersion : liferayVersionsArray = StringUtil.split((String)properties.getProperty("liferay-versions"))) {
            liferayVersions.add(liferayVersion.trim());
        }
        if (liferayVersions.isEmpty()) {
            liferayVersions.add(ReleaseInfo.getVersion() + "+");
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : tagsArray = StringUtil.split((String)properties.getProperty("tags"))) {
            tags.add(tag.trim());
        }
        String shortDescription = GetterUtil.getString((String)properties.getProperty("short-description"));
        String longDescription = GetterUtil.getString((String)properties.getProperty("long-description"));
        String changeLog = GetterUtil.getString((String)properties.getProperty("change-log"));
        String pageURL = GetterUtil.getString((String)properties.getProperty("page-url"));
        List requiredDeploymentContexts = ListUtil.fromArray((Object[])StringUtil.split((String)properties.getProperty("required-deployment-contexts")));
        PluginPackageImpl pluginPackage = new PluginPackageImpl(moduleId);
        pluginPackage.setName(pluginName);
        pluginPackage.setRecommendedDeploymentContext(deploymentContext);
        pluginPackage.setAuthor(GetterUtil.getString((String)properties.getProperty("author")));
        pluginPackage.setTypes(types);
        pluginPackage.setLicenses(licenses);
        pluginPackage.setLiferayVersions(liferayVersions);
        pluginPackage.setTags(tags);
        pluginPackage.setShortDescription(shortDescription);
        pluginPackage.setLongDescription(longDescription);
        pluginPackage.setChangeLog(changeLog);
        pluginPackage.setPageURL(pageURL);
        pluginPackage.setRequiredDeploymentContexts(requiredDeploymentContexts);
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageServletContext(ServletContext servletContext) throws DocumentException, IOException {
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            if (servletContextName == null) {
                _log.debug((Object)"Reading plugin package for the root context");
            } else {
                _log.debug((Object)("Reading plugin package for " + servletContextName));
            }
        }
        PluginPackage pluginPackage = null;
        String xml = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-plugin-package.xml"));
        if (xml != null) {
            pluginPackage = this._readPluginPackageXml(xml);
        } else {
            String propertiesString = StreamUtil.toString((InputStream)servletContext.getResourceAsStream("/WEB-INF/liferay-plugin-package.properties"));
            if (propertiesString != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Reading plugin package from liferay-plugin-package.properties");
                }
                Properties properties = PropertiesUtil.load((String)propertiesString);
                String displayName = servletContextName;
                if (displayName.startsWith("/")) {
                    displayName = displayName.substring(1);
                }
                pluginPackage = this._readPluginPackageProperties(displayName, properties);
            }
            if (pluginPackage == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Reading plugin package from MANIFEST.MF");
                }
                pluginPackage = this._readPluginPackageServletManifest(servletContext);
            }
        }
        pluginPackage.setContext(servletContextName);
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageServletManifest(ServletContext servletContext) throws IOException {
        String pageURL;
        String version;
        String artifactId;
        Attributes attributes = null;
        String servletContextName = servletContext.getServletContextName();
        InputStream inputStream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");
        if (inputStream != null) {
            Manifest manifest = new Manifest(inputStream);
            attributes = manifest.getMainAttributes();
        } else {
            attributes = new Attributes();
        }
        String artifactGroupId = attributes.getValue("Implementation-Vendor-Id");
        if (Validator.isNull((String)artifactGroupId)) {
            artifactGroupId = attributes.getValue("Implementation-Vendor");
        }
        if (Validator.isNull((String)artifactGroupId)) {
            artifactGroupId = GetterUtil.getString((String)attributes.getValue("Bundle-Vendor"), (String)servletContextName);
        }
        if (Validator.isNull((String)(artifactId = attributes.getValue("Implementation-Title")))) {
            artifactId = GetterUtil.getString((String)attributes.getValue("Bundle-Name"), (String)servletContextName);
        }
        if (Validator.isNull((String)(version = attributes.getValue("Implementation-Version")))) {
            version = GetterUtil.getString((String)attributes.getValue("Bundle-Version"), (String)"unknown");
        }
        if (version.equals("unknown") && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Plugin package on context ", servletContextName, " cannot be tracked because this WAR does not contain a ", "liferay-plugin-package.xml file"}));
        }
        PluginPackageImpl pluginPackage = new PluginPackageImpl(StringBundler.concat((String[])new String[]{artifactGroupId, "/", artifactId, "/", version, "/war"}));
        pluginPackage.setName(artifactId);
        String shortDescription = attributes.getValue("Bundle-Description");
        if (Validator.isNotNull((String)shortDescription)) {
            pluginPackage.setShortDescription(shortDescription);
        }
        if (Validator.isNotNull((String)(pageURL = attributes.getValue("Bundle-DocURL")))) {
            pluginPackage.setPageURL(pageURL);
        }
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageXml(Element pluginPackageElement) {
        String name = pluginPackageElement.elementText("name");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading pluginPackage definition " + name));
        }
        PluginPackageImpl pluginPackage = new PluginPackageImpl(GetterUtil.getString((String)pluginPackageElement.elementText("module-id")));
        List<String> liferayVersions = this._readList(pluginPackageElement.element("liferay-versions"), "liferay-version");
        List<String> types = this._readList(pluginPackageElement.element("types"), "type");
        if (types.contains("layout-template")) {
            types.remove("layout-template");
            types.add("layouttpl");
        }
        pluginPackage.setName(this._readText(name));
        pluginPackage.setRecommendedDeploymentContext(this._readText(pluginPackageElement.elementText("recommended-deployment-context")));
        pluginPackage.setRequiredDeploymentContexts(this._readList(pluginPackageElement.element("required-deployment-contexts"), "required-deployment-context"));
        pluginPackage.setModifiedDate(this._readDate(pluginPackageElement.elementText("modified-date")));
        pluginPackage.setAuthor(this._readText(pluginPackageElement.elementText("author")));
        pluginPackage.setTypes(types);
        pluginPackage.setLicenses(this._readLicenseList(pluginPackageElement.element("licenses"), "license"));
        pluginPackage.setLiferayVersions(liferayVersions);
        pluginPackage.setTags(this._readList(pluginPackageElement.element("tags"), "tag"));
        pluginPackage.setShortDescription(this._readText(pluginPackageElement.elementText("short-description")));
        pluginPackage.setLongDescription(this._readHtml(pluginPackageElement.elementText("long-description")));
        pluginPackage.setChangeLog(this._readHtml(pluginPackageElement.elementText("change-log")));
        pluginPackage.setScreenshots(this._readScreenshots(pluginPackageElement.element("screenshots")));
        pluginPackage.setPageURL(this._readText(pluginPackageElement.elementText("page-url")));
        pluginPackage.setDeploymentSettings(this._readProperties(pluginPackageElement.element("deployment-settings"), "setting"));
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageXml(String xml) throws DocumentException {
        Document document = SAXReaderUtil.read((String)xml);
        return this._readPluginPackageXml(document.getRootElement());
    }

    private Properties _readProperties(Element parentElement, String name) {
        Properties properties = new Properties();
        if (parentElement == null) {
            return properties;
        }
        for (Element element : parentElement.elements(name)) {
            properties.setProperty(element.attributeValue("name"), element.attributeValue("value"));
        }
        return properties;
    }

    private List<Screenshot> _readScreenshots(Element parentElement) {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        if (parentElement == null) {
            return screenshots;
        }
        for (Element screenshotElement : parentElement.elements("screenshot")) {
            Screenshot screenshot = new Screenshot();
            screenshot.setThumbnailURL(screenshotElement.elementText("thumbnail-url"));
            screenshot.setLargeImageURL(screenshotElement.elementText("large-image-url"));
            screenshots.add(screenshot);
        }
        return screenshots;
    }

    private String _readText(String text) {
        return HtmlParserUtil.extractText((String)GetterUtil.getString((String)text));
    }

    private void _registerInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        this._installedPluginPackages.addPluginPackage(pluginPackage);
    }

    private void _unregisterInstalledPluginPackage(PluginPackage pluginPackage) throws PortalException {
        this._installedPluginPackages.removePluginPackage(pluginPackage);
    }

    private void _updateInstallingPluginPackage(String preliminaryContext, PluginPackage pluginPackage) {
        this._installedPluginPackages.unregisterPluginPackageInstallation(preliminaryContext);
        this._installedPluginPackages.registerPluginPackageInstallation(pluginPackage);
    }
}

