/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.repository.external.LegacyExternalRepositoryDefiner;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.repository.util.ExternalRepositoryFactory;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryImpl;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class RepositoryClassDefinitionCatalogImpl
implements CacheRegistryItem,
RepositoryClassDefinitionCatalog {
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final Map<String, RepositoryClassDefinition> _externalRepositoryClassDefinitions = new ConcurrentHashMap<String, RepositoryClassDefinition>();
    private RepositoryFactory _legacyExternalRepositoryFactory;
    private final Map<String, RepositoryClassDefinition> _repositoryClassDefinitions = new ConcurrentHashMap<String, RepositoryClassDefinition>();
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private ServiceTracker<RepositoryDefiner, ServiceRegistration<RepositoryFactory>> _serviceTracker;

    public void afterPropertiesSet() {
        this._serviceTracker = new ServiceTracker(this._bundleContext, RepositoryDefiner.class, (ServiceTrackerCustomizer)new RepositoryDefinerServiceTrackerCustomizer());
        this._serviceTracker.open();
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        for (String className : PropsValues.DL_REPOSITORY_IMPL) {
            ExternalRepositoryFactoryImpl externalRepositoryFactory = new ExternalRepositoryFactoryImpl(className, classLoader);
            this.registerLegacyExternalRepositoryFactory(className, externalRepositoryFactory, LanguageUtil.getResourceBundleLoader());
        }
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    @Override
    public Iterable<RepositoryClassDefinition> getExternalRepositoryClassDefinitions() {
        return this._externalRepositoryClassDefinitions.values();
    }

    @Override
    public Collection<String> getExternalRepositoryClassNames() {
        return this._externalRepositoryClassDefinitions.keySet();
    }

    public String getRegistryName() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    @Override
    public RepositoryClassDefinition getRepositoryClassDefinition(String className) {
        return this._repositoryClassDefinitions.get(className);
    }

    public void invalidate() {
        for (RepositoryClassDefinition repositoryClassDefinition : this._repositoryClassDefinitions.values()) {
            repositoryClassDefinition.invalidateCache();
        }
    }

    @Override
    public void registerLegacyExternalRepositoryFactory(String className, ExternalRepositoryFactory externalRepositoryFactory, ResourceBundleLoader resourceBundleLoader) {
        ExternalRepositoryFactoryUtil.registerExternalRepositoryFactory(className, externalRepositoryFactory);
        LegacyExternalRepositoryDefiner repositoryDefiner = new LegacyExternalRepositoryDefiner(className, this._legacyExternalRepositoryFactory, resourceBundleLoader);
        ServiceRegistration<RepositoryDefiner> serviceRegistration = this.registerRepositoryDefiner((RepositoryDefiner)repositoryDefiner);
        this._serviceRegistrations.put(className, serviceRegistration);
    }

    public void setLegacyExternalRepositoryFactory(RepositoryFactory legacyExternalRepositoryFactory) {
        this._legacyExternalRepositoryFactory = legacyExternalRepositoryFactory;
    }

    @Override
    public void unregisterLegacyExternalRepositoryFactory(String className) {
        ExternalRepositoryFactoryUtil.unregisterExternalRepositoryFactory(className);
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(className);
        serviceRegistration.unregister();
        this.unregisterRepositoryDefiner(className);
    }

    protected ServiceRegistration<RepositoryDefiner> registerRepositoryDefiner(RepositoryDefiner repositoryDefiner) {
        return this._bundleContext.registerService(RepositoryDefiner.class, (Object)repositoryDefiner, null);
    }

    protected void unregisterRepositoryDefiner(String className) {
        this._externalRepositoryClassDefinitions.remove(className);
        this._repositoryClassDefinitions.remove(className);
    }

    private class RepositoryDefinerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<RepositoryDefiner, ServiceRegistration<RepositoryFactory>> {
        private RepositoryDefinerServiceTrackerCustomizer() {
        }

        public ServiceRegistration<RepositoryFactory> addingService(ServiceReference<RepositoryDefiner> serviceReference) {
            RepositoryDefiner repositoryDefiner = (RepositoryDefiner)RepositoryClassDefinitionCatalogImpl.this._bundleContext.getService(serviceReference);
            String className = repositoryDefiner.getClassName();
            RepositoryClassDefinition repositoryClassDefinition = RepositoryClassDefinition.fromRepositoryDefiner(repositoryDefiner);
            if (repositoryDefiner.isExternalRepository()) {
                RepositoryClassDefinitionCatalogImpl.this._externalRepositoryClassDefinitions.put(className, repositoryClassDefinition);
            }
            RepositoryClassDefinitionCatalogImpl.this._repositoryClassDefinitions.put(className, repositoryClassDefinition);
            return RepositoryClassDefinitionCatalogImpl.this._bundleContext.registerService(RepositoryFactory.class, (Object)repositoryClassDefinition, MapUtil.singletonDictionary((Object)"class.name", (Object)className));
        }

        public void modifiedService(ServiceReference<RepositoryDefiner> serviceReference, ServiceRegistration<RepositoryFactory> serviceRegistration) {
        }

        public void removedService(ServiceReference<RepositoryDefiner> serviceReference, ServiceRegistration<RepositoryFactory> serviceRegistration) {
            RepositoryClassDefinitionCatalogImpl.this._bundleContext.ungetService(serviceReference);
            ServiceReference repositoryFactoryServiceReference = serviceRegistration.getReference();
            String className = (String)repositoryFactoryServiceReference.getProperty("class.name");
            RepositoryClassDefinitionCatalogImpl.this.unregisterRepositoryDefiner(className);
            serviceRegistration.unregister();
        }
    }
}

