/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.service.base.ImageLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class ImageLocalServiceImpl
extends ImageLocalServiceBaseImpl {
    private static final long _REPOSITORY_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(ImageLocalServiceImpl.class);

    @Override
    public Image deleteImage(long imageId) throws PortalException {
        try {
            if (imageId <= 0L) {
                return null;
            }
            Image image = this.getImage(imageId);
            if (image == null) {
                return null;
            }
            this.imagePersistence.remove((BaseModel)image);
            String fileName = this._getFileName(image.getImageId(), image.getType());
            try {
                DLStoreUtil.deleteFile((long)image.getCompanyId(), (long)0L, (String)fileName);
            }
            catch (NoSuchFileException noSuchFileException) {
                throw new NoSuchImageException((Throwable)noSuchFileException);
            }
            return image;
        }
        catch (NoSuchImageException noSuchImageException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)noSuchImageException);
            }
            return null;
        }
    }

    public Image getCompanyLogo(long imageId) {
        Image image = this.getImage(imageId);
        if (image != null) {
            return image;
        }
        return ImageToolUtil.getDefaultCompanyLogo();
    }

    @Override
    public Image getImage(long imageId) {
        try {
            if (imageId <= 0L) {
                return null;
            }
            return this.imagePersistence.fetchByPrimaryKey(imageId);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get image ", imageId, ": ", exception.getMessage()}));
            }
            return null;
        }
    }

    public Image getImageOrDefault(long imageId) {
        Image image = this.getImage(imageId);
        if (image != null) {
            return image;
        }
        return ImageToolUtil.getDefaultSpacer();
    }

    public List<Image> getImages() {
        return this.imagePersistence.findAll();
    }

    public List<Image> getImagesBySize(int size) {
        return this.imagePersistence.findByLtSize(size);
    }

    public Image moveImage(long imageId, byte[] bytes) throws PortalException {
        Image image = this.updateImage(this._getImageCompanyId(imageId), this.counterLocalService.increment(), bytes);
        this.deleteImage(imageId);
        return image;
    }

    @Deprecated
    public Image updateImage(long imageId, byte[] bytes) throws PortalException {
        return this.updateImage(0L, imageId, bytes);
    }

    @Deprecated
    public Image updateImage(long imageId, byte[] bytes, String type, int height, int width, int size) throws PortalException {
        return this.updateImage(0L, imageId, bytes, type, height, width, size);
    }

    @Deprecated
    public Image updateImage(long imageId, File file) throws PortalException {
        return this.updateImage(0L, imageId, file);
    }

    @Deprecated
    public Image updateImage(long imageId, InputStream inputStream) throws PortalException {
        return this.updateImage(0L, imageId, inputStream);
    }

    @Deprecated
    public Image updateImage(long imageId, InputStream inputStream, boolean cleanUpStream) throws PortalException {
        try {
            Image image = ImageToolUtil.getImage((InputStream)inputStream, (boolean)cleanUpStream);
            return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public Image updateImage(long companyId, long imageId, byte[] bytes) throws PortalException {
        try {
            Image image = ImageToolUtil.getImage((byte[])bytes);
            return this.updateImage(companyId, imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public Image updateImage(long companyId, long imageId, byte[] bytes, String type, int height, int width, int size) throws PortalException {
        if (companyId == 0L && _log.isWarnEnabled()) {
            _log.warn((Object)("Associating image " + imageId + " to a system company"));
        }
        this.validate(type);
        Image image = this.imagePersistence.fetchByPrimaryKey(imageId);
        if (image == null) {
            image = this.imagePersistence.create(imageId);
            image.setCompanyId(companyId);
        }
        image.setModifiedDate(new Date());
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        String fileName = this._getFileName(image.getImageId(), image.getType());
        DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (byte[])bytes);
        if (DLStoreUtil.hasFile((long)image.getCompanyId(), (long)0L, (String)fileName)) {
            DLStoreUtil.deleteFile((long)image.getCompanyId(), (long)0L, (String)fileName);
        }
        DLStoreUtil.addFile((DLStoreRequest)DLStoreRequest.builder((long)image.getCompanyId(), (long)0L, (String)fileName).className(image.getModelClassName()).classPK(image.getImageId()).size((long)image.getSize()).validateFileExtension(true).build(), (byte[])bytes);
        image = (Image)this.imagePersistence.update((BaseModel)image);
        WebServerServletTokenUtil.resetToken((long)imageId);
        return image;
    }

    public Image updateImage(long companyId, long imageId, File file) throws PortalException {
        try {
            Image image = ImageToolUtil.getImage((File)file);
            return this.updateImage(companyId, imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public Image updateImage(long companyId, long imageId, InputStream inputStream) throws PortalException {
        try {
            Image image = ImageToolUtil.getImage((InputStream)inputStream);
            return this.updateImage(companyId, imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public Image updateImage(long companyId, long imageId, InputStream inputStream, boolean cleanUpStream) throws PortalException {
        try {
            Image image = ImageToolUtil.getImage((InputStream)inputStream, (boolean)cleanUpStream);
            return this.updateImage(companyId, imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    protected void validate(String type) throws PortalException {
        if (type == null || type.contains("\\") || type.contains(":") || type.contains(">") || type.contains("<") || type.contains("%") || type.contains(".") || type.contains("|") || type.contains("?") || type.contains("\"") || type.contains("/") || type.contains(" ") || type.contains("*")) {
            throw new ImageTypeException();
        }
    }

    private String _getFileName(long imageId, String type) {
        return imageId + "." + type;
    }

    private long _getImageCompanyId(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Image " + imageId + " is associated to a system company"));
            }
            return 0L;
        }
        return image.getCompanyId();
    }
}

